/*
 * Decompiled with CFR 0.152.
 */
package net.simonvt.menudrawer;

import android.app.Activity;
import android.content.Context;
import android.graphics.Canvas;
import android.graphics.drawable.GradientDrawable;
import android.util.AttributeSet;
import android.view.MotionEvent;
import net.simonvt.menudrawer.VerticalDrawer;

public class BottomDrawer
extends VerticalDrawer {
    private int mIndicatorLeft;

    BottomDrawer(Activity activity, int dragMode) {
        super(activity, dragMode);
    }

    public BottomDrawer(Context context) {
        super(context);
    }

    public BottomDrawer(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public BottomDrawer(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
    }

    @Override
    public void openMenu(boolean animate) {
        this.animateOffsetTo(-this.mMenuSize, 0, animate);
    }

    @Override
    public void closeMenu(boolean animate) {
        this.animateOffsetTo(0, 0, animate);
    }

    @Override
    public void setDropShadowColor(int color2) {
        int endColor = color2 & 0xFFFFFF;
        this.mDropShadowDrawable = new GradientDrawable(GradientDrawable.Orientation.TOP_BOTTOM, new int[]{color2, endColor});
        this.invalidate();
    }

    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        int width = r - l;
        int height = b - t;
        int offsetPixels = (int)this.mOffsetPixels;
        int menuSize = this.mMenuSize;
        this.mMenuContainer.layout(0, height - menuSize, width, height);
        this.offsetMenu(offsetPixels);
        if (USE_TRANSLATIONS) {
            this.mContentContainer.layout(0, 0, width, height);
        } else {
            this.mContentContainer.layout(0, offsetPixels, width, height + offsetPixels);
        }
    }

    private void offsetMenu(int offsetPixels) {
        if (this.mOffsetMenu && this.mMenuSize != 0) {
            int height = this.getHeight();
            int menuSize = this.mMenuSize;
            float openRatio = ((float)menuSize + (float)offsetPixels) / (float)menuSize;
            if (USE_TRANSLATIONS) {
                if (offsetPixels != 0) {
                    int offset = (int)(0.25f * (openRatio * (float)menuSize));
                    this.mMenuContainer.setTranslationY(offset);
                } else {
                    this.mMenuContainer.setTranslationY(height + menuSize);
                }
            } else {
                int oldMenuTop = this.mMenuContainer.getTop();
                int offsetBy = (int)(0.25f * (openRatio * (float)menuSize));
                int offset = height - this.mMenuSize + offsetBy - oldMenuTop;
                this.mMenuContainer.offsetTopAndBottom(offset);
                this.mMenuContainer.setVisibility(offsetPixels == 0 ? 4 : 0);
            }
        }
    }

    @Override
    protected void drawDropShadow(Canvas canvas, int offsetPixels) {
        int width = this.getWidth();
        int height = this.getHeight();
        this.mDropShadowDrawable.setBounds(0, height + offsetPixels, width, height + offsetPixels + this.mDropShadowSize);
        this.mDropShadowDrawable.draw(canvas);
    }

    @Override
    protected void drawMenuOverlay(Canvas canvas, int offsetPixels) {
        int width = this.getWidth();
        int height = this.getHeight();
        float openRatio = (float)Math.abs(offsetPixels) / (float)this.mMenuSize;
        this.mMenuOverlay.setBounds(0, height + offsetPixels, width, height);
        this.mMenuOverlay.setAlpha((int)(185.0f * (1.0f - openRatio)));
        this.mMenuOverlay.draw(canvas);
    }

    @Override
    protected void drawIndicator(Canvas canvas, int offsetPixels) {
        if (this.mActiveView != null && this.isViewDescendant(this.mActiveView)) {
            int pos;
            Integer position = (Integer)this.mActiveView.getTag(2131034117);
            int n = pos = position == null ? 0 : position;
            if (pos == this.mActivePosition) {
                int height = this.getHeight();
                int menuHeight = this.mMenuSize;
                int indicatorHeight = this.mActiveIndicator.getHeight();
                float openRatio = (float)Math.abs(offsetPixels) / (float)menuHeight;
                this.mActiveView.getDrawingRect(this.mActiveRect);
                this.offsetDescendantRectToMyCoords(this.mActiveView, this.mActiveRect);
                int indicatorWidth = this.mActiveIndicator.getWidth();
                float interpolatedRatio = 1.0f - INDICATOR_INTERPOLATOR.getInterpolation(1.0f - openRatio);
                int interpolatedHeight = (int)((float)indicatorHeight * interpolatedRatio);
                int indicatorBottom = height + offsetPixels + interpolatedHeight;
                int indicatorTop = indicatorBottom - indicatorHeight;
                if (this.mIndicatorAnimating) {
                    int finalLeft = this.mActiveRect.left + (this.mActiveRect.width() - indicatorWidth) / 2;
                    int startLeft = this.mIndicatorStartPos;
                    int diff = finalLeft - startLeft;
                    int startOffset = (int)((float)diff * this.mIndicatorOffset);
                    this.mIndicatorLeft = startLeft + startOffset;
                } else {
                    this.mIndicatorLeft = this.mActiveRect.left + (this.mActiveRect.width() - indicatorWidth) / 2;
                }
                canvas.save();
                canvas.clipRect(this.mIndicatorLeft, height + offsetPixels, this.mIndicatorLeft + indicatorWidth, indicatorBottom);
                canvas.drawBitmap(this.mActiveIndicator, (float)this.mIndicatorLeft, (float)indicatorTop, null);
                canvas.restore();
            }
        }
    }

    @Override
    protected int getIndicatorStartPos() {
        return this.mIndicatorLeft;
    }

    @Override
    protected void initPeekScroller() {
        int dx = -this.mMenuSize / 3;
        this.mPeekScroller.startScroll(0, 0, dx, 0, 5000);
    }

    @Override
    protected void onOffsetPixelsChanged(int offsetPixels) {
        if (USE_TRANSLATIONS) {
            this.mContentContainer.setTranslationY(offsetPixels);
            this.offsetMenu(offsetPixels);
            this.invalidate();
        } else {
            this.mContentContainer.offsetTopAndBottom(offsetPixels - this.mContentContainer.getTop());
            this.offsetMenu(offsetPixels);
            this.invalidate();
        }
    }

    @Override
    protected boolean isContentTouch(MotionEvent ev) {
        return ev.getY() < (float)this.getHeight() + this.mOffsetPixels;
    }

    @Override
    protected boolean onDownAllowDrag(MotionEvent ev) {
        int height = this.getHeight();
        return !this.mMenuVisible && this.mInitialMotionY >= (float)(height - this.mTouchSize) || this.mMenuVisible && this.mInitialMotionY <= (float)height + this.mOffsetPixels;
    }

    @Override
    protected boolean onMoveAllowDrag(MotionEvent ev, float diff) {
        int height = this.getHeight();
        return !this.mMenuVisible && this.mInitialMotionY >= (float)(height - this.mTouchSize) && diff < 0.0f || this.mMenuVisible && this.mInitialMotionY <= (float)height + this.mOffsetPixels;
    }

    @Override
    protected void onMoveEvent(float dx) {
        this.setOffsetPixels(Math.max(Math.min(this.mOffsetPixels + dx, 0.0f), (float)(-this.mMenuSize)));
    }

    @Override
    protected void onUpEvent(MotionEvent ev) {
        int offsetPixels = (int)this.mOffsetPixels;
        if (this.mIsDragging) {
            this.mVelocityTracker.computeCurrentVelocity(1000, (float)this.mMaxVelocity);
            int initialVelocity = (int)this.mVelocityTracker.getXVelocity();
            this.mLastMotionY = ev.getY();
            this.animateOffsetTo(this.mVelocityTracker.getYVelocity() < 0.0f ? -this.mMenuSize : 0, initialVelocity, true);
        } else if (this.mMenuVisible && ev.getY() < (float)(this.getHeight() + offsetPixels)) {
            this.closeMenu();
        }
    }
}

