/*
 * Decompiled with CFR 0.152.
 */
package net.simonvt.widget;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.drawable.GradientDrawable;
import android.util.AttributeSet;
import android.view.MotionEvent;
import net.simonvt.widget.MenuDrawer;

public class RightDrawer
extends MenuDrawer {
    public RightDrawer(Context context) {
        super(context);
    }

    public RightDrawer(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public RightDrawer(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
    }

    @Override
    public void setDropShadowColor(int color2) {
        int endColor = color2 & 0xFFFFFF;
        this.mDropShadowDrawable = new GradientDrawable(GradientDrawable.Orientation.LEFT_RIGHT, new int[]{color2, endColor});
        this.invalidate();
    }

    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        int width = r - l;
        int height = b - t;
        int offsetPixels = this.mOffsetPixels;
        this.mMenuContainer.layout(width - this.mMenuWidth, 0, width, height);
        this.offsetMenu(offsetPixels);
        if (USE_TRANSLATIONS) {
            this.mContentView.layout(0, 0, width, height);
        } else {
            this.mContentView.layout(-offsetPixels, 0, width - offsetPixels, height);
        }
    }

    private void offsetMenu(int offsetPixels) {
        if (this.mOffsetMenu && this.mMenuWidth != 0) {
            int menuWidth = this.mMenuWidth;
            float openRatio = ((float)menuWidth - (float)offsetPixels) / (float)menuWidth;
            if (USE_TRANSLATIONS) {
                int offset = (int)(0.25f * (openRatio * (float)menuWidth));
                this.mMenuContainer.setTranslationX(offset);
            } else {
                int width = this.getWidth();
                int oldMenuRight = this.mMenuContainer.getRight();
                int newRight = width + (int)(0.25f * (openRatio * (float)menuWidth));
                int offset = newRight - oldMenuRight;
                this.mMenuContainer.offsetLeftAndRight(offset);
            }
        }
    }

    @Override
    protected void drawDropShadow(Canvas canvas, int offsetPixels) {
        int height = this.getHeight();
        int width = this.getWidth();
        int left = width - offsetPixels;
        int right = left + this.mDropShadowWidth;
        this.mDropShadowDrawable.setBounds(left, 0, right, height);
        this.mDropShadowDrawable.draw(canvas);
    }

    @Override
    protected void drawMenuOverlay(Canvas canvas, int offsetPixels) {
        int height = this.getHeight();
        int width = this.getWidth();
        int left = width - offsetPixels;
        int right = width;
        float openRatio = (float)offsetPixels / (float)this.mMenuWidth;
        this.mMenuOverlay.setBounds(left, 0, right, height);
        this.mMenuOverlay.setAlpha((int)(185.0f * (1.0f - openRatio)));
        this.mMenuOverlay.draw(canvas);
    }

    @Override
    protected void drawArrow(Canvas canvas, int offsetPixels) {
        if (this.mActiveView != null && this.mActiveView.getParent() != null) {
            int pos;
            Integer position = (Integer)this.mActiveView.getTag(2131034115);
            int n = pos = position == null ? 0 : position;
            if (pos == this.mActivePosition) {
                int width = this.getWidth();
                int menuWidth = this.mMenuWidth;
                int arrowWidth = this.mArrowBitmap.getWidth();
                int contentRight = width - offsetPixels;
                float openRatio = (float)offsetPixels / (float)menuWidth;
                this.mActiveView.getDrawingRect(this.mActiveRect);
                this.offsetDescendantRectToMyCoords(this.mActiveView, this.mActiveRect);
                float interpolatedRatio = 1.0f - ARROW_INTERPOLATOR.getInterpolation(1.0f - openRatio);
                int interpolatedArrowWidth = (int)((float)arrowWidth * interpolatedRatio);
                int arrowRight = contentRight + interpolatedArrowWidth;
                int arrowLeft = arrowRight - arrowWidth;
                int top = this.mActiveRect.top + (this.mActiveRect.height() - this.mArrowBitmap.getHeight()) / 2;
                canvas.save();
                canvas.clipRect(contentRight, 0, arrowRight, this.getHeight());
                canvas.drawBitmap(this.mArrowBitmap, (float)arrowLeft, (float)top, null);
                canvas.restore();
            }
        }
    }

    @Override
    protected void onOffsetPixelsChanged(int offsetPixels) {
        if (USE_TRANSLATIONS) {
            this.mContentView.setTranslationX(-offsetPixels);
            this.offsetMenu(offsetPixels);
            this.invalidate();
        } else {
            this.mContentView.offsetLeftAndRight(-offsetPixels - this.mContentView.getLeft());
            this.offsetMenu(offsetPixels);
            this.invalidate();
        }
    }

    @Override
    protected boolean isContentTouch(MotionEvent ev) {
        return ev.getX() < (float)(this.getWidth() - this.mOffsetPixels);
    }

    @Override
    protected boolean onDownAllowDrag(MotionEvent ev) {
        int width = this.getWidth();
        int initialMotionX = (int)this.mInitialMotionX;
        return !this.mMenuVisible && initialMotionX >= width - this.mTouchWidth || this.mMenuVisible && initialMotionX <= width - this.mOffsetPixels;
    }

    @Override
    protected boolean onMoveAllowDrag(MotionEvent ev, float diff) {
        int width = this.getWidth();
        int initialMotionX = (int)this.mInitialMotionX;
        return !this.mMenuVisible && initialMotionX >= width - this.mTouchWidth && diff < 0.0f || this.mMenuVisible && initialMotionX <= width - this.mOffsetPixels;
    }

    @Override
    protected void onMoveEvent(float dx) {
        this.setOffsetPixels(Math.min(Math.max(this.mOffsetPixels - (int)dx, 0), this.mMenuWidth));
    }

    @Override
    protected void onUpEvent(MotionEvent ev) {
        int offsetPixels = this.mOffsetPixels;
        int width = this.getWidth();
        if (this.mIsDragging) {
            this.mVelocityTracker.computeCurrentVelocity(1000, (float)this.mMaxVelocity);
            int initialVelocity = (int)this.mVelocityTracker.getXVelocity();
            this.mLastMotionX = ev.getX();
            this.animateOffsetTo(this.mVelocityTracker.getXVelocity() > 0.0f ? 0 : this.mMenuWidth, initialVelocity, true);
        } else if (this.mMenuVisible && ev.getX() < (float)(width - offsetPixels)) {
            this.closeMenu();
        }
    }
}

