/*
 * Decompiled with CFR 0.152.
 */
package net.simonvt.widget;

import android.app.Activity;
import android.content.Context;
import android.os.Bundle;
import android.os.Parcelable;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import net.simonvt.widget.LeftDrawer;
import net.simonvt.widget.MenuDrawer;
import net.simonvt.widget.RightDrawer;

public class MenuDrawerManager {
    private static final String STATE_LAYOUT = "net.simonvt.widget.MenuDrawerManager.layoutState";
    private final Activity mActivity;
    private MenuDrawer mMenuDrawer;
    private ViewGroup mMenuContainer;
    private ViewGroup mContentContainer;
    private View mMenuView;
    private int mDragMode = 0;
    private boolean mMenuAttached;
    private Bundle mRestoredState;

    public MenuDrawerManager(Activity activity, int dragMode) {
        this(activity, dragMode, 0);
    }

    public MenuDrawerManager(Activity activity, int dragMode, int gravity) {
        this.mActivity = activity;
        this.mDragMode = dragMode;
        this.mMenuDrawer = gravity == 1 ? new RightDrawer((Context)activity) : new LeftDrawer((Context)activity);
        this.mMenuDrawer.setDragMode(dragMode);
        this.mMenuDrawer.setId(2131034112);
        this.mMenuContainer = (ViewGroup)this.mMenuDrawer.findViewById(2131034114);
        this.mContentContainer = (ViewGroup)this.mMenuDrawer.findViewById(2131034113);
        this.attachMenuLayout();
    }

    private void attachMenuLayout() {
        if (!this.mMenuAttached) {
            this.mMenuAttached = true;
            switch (this.mDragMode) {
                case 0: {
                    this.attachToContent();
                    break;
                }
                case 1: {
                    this.attachToDecor();
                    break;
                }
                default: {
                    throw new RuntimeException("Unknown menu mode: " + this.mDragMode);
                }
            }
        }
    }

    private void attachToContent() {
        ViewGroup content = (ViewGroup)this.mActivity.findViewById(0x1020002);
        content.removeAllViews();
        content.addView((View)this.mMenuDrawer, -1, -1);
    }

    private void attachToDecor() {
        ViewGroup decorView = (ViewGroup)this.mActivity.getWindow().getDecorView();
        ViewGroup decorChild = (ViewGroup)decorView.getChildAt(0);
        decorView.removeAllViews();
        decorView.addView((View)this.mMenuDrawer, -1, -1);
        this.mContentContainer.addView((View)decorChild, decorChild.getLayoutParams());
    }

    public MenuDrawer getMenuDrawer() {
        return this.mMenuDrawer;
    }

    public void setActiveView(View v) {
        this.setActiveView(v, 0);
    }

    public void setActiveView(View v, int position) {
        this.mMenuDrawer.setActiveView(v, position);
    }

    public void toggleMenu() {
        this.mMenuDrawer.toggleMenu();
    }

    public void toggleMenu(boolean animate) {
        this.mMenuDrawer.toggleMenu(animate);
    }

    public void openMenu() {
        this.mMenuDrawer.openMenu();
    }

    public void openMenu(boolean animate) {
        this.mMenuDrawer.openMenu(animate);
    }

    public void closeMenu() {
        this.mMenuDrawer.closeMenu();
    }

    public void closeMenu(boolean animate) {
        this.mMenuDrawer.closeMenu(animate);
    }

    public boolean isMenuVisible() {
        return this.mMenuDrawer.isMenuVisible();
    }

    public int getDrawerState() {
        return this.mMenuDrawer.getDrawerState();
    }

    public void setMenuView(int layoutResId) {
        this.mMenuContainer.removeAllViews();
        this.mMenuView = this.mActivity.getLayoutInflater().inflate(layoutResId, this.mMenuContainer, false);
        this.mMenuContainer.addView(this.mMenuView);
    }

    public void setMenuView(View view) {
        this.setMenuView(view, new ViewGroup.LayoutParams(-1, -1));
    }

    public void setMenuView(View view, ViewGroup.LayoutParams params) {
        this.mMenuView = view;
        this.mMenuContainer.removeAllViews();
        this.mMenuContainer.addView(view, params);
    }

    public View getMenuView() {
        return this.mMenuView;
    }

    public void setContentView(int layoutResId) {
        switch (this.mDragMode) {
            case 0: {
                this.mContentContainer.removeAllViews();
                LayoutInflater inflater = this.mActivity.getLayoutInflater();
                inflater.inflate(layoutResId, this.mContentContainer, true);
                break;
            }
            case 1: {
                this.mActivity.setContentView(layoutResId);
            }
        }
    }

    public void setContentView(View view) {
        this.setContentView(view, new ViewGroup.LayoutParams(-1, -1));
    }

    public void setContentView(View view, ViewGroup.LayoutParams params) {
        switch (this.mDragMode) {
            case 0: {
                this.mContentContainer.removeAllViews();
                this.mContentContainer.addView(view, params);
                break;
            }
            case 1: {
                this.mActivity.setContentView(view, params);
            }
        }
    }

    public Parcelable onSaveDrawerState() {
        Bundle state = new Bundle();
        state.putParcelable(STATE_LAYOUT, this.mMenuDrawer.saveState());
        return state;
    }

    public void onRestoreDrawerState(Parcelable in) {
        this.mRestoredState = (Bundle)in;
        this.mMenuDrawer.restoreState(this.mRestoredState.getParcelable(STATE_LAYOUT));
    }
}

