/*
 * Decompiled with CFR 0.152.
 */
package net.simonvt.widget;

import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.os.Bundle;
import android.os.Parcelable;
import android.util.AttributeSet;
import android.util.Log;
import android.view.MotionEvent;
import android.view.VelocityTracker;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewGroup;
import android.view.animation.AccelerateInterpolator;
import android.view.animation.Interpolator;
import net.simonvt.menudrawer.R;
import net.simonvt.widget.BuildLayerFrameLayout;
import net.simonvt.widget.ColorDrawable;
import net.simonvt.widget.NoClickThroughFrameLayout;
import net.simonvt.widget.PeekInterpolator;
import net.simonvt.widget.Scroller;
import net.simonvt.widget.SmoothInterpolator;

public abstract class MenuDrawer
extends ViewGroup {
    private static final String TAG = "MenuDrawer";
    private static final boolean DEBUG = false;
    private static final String STATE_MENU_VISIBLE = "net.simonvt.menudrawer.view.menu.menuVisible";
    protected static final int ANIMATION_DELAY = 16;
    protected static final Interpolator ARROW_INTERPOLATOR = new AccelerateInterpolator();
    private static final Interpolator PEEK_INTERPOLATOR = new PeekInterpolator();
    private static final Interpolator SMOOTH_INTERPOLATOR = new SmoothInterpolator();
    private static final long DEFAULT_PEEK_START_DELAY = 5000L;
    private static final long DEFAULT_PEEK_DELAY = 10000L;
    private static final int PEEK_DURATION = 5000;
    private static final int MAX_DRAG_BEZEL_DP = 24;
    private static final int DURATION_MAX = 600;
    protected static final int MAX_MENU_OVERLAY_ALPHA = 185;
    public static final int MENU_DRAG_CONTENT = 0;
    public static final int MENU_DRAG_WINDOW = 1;
    public static final int MENU_POSITION_LEFT = 0;
    public static final int MENU_POSITION_RIGHT = 1;
    public static final int TOUCH_MODE_NONE = 0;
    public static final int TOUCH_MODE_BEZEL = 1;
    public static final int TOUCH_MODE_FULLSCREEN = 2;
    public static final int STATE_CLOSED = 0;
    public static final int STATE_CLOSING = 1;
    public static final int STATE_DRAGGING = 2;
    public static final int STATE_OPENING = 4;
    public static final int STATE_OPEN = 8;
    private static final int CLOSE_ENOUGH = 3;
    static final boolean USE_TRANSLATIONS = Build.VERSION.SDK_INT >= 11;
    protected Drawable mMenuOverlay;
    private boolean mDropShadowEnabled;
    protected Drawable mDropShadowDrawable;
    protected int mDropShadowWidth;
    protected Bitmap mArrowBitmap;
    protected View mActiveView;
    protected int mActivePosition;
    protected final Rect mActiveRect = new Rect();
    protected BuildLayerFrameLayout mMenuContainer;
    protected BuildLayerFrameLayout mContentView;
    protected int mMenuWidth;
    private boolean mMenuWidthSet;
    protected int mOffsetPixels;
    protected boolean mMenuVisible;
    private int mDragMode;
    private int mDrawerState = 0;
    protected int mMaxTouchBezelWidth;
    protected int mTouchWidth;
    protected boolean mIsDragging;
    protected final int mTouchSlop;
    protected float mInitialMotionX;
    protected float mLastMotionX = -1.0f;
    protected float mLastMotionY = -1.0f;
    private final Runnable mDragRunnable = new Runnable(){

        @Override
        public void run() {
            MenuDrawer.this.postAnimationInvalidate();
        }
    };
    protected final Runnable mPeekRunnable = new Runnable(){

        @Override
        public void run() {
            MenuDrawer.this.peekDrawerInvalidate();
        }
    };
    private Runnable mPeekStartRunnable;
    protected long mPeekDelay;
    private Scroller mScroller;
    protected Scroller mPeekScroller;
    protected VelocityTracker mVelocityTracker;
    protected int mMaxVelocity;
    private OnDrawerStateChangeListener mOnDrawerStateChangeListener;
    protected boolean mOffsetMenu = true;
    protected int mTouchMode = 1;
    protected int mCloseEnough;
    private boolean mLayerTypeHardware;
    private boolean mHardwareLayersEnabled = true;

    public MenuDrawer(Context context) {
        this(context, null);
    }

    public MenuDrawer(Context context, AttributeSet attrs) {
        this(context, attrs, 2130771968);
    }

    public MenuDrawer(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.setWillNotDraw(false);
        this.setFocusable(false);
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.MenuDrawer, defStyle, 2131099649);
        Drawable contentBackground = a.getDrawable(0);
        Drawable menuBackground = a.getDrawable(1);
        this.mMenuWidth = a.getDimensionPixelSize(2, -1);
        this.mMenuWidthSet = this.mMenuWidth != -1;
        int arrowResId = a.getResourceId(3, 0);
        if (arrowResId != 0) {
            this.mArrowBitmap = BitmapFactory.decodeResource((Resources)this.getResources(), (int)arrowResId);
        }
        this.mDropShadowEnabled = a.getBoolean(4, true);
        this.mDropShadowDrawable = a.getDrawable(7);
        if (this.mDropShadowDrawable == null) {
            int dropShadowColor = a.getColor(6, -16777216);
            this.setDropShadowColor(dropShadowColor);
        }
        this.mDropShadowWidth = a.getDimensionPixelSize(5, this.dpToPx(6));
        a.recycle();
        this.mMenuContainer = new BuildLayerFrameLayout(context);
        this.mMenuContainer.setId(2131034114);
        this.mMenuContainer.setBackgroundDrawable(menuBackground);
        this.addView((View)this.mMenuContainer);
        this.mContentView = new NoClickThroughFrameLayout(context);
        this.mContentView.setId(2131034113);
        this.mContentView.setBackgroundDrawable(contentBackground);
        this.addView((View)this.mContentView);
        this.mMenuOverlay = new ColorDrawable(-16777216);
        ViewConfiguration configuration = ViewConfiguration.get((Context)context);
        this.mTouchSlop = configuration.getScaledTouchSlop();
        this.mMaxVelocity = configuration.getScaledMaximumFlingVelocity();
        this.mScroller = new Scroller(context, SMOOTH_INTERPOLATOR);
        this.mPeekScroller = new Scroller(context, PEEK_INTERPOLATOR);
        this.mMaxTouchBezelWidth = this.dpToPx(24);
        this.mCloseEnough = this.dpToPx(3);
    }

    private int dpToPx(int dp) {
        return (int)(this.getResources().getDisplayMetrics().density * (float)dp + 0.5f);
    }

    public void toggleMenu() {
        this.toggleMenu(true);
    }

    public void toggleMenu(boolean animate) {
        if (this.mDrawerState == 8 || this.mDrawerState == 4) {
            this.closeMenu(animate);
        } else if (this.mDrawerState == 0 || this.mDrawerState == 1) {
            this.openMenu(animate);
        }
    }

    public void openMenu() {
        this.openMenu(true);
    }

    public void openMenu(boolean animate) {
        this.animateOffsetTo(this.mMenuWidth, 0, animate);
    }

    public void closeMenu() {
        this.closeMenu(true);
    }

    public void closeMenu(boolean animate) {
        this.animateOffsetTo(0, 0, animate);
    }

    public boolean isMenuVisible() {
        return this.mMenuVisible;
    }

    public void setMenuWidth(int width) {
        this.mMenuWidth = width;
        this.mMenuWidthSet = true;
        if (this.mDrawerState == 8 || this.mDrawerState == 4) {
            this.setOffsetPixels(this.mMenuWidth);
        }
        this.requestLayout();
        this.invalidate();
    }

    public void setActiveView(View v, int position) {
        this.mActiveView = v;
        this.mActivePosition = position;
        this.invalidate();
    }

    public void setOffsetMenuEnabled(boolean offsetMenu) {
        if (offsetMenu != this.mOffsetMenu) {
            this.mOffsetMenu = offsetMenu;
            this.requestLayout();
            this.invalidate();
        }
    }

    public boolean getOffsetMenuEnabled() {
        return this.mOffsetMenu;
    }

    public int getDrawerState() {
        return this.mDrawerState;
    }

    public void setOnDrawerStateChangeListener(OnDrawerStateChangeListener listener) {
        this.mOnDrawerStateChangeListener = listener;
    }

    public void setDropShadowEnabled(boolean enabled) {
        this.mDropShadowEnabled = enabled;
        this.invalidate();
    }

    public abstract void setDropShadowColor(int var1);

    public void setDropShadow(Drawable drawable2) {
        this.mDropShadowDrawable = drawable2;
        this.invalidate();
    }

    public void setDropShadow(int resId) {
        this.setDropShadow(this.getResources().getDrawable(resId));
    }

    public Drawable getDropShadow() {
        return this.mDropShadowDrawable;
    }

    public void setDropShadowWidth(int width) {
        this.mDropShadowWidth = width;
        this.invalidate();
    }

    public void peekDrawer() {
        this.peekDrawer(5000L, 10000L);
    }

    public void peekDrawer(long delay) {
        this.peekDrawer(5000L, delay);
    }

    public void peekDrawer(long startDelay, long delay) {
        if (startDelay < 0L) {
            throw new IllegalArgumentException("startDelay must be zero or larger.");
        }
        if (delay < 0L) {
            throw new IllegalArgumentException("delay must be zero or larger");
        }
        this.removeCallbacks(this.mPeekRunnable);
        this.removeCallbacks(this.mPeekStartRunnable);
        this.mPeekDelay = delay;
        this.mPeekStartRunnable = new Runnable(){

            @Override
            public void run() {
                MenuDrawer.this.startPeek();
            }
        };
        this.postDelayed(this.mPeekStartRunnable, startDelay);
    }

    public void setHardwareLayerEnabled(boolean enabled) {
        if (enabled != this.mHardwareLayersEnabled) {
            this.mHardwareLayersEnabled = enabled;
            this.mMenuContainer.setHardwareLayersEnabled(enabled);
            this.mContentView.setHardwareLayersEnabled(enabled);
            this.stopLayerTranslation();
        }
    }

    protected void setDrawerState(int state) {
        if (state != this.mDrawerState) {
            int oldState = this.mDrawerState;
            this.mDrawerState = state;
            if (this.mOnDrawerStateChangeListener != null) {
                this.mOnDrawerStateChangeListener.onDrawerStateChange(oldState, state);
            }
        }
    }

    private void logDrawerState(int state) {
        switch (state) {
            case 0: {
                Log.d((String)TAG, (String)"[DrawerState] STATE_CLOSED");
                break;
            }
            case 1: {
                Log.d((String)TAG, (String)"[DrawerState] STATE_CLOSING");
                break;
            }
            case 2: {
                Log.d((String)TAG, (String)"[DrawerState] STATE_DRAGGING");
                break;
            }
            case 4: {
                Log.d((String)TAG, (String)"[DrawerState] STATE_OPENING");
                break;
            }
            case 8: {
                Log.d((String)TAG, (String)"[DrawerState] STATE_OPEN");
                break;
            }
            default: {
                Log.d((String)TAG, (String)("[DrawerState] Unknown: " + state));
            }
        }
    }

    public void setDragMode(int dragMode) {
        this.mDragMode = dragMode;
    }

    public int getTouchMode() {
        return this.mTouchMode;
    }

    public void setTouchMode(int mode) {
        if (this.mTouchMode != mode) {
            this.mTouchMode = mode;
            this.updateTouchAreaWidth();
        }
    }

    protected void dispatchDraw(Canvas canvas) {
        super.dispatchDraw(canvas);
        int offsetPixels = this.mOffsetPixels;
        this.drawMenuOverlay(canvas, offsetPixels);
        if (this.mDropShadowEnabled) {
            this.drawDropShadow(canvas, offsetPixels);
        }
        if (this.mArrowBitmap != null) {
            this.drawArrow(canvas, offsetPixels);
        }
    }

    protected abstract void drawDropShadow(Canvas var1, int var2);

    protected abstract void drawMenuOverlay(Canvas var1, int var2);

    protected abstract void drawArrow(Canvas var1, int var2);

    protected void setOffsetPixels(int offsetPixels) {
        if (offsetPixels != this.mOffsetPixels) {
            this.onOffsetPixelsChanged(offsetPixels);
            this.mOffsetPixels = offsetPixels;
            this.mMenuVisible = offsetPixels != 0;
        }
    }

    protected abstract void onOffsetPixelsChanged(int var1);

    protected void startLayerTranslation() {
        if (USE_TRANSLATIONS && this.mHardwareLayersEnabled && !this.mLayerTypeHardware) {
            this.mLayerTypeHardware = true;
            this.mContentView.setLayerType(2, null);
            this.mMenuContainer.setLayerType(2, null);
        }
    }

    private void stopLayerTranslation() {
        if (this.mLayerTypeHardware) {
            this.mLayerTypeHardware = false;
            this.mContentView.setLayerType(0, null);
            this.mMenuContainer.setLayerType(0, null);
        }
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int widthMode = View.MeasureSpec.getMode((int)widthMeasureSpec);
        int heightMode = View.MeasureSpec.getMode((int)heightMeasureSpec);
        if (widthMode != 0x40000000 || heightMode != 0x40000000) {
            throw new IllegalStateException("Must measure with an exact size");
        }
        int width = View.MeasureSpec.getSize((int)widthMeasureSpec);
        int height = View.MeasureSpec.getSize((int)heightMeasureSpec);
        if (!this.mMenuWidthSet) {
            this.mMenuWidth = (int)((float)width * 0.8f);
        }
        if (this.mOffsetPixels == -1) {
            this.setOffsetPixels(this.mMenuWidth);
        }
        int menuWidthMeasureSpec = MenuDrawer.getChildMeasureSpec((int)widthMeasureSpec, (int)0, (int)this.mMenuWidth);
        int menuHeightMeasureSpec = MenuDrawer.getChildMeasureSpec((int)widthMeasureSpec, (int)0, (int)height);
        this.mMenuContainer.measure(menuWidthMeasureSpec, menuHeightMeasureSpec);
        int contentWidthMeasureSpec = MenuDrawer.getChildMeasureSpec((int)widthMeasureSpec, (int)0, (int)width);
        int contentHeightMeasureSpec = MenuDrawer.getChildMeasureSpec((int)widthMeasureSpec, (int)0, (int)height);
        this.mContentView.measure(contentWidthMeasureSpec, contentHeightMeasureSpec);
        this.setMeasuredDimension(width, height);
        this.updateTouchAreaWidth();
    }

    protected boolean fitSystemWindows(Rect insets) {
        if (this.mDragMode == 1) {
            this.mMenuContainer.setPadding(0, insets.top, 0, 0);
        }
        return super.fitSystemWindows(insets);
    }

    private void updateTouchAreaWidth() {
        this.mTouchWidth = this.mTouchMode == 1 ? Math.min(this.getMeasuredWidth() / 10, this.mMaxTouchBezelWidth) : (this.mTouchMode == 2 ? this.getMeasuredWidth() : 0);
    }

    private void endDrag() {
        this.mIsDragging = false;
        if (this.mVelocityTracker != null) {
            this.mVelocityTracker.recycle();
            this.mVelocityTracker = null;
        }
    }

    protected void stopAnimation() {
        this.removeCallbacks(this.mDragRunnable);
        this.mScroller.abortAnimation();
        this.stopLayerTranslation();
    }

    private void completeAnimation() {
        this.mScroller.abortAnimation();
        int finalX = this.mScroller.getFinalX();
        this.setOffsetPixels(finalX);
        this.setDrawerState(finalX == 0 ? 0 : 8);
        this.stopLayerTranslation();
    }

    protected void animateOffsetTo(int position, int velocity, boolean animate) {
        this.endDrag();
        this.endPeek();
        int startX = this.mOffsetPixels;
        int dx = position - startX;
        if (dx == 0 || !animate) {
            this.setOffsetPixels(position);
            this.setDrawerState(position == 0 ? 0 : 8);
            this.stopLayerTranslation();
            return;
        }
        int duration = (velocity = Math.abs(velocity)) > 0 ? 4 * Math.round(1000.0f * Math.abs((float)dx / (float)velocity)) : (int)(600.0f * Math.abs((float)dx / (float)this.mMenuWidth));
        duration = Math.min(duration, 600);
        if (dx > 0) {
            this.setDrawerState(4);
            this.mScroller.startScroll(startX, 0, dx, 0, duration);
        } else {
            this.setDrawerState(1);
            this.mScroller.startScroll(startX, 0, dx, 0, duration);
        }
        this.startLayerTranslation();
        this.postAnimationInvalidate();
    }

    private void postAnimationInvalidate() {
        if (this.mScroller.computeScrollOffset()) {
            int oldX = this.mOffsetPixels;
            int x = this.mScroller.getCurrX();
            if (x != oldX) {
                this.setOffsetPixels(x);
            }
            if (x != this.mScroller.getFinalX()) {
                this.postOnAnimation(this.mDragRunnable);
                return;
            }
        }
        this.completeAnimation();
    }

    protected void startPeek() {
        int menuWidth = this.mMenuWidth;
        int dx = menuWidth / 3;
        this.mPeekScroller.startScroll(0, 0, dx, 0, 5000);
        this.startLayerTranslation();
        this.peekDrawerInvalidate();
    }

    private void peekDrawerInvalidate() {
        if (this.mPeekScroller.computeScrollOffset()) {
            int oldX = this.mOffsetPixels;
            int x = this.mPeekScroller.getCurrX();
            if (x != oldX) {
                this.setOffsetPixels(x);
            }
            if (!this.mPeekScroller.isFinished()) {
                this.postOnAnimation(this.mPeekRunnable);
                return;
            }
            if (this.mPeekDelay > 0L) {
                this.mPeekStartRunnable = new Runnable(){

                    @Override
                    public void run() {
                        MenuDrawer.this.startPeek();
                    }
                };
                this.postDelayed(this.mPeekStartRunnable, this.mPeekDelay);
            }
        }
        this.completePeek();
    }

    private void completePeek() {
        this.mPeekScroller.abortAnimation();
        this.setOffsetPixels(0);
        this.setDrawerState(0);
        this.stopLayerTranslation();
    }

    protected void endPeek() {
        this.removeCallbacks(this.mPeekStartRunnable);
        this.removeCallbacks(this.mPeekRunnable);
        this.stopLayerTranslation();
    }

    public void postOnAnimation(Runnable action) {
        if (Build.VERSION.SDK_INT >= 16) {
            super.postOnAnimation(action);
        } else {
            this.postDelayed(action, 16L);
        }
    }

    protected boolean isCloseEnough() {
        return this.mOffsetPixels <= this.mCloseEnough;
    }

    protected abstract boolean isContentTouch(MotionEvent var1);

    protected abstract boolean onDownAllowDrag(MotionEvent var1);

    protected abstract boolean onMoveAllowDrag(MotionEvent var1, float var2);

    protected abstract void onMoveEvent(float var1);

    protected abstract void onUpEvent(MotionEvent var1);

    public boolean onInterceptTouchEvent(MotionEvent ev) {
        int action = ev.getAction() & 0xFF;
        if (action == 0 && this.mMenuVisible && this.isCloseEnough()) {
            this.setOffsetPixels(0);
            this.stopAnimation();
            this.endPeek();
            this.setDrawerState(0);
        }
        if (this.mMenuVisible && this.isContentTouch(ev)) {
            return true;
        }
        if (this.mTouchMode == 0) {
            return false;
        }
        if (action != 0 && this.mIsDragging) {
            return true;
        }
        switch (action) {
            case 0: {
                this.mLastMotionX = this.mInitialMotionX = ev.getX();
                this.mLastMotionY = ev.getY();
                boolean allowDrag = this.onDownAllowDrag(ev);
                if (!allowDrag) break;
                this.setDrawerState(this.mMenuVisible ? 8 : 0);
                this.stopAnimation();
                this.endPeek();
                this.mIsDragging = false;
                break;
            }
            case 2: {
                boolean allowDrag;
                float x = ev.getX();
                float dx = x - this.mLastMotionX;
                float xDiff = Math.abs(dx);
                float y = ev.getY();
                float yDiff = Math.abs(y - this.mLastMotionY);
                if (!(xDiff > (float)this.mTouchSlop) || !(xDiff > yDiff) || !(allowDrag = this.onMoveAllowDrag(ev, dx))) break;
                this.setDrawerState(2);
                this.mIsDragging = true;
                this.mLastMotionX = x;
                this.mLastMotionY = y;
                break;
            }
            case 1: 
            case 3: {
                int offsetPixels = this.mOffsetPixels;
                this.animateOffsetTo(offsetPixels > this.mMenuWidth / 2 ? this.mMenuWidth : 0, 0, true);
                break;
            }
        }
        if (this.mVelocityTracker == null) {
            this.mVelocityTracker = VelocityTracker.obtain();
        }
        this.mVelocityTracker.addMovement(ev);
        return this.mIsDragging;
    }

    public boolean onTouchEvent(MotionEvent ev) {
        if (!this.mMenuVisible && this.mTouchMode == 0) {
            return false;
        }
        int action = ev.getAction() & 0xFF;
        if (this.mVelocityTracker == null) {
            this.mVelocityTracker = VelocityTracker.obtain();
        }
        this.mVelocityTracker.addMovement(ev);
        switch (action) {
            case 0: {
                this.mLastMotionX = this.mInitialMotionX = ev.getX();
                this.mLastMotionY = ev.getY();
                boolean allowDrag = this.onDownAllowDrag(ev);
                if (!allowDrag) break;
                this.stopAnimation();
                this.endPeek();
                this.startLayerTranslation();
                break;
            }
            case 2: {
                float dx;
                float x;
                if (!this.mIsDragging) {
                    boolean allowDrag;
                    x = ev.getX();
                    dx = x - this.mLastMotionX;
                    float xDiff = Math.abs(dx);
                    float y = ev.getY();
                    float yDiff = Math.abs(y - this.mLastMotionY);
                    if (xDiff > (float)this.mTouchSlop && xDiff > yDiff && (allowDrag = this.onMoveAllowDrag(ev, dx))) {
                        this.setDrawerState(2);
                        this.mIsDragging = true;
                        float f = this.mLastMotionX = x - this.mInitialMotionX > 0.0f ? this.mInitialMotionX + (float)this.mTouchSlop : this.mInitialMotionX - (float)this.mTouchSlop;
                    }
                }
                if (!this.mIsDragging) break;
                this.startLayerTranslation();
                x = ev.getX();
                dx = x - this.mLastMotionX;
                this.mLastMotionX = x;
                this.onMoveEvent(dx);
                break;
            }
            case 1: 
            case 3: {
                this.onUpEvent(ev);
            }
        }
        return true;
    }

    public Parcelable saveState() {
        Bundle state = new Bundle();
        boolean menuVisible = this.mDrawerState == 8 || this.mDrawerState == 4;
        state.putBoolean(STATE_MENU_VISIBLE, menuVisible);
        return state;
    }

    public void restoreState(Parcelable in) {
        Bundle state = (Bundle)in;
        boolean menuOpen = state.getBoolean(STATE_MENU_VISIBLE);
        this.setOffsetPixels(menuOpen ? this.mMenuWidth : 0);
        this.mDrawerState = menuOpen ? 8 : 0;
    }

    public static interface OnDrawerStateChangeListener {
        public void onDrawerStateChange(int var1, int var2);
    }
}

