/*
 * Decompiled with CFR 0.152.
 */
package net.simonvt.widget;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.drawable.GradientDrawable;
import android.util.AttributeSet;
import android.view.MotionEvent;
import net.simonvt.widget.MenuDrawer;

public class LeftDrawer
extends MenuDrawer {
    public LeftDrawer(Context context) {
        super(context);
    }

    public LeftDrawer(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public LeftDrawer(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
    }

    @Override
    public void setDropShadowColor(int color2) {
        int endColor = color2 & 0xFFFFFF;
        this.mDropShadowDrawable = new GradientDrawable(GradientDrawable.Orientation.RIGHT_LEFT, new int[]{color2, endColor});
        this.invalidate();
    }

    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        int width = r - l;
        int height = b - t;
        int offsetPixels = this.mOffsetPixels;
        this.mMenuContainer.layout(0, 0, this.mMenuWidth, height);
        this.offsetMenu(offsetPixels);
        if (USE_TRANSLATIONS) {
            this.mContentView.layout(0, 0, width, height);
        } else {
            this.mContentView.layout(offsetPixels, 0, width + offsetPixels, height);
        }
    }

    private void offsetMenu(int offsetPixels) {
        if (this.mOffsetMenu && this.mMenuWidth != 0) {
            int menuWidth = this.mMenuWidth;
            float openRatio = ((float)menuWidth - (float)offsetPixels) / (float)menuWidth;
            if (USE_TRANSLATIONS) {
                int menuLeft = (int)(0.25f * (-openRatio * (float)menuWidth));
                this.mMenuContainer.setTranslationX(menuLeft);
            } else {
                int oldMenuLeft = this.mMenuContainer.getLeft();
                int offset = (int)(0.25f * (-openRatio * (float)menuWidth)) - oldMenuLeft;
                this.mMenuContainer.offsetLeftAndRight(offset);
            }
        }
    }

    @Override
    protected void drawDropShadow(Canvas canvas, int offsetPixels) {
        int height = this.getHeight();
        this.mDropShadowDrawable.setBounds(offsetPixels - this.mDropShadowWidth, 0, offsetPixels, height);
        this.mDropShadowDrawable.draw(canvas);
    }

    @Override
    protected void drawMenuOverlay(Canvas canvas, int offsetPixels) {
        int height = this.getHeight();
        float openRatio = (float)offsetPixels / (float)this.mMenuWidth;
        this.mMenuOverlay.setBounds(0, 0, offsetPixels, height);
        this.mMenuOverlay.setAlpha((int)(185.0f * (1.0f - openRatio)));
        this.mMenuOverlay.draw(canvas);
    }

    @Override
    protected void drawArrow(Canvas canvas, int offsetPixels) {
        if (this.mActiveView != null && this.mActiveView.getParent() != null) {
            int pos;
            Integer position = (Integer)this.mActiveView.getTag(2131034115);
            int n = pos = position == null ? 0 : position;
            if (pos == this.mActivePosition) {
                float openRatio = (float)offsetPixels / (float)this.mMenuWidth;
                this.mActiveView.getDrawingRect(this.mActiveRect);
                this.offsetDescendantRectToMyCoords(this.mActiveView, this.mActiveRect);
                float interpolatedRatio = 1.0f - ARROW_INTERPOLATOR.getInterpolation(1.0f - openRatio);
                int interpolatedArrowWidth = (int)((float)this.mArrowBitmap.getWidth() * interpolatedRatio);
                int top = this.mActiveRect.top + (this.mActiveRect.height() - this.mArrowBitmap.getHeight()) / 2;
                int right = offsetPixels;
                int left = right - interpolatedArrowWidth;
                canvas.save();
                canvas.clipRect(left, 0, right, this.getHeight());
                canvas.drawBitmap(this.mArrowBitmap, (float)left, (float)top, null);
                canvas.restore();
            }
        }
    }

    @Override
    protected void onOffsetPixelsChanged(int offsetPixels) {
        if (USE_TRANSLATIONS) {
            this.mContentView.setTranslationX(offsetPixels);
            this.offsetMenu(offsetPixels);
            this.invalidate();
        } else {
            this.mContentView.offsetLeftAndRight(offsetPixels - this.mContentView.getLeft());
            this.offsetMenu(offsetPixels);
            this.invalidate();
        }
    }

    @Override
    protected boolean isContentTouch(MotionEvent ev) {
        return ev.getX() > (float)this.mOffsetPixels;
    }

    @Override
    protected boolean onDownAllowDrag(MotionEvent ev) {
        return !this.mMenuVisible && this.mInitialMotionX <= (float)this.mTouchWidth || this.mMenuVisible && this.mInitialMotionX >= (float)this.mOffsetPixels;
    }

    @Override
    protected boolean onMoveAllowDrag(MotionEvent ev, float diff) {
        return !this.mMenuVisible && this.mInitialMotionX <= (float)this.mTouchWidth && diff > 0.0f || this.mMenuVisible && this.mInitialMotionX >= (float)this.mOffsetPixels;
    }

    @Override
    protected void onMoveEvent(float dx) {
        this.setOffsetPixels(Math.min(Math.max(this.mOffsetPixels + (int)dx, 0), this.mMenuWidth));
    }

    @Override
    protected void onUpEvent(MotionEvent ev) {
        int offsetPixels = this.mOffsetPixels;
        if (this.mIsDragging) {
            this.mVelocityTracker.computeCurrentVelocity(1000, (float)this.mMaxVelocity);
            int initialVelocity = (int)this.mVelocityTracker.getXVelocity();
            this.mLastMotionX = ev.getX();
            this.animateOffsetTo(this.mVelocityTracker.getXVelocity() > 0.0f ? this.mMenuWidth : 0, initialVelocity, true);
        } else if (this.mMenuVisible && ev.getX() > (float)offsetPixels) {
            this.closeMenu();
        }
    }
}

