/*
 * Decompiled with CFR 0.152.
 */
package net.simonvt.widget;

import android.content.Context;
import android.graphics.Canvas;
import android.util.AttributeSet;
import android.widget.FrameLayout;
import net.simonvt.widget.MenuDrawer;

public class BuildLayerFrameLayout
extends FrameLayout {
    private boolean mChanged;
    private boolean mHardwareLayersEnabled = true;
    private boolean mAttached;

    public BuildLayerFrameLayout(Context context) {
        super(context);
    }

    public BuildLayerFrameLayout(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public BuildLayerFrameLayout(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
    }

    void setHardwareLayersEnabled(boolean enabled) {
        this.mHardwareLayersEnabled = enabled;
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.mAttached = true;
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.mAttached = false;
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        if (MenuDrawer.USE_TRANSLATIONS && this.mHardwareLayersEnabled) {
            this.post(new Runnable(){

                @Override
                public void run() {
                    BuildLayerFrameLayout.this.mChanged = true;
                    BuildLayerFrameLayout.this.invalidate();
                }
            });
        }
    }

    protected void dispatchDraw(Canvas canvas) {
        super.dispatchDraw(canvas);
        if (this.mChanged && MenuDrawer.USE_TRANSLATIONS) {
            this.post(new Runnable(){

                @Override
                public void run() {
                    int layerType;
                    if (BuildLayerFrameLayout.this.mAttached && (layerType = BuildLayerFrameLayout.this.getLayerType()) != 2) {
                        BuildLayerFrameLayout.this.setLayerType(2, null);
                        BuildLayerFrameLayout.this.buildLayer();
                        BuildLayerFrameLayout.this.setLayerType(0, null);
                    }
                }
            });
            this.mChanged = false;
        }
    }
}

