/*
 * Decompiled with CFR 0.152.
 */
package net.simonvt.menudrawer.samples;

import android.app.Activity;
import android.os.Build;
import android.os.Bundle;
import android.view.MenuItem;
import android.view.View;
import android.widget.TextView;
import net.simonvt.menudrawer.samples.MenuScrollView;
import net.simonvt.widget.MenuDrawerManager;

public class WindowSample
extends Activity
implements View.OnClickListener {
    private static final String STATE_MENUDRAWER = "net.simonvt.menudrawer.samples.WindowSample.menuDrawer";
    private static final String STATE_ACTIVE_VIEW_ID = "net.simonvt.menudrawer.samples.WindowSample.activeViewId";
    private MenuDrawerManager mMenuDrawer;
    private TextView mContentTextView;
    private int mActiveViewId;

    public void onCreate(Bundle inState) {
        super.onCreate(inState);
        if (inState != null) {
            this.mActiveViewId = inState.getInt(STATE_ACTIVE_VIEW_ID);
        }
        this.mMenuDrawer = new MenuDrawerManager(this, 1);
        this.mMenuDrawer.setContentView(2130903043);
        this.mMenuDrawer.setMenuView(2130903048);
        MenuScrollView msv = (MenuScrollView)this.mMenuDrawer.getMenuView();
        msv.setOnScrollChangedListener(new MenuScrollView.OnScrollChangedListener(){

            @Override
            public void onScrollChanged() {
                WindowSample.this.mMenuDrawer.getMenuDrawer().invalidate();
            }
        });
        if (Build.VERSION.SDK_INT >= 14) {
            this.getActionBar().setDisplayHomeAsUpEnabled(true);
        }
        this.mContentTextView = (TextView)this.findViewById(2131034116);
        this.findViewById(2131034125).setOnClickListener((View.OnClickListener)this);
        this.findViewById(2131034126).setOnClickListener((View.OnClickListener)this);
        this.findViewById(2131034127).setOnClickListener((View.OnClickListener)this);
        this.findViewById(2131034128).setOnClickListener((View.OnClickListener)this);
        this.findViewById(2131034129).setOnClickListener((View.OnClickListener)this);
        this.findViewById(2131034130).setOnClickListener((View.OnClickListener)this);
        TextView activeView = (TextView)this.findViewById(this.mActiveViewId);
        if (activeView != null) {
            this.mMenuDrawer.setActiveView((View)activeView);
            this.mContentTextView.setText((CharSequence)("Active item: " + activeView.getText()));
        }
        this.mMenuDrawer.getMenuDrawer().peekDrawer();
    }

    protected void onRestoreInstanceState(Bundle inState) {
        super.onRestoreInstanceState(inState);
        this.mMenuDrawer.onRestoreDrawerState(inState.getParcelable(STATE_MENUDRAWER));
    }

    protected void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
        outState.putParcelable(STATE_MENUDRAWER, this.mMenuDrawer.onSaveDrawerState());
        outState.putInt(STATE_ACTIVE_VIEW_ID, this.mActiveViewId);
    }

    public boolean onOptionsItemSelected(MenuItem item) {
        switch (item.getItemId()) {
            case 16908332: {
                this.mMenuDrawer.toggleMenu();
                return true;
            }
        }
        return super.onOptionsItemSelected(item);
    }

    public void onBackPressed() {
        int drawerState = this.mMenuDrawer.getDrawerState();
        if (drawerState == 8 || drawerState == 4) {
            this.mMenuDrawer.closeMenu();
            return;
        }
        super.onBackPressed();
    }

    public void onClick(View v) {
        this.mMenuDrawer.setActiveView(v);
        this.mContentTextView.setText((CharSequence)("Active item: " + ((TextView)v).getText()));
        this.mMenuDrawer.closeMenu();
        this.mActiveViewId = v.getId();
    }
}

