/*
 * Decompiled with CFR 0.152.
 */
package net.simonvt.menudrawer.samples;

import android.app.Activity;
import android.content.Context;
import android.os.Build;
import android.os.Bundle;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentActivity;
import android.support.v4.app.FragmentPagerAdapter;
import android.support.v4.view.ViewPager;
import android.view.LayoutInflater;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AdapterView;
import android.widget.BaseAdapter;
import android.widget.FrameLayout;
import android.widget.ListAdapter;
import android.widget.TextView;
import java.util.ArrayList;
import java.util.List;
import net.simonvt.menudrawer.samples.MenuListView;
import net.simonvt.widget.MenuDrawerManager;

public class ViewPagerSample
extends FragmentActivity {
    private static final String STATE_MENUDRAWER = "net.simonvt.menudrawer.samples.ContentSample.menuDrawer";
    private static final String STATE_ACTIVE_POSITION = "net.simonvt.menudrawer.samples.ContentSample.activePosition";
    private MenuDrawerManager mMenuDrawer;
    private MenuAdapter mAdapter;
    private MenuListView mList;
    private int mActivePosition = -1;
    private PagerAdapter mPagerAdapter;
    private ViewPager mViewPager;
    private AdapterView.OnItemClickListener mItemClickListener = new AdapterView.OnItemClickListener(){

        public void onItemClick(AdapterView<?> parent, View view, int position, long id2) {
            ViewPagerSample.this.mActivePosition = position;
            ViewPagerSample.this.mMenuDrawer.setActiveView(view, position);
            ViewPagerSample.this.mMenuDrawer.closeMenu();
        }
    };

    protected void onCreate(Bundle inState) {
        super.onCreate(inState);
        if (inState != null) {
            this.mActivePosition = inState.getInt(STATE_ACTIVE_POSITION);
        }
        this.mMenuDrawer = new MenuDrawerManager((Activity)this, 0);
        this.mMenuDrawer.setContentView(2130903042);
        ArrayList<Object> items = new ArrayList<Object>();
        items.add(new Item("Item 1", 2130837504));
        items.add(new Item("Item 2", 2130837505));
        items.add(new Category("Cat 1"));
        items.add(new Item("Item 3", 2130837504));
        items.add(new Item("Item 4", 2130837505));
        items.add(new Category("Cat 2"));
        items.add(new Item("Item 5", 2130837504));
        items.add(new Item("Item 6", 2130837505));
        this.mList = new MenuListView((Context)this);
        this.mAdapter = new MenuAdapter(items);
        this.mList.setAdapter((ListAdapter)this.mAdapter);
        this.mList.setOnItemClickListener(this.mItemClickListener);
        this.mList.setOnScrollChangedListener(new MenuListView.OnScrollChangedListener(){

            @Override
            public void onScrollChanged() {
                ViewPagerSample.this.mMenuDrawer.getMenuDrawer().invalidate();
            }
        });
        this.mMenuDrawer.setMenuView((View)this.mList);
        if (Build.VERSION.SDK_INT >= 14) {
            this.getActionBar().setDisplayHomeAsUpEnabled(true);
        }
        this.mMenuDrawer.getMenuDrawer().setTouchMode(2);
        this.mViewPager = (ViewPager)this.findViewById(2131034117);
        this.mViewPager.setOnPageChangeListener((ViewPager.OnPageChangeListener)new ViewPager.SimpleOnPageChangeListener(){

            public void onPageSelected(int position) {
                ViewPagerSample.this.mMenuDrawer.getMenuDrawer().setTouchMode(position == 0 ? 2 : 0);
            }
        });
        this.mPagerAdapter = new PagerAdapter(this);
        this.mPagerAdapter.addTab(TextViewFragment.class, null);
        this.mPagerAdapter.addTab(TextViewFragment.class, null);
        this.mPagerAdapter.addTab(TextViewFragment.class, null);
        this.mViewPager.setAdapter((android.support.v4.view.PagerAdapter)this.mPagerAdapter);
    }

    protected void onRestoreInstanceState(Bundle inState) {
        super.onRestoreInstanceState(inState);
        this.mMenuDrawer.onRestoreDrawerState(inState.getParcelable(STATE_MENUDRAWER));
    }

    protected void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
        outState.putParcelable(STATE_MENUDRAWER, this.mMenuDrawer.onSaveDrawerState());
        outState.putInt(STATE_ACTIVE_POSITION, this.mActivePosition);
    }

    public boolean onOptionsItemSelected(MenuItem item) {
        switch (item.getItemId()) {
            case 16908332: {
                this.mMenuDrawer.toggleMenu();
                return true;
            }
        }
        return super.onOptionsItemSelected(item);
    }

    public void onBackPressed() {
        int drawerState = this.mMenuDrawer.getDrawerState();
        if (drawerState == 8 || drawerState == 4) {
            this.mMenuDrawer.closeMenu();
            return;
        }
        super.onBackPressed();
    }

    public static class TextViewFragment
    extends Fragment {
        public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
            FrameLayout frameLayout = new FrameLayout((Context)this.getActivity());
            frameLayout.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1, 17));
            TextView tv = new TextView((Context)this.getActivity());
            tv.setText((CharSequence)"This is an example of a Fragment in a View Pager");
            frameLayout.addView((View)tv);
            return frameLayout;
        }
    }

    public static class PagerAdapter
    extends FragmentPagerAdapter {
        private final Context mContext;
        private final ArrayList<TabInfo> mTabs = new ArrayList();

        public PagerAdapter(FragmentActivity activity) {
            super(activity.getSupportFragmentManager());
            this.mContext = activity;
        }

        public int getCount() {
            return this.mTabs.size();
        }

        public Fragment getItem(int position) {
            TabInfo info = this.mTabs.get(position);
            return Fragment.instantiate((Context)this.mContext, (String)info.mClss.getName(), (Bundle)info.mArgs);
        }

        public void addTab(Class<?> clss, Bundle args) {
            TabInfo info = new TabInfo(clss, args);
            this.mTabs.add(info);
            this.notifyDataSetChanged();
        }

        static final class TabInfo {
            private final Class<?> mClss;
            private final Bundle mArgs;

            TabInfo(Class<?> aClass, Bundle args) {
                this.mClss = aClass;
                this.mArgs = args;
            }
        }
    }

    private class MenuAdapter
    extends BaseAdapter {
        private List<Object> mItems;

        MenuAdapter(List<Object> items) {
            this.mItems = items;
        }

        public int getCount() {
            return this.mItems.size();
        }

        public Object getItem(int position) {
            return this.mItems.get(position);
        }

        public long getItemId(int position) {
            return position;
        }

        public int getItemViewType(int position) {
            return this.getItem(position) instanceof Item ? 0 : 1;
        }

        public int getViewTypeCount() {
            return 2;
        }

        public boolean isEnabled(int position) {
            return this.getItem(position) instanceof Item;
        }

        public boolean areAllItemsEnabled() {
            return false;
        }

        public View getView(int position, View convertView, ViewGroup parent) {
            View v = convertView;
            Object item = this.getItem(position);
            if (item instanceof Category) {
                if (v == null) {
                    v = ViewPagerSample.this.getLayoutInflater().inflate(2130903046, parent, false);
                }
                ((TextView)v).setText((CharSequence)((Category)item).mTitle);
            } else {
                if (v == null) {
                    v = ViewPagerSample.this.getLayoutInflater().inflate(2130903047, parent, false);
                }
                TextView tv = (TextView)v;
                tv.setText((CharSequence)((Item)item).mTitle);
                tv.setCompoundDrawablesWithIntrinsicBounds(((Item)item).mIconRes, 0, 0, 0);
            }
            v.setTag(2131034115, (Object)position);
            if (position == ViewPagerSample.this.mActivePosition) {
                ViewPagerSample.this.mMenuDrawer.setActiveView(v, position);
            }
            return v;
        }
    }

    private static final class Category {
        String mTitle;

        Category(String title) {
            this.mTitle = title;
        }
    }

    private static final class Item {
        String mTitle;
        int mIconRes;

        Item(String title, int iconRes) {
            this.mTitle = title;
            this.mIconRes = iconRes;
        }
    }
}

