/*
 * Decompiled with CFR 0.152.
 */
package net.simonvt.menudrawer.samples;

import android.app.Activity;
import android.app.ListActivity;
import android.content.Context;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.view.MenuItem;
import android.view.View;
import android.widget.ArrayAdapter;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.TextView;
import android.widget.Toast;
import java.util.ArrayList;
import net.simonvt.widget.MenuDrawer;
import net.simonvt.widget.MenuDrawerManager;

public class ListActivitySample
extends ListActivity {
    private static final String STATE_MENUDRAWER = "net.simonvt.menudrawer.samples.ListActivitySample.menuDrawer";
    private MenuDrawerManager mMenuDrawer;
    private Handler mHandler;
    private Runnable mToggleUpRunnable;
    private boolean mDisplayUp = true;

    public void onCreate(Bundle inState) {
        super.onCreate(inState);
        this.mMenuDrawer = new MenuDrawerManager((Activity)this, 0);
        TextView menuView = new TextView((Context)this);
        menuView.setGravity(17);
        menuView.setTextColor(-1);
        int padding = this.dpToPx(16);
        menuView.setPadding(padding, padding, padding, padding);
        menuView.setText(2131165187);
        this.mMenuDrawer.setMenuView((View)menuView);
        this.mMenuDrawer.getMenuDrawer().setOffsetMenuEnabled(false);
        ArrayList<String> items = new ArrayList<String>();
        for (int i = 1; i <= 20; ++i) {
            items.add("Item " + i);
        }
        this.setListAdapter((ListAdapter)new ArrayAdapter((Context)this, 17367043, items));
        if (Build.VERSION.SDK_INT >= 14) {
            this.mHandler = new Handler();
            this.getActionBar().setDisplayHomeAsUpEnabled(true);
            this.mToggleUpRunnable = new Runnable(){

                @Override
                public void run() {
                    ListActivitySample.this.mDisplayUp = !ListActivitySample.this.mDisplayUp;
                    ListActivitySample.this.getActionBar().setDisplayHomeAsUpEnabled(ListActivitySample.this.mDisplayUp);
                    ListActivitySample.this.mHandler.postDelayed(ListActivitySample.this.mToggleUpRunnable, 500L);
                }
            };
            this.mHandler.postDelayed(this.mToggleUpRunnable, 500L);
            this.mMenuDrawer.getMenuDrawer().setOnDrawerStateChangeListener(new MenuDrawer.OnDrawerStateChangeListener(){

                @Override
                public void onDrawerStateChange(int oldState, int newState) {
                    if (newState == 8) {
                        ListActivitySample.this.mHandler.removeCallbacks(ListActivitySample.this.mToggleUpRunnable);
                        if (!ListActivitySample.this.mDisplayUp) {
                            ListActivitySample.this.getActionBar().setDisplayHomeAsUpEnabled(true);
                        }
                        ListActivitySample.this.mMenuDrawer.getMenuDrawer().setOnDrawerStateChangeListener(null);
                    }
                }
            });
        }
    }

    private int dpToPx(int dp) {
        return (int)(this.getResources().getDisplayMetrics().density * (float)dp + 0.5f);
    }

    public void setContentView(int layoutResID) {
        this.mMenuDrawer.setContentView(layoutResID);
        this.onContentChanged();
    }

    protected void onListItemClick(ListView l, View v, int position, long id2) {
        String str = (String)this.getListAdapter().getItem(position);
        Toast.makeText((Context)this, (CharSequence)("Clicked: " + str), (int)0).show();
    }

    protected void onRestoreInstanceState(Bundle inState) {
        super.onRestoreInstanceState(inState);
        this.mMenuDrawer.onRestoreDrawerState(inState.getParcelable(STATE_MENUDRAWER));
    }

    protected void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
        outState.putParcelable(STATE_MENUDRAWER, this.mMenuDrawer.onSaveDrawerState());
    }

    public boolean onOptionsItemSelected(MenuItem item) {
        switch (item.getItemId()) {
            case 16908332: {
                this.mMenuDrawer.toggleMenu();
                return true;
            }
        }
        return super.onOptionsItemSelected(item);
    }

    public void onBackPressed() {
        int drawerState = this.mMenuDrawer.getDrawerState();
        if (drawerState == 8 || drawerState == 4) {
            this.mMenuDrawer.closeMenu();
            return;
        }
        super.onBackPressed();
    }
}

