package net.silkmc.silk.commands.mixin.client;

import com.mojang.brigadier.CommandDispatcher;
import net.minecraft.class_2172;
import net.minecraft.class_2641;
import net.minecraft.class_2678;
import net.minecraft.class_310;
import net.minecraft.class_5455;
import net.minecraft.class_634;
import net.minecraft.class_7157;
import net.minecraft.class_746;
import net.minecraft.class_7701;
import net.silkmc.silk.commands.internal.ClientCommandHandler;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(class_634.class)
public abstract class MixinClientPacketListener {

    @Shadow
    private CommandDispatcher<class_2172> commands;

    @Shadow public abstract class_5455.class_6890 registryAccess();

    @Inject(
        method = "handleLogin",
        at = @At("RETURN")
    )
    private void onHandleLogin(class_2678 packet, CallbackInfo ci) {
        final var context = class_7157.method_46722(registryAccess(), class_7701.field_40183);
        ClientCommandHandler.INSTANCE.refreshDispatcher(context);
    }

    @Inject(
        method = "handleCommands",
        at = @At("RETURN")
    )
    private void onHandleCommands(class_2641 packet, CallbackInfo ci) {
        ClientCommandHandler.INSTANCE.applyCommands(commands);
    }

    @Inject(
        method = "sendCommand",
        at = @At("HEAD"),
        cancellable = true
    )
    private void onSendCommand(String command, CallbackInfo ci) {
        final var player = class_310.method_1551().field_1724;
        if (player != null) {
            if (ClientCommandHandler.INSTANCE.executeCommand(command, player)) {
                ci.cancel();
            }
        }
    }
}
