// Generated by <a href="http://scalaxb.org/">scalaxb</a>.
package org.iptc.sportsml.v3


/** SportsML is a global XML standard for the interchange of sports data.
            Designed to be as easy to understand and implement as possible, SportsML allows for the
            exchange of sports scores, schedules, standings, and statistics for a wide variety of
            competitions. Its extensibility allows for the easy accommodation of many sports from
            around the globe. It cooperates with current IPTC standards NewsML and NITF to enable
            publishers to package sports statistics alongside edited coverage of
            sports.
*/


case class SportsContent(sportsContentoption: Seq[scalaxb.DataRecord[org.iptc.sportsml.v3.SportsContentOption]] = Nil,
  attributes: Map[String, scalaxb.DataRecord[Any]] = Map()) {
  lazy val id = attributes.get("@id") map { _.as[String]}
  lazy val classValue = attributes.get("@class") map { _.as[String]}
  lazy val style = attributes.get("@style") map { _.as[String]}
}

      

trait SportsContentOption

/** Background information about a game. | Where, when, and what an event
                is.
*/
case class EventMetadataComplexType(sportsContentCodes: Option[org.iptc.sportsml.v3.SportsContentCodesComplexType] = None,
  sportsProperty: Seq[org.iptc.sportsml.v3.SportsPropertyComplexType] = Nil,
  name: Seq[org.iptc.sportsml.v3.ConceptNameType] = Nil,
  site: Seq[org.iptc.sportsml.v3.SiteComplexType] = Nil,
  award: Seq[org.iptc.sportsml.v3.AwardComplexType] = Nil,
  eventSponsor: Seq[org.iptc.sportsml.v3.EventSponsorComplexType] = Nil,
  eventRecurringName: Seq[org.iptc.sportsml.v3.ConceptNameType] = Nil,
  eventmetadatacomplextypeoption: Option[scalaxb.DataRecord[org.iptc.sportsml.v3.EventMetadataComplexTypeOption]] = None,
  attributes: Map[String, scalaxb.DataRecord[Any]] = Map()) extends BaseEventMetadataComplexTypable {
  lazy val id = attributes.get("@id") map { _.as[String]}
  lazy val classValue = attributes.get("@class") map { _.as[String]}
  lazy val style = attributes.get("@style") map { _.as[String]}
  lazy val statsCoverage = attributes.get("@stats-coverage") map { _.as[String]}
  lazy val teamCoverage = attributes.get("@team-coverage") map { _.as[TeamCoverage]}
  lazy val durationScope = attributes.get("@duration-scope") map { _.as[String]}
  lazy val alignmentScope = attributes.get("@alignment-scope") map { _.as[AlignmentScope]}
  lazy val position = attributes.get("@position") map { _.as[String]}
  lazy val recordMakingScope = attributes.get("@record-making-scope") map { _.as[String]}
  lazy val scopingLabel = attributes.get("@scoping-label") map { _.as[String]}
  lazy val periodValue = attributes.get("@period-value") map { _.as[String]}
  lazy val periodType = attributes.get("@period-type") map { _.as[String]}
  lazy val startDateTime = attributes.get("@start-date-time") map { _.as[String]}
  lazy val endDateTime = attributes.get("@end-date-time") map { _.as[String]}
  lazy val periodStartDateTime = attributes.get("@period-start-date-time") map { _.as[String]}
  lazy val periodEndDateTime = attributes.get("@period-end-date-time") map { _.as[String]}
  lazy val temporalUnitType = attributes.get("@temporal-unit-type") map { _.as[String]}
  lazy val temporalUnitValue = attributes.get("@temporal-unit-value") map { _.as[String]}
  lazy val eventSpan = attributes.get("@event-span") map { _.as[BigInt]}
  lazy val opponentValue = attributes.get("@opponent-value") map { _.as[String]}
  lazy val opponentType = attributes.get("@opponent-type") map { _.as[String]}
  lazy val team = attributes.get("@team") map { _.as[String]}
  lazy val competition = attributes.get("@competition") map { _.as[String]}
  lazy val unitValue = attributes.get("@unit-value") map { _.as[String]}
  lazy val unitType = attributes.get("@unit-type") map { _.as[String]}
  lazy val situation = attributes.get("@situation") map { _.as[String]}
  lazy val locationKey = attributes.get("@location-key") map { _.as[String]}
  lazy val venueType = attributes.get("@venue-type") map { _.as[String]}
  lazy val surfaceType = attributes.get("@surface-type") map { _.as[String]}
  lazy val weatherType = attributes.get("@weather-type") map { _.as[String]}
  lazy val scopeValue = attributes.get("@scope-value") map { _.as[String]}
  lazy val distance = attributes.get("@distance") map { _.as[String]}
  lazy val distanceMaximum = attributes.get("@distance-maximum") map { _.as[String]}
  lazy val distanceMinimum = attributes.get("@distance-minimum") map { _.as[String]}
  lazy val measurementUnits = attributes.get("@measurement-units") map { _.as[String]}
  lazy val key = attributes.get("@key") map { _.as[String]}
  lazy val minutesElapsed = attributes.get("@minutes-elapsed") map { _.as[String]}
  lazy val periodMinuteElapsed = attributes.get("@period-minute-elapsed") map { _.as[String]}
  lazy val periodTimeElapsed = attributes.get("@period-time-elapsed") map { _.as[String]}
  lazy val periodTimeRemaining = attributes.get("@period-time-remaining") map { _.as[String]}
  lazy val eventRecurringKey = attributes.get("@event-recurring-key") map { _.as[String]}
  lazy val eventStyle = attributes.get("@event-style") map { _.as[String]}
  lazy val eventNumber = attributes.get("@event-number") map { _.as[BigInt]}
  lazy val eventStatus = attributes.get("@event-status") map { _.as[String]}
  lazy val eventType = attributes.get("@event-type") map { _.as[String]}
  lazy val eventStatusReason = attributes.get("@event-status-reason") map { _.as[String]}
  lazy val eventStatusNote = attributes.get("@event-status-note") map { _.as[String]}
  lazy val eventOfDay = attributes.get("@event-of-day") map { _.as[String]}
  lazy val eventsDayTotal = attributes.get("@events-day-total") map { _.as[String]}
  lazy val startWeekday = attributes.get("@start-weekday") map { _.as[String]}
  lazy val endWeekday = attributes.get("@end-weekday") map { _.as[String]}
  lazy val heatNumber = attributes.get("@heat-number") map { _.as[String]}
  lazy val duration = attributes.get("@duration") map { _.as[javax.xml.datatype.Duration]}
  lazy val timeCertainty = attributes.get("@time-certainty") map { _.as[TimeCertainty]}
  lazy val seasonKey = attributes.get("@season-key") map { _.as[String]}
  lazy val seasonType = attributes.get("@season-type") map { _.as[String]}
  lazy val seriesIndex = attributes.get("@series-index") map { _.as[String]}
  lazy val eventOutcomeType = attributes.get("@event-outcome-type") map { _.as[String]}
}

      

trait EventMetadataComplexTypeOption

/** Stats applying to the game as a whole. Initially designed for motor-racing, but potentially applicable to many sports.
*/
case class EventStatsComplexType(sportsProperty: Seq[org.iptc.sportsml.v3.SportsPropertyComplexType] = Nil,
  eventstatscomplextypeoption: Option[scalaxb.DataRecord[org.iptc.sportsml.v3.MotorRacingEventStatsComplexType]] = None,
  attributes: Map[String, scalaxb.DataRecord[Any]] = Map()) {
  lazy val id = attributes.get("@id") map { _.as[String]}
  lazy val classValue = attributes.get("@class") map { _.as[String]}
  lazy val style = attributes.get("@style") map { _.as[String]}
  lazy val statsCoverage = attributes.get("@stats-coverage") map { _.as[String]}
  lazy val teamCoverage = attributes.get("@team-coverage") map { _.as[TeamCoverage]}
  lazy val durationScope = attributes.get("@duration-scope") map { _.as[String]}
  lazy val alignmentScope = attributes.get("@alignment-scope") map { _.as[AlignmentScope]}
  lazy val position = attributes.get("@position") map { _.as[String]}
  lazy val recordMakingScope = attributes.get("@record-making-scope") map { _.as[String]}
  lazy val scopingLabel = attributes.get("@scoping-label") map { _.as[String]}
  lazy val periodValue = attributes.get("@period-value") map { _.as[String]}
  lazy val periodType = attributes.get("@period-type") map { _.as[String]}
  lazy val startDateTime = attributes.get("@start-date-time") map { _.as[String]}
  lazy val endDateTime = attributes.get("@end-date-time") map { _.as[String]}
  lazy val periodStartDateTime = attributes.get("@period-start-date-time") map { _.as[String]}
  lazy val periodEndDateTime = attributes.get("@period-end-date-time") map { _.as[String]}
  lazy val temporalUnitType = attributes.get("@temporal-unit-type") map { _.as[String]}
  lazy val temporalUnitValue = attributes.get("@temporal-unit-value") map { _.as[String]}
  lazy val eventSpan = attributes.get("@event-span") map { _.as[BigInt]}
  lazy val opponentValue = attributes.get("@opponent-value") map { _.as[String]}
  lazy val opponentType = attributes.get("@opponent-type") map { _.as[String]}
  lazy val team = attributes.get("@team") map { _.as[String]}
  lazy val competition = attributes.get("@competition") map { _.as[String]}
  lazy val unitValue = attributes.get("@unit-value") map { _.as[String]}
  lazy val unitType = attributes.get("@unit-type") map { _.as[String]}
  lazy val situation = attributes.get("@situation") map { _.as[String]}
  lazy val locationKey = attributes.get("@location-key") map { _.as[String]}
  lazy val venueType = attributes.get("@venue-type") map { _.as[String]}
  lazy val surfaceType = attributes.get("@surface-type") map { _.as[String]}
  lazy val weatherType = attributes.get("@weather-type") map { _.as[String]}
  lazy val scopeValue = attributes.get("@scope-value") map { _.as[String]}
  lazy val distance = attributes.get("@distance") map { _.as[String]}
  lazy val distanceMaximum = attributes.get("@distance-maximum") map { _.as[String]}
  lazy val distanceMinimum = attributes.get("@distance-minimum") map { _.as[String]}
  lazy val measurementUnits = attributes.get("@measurement-units") map { _.as[String]}
}

      

trait EventStatsComplexTypeOption

/** Complex type for sports events, both generic and sport specific.
*/
case class EventActionsComplexType(action: Seq[org.iptc.sportsml.v3.BaseActionComplexType] = Nil,
  attributes: Map[String, scalaxb.DataRecord[Any]] = Map()) {
  lazy val id = attributes.get("@id") map { _.as[String]}
  lazy val classValue = attributes.get("@class") map { _.as[String]}
  lazy val style = attributes.get("@style") map { _.as[String]}
}

      


/** Background data about a tournament. | Where and when the this tournament took place.
*/
case class TournamentMetadataComplexType(sportsContentCodes: Option[org.iptc.sportsml.v3.SportsContentCodesComplexType] = None,
  sportsProperty: Seq[org.iptc.sportsml.v3.SportsPropertyComplexType] = Nil,
  name: Seq[org.iptc.sportsml.v3.ConceptNameType] = Nil,
  site: Seq[org.iptc.sportsml.v3.SiteComplexType] = Nil,
  award: Seq[org.iptc.sportsml.v3.AwardComplexType] = Nil,
  tournamentmetadatacomplextypeoption: Option[scalaxb.DataRecord[org.iptc.sportsml.v3.TournamentMetadataComplexTypeOption]] = None,
  attributes: Map[String, scalaxb.DataRecord[Any]] = Map()) extends BaseTournamentMetadataComplexTypable {
  lazy val id = attributes.get("@id") map { _.as[String]}
  lazy val classValue = attributes.get("@class") map { _.as[String]}
  lazy val style = attributes.get("@style") map { _.as[String]}
  lazy val statsCoverage = attributes.get("@stats-coverage") map { _.as[String]}
  lazy val teamCoverage = attributes.get("@team-coverage") map { _.as[TeamCoverage]}
  lazy val durationScope = attributes.get("@duration-scope") map { _.as[String]}
  lazy val alignmentScope = attributes.get("@alignment-scope") map { _.as[AlignmentScope]}
  lazy val position = attributes.get("@position") map { _.as[String]}
  lazy val recordMakingScope = attributes.get("@record-making-scope") map { _.as[String]}
  lazy val scopingLabel = attributes.get("@scoping-label") map { _.as[String]}
  lazy val periodValue = attributes.get("@period-value") map { _.as[String]}
  lazy val periodType = attributes.get("@period-type") map { _.as[String]}
  lazy val startDateTime = attributes.get("@start-date-time") map { _.as[String]}
  lazy val endDateTime = attributes.get("@end-date-time") map { _.as[String]}
  lazy val periodStartDateTime = attributes.get("@period-start-date-time") map { _.as[String]}
  lazy val periodEndDateTime = attributes.get("@period-end-date-time") map { _.as[String]}
  lazy val temporalUnitType = attributes.get("@temporal-unit-type") map { _.as[String]}
  lazy val temporalUnitValue = attributes.get("@temporal-unit-value") map { _.as[String]}
  lazy val eventSpan = attributes.get("@event-span") map { _.as[BigInt]}
  lazy val opponentValue = attributes.get("@opponent-value") map { _.as[String]}
  lazy val opponentType = attributes.get("@opponent-type") map { _.as[String]}
  lazy val team = attributes.get("@team") map { _.as[String]}
  lazy val competition = attributes.get("@competition") map { _.as[String]}
  lazy val unitValue = attributes.get("@unit-value") map { _.as[String]}
  lazy val unitType = attributes.get("@unit-type") map { _.as[String]}
  lazy val situation = attributes.get("@situation") map { _.as[String]}
  lazy val locationKey = attributes.get("@location-key") map { _.as[String]}
  lazy val venueType = attributes.get("@venue-type") map { _.as[String]}
  lazy val surfaceType = attributes.get("@surface-type") map { _.as[String]}
  lazy val weatherType = attributes.get("@weather-type") map { _.as[String]}
  lazy val scopeValue = attributes.get("@scope-value") map { _.as[String]}
  lazy val distance = attributes.get("@distance") map { _.as[String]}
  lazy val distanceMaximum = attributes.get("@distance-maximum") map { _.as[String]}
  lazy val distanceMinimum = attributes.get("@distance-minimum") map { _.as[String]}
  lazy val measurementUnits = attributes.get("@measurement-units") map { _.as[String]}
  lazy val key = attributes.get("@key") map { _.as[String]}
  lazy val status = attributes.get("@status") map { _.as[String]}
  lazy val minimumSubparts = attributes.get("@minimum-subparts") map { _.as[BigInt]}
  lazy val maximumSubparts = attributes.get("@maximum-subparts") map { _.as[BigInt]}
  lazy val number = attributes.get("@number") map { _.as[BigInt]}
}

      

trait TournamentMetadataComplexTypeOption

/** General information about the division of this tournament. | Where and when this division is competing.
*/
case class TournamentDivisionMetadataComplexType(sportsContentCodes: Option[org.iptc.sportsml.v3.SportsContentCodesComplexType] = None,
  sportsProperty: Seq[org.iptc.sportsml.v3.SportsPropertyComplexType] = Nil,
  name: Seq[org.iptc.sportsml.v3.ConceptNameType] = Nil,
  site: Seq[org.iptc.sportsml.v3.SiteComplexType] = Nil,
  award: Seq[org.iptc.sportsml.v3.AwardComplexType] = Nil,
  tournamentdivisionmetadatacomplextypeoption: Option[scalaxb.DataRecord[org.iptc.sportsml.v3.GolfTournamentDivisionMetadataComplexType]] = None,
  attributes: Map[String, scalaxb.DataRecord[Any]] = Map()) extends BaseTournamentMetadataComplexTypable {
  lazy val id = attributes.get("@id") map { _.as[String]}
  lazy val classValue = attributes.get("@class") map { _.as[String]}
  lazy val style = attributes.get("@style") map { _.as[String]}
  lazy val statsCoverage = attributes.get("@stats-coverage") map { _.as[String]}
  lazy val teamCoverage = attributes.get("@team-coverage") map { _.as[TeamCoverage]}
  lazy val durationScope = attributes.get("@duration-scope") map { _.as[String]}
  lazy val alignmentScope = attributes.get("@alignment-scope") map { _.as[AlignmentScope]}
  lazy val position = attributes.get("@position") map { _.as[String]}
  lazy val recordMakingScope = attributes.get("@record-making-scope") map { _.as[String]}
  lazy val scopingLabel = attributes.get("@scoping-label") map { _.as[String]}
  lazy val periodValue = attributes.get("@period-value") map { _.as[String]}
  lazy val periodType = attributes.get("@period-type") map { _.as[String]}
  lazy val startDateTime = attributes.get("@start-date-time") map { _.as[String]}
  lazy val endDateTime = attributes.get("@end-date-time") map { _.as[String]}
  lazy val periodStartDateTime = attributes.get("@period-start-date-time") map { _.as[String]}
  lazy val periodEndDateTime = attributes.get("@period-end-date-time") map { _.as[String]}
  lazy val temporalUnitType = attributes.get("@temporal-unit-type") map { _.as[String]}
  lazy val temporalUnitValue = attributes.get("@temporal-unit-value") map { _.as[String]}
  lazy val eventSpan = attributes.get("@event-span") map { _.as[BigInt]}
  lazy val opponentValue = attributes.get("@opponent-value") map { _.as[String]}
  lazy val opponentType = attributes.get("@opponent-type") map { _.as[String]}
  lazy val team = attributes.get("@team") map { _.as[String]}
  lazy val competition = attributes.get("@competition") map { _.as[String]}
  lazy val unitValue = attributes.get("@unit-value") map { _.as[String]}
  lazy val unitType = attributes.get("@unit-type") map { _.as[String]}
  lazy val situation = attributes.get("@situation") map { _.as[String]}
  lazy val locationKey = attributes.get("@location-key") map { _.as[String]}
  lazy val venueType = attributes.get("@venue-type") map { _.as[String]}
  lazy val surfaceType = attributes.get("@surface-type") map { _.as[String]}
  lazy val weatherType = attributes.get("@weather-type") map { _.as[String]}
  lazy val scopeValue = attributes.get("@scope-value") map { _.as[String]}
  lazy val distance = attributes.get("@distance") map { _.as[String]}
  lazy val distanceMaximum = attributes.get("@distance-maximum") map { _.as[String]}
  lazy val distanceMinimum = attributes.get("@distance-minimum") map { _.as[String]}
  lazy val measurementUnits = attributes.get("@measurement-units") map { _.as[String]}
  lazy val key = attributes.get("@key") map { _.as[String]}
  lazy val status = attributes.get("@status") map { _.as[String]}
  lazy val minimumSubparts = attributes.get("@minimum-subparts") map { _.as[BigInt]}
  lazy val maximumSubparts = attributes.get("@maximum-subparts") map { _.as[BigInt]}
  lazy val number = attributes.get("@number") map { _.as[BigInt]}
  lazy val divisionNumber = attributes.get("@division-number") map { _.as[String]}
}

      

trait TournamentDivisionMetadataComplexTypeOption

/** General information about the division of this tournament. | Where and when this division is competing.
*/
case class TournamentPartMetadataComplexType(sportsContentCodes: Option[org.iptc.sportsml.v3.SportsContentCodesComplexType] = None,
  sportsProperty: Seq[org.iptc.sportsml.v3.SportsPropertyComplexType] = Nil,
  name: Seq[org.iptc.sportsml.v3.ConceptNameType] = Nil,
  site: Seq[org.iptc.sportsml.v3.SiteComplexType] = Nil,
  award: Seq[org.iptc.sportsml.v3.AwardComplexType] = Nil,
  attributes: Map[String, scalaxb.DataRecord[Any]] = Map()) extends BaseTournamentMetadataComplexTypable {
  lazy val id = attributes.get("@id") map { _.as[String]}
  lazy val classValue = attributes.get("@class") map { _.as[String]}
  lazy val style = attributes.get("@style") map { _.as[String]}
  lazy val statsCoverage = attributes.get("@stats-coverage") map { _.as[String]}
  lazy val teamCoverage = attributes.get("@team-coverage") map { _.as[TeamCoverage]}
  lazy val durationScope = attributes.get("@duration-scope") map { _.as[String]}
  lazy val alignmentScope = attributes.get("@alignment-scope") map { _.as[AlignmentScope]}
  lazy val position = attributes.get("@position") map { _.as[String]}
  lazy val recordMakingScope = attributes.get("@record-making-scope") map { _.as[String]}
  lazy val scopingLabel = attributes.get("@scoping-label") map { _.as[String]}
  lazy val periodValue = attributes.get("@period-value") map { _.as[String]}
  lazy val periodType = attributes.get("@period-type") map { _.as[String]}
  lazy val startDateTime = attributes.get("@start-date-time") map { _.as[String]}
  lazy val endDateTime = attributes.get("@end-date-time") map { _.as[String]}
  lazy val periodStartDateTime = attributes.get("@period-start-date-time") map { _.as[String]}
  lazy val periodEndDateTime = attributes.get("@period-end-date-time") map { _.as[String]}
  lazy val temporalUnitType = attributes.get("@temporal-unit-type") map { _.as[String]}
  lazy val temporalUnitValue = attributes.get("@temporal-unit-value") map { _.as[String]}
  lazy val eventSpan = attributes.get("@event-span") map { _.as[BigInt]}
  lazy val opponentValue = attributes.get("@opponent-value") map { _.as[String]}
  lazy val opponentType = attributes.get("@opponent-type") map { _.as[String]}
  lazy val team = attributes.get("@team") map { _.as[String]}
  lazy val competition = attributes.get("@competition") map { _.as[String]}
  lazy val unitValue = attributes.get("@unit-value") map { _.as[String]}
  lazy val unitType = attributes.get("@unit-type") map { _.as[String]}
  lazy val situation = attributes.get("@situation") map { _.as[String]}
  lazy val locationKey = attributes.get("@location-key") map { _.as[String]}
  lazy val venueType = attributes.get("@venue-type") map { _.as[String]}
  lazy val surfaceType = attributes.get("@surface-type") map { _.as[String]}
  lazy val weatherType = attributes.get("@weather-type") map { _.as[String]}
  lazy val scopeValue = attributes.get("@scope-value") map { _.as[String]}
  lazy val distance = attributes.get("@distance") map { _.as[String]}
  lazy val distanceMaximum = attributes.get("@distance-maximum") map { _.as[String]}
  lazy val distanceMinimum = attributes.get("@distance-minimum") map { _.as[String]}
  lazy val measurementUnits = attributes.get("@measurement-units") map { _.as[String]}
  lazy val key = attributes.get("@key") map { _.as[String]}
  lazy val status = attributes.get("@status") map { _.as[String]}
  lazy val minimumSubparts = attributes.get("@minimum-subparts") map { _.as[BigInt]}
  lazy val maximumSubparts = attributes.get("@maximum-subparts") map { _.as[BigInt]}
  lazy val number = attributes.get("@number") map { _.as[BigInt]}
  lazy val typeValue = attributes.get("@type") map { _.as[String]}
  lazy val formatType = attributes.get("@format-type") map { _.as[String]}
}

      


case class TeamMetadataComplexType(name: Seq[org.iptc.sportsml.v3.ConceptNameType] = Nil,
  homeLocation: Option[org.iptc.sportsml.v3.FlexLocationPropTypable] = None,
  sportsProperty: Seq[org.iptc.sportsml.v3.SportsPropertyComplexType] = Nil,
  site: Seq[org.iptc.sportsml.v3.SiteComplexType] = Nil,
  sportsContentCodes: Seq[org.iptc.sportsml.v3.SportsContentCodesComplexType] = Nil,
  teammetadatacomplextypeoption: Option[scalaxb.DataRecord[org.iptc.sportsml.v3.TeamMetadataComplexTypeOption]] = None,
  attributes: Map[String, scalaxb.DataRecord[Any]] = Map()) extends BaseTeamMetadataComplexTypable {
  lazy val id = attributes.get("@id") map { _.as[String]}
  lazy val classValue = attributes.get("@class") map { _.as[String]}
  lazy val style = attributes.get("@style") map { _.as[String]}
  lazy val key = attributes.get("@key") map { _.as[String]}
  lazy val nationality = attributes.get("@nationality") map { _.as[String]}
  lazy val alignment = attributes.get("@alignment") map { _.as[AlignmentType]}
  lazy val established = attributes.get("@established") map { _.as[String]}
  lazy val dissolved = attributes.get("@dissolved") map { _.as[String]}
  lazy val teamIdref = attributes.get("@team-idref") map { _.as[String]}
  lazy val homePageUrl = attributes.get("@home-page-url") map { _.as[java.net.URI]}
  lazy val roundPosition = attributes.get("@round-position") map { _.as[String]}
}

      

trait TeamMetadataComplexTypeOption

case class TeamStatsComplexType(rating: Seq[org.iptc.sportsml.v3.RatingComplexType] = Nil,
  sportsProperty: Seq[org.iptc.sportsml.v3.SportsPropertyComplexType] = Nil,
  stats: Seq[org.iptc.sportsml.v3.GenericStatComplexType] = Nil,
  outcomeTotals: Seq[org.iptc.sportsml.v3.OutcomeTotalsComplexType] = Nil,
  outcomeResult: Seq[org.iptc.sportsml.v3.OutcomeResultComplexType] = Nil,
  penaltyStats: Seq[org.iptc.sportsml.v3.PenaltyStatsComplexType] = Nil,
  award: Seq[org.iptc.sportsml.v3.AwardComplexType] = Nil,
  rank: Seq[org.iptc.sportsml.v3.RankComplexType] = Nil,
  subScore: Seq[org.iptc.sportsml.v3.SubScoreComplexType] = Nil,
  eventRecord: Seq[org.iptc.sportsml.v3.EventRecordComplexType] = Nil,
  teamstatscomplextypeoption: Option[scalaxb.DataRecord[org.iptc.sportsml.v3.TeamStatsComplexTypeOption]] = None,
  attributes: Map[String, scalaxb.DataRecord[Any]] = Map()) extends BaseTeamStatsComplexTypable {
  lazy val id = attributes.get("@id") map { _.as[String]}
  lazy val classValue = attributes.get("@class") map { _.as[String]}
  lazy val style = attributes.get("@style") map { _.as[String]}
  lazy val points = attributes.get("@points") map { _.as[BigInt]}
  lazy val statsCoverage = attributes.get("@stats-coverage") map { _.as[String]}
  lazy val teamCoverage = attributes.get("@team-coverage") map { _.as[TeamCoverage]}
  lazy val durationScope = attributes.get("@duration-scope") map { _.as[String]}
  lazy val alignmentScope = attributes.get("@alignment-scope") map { _.as[AlignmentScope]}
  lazy val position = attributes.get("@position") map { _.as[String]}
  lazy val recordMakingScope = attributes.get("@record-making-scope") map { _.as[String]}
  lazy val scopingLabel = attributes.get("@scoping-label") map { _.as[String]}
  lazy val periodValue = attributes.get("@period-value") map { _.as[String]}
  lazy val periodType = attributes.get("@period-type") map { _.as[String]}
  lazy val startDateTime = attributes.get("@start-date-time") map { _.as[String]}
  lazy val endDateTime = attributes.get("@end-date-time") map { _.as[String]}
  lazy val periodStartDateTime = attributes.get("@period-start-date-time") map { _.as[String]}
  lazy val periodEndDateTime = attributes.get("@period-end-date-time") map { _.as[String]}
  lazy val temporalUnitType = attributes.get("@temporal-unit-type") map { _.as[String]}
  lazy val temporalUnitValue = attributes.get("@temporal-unit-value") map { _.as[String]}
  lazy val eventSpan = attributes.get("@event-span") map { _.as[BigInt]}
  lazy val opponentValue = attributes.get("@opponent-value") map { _.as[String]}
  lazy val opponentType = attributes.get("@opponent-type") map { _.as[String]}
  lazy val team = attributes.get("@team") map { _.as[String]}
  lazy val competition = attributes.get("@competition") map { _.as[String]}
  lazy val unitValue = attributes.get("@unit-value") map { _.as[String]}
  lazy val unitType = attributes.get("@unit-type") map { _.as[String]}
  lazy val situation = attributes.get("@situation") map { _.as[String]}
  lazy val locationKey = attributes.get("@location-key") map { _.as[String]}
  lazy val venueType = attributes.get("@venue-type") map { _.as[String]}
  lazy val surfaceType = attributes.get("@surface-type") map { _.as[String]}
  lazy val weatherType = attributes.get("@weather-type") map { _.as[String]}
  lazy val scopeValue = attributes.get("@scope-value") map { _.as[String]}
  lazy val distance = attributes.get("@distance") map { _.as[String]}
  lazy val distanceMaximum = attributes.get("@distance-maximum") map { _.as[String]}
  lazy val distanceMinimum = attributes.get("@distance-minimum") map { _.as[String]}
  lazy val measurementUnits = attributes.get("@measurement-units") map { _.as[String]}
  lazy val score = attributes.get("@score") map { _.as[String]}
  lazy val scoreOpposing = attributes.get("@score-opposing") map { _.as[String]}
  lazy val scoreAverage = attributes.get("@score-average") map { _.as[String]}
  lazy val scoreOpposingAverage = attributes.get("@score-opposing-average") map { _.as[String]}
  lazy val scoreUnits = attributes.get("@score-units") map { _.as[String]}
  lazy val scoreBehind = attributes.get("@score-behind") map { _.as[String]}
  lazy val scoreAttempts = attributes.get("@score-attempts") map { _.as[String]}
  lazy val scoreAttemptsOpposing = attributes.get("@score-attempts-opposing") map { _.as[String]}
  lazy val scoreAttemptsOnGoal = attributes.get("@score-attempts-on-goal") map { _.as[String]}
  lazy val scoreAttemptsOnGoalOpposing = attributes.get("@score-attempts-on-goal-opposing") map { _.as[String]}
  lazy val scorePercentage = attributes.get("@score-percentage") map { _.as[String]}
  lazy val scorePercentageOpposing = attributes.get("@score-percentage-opposing") map { _.as[String]}
  lazy val resultEffect = attributes.get("@result-effect") map { _.as[String]}
  lazy val eventOutcome = attributes.get("@event-outcome") map { _.as[String]}
  lazy val eventStandingPoints = attributes.get("@event-standing-points") map { _.as[String]}
  lazy val eventStandingPointsAgainst = attributes.get("@event-standing-points-against") map { _.as[String]}
  lazy val scoreType = attributes.get("@score-type") map { _.as[String]}
  lazy val eventsRemaining = attributes.get("@events-remaining") map { _.as[String]}
  lazy val timeOfPossession = attributes.get("@time-of-possession") map { _.as[String]}
  lazy val timeOfPossessionPercentage = attributes.get("@time-of-possession-percentage") map { _.as[String]}
  lazy val timeOfPossessionPercentageOpposing = attributes.get("@time-of-possession-percentage-opposing") map { _.as[String]}
  lazy val timeOfPossessionAverage = attributes.get("@time-of-possession-average") map { _.as[String]}
  lazy val timeOfPossessionAverageOpposing = attributes.get("@time-of-possession-average-opposing") map { _.as[String]}
  lazy val seriesScore = attributes.get("@series-score") map { _.as[String]}
  lazy val seriesScoreOpposing = attributes.get("@series-score-opposing") map { _.as[String]}
  lazy val adjustedScoreFor = attributes.get("@adjusted-score-for") map { _.as[String]}
  lazy val adjustedScoreAgainst = attributes.get("@adjusted-score-against") map { _.as[String]}
  lazy val eventsPlayed = attributes.get("@events-played") map { _.as[BigInt]}
  lazy val timePlayedTotal = attributes.get("@time-played-total") map { _.as[String]}
}

      

trait TeamStatsComplexTypeOption

case class PlayerMetadataComplexType(name: Seq[org.iptc.sportsml.v3.ConceptNameType] = Nil,
  homeLocation: Option[org.iptc.sportsml.v3.FlexLocationPropTypable] = None,
  sportsProperty: Seq[org.iptc.sportsml.v3.SportsPropertyComplexType] = Nil,
  baseplayermetadatacomplextypableoption: Option[scalaxb.DataRecord[org.iptc.sportsml.v3.BasePlayerMetadataComplexTypableOption]] = None,
  playermetadatacomplextypeoption: Option[scalaxb.DataRecord[org.iptc.sportsml.v3.PlayerMetadataComplexTypeOption]] = None,
  attributes: Map[String, scalaxb.DataRecord[Any]] = Map()) extends BasePlayerMetadataComplexTypable {
  lazy val id = attributes.get("@id") map { _.as[String]}
  lazy val classValue = attributes.get("@class") map { _.as[String]}
  lazy val style = attributes.get("@style") map { _.as[String]}
  lazy val key = attributes.get("@key") map { _.as[String]}
  lazy val nationality = attributes.get("@nationality") map { _.as[String]}
  lazy val dateOfBirth = attributes.get("@date-of-birth") map { _.as[String]}
  lazy val dateOfDeath = attributes.get("@date-of-death") map { _.as[String]}
  lazy val height = attributes.get("@height") map { _.as[String]}
  lazy val weight = attributes.get("@weight") map { _.as[BigInt]}
  lazy val positionRegular = attributes.get("@position-regular") map { _.as[String]}
  lazy val positionEvent = attributes.get("@position-event") map { _.as[String]}
  lazy val positionDepth = attributes.get("@position-depth") map { _.as[String]}
  lazy val health = attributes.get("@health") map { _.as[String]}
  lazy val gender = attributes.get("@gender") map { _.as[GenderType]}
  lazy val teamIdref = attributes.get("@team-idref") map { _.as[String]}
  lazy val status = attributes.get("@status") map { _.as[String]}
  lazy val lineupSlot = attributes.get("@lineup-slot") map { _.as[String]}
  lazy val lineupSlotSequence = attributes.get("@lineup-slot-sequence") map { _.as[String]}
  lazy val scratchReason = attributes.get("@scratch-reason") map { _.as[String]}
  lazy val uniformNumber = attributes.get("@uniform-number") map { _.as[String]}
  lazy val homePageUrl = attributes.get("@home-page-url") map { _.as[java.net.URI]}
  lazy val roundPosition = attributes.get("@round-position") map { _.as[String]}
}

      

trait PlayerMetadataComplexTypeOption

case class PlayerStatsComplexType(rating: Seq[org.iptc.sportsml.v3.RatingComplexType] = Nil,
  sportsProperty: Seq[org.iptc.sportsml.v3.SportsPropertyComplexType] = Nil,
  stats: Seq[org.iptc.sportsml.v3.GenericStatComplexType] = Nil,
  outcomeTotals: Seq[org.iptc.sportsml.v3.OutcomeTotalsComplexType] = Nil,
  outcomeResult: Seq[org.iptc.sportsml.v3.OutcomeResultComplexType] = Nil,
  penaltyStats: Seq[org.iptc.sportsml.v3.PenaltyStatsComplexType] = Nil,
  award: Seq[org.iptc.sportsml.v3.AwardComplexType] = Nil,
  rank: Seq[org.iptc.sportsml.v3.RankComplexType] = Nil,
  subScore: Seq[org.iptc.sportsml.v3.SubScoreComplexType] = Nil,
  eventRecord: Seq[org.iptc.sportsml.v3.EventRecordComplexType] = Nil,
  playerstatscomplextypeoption: Option[scalaxb.DataRecord[org.iptc.sportsml.v3.PlayerStatsComplexTypeOption]] = None,
  attributes: Map[String, scalaxb.DataRecord[Any]] = Map()) extends BasePlayerStatsComplexTypable {
  lazy val id = attributes.get("@id") map { _.as[String]}
  lazy val classValue = attributes.get("@class") map { _.as[String]}
  lazy val style = attributes.get("@style") map { _.as[String]}
  lazy val points = attributes.get("@points") map { _.as[BigInt]}
  lazy val statsCoverage = attributes.get("@stats-coverage") map { _.as[String]}
  lazy val teamCoverage = attributes.get("@team-coverage") map { _.as[TeamCoverage]}
  lazy val durationScope = attributes.get("@duration-scope") map { _.as[String]}
  lazy val alignmentScope = attributes.get("@alignment-scope") map { _.as[AlignmentScope]}
  lazy val position = attributes.get("@position") map { _.as[String]}
  lazy val recordMakingScope = attributes.get("@record-making-scope") map { _.as[String]}
  lazy val scopingLabel = attributes.get("@scoping-label") map { _.as[String]}
  lazy val periodValue = attributes.get("@period-value") map { _.as[String]}
  lazy val periodType = attributes.get("@period-type") map { _.as[String]}
  lazy val startDateTime = attributes.get("@start-date-time") map { _.as[String]}
  lazy val endDateTime = attributes.get("@end-date-time") map { _.as[String]}
  lazy val periodStartDateTime = attributes.get("@period-start-date-time") map { _.as[String]}
  lazy val periodEndDateTime = attributes.get("@period-end-date-time") map { _.as[String]}
  lazy val temporalUnitType = attributes.get("@temporal-unit-type") map { _.as[String]}
  lazy val temporalUnitValue = attributes.get("@temporal-unit-value") map { _.as[String]}
  lazy val eventSpan = attributes.get("@event-span") map { _.as[BigInt]}
  lazy val opponentValue = attributes.get("@opponent-value") map { _.as[String]}
  lazy val opponentType = attributes.get("@opponent-type") map { _.as[String]}
  lazy val team = attributes.get("@team") map { _.as[String]}
  lazy val competition = attributes.get("@competition") map { _.as[String]}
  lazy val unitValue = attributes.get("@unit-value") map { _.as[String]}
  lazy val unitType = attributes.get("@unit-type") map { _.as[String]}
  lazy val situation = attributes.get("@situation") map { _.as[String]}
  lazy val locationKey = attributes.get("@location-key") map { _.as[String]}
  lazy val venueType = attributes.get("@venue-type") map { _.as[String]}
  lazy val surfaceType = attributes.get("@surface-type") map { _.as[String]}
  lazy val weatherType = attributes.get("@weather-type") map { _.as[String]}
  lazy val scopeValue = attributes.get("@scope-value") map { _.as[String]}
  lazy val distance = attributes.get("@distance") map { _.as[String]}
  lazy val distanceMaximum = attributes.get("@distance-maximum") map { _.as[String]}
  lazy val distanceMinimum = attributes.get("@distance-minimum") map { _.as[String]}
  lazy val measurementUnits = attributes.get("@measurement-units") map { _.as[String]}
  lazy val score = attributes.get("@score") map { _.as[String]}
  lazy val scoreOpposing = attributes.get("@score-opposing") map { _.as[String]}
  lazy val scoreAverage = attributes.get("@score-average") map { _.as[String]}
  lazy val scoreOpposingAverage = attributes.get("@score-opposing-average") map { _.as[String]}
  lazy val scoreUnits = attributes.get("@score-units") map { _.as[String]}
  lazy val scoreBehind = attributes.get("@score-behind") map { _.as[String]}
  lazy val scoreAttempts = attributes.get("@score-attempts") map { _.as[String]}
  lazy val scoreAttemptsOpposing = attributes.get("@score-attempts-opposing") map { _.as[String]}
  lazy val scoreAttemptsOnGoal = attributes.get("@score-attempts-on-goal") map { _.as[String]}
  lazy val scoreAttemptsOnGoalOpposing = attributes.get("@score-attempts-on-goal-opposing") map { _.as[String]}
  lazy val scorePercentage = attributes.get("@score-percentage") map { _.as[String]}
  lazy val scorePercentageOpposing = attributes.get("@score-percentage-opposing") map { _.as[String]}
  lazy val resultEffect = attributes.get("@result-effect") map { _.as[String]}
  lazy val eventOutcome = attributes.get("@event-outcome") map { _.as[String]}
  lazy val eventStandingPoints = attributes.get("@event-standing-points") map { _.as[String]}
  lazy val eventStandingPointsAgainst = attributes.get("@event-standing-points-against") map { _.as[String]}
  lazy val scoreType = attributes.get("@score-type") map { _.as[String]}
  lazy val eventsRemaining = attributes.get("@events-remaining") map { _.as[String]}
  lazy val timeOfPossession = attributes.get("@time-of-possession") map { _.as[String]}
  lazy val timeOfPossessionPercentage = attributes.get("@time-of-possession-percentage") map { _.as[String]}
  lazy val timeOfPossessionPercentageOpposing = attributes.get("@time-of-possession-percentage-opposing") map { _.as[String]}
  lazy val timeOfPossessionAverage = attributes.get("@time-of-possession-average") map { _.as[String]}
  lazy val timeOfPossessionAverageOpposing = attributes.get("@time-of-possession-average-opposing") map { _.as[String]}
  lazy val seriesScore = attributes.get("@series-score") map { _.as[String]}
  lazy val seriesScoreOpposing = attributes.get("@series-score-opposing") map { _.as[String]}
  lazy val adjustedScoreFor = attributes.get("@adjusted-score-for") map { _.as[String]}
  lazy val adjustedScoreAgainst = attributes.get("@adjusted-score-against") map { _.as[String]}
  lazy val eventsPlayed = attributes.get("@events-played") map { _.as[BigInt]}
  lazy val timePlayedTotal = attributes.get("@time-played-total") map { _.as[String]}
  lazy val timePlayedEvent = attributes.get("@time-played-event") map { _.as[String]}
  lazy val timePlayedEventAverage = attributes.get("@time-played-event-average") map { _.as[String]}
  lazy val eventsStarted = attributes.get("@events-started") map { _.as[BigInt]}
  lazy val dateTimeEntered = attributes.get("@date-time-entered") map { _.as[javax.xml.datatype.XMLGregorianCalendar]}
  lazy val dateTimeExited = attributes.get("@date-time-exited") map { _.as[javax.xml.datatype.XMLGregorianCalendar]}
  lazy val eventTimeEntered = attributes.get("@event-time-entered") map { _.as[String]}
  lazy val eventTimeExited = attributes.get("@event-time-exited") map { _.as[String]}
}

      

trait PlayerStatsComplexTypeOption

case class OfficialMetadataComplexType(name: Seq[org.iptc.sportsml.v3.ConceptNameType] = Nil,
  homeLocation: Option[org.iptc.sportsml.v3.FlexLocationPropTypable] = None,
  sportsProperty: Seq[org.iptc.sportsml.v3.SportsPropertyComplexType] = Nil,
  attributes: Map[String, scalaxb.DataRecord[Any]] = Map()) extends BaseOfficialMetadataComplexTypable {
  lazy val id = attributes.get("@id") map { _.as[String]}
  lazy val classValue = attributes.get("@class") map { _.as[String]}
  lazy val style = attributes.get("@style") map { _.as[String]}
  lazy val key = attributes.get("@key") map { _.as[String]}
  lazy val nationality = attributes.get("@nationality") map { _.as[String]}
  lazy val dateOfBirth = attributes.get("@date-of-birth") map { _.as[String]}
  lazy val dateOfDeath = attributes.get("@date-of-death") map { _.as[String]}
  lazy val height = attributes.get("@height") map { _.as[String]}
  lazy val weight = attributes.get("@weight") map { _.as[BigInt]}
  lazy val positionRegular = attributes.get("@position-regular") map { _.as[String]}
  lazy val positionEvent = attributes.get("@position-event") map { _.as[String]}
  lazy val positionDepth = attributes.get("@position-depth") map { _.as[String]}
  lazy val health = attributes.get("@health") map { _.as[String]}
  lazy val gender = attributes.get("@gender") map { _.as[GenderType]}
  lazy val uniformNumber = attributes.get("@uniform-number") map { _.as[String]}
}

      


case class OfficialStatsComplexType(rating: Seq[org.iptc.sportsml.v3.RatingComplexType] = Nil,
  sportsProperty: Seq[org.iptc.sportsml.v3.SportsPropertyComplexType] = Nil,
  stats: Seq[org.iptc.sportsml.v3.GenericStatComplexType] = Nil,
  attributes: Map[String, scalaxb.DataRecord[Any]] = Map()) extends BaseStatsComplexTypable {
  lazy val id = attributes.get("@id") map { _.as[String]}
  lazy val classValue = attributes.get("@class") map { _.as[String]}
  lazy val style = attributes.get("@style") map { _.as[String]}
}

      


case class AssociateStatsComplexType(rating: Seq[org.iptc.sportsml.v3.RatingComplexType] = Nil,
  sportsProperty: Seq[org.iptc.sportsml.v3.SportsPropertyComplexType] = Nil,
  stats: Seq[org.iptc.sportsml.v3.GenericStatComplexType] = Nil,
  outcomeTotals: Seq[org.iptc.sportsml.v3.OutcomeTotalsComplexType] = Nil,
  outcomeResult: Seq[org.iptc.sportsml.v3.OutcomeResultComplexType] = Nil,
  attributes: Map[String, scalaxb.DataRecord[Any]] = Map()) extends Base2StatsComplexTypable {
  lazy val id = attributes.get("@id") map { _.as[String]}
  lazy val classValue = attributes.get("@class") map { _.as[String]}
  lazy val style = attributes.get("@style") map { _.as[String]}
  lazy val points = attributes.get("@points") map { _.as[BigInt]}
}

      


case class AssociateMetadataComplexType(name: Seq[org.iptc.sportsml.v3.ConceptNameType] = Nil,
  homeLocation: Option[org.iptc.sportsml.v3.FlexLocationPropTypable] = None,
  sportsProperty: Seq[org.iptc.sportsml.v3.SportsPropertyComplexType] = Nil,
  associatemetadatacomplextypeoption: Option[scalaxb.DataRecord[org.iptc.sportsml.v3.MotorRacingAssociateMetadataComplexType]] = None,
  attributes: Map[String, scalaxb.DataRecord[Any]] = Map()) extends BaseAssociateMetadataComplexTypable {
  lazy val id = attributes.get("@id") map { _.as[String]}
  lazy val classValue = attributes.get("@class") map { _.as[String]}
  lazy val style = attributes.get("@style") map { _.as[String]}
  lazy val key = attributes.get("@key") map { _.as[String]}
  lazy val nationality = attributes.get("@nationality") map { _.as[String]}
  lazy val dateOfBirth = attributes.get("@date-of-birth") map { _.as[String]}
  lazy val dateOfDeath = attributes.get("@date-of-death") map { _.as[String]}
  lazy val height = attributes.get("@height") map { _.as[String]}
  lazy val weight = attributes.get("@weight") map { _.as[BigInt]}
  lazy val positionRegular = attributes.get("@position-regular") map { _.as[String]}
  lazy val positionEvent = attributes.get("@position-event") map { _.as[String]}
  lazy val positionDepth = attributes.get("@position-depth") map { _.as[String]}
  lazy val health = attributes.get("@health") map { _.as[String]}
  lazy val gender = attributes.get("@gender") map { _.as[GenderType]}
}

      

trait AssociateMetadataComplexTypeOption

case class Advisory(mixed: Seq[scalaxb.DataRecord[Any]] = Nil,
  attributes: Map[String, scalaxb.DataRecord[Any]] = Map()) {
  lazy val id = attributes.get("@id") map { _.as[String]}
  lazy val classValue = attributes.get("@class") map { _.as[String]}
  lazy val style = attributes.get("@style") map { _.as[String]}
}

      


case class SportsMetadataComplexType(sportsContentCodes: Option[org.iptc.sportsml.v3.SportsContentCodesComplexType] = None,
  sportsProperty: Seq[org.iptc.sportsml.v3.SportsPropertyComplexType] = Nil,
  catalogRef: Seq[org.iptc.sportsml.v3.CatalogRef2] = Nil,
  sportsTitle: Seq[org.iptc.sportsml.v3.ConceptNameType] = Nil,
  advisory: Option[org.iptc.sportsml.v3.Advisory] = None,
  featureName: Seq[org.iptc.sportsml.v3.ConceptNameType] = Nil,
  attributes: Map[String, scalaxb.DataRecord[Any]] = Map()) extends BaseMetadataComplexTypable with SportsContentOption {
  lazy val id = attributes.get("@id") map { _.as[String]}
  lazy val classValue = attributes.get("@class") map { _.as[String]}
  lazy val style = attributes.get("@style") map { _.as[String]}
  lazy val statsCoverage = attributes.get("@stats-coverage") map { _.as[String]}
  lazy val teamCoverage = attributes.get("@team-coverage") map { _.as[TeamCoverage]}
  lazy val durationScope = attributes.get("@duration-scope") map { _.as[String]}
  lazy val alignmentScope = attributes.get("@alignment-scope") map { _.as[AlignmentScope]}
  lazy val position = attributes.get("@position") map { _.as[String]}
  lazy val recordMakingScope = attributes.get("@record-making-scope") map { _.as[String]}
  lazy val scopingLabel = attributes.get("@scoping-label") map { _.as[String]}
  lazy val periodValue = attributes.get("@period-value") map { _.as[String]}
  lazy val periodType = attributes.get("@period-type") map { _.as[String]}
  lazy val startDateTime = attributes.get("@start-date-time") map { _.as[String]}
  lazy val endDateTime = attributes.get("@end-date-time") map { _.as[String]}
  lazy val periodStartDateTime = attributes.get("@period-start-date-time") map { _.as[String]}
  lazy val periodEndDateTime = attributes.get("@period-end-date-time") map { _.as[String]}
  lazy val temporalUnitType = attributes.get("@temporal-unit-type") map { _.as[String]}
  lazy val temporalUnitValue = attributes.get("@temporal-unit-value") map { _.as[String]}
  lazy val eventSpan = attributes.get("@event-span") map { _.as[BigInt]}
  lazy val opponentValue = attributes.get("@opponent-value") map { _.as[String]}
  lazy val opponentType = attributes.get("@opponent-type") map { _.as[String]}
  lazy val team = attributes.get("@team") map { _.as[String]}
  lazy val competition = attributes.get("@competition") map { _.as[String]}
  lazy val unitValue = attributes.get("@unit-value") map { _.as[String]}
  lazy val unitType = attributes.get("@unit-type") map { _.as[String]}
  lazy val situation = attributes.get("@situation") map { _.as[String]}
  lazy val locationKey = attributes.get("@location-key") map { _.as[String]}
  lazy val venueType = attributes.get("@venue-type") map { _.as[String]}
  lazy val surfaceType = attributes.get("@surface-type") map { _.as[String]}
  lazy val weatherType = attributes.get("@weather-type") map { _.as[String]}
  lazy val scopeValue = attributes.get("@scope-value") map { _.as[String]}
  lazy val distance = attributes.get("@distance") map { _.as[String]}
  lazy val distanceMaximum = attributes.get("@distance-maximum") map { _.as[String]}
  lazy val distanceMinimum = attributes.get("@distance-minimum") map { _.as[String]}
  lazy val measurementUnits = attributes.get("@measurement-units") map { _.as[String]}
  lazy val docId = attributes("@doc-id").as[String]
  lazy val publisher = attributes.get("@publisher") map { _.as[String]}
  lazy val dateTime = attributes.get("@date-time") map { _.as[String]}
  lazy val language = attributes.get("@language") map { _.as[String]}
  lazy val slug = attributes.get("@slug") map { _.as[String]}
  lazy val documentClass = attributes.get("@document-class") map { _.as[String]}
  lazy val fixtureKey = attributes.get("@fixture-key") map { _.as[String]}
}

      


/** A container for content-codes. | Can hold as many codes as needed to describe all contents at this level and below.
*/
case class SportsContentCodesComplexType(sportscontentcodescomplextypesequence1: Seq[org.iptc.sportsml.v3.SportsContentCodesComplexTypeSequence1] = Nil,
  attributes: Map[String, scalaxb.DataRecord[Any]] = Map()) {
  lazy val id = attributes.get("@id") map { _.as[String]}
  lazy val classValue = attributes.get("@class") map { _.as[String]}
  lazy val style = attributes.get("@style") map { _.as[String]}
}

      

case class SportsContentCodesComplexTypeSequence1(sportsContentCode: org.iptc.sportsml.v3.SportsContentCodeComplexType)

/** An individual code that describes an entity one may want to filter for. Describes what sports, what teams, etc., are covered.
*/
case class SportsContentCodeComplexType(sportscontentcodecomplextypesequence1: Seq[org.iptc.sportsml.v3.SportsContentCodeComplexTypeSequence1] = Nil,
  attributes: Map[String, scalaxb.DataRecord[Any]] = Map()) {
  lazy val id = attributes.get("@id") map { _.as[String]}
  lazy val classValue = attributes.get("@class") map { _.as[String]}
  lazy val style = attributes.get("@style") map { _.as[String]}
  lazy val codeType = attributes("@code-type").as[String]
  lazy val codeKey = attributes.get("@code-key") map { _.as[String]}
  lazy val codeName = attributes.get("@code-name") map { _.as[String]}
}

      

case class SportsContentCodeComplexTypeSequence1(sportsContentQualifier: org.iptc.sportsml.v3.SportsContentQualifierComplexType)
trait Gender

object Gender {
  def fromString(value: String, scope: scala.xml.NamespaceBinding)(implicit fmt: scalaxb.XMLFormat[org.iptc.sportsml.v3.Gender]): Gender = fmt.reads(scala.xml.Text(value), Nil) match {
    case Right(x: Gender) => x
    case x => throw new RuntimeException(s"fromString returned unexpected value $x for input $value")
  }
}

case object Male extends Gender { override def toString = "male" }
case object Female extends Gender { override def toString = "female" }
case object Mixed extends Gender { override def toString = "mixed" }


/** Further refinement/elaboration of a sports-content-code. | If the document covers more than one of these, additional sports-content-qualifier elements may be used.
*/
case class SportsContentQualifierComplexType(attributes: Map[String, scalaxb.DataRecord[Any]] = Map()) {
  lazy val id = attributes.get("@id") map { _.as[String]}
  lazy val classValue = attributes.get("@class") map { _.as[String]}
  lazy val style = attributes.get("@style") map { _.as[String]}
  lazy val gender = attributes.get("@gender") map { _.as[Gender]}
  lazy val participantCount = attributes.get("@participant-count") map { _.as[String]}
  lazy val professionalStatus = attributes.get("@professional-status") map { _.as[String]}
  lazy val specialGroup = attributes.get("@special-group") map { _.as[String]}
  lazy val minimumAge = attributes.get("@minimum-age") map { _.as[String]}
  lazy val maximumAge = attributes.get("@maximum-age") map { _.as[String]}
  lazy val specialNeeds = attributes.get("@special-needs") map { _.as[String]}
}

      


/** An extensible property, similar to structures in NewsML 1.
*/
case class SportsPropertyComplexType(attributes: Map[String, scalaxb.DataRecord[Any]] = Map()) {
  lazy val id = attributes.get("@id") map { _.as[String]}
  lazy val classValue = attributes.get("@class") map { _.as[String]}
  lazy val style = attributes.get("@style") map { _.as[String]}
  lazy val formalName = attributes.get("@formal-name") map { _.as[String]}
  lazy val vocabulary = attributes.get("@vocabulary") map { _.as[String]}
  lazy val scheme = attributes.get("@scheme") map { _.as[String]}
  lazy val valueAttribute = attributes.get("@value") map { _.as[String]}
  lazy val allowedValues = attributes.get("@allowed-values") map { _.as[String]}
}

      


/** A sporting competition. | A contest that generally ends with a winner.
*/
case class SportsEventComplexType(eventMetadata: Option[org.iptc.sportsml.v3.EventMetadataComplexType] = None,
  eventStats: Option[org.iptc.sportsml.v3.EventStatsComplexType] = None,
  sportseventcomplextypeoption: Seq[scalaxb.DataRecord[org.iptc.sportsml.v3.SportsEventComplexTypeOption]] = Nil,
  wageringStats: Seq[org.iptc.sportsml.v3.WageringStats] = Nil,
  officials: Option[org.iptc.sportsml.v3.OfficialsComplexType] = None,
  actions: Option[org.iptc.sportsml.v3.EventActionsComplexType] = None,
  highlight: Seq[org.iptc.sportsml.v3.HighlightComplexType] = Nil,
  award: Seq[org.iptc.sportsml.v3.AwardComplexType] = Nil,
  sportsEvent: Seq[org.iptc.sportsml.v3.SportsEventComplexType] = Nil,
  attributes: Map[String, scalaxb.DataRecord[Any]] = Map()) extends SportsContentOption with TournamentComplexTypeOption with TournamentDivisionComplexTypeOption with TournamentPartComplexTypeOption {
  lazy val id = attributes.get("@id") map { _.as[String]}
  lazy val classValue = attributes.get("@class") map { _.as[String]}
  lazy val style = attributes.get("@style") map { _.as[String]}
}

      

trait SportsEventComplexTypeOption

/** A sponsor for an event. | Events can have more than one sponsor.
*/
case class EventSponsorComplexType(name: Seq[org.iptc.sportsml.v3.ConceptNameType] = Nil,
  attributes: Map[String, scalaxb.DataRecord[Any]] = Map()) {
  lazy val id = attributes.get("@id") map { _.as[String]}
  lazy val classValue = attributes.get("@class") map { _.as[String]}
  lazy val style = attributes.get("@style") map { _.as[String]}
  lazy val typeValue = attributes.get("@type") map { _.as[String]}
}

      


/** A textual highlight. | Can hold plain text, or could hold NITF.
*/
case class HighlightComplexType(mixed: Seq[scalaxb.DataRecord[Any]] = Nil,
  attributes: Map[String, scalaxb.DataRecord[Any]] = Map()) {
  lazy val id = attributes.get("@id") map { _.as[String]}
  lazy val classValue = attributes.get("@class") map { _.as[String]}
  lazy val style = attributes.get("@style") map { _.as[String]}
}

      


/** An element housing data having to do with a venue, stadium, arena, field, etc.
*/
case class SiteComplexType(siteMetadata: org.iptc.sportsml.v3.SiteMetadataComplexType,
  siteStats: Seq[org.iptc.sportsml.v3.SiteStatsComnplexType] = Nil,
  attributes: Map[String, scalaxb.DataRecord[Any]] = Map()) {
  lazy val id = attributes.get("@id") map { _.as[String]}
  lazy val classValue = attributes.get("@class") map { _.as[String]}
  lazy val style = attributes.get("@style") map { _.as[String]}
}

      


/** Metadata about the site.
*/
case class SiteMetadataComplexType(name: Seq[org.iptc.sportsml.v3.ConceptNameType] = Nil,
  homeLocation: Option[org.iptc.sportsml.v3.FlexLocationPropTypable] = None,
  sportsProperty: Seq[org.iptc.sportsml.v3.SportsPropertyComplexType] = Nil,
  sportsContentCodes: Option[org.iptc.sportsml.v3.SportsContentCodesComplexType] = None,
  attributes: Map[String, scalaxb.DataRecord[Any]] = Map()) extends BaseEntityMetadataComplexTypable {
  lazy val id = attributes.get("@id") map { _.as[String]}
  lazy val classValue = attributes.get("@class") map { _.as[String]}
  lazy val style = attributes.get("@style") map { _.as[String]}
  lazy val key = attributes.get("@key") map { _.as[String]}
  lazy val nationality = attributes.get("@nationality") map { _.as[String]}
  lazy val capacity = attributes.get("@capacity") map { _.as[String]}
  lazy val siteStyle = attributes.get("@site-style") map { _.as[String]}
  lazy val surface = attributes.get("@surface") map { _.as[String]}
  lazy val shape = attributes.get("@shape") map { _.as[String]}
  lazy val incline = attributes.get("@incline") map { _.as[String]}
  lazy val length = attributes.get("@length") map { _.as[String]}
  lazy val lengthUnits = attributes.get("@length-units") map { _.as[String]}
  lazy val typeValue = attributes.get("@type") map { _.as[String]}
  lazy val homePageUrl = attributes.get("@home-page-url") map { _.as[java.net.URI]}
  lazy val created = attributes.get("@created") map { _.as[String]}
  lazy val ceasedToExist = attributes.get("@ceasedToExist") map { _.as[String]}
}

      

trait Alignment

object Alignment {
  def fromString(value: String, scope: scala.xml.NamespaceBinding)(implicit fmt: scalaxb.XMLFormat[org.iptc.sportsml.v3.Alignment]): Alignment = fmt.reads(scala.xml.Text(value), Nil) match {
    case Right(x: Alignment) => x
    case x => throw new RuntimeException(s"fromString returned unexpected value $x for input $value")
  }
}

case object HomeValue extends Alignment { override def toString = "home" }
case object Neutral extends Alignment { override def toString = "neutral" }


/** Holder for statistics about the site.
*/
case class SiteStatsComnplexType(attributes: Map[String, scalaxb.DataRecord[Any]] = Map()) {
  lazy val id = attributes.get("@id") map { _.as[String]}
  lazy val classValue = attributes.get("@class") map { _.as[String]}
  lazy val style = attributes.get("@style") map { _.as[String]}
  lazy val statsCoverage = attributes.get("@stats-coverage") map { _.as[String]}
  lazy val teamCoverage = attributes.get("@team-coverage") map { _.as[TeamCoverage]}
  lazy val durationScope = attributes.get("@duration-scope") map { _.as[String]}
  lazy val alignmentScope = attributes.get("@alignment-scope") map { _.as[AlignmentScope]}
  lazy val position = attributes.get("@position") map { _.as[String]}
  lazy val recordMakingScope = attributes.get("@record-making-scope") map { _.as[String]}
  lazy val scopingLabel = attributes.get("@scoping-label") map { _.as[String]}
  lazy val periodValue = attributes.get("@period-value") map { _.as[String]}
  lazy val periodType = attributes.get("@period-type") map { _.as[String]}
  lazy val startDateTime = attributes.get("@start-date-time") map { _.as[String]}
  lazy val endDateTime = attributes.get("@end-date-time") map { _.as[String]}
  lazy val periodStartDateTime = attributes.get("@period-start-date-time") map { _.as[String]}
  lazy val periodEndDateTime = attributes.get("@period-end-date-time") map { _.as[String]}
  lazy val temporalUnitType = attributes.get("@temporal-unit-type") map { _.as[String]}
  lazy val temporalUnitValue = attributes.get("@temporal-unit-value") map { _.as[String]}
  lazy val eventSpan = attributes.get("@event-span") map { _.as[BigInt]}
  lazy val opponentValue = attributes.get("@opponent-value") map { _.as[String]}
  lazy val opponentType = attributes.get("@opponent-type") map { _.as[String]}
  lazy val team = attributes.get("@team") map { _.as[String]}
  lazy val competition = attributes.get("@competition") map { _.as[String]}
  lazy val unitValue = attributes.get("@unit-value") map { _.as[String]}
  lazy val unitType = attributes.get("@unit-type") map { _.as[String]}
  lazy val situation = attributes.get("@situation") map { _.as[String]}
  lazy val locationKey = attributes.get("@location-key") map { _.as[String]}
  lazy val venueType = attributes.get("@venue-type") map { _.as[String]}
  lazy val surfaceType = attributes.get("@surface-type") map { _.as[String]}
  lazy val weatherType = attributes.get("@weather-type") map { _.as[String]}
  lazy val scopeValue = attributes.get("@scope-value") map { _.as[String]}
  lazy val distance = attributes.get("@distance") map { _.as[String]}
  lazy val distanceMaximum = attributes.get("@distance-maximum") map { _.as[String]}
  lazy val distanceMinimum = attributes.get("@distance-minimum") map { _.as[String]}
  lazy val measurementUnits = attributes.get("@measurement-units") map { _.as[String]}
  lazy val alignment = attributes.get("@alignment") map { _.as[Alignment]}
  lazy val attendance = attributes.get("@attendance") map { _.as[String]}
  lazy val attendanceAverage = attributes.get("@attendance-average") map { _.as[String]}
  lazy val temperature = attributes.get("@temperature") map { _.as[String]}
  lazy val temperatureUnits = attributes.get("@temperature-units") map { _.as[String]}
  lazy val weatherCode = attributes.get("@weather-code") map { _.as[String]}
  lazy val weatherLabel = attributes.get("@weather-label") map { _.as[String]}
  lazy val weatherWind = attributes.get("@weather-wind") map { _.as[String]}
  lazy val weatherPrediction = attributes.get("@weather-prediction") map { _.as[String]}
  lazy val probabilityOfPrecipitation = attributes.get("@probability-of-precipitation") map { _.as[String]}
}

      


/** A team participating in a sporting event. | Holds metadata and
                statistical data for team.
*/
case class TeamComplexType(teamMetadata: org.iptc.sportsml.v3.TeamMetadataComplexType,
  teamStats: Seq[org.iptc.sportsml.v3.TeamStatsComplexType] = Nil,
  player: Seq[org.iptc.sportsml.v3.PlayerComplexType] = Nil,
  wageringStats: Seq[org.iptc.sportsml.v3.WageringStats] = Nil,
  associate: Seq[org.iptc.sportsml.v3.AssociateComplexType] = Nil,
  affiliation: Seq[org.iptc.sportsml.v3.AffiliationComplexType] = Nil,
  attributes: Map[String, scalaxb.DataRecord[Any]] = Map()) extends SportsEventComplexTypeOption with StandingComplexTypeOption {
  lazy val id = attributes.get("@id") map { _.as[String]}
  lazy val classValue = attributes.get("@class") map { _.as[String]}
  lazy val style = attributes.get("@style") map { _.as[String]}
}

      


/** Statistics that detail the score for a particular period or inning. Per-sport controlled vocabularies used for period- value.
*/
case class SubScoreComplexType(attributes: Map[String, scalaxb.DataRecord[Any]] = Map()) {
  lazy val periodValue = attributes.get("@period-value") map { _.as[String]}
  lazy val score = attributes.get("@score") map { _.as[String]}
  lazy val subScoreType = attributes.get("@sub-score-type") map { _.as[String]}
  lazy val subScoreKey = attributes.get("@sub-score-key") map { _.as[String]}
  lazy val subScoreName = attributes.get("@sub-score-name") map { _.as[String]}
  lazy val rank = attributes.get("@rank") map { _.as[String]}
  lazy val totalScore = attributes.get("@total-score") map { _.as[String]}
  lazy val scoreAttempts = attributes.get("@score-attempts") map { _.as[String]}
}

      


/** Statistics that detail the number of each type of penalty. | Can be recorded for either a team or a player.
*/
case class PenaltyStatsComplexType(attributes: Map[String, scalaxb.DataRecord[Any]] = Map()) {
  lazy val id = attributes.get("@id") map { _.as[String]}
  lazy val classValue = attributes.get("@class") map { _.as[String]}
  lazy val style = attributes.get("@style") map { _.as[String]}
  lazy val typeValue = attributes.get("@type") map { _.as[String]}
  lazy val count = attributes.get("@count") map { _.as[BigInt]}
  lazy val valueAttribute = attributes.get("@value") map { _.as[String]}
}

      


/** A report on the number of wins, losses, etc., the team or player had during a particular time period. | Can also be scoped with various coverage qualifications, such as just events played at home.
*/
case class OutcomeTotalsComplexType(attributes: Map[String, scalaxb.DataRecord[Any]] = Map()) {
  lazy val id = attributes.get("@id") map { _.as[String]}
  lazy val classValue = attributes.get("@class") map { _.as[String]}
  lazy val style = attributes.get("@style") map { _.as[String]}
  lazy val statsCoverage = attributes.get("@stats-coverage") map { _.as[String]}
  lazy val teamCoverage = attributes.get("@team-coverage") map { _.as[TeamCoverage]}
  lazy val durationScope = attributes.get("@duration-scope") map { _.as[String]}
  lazy val alignmentScope = attributes.get("@alignment-scope") map { _.as[AlignmentScope]}
  lazy val position = attributes.get("@position") map { _.as[String]}
  lazy val recordMakingScope = attributes.get("@record-making-scope") map { _.as[String]}
  lazy val scopingLabel = attributes.get("@scoping-label") map { _.as[String]}
  lazy val periodValue = attributes.get("@period-value") map { _.as[String]}
  lazy val periodType = attributes.get("@period-type") map { _.as[String]}
  lazy val startDateTime = attributes.get("@start-date-time") map { _.as[String]}
  lazy val endDateTime = attributes.get("@end-date-time") map { _.as[String]}
  lazy val periodStartDateTime = attributes.get("@period-start-date-time") map { _.as[String]}
  lazy val periodEndDateTime = attributes.get("@period-end-date-time") map { _.as[String]}
  lazy val temporalUnitType = attributes.get("@temporal-unit-type") map { _.as[String]}
  lazy val temporalUnitValue = attributes.get("@temporal-unit-value") map { _.as[String]}
  lazy val eventSpan = attributes.get("@event-span") map { _.as[BigInt]}
  lazy val opponentValue = attributes.get("@opponent-value") map { _.as[String]}
  lazy val opponentType = attributes.get("@opponent-type") map { _.as[String]}
  lazy val team = attributes.get("@team") map { _.as[String]}
  lazy val competition = attributes.get("@competition") map { _.as[String]}
  lazy val unitValue = attributes.get("@unit-value") map { _.as[String]}
  lazy val unitType = attributes.get("@unit-type") map { _.as[String]}
  lazy val situation = attributes.get("@situation") map { _.as[String]}
  lazy val locationKey = attributes.get("@location-key") map { _.as[String]}
  lazy val venueType = attributes.get("@venue-type") map { _.as[String]}
  lazy val surfaceType = attributes.get("@surface-type") map { _.as[String]}
  lazy val weatherType = attributes.get("@weather-type") map { _.as[String]}
  lazy val scopeValue = attributes.get("@scope-value") map { _.as[String]}
  lazy val distance = attributes.get("@distance") map { _.as[String]}
  lazy val distanceMaximum = attributes.get("@distance-maximum") map { _.as[String]}
  lazy val distanceMinimum = attributes.get("@distance-minimum") map { _.as[String]}
  lazy val measurementUnits = attributes.get("@measurement-units") map { _.as[String]}
  lazy val wins = attributes.get("@wins") map { _.as[BigInt]}
  lazy val losses = attributes.get("@losses") map { _.as[BigInt]}
  lazy val ties = attributes.get("@ties") map { _.as[BigInt]}
  lazy val undecideds = attributes.get("@undecideds") map { _.as[BigInt]}
  lazy val winningPercentage = attributes.get("@winning-percentage") map { _.as[BigInt]}
  lazy val pointsScoredFor = attributes.get("@points-scored-for") map { _.as[BigInt]}
  lazy val pointsScoredAgainst = attributes.get("@points-scored-against") map { _.as[BigInt]}
  lazy val pointsDifference = attributes.get("@points-difference") map { _.as[BigInt]}
  lazy val standingPoints = attributes.get("@standing-points") map { _.as[String]}
  lazy val standingPointsAgainst = attributes.get("@standing-points-against") map { _.as[String]}
  lazy val streakType = attributes.get("@streak-type") map { _.as[String]}
  lazy val streakDuration = attributes.get("@streak-duration") map { _.as[javax.xml.datatype.Duration]}
  lazy val streakTotal = attributes.get("@streak-total") map { _.as[BigInt]}
  lazy val streakStart = attributes.get("@streak-start") map { _.as[String]}
  lazy val streakEnd = attributes.get("@streak-end") map { _.as[String]}
  lazy val eventsPlayed = attributes.get("@events-played") map { _.as[BigInt]}
  lazy val eventsRemaining = attributes.get("@events-remaining") map { _.as[BigInt]}
  lazy val gamesBack = attributes.get("@games-back") map { _.as[BigInt]}
  lazy val lossesOvertime = attributes.get("@losses-overtime") map { _.as[BigInt]}
  lazy val relegationAverage = attributes.get("@relegation-average") map { _.as[BigDecimal]}
}

      


/** A report on the result, if any, from the event etc.
*/
case class OutcomeResultComplexType(attributes: Map[String, scalaxb.DataRecord[Any]] = Map()) {
  lazy val id = attributes.get("@id") map { _.as[String]}
  lazy val classValue = attributes.get("@class") map { _.as[String]}
  lazy val style = attributes.get("@style") map { _.as[String]}
  lazy val statsCoverage = attributes.get("@stats-coverage") map { _.as[String]}
  lazy val teamCoverage = attributes.get("@team-coverage") map { _.as[TeamCoverage]}
  lazy val durationScope = attributes.get("@duration-scope") map { _.as[String]}
  lazy val alignmentScope = attributes.get("@alignment-scope") map { _.as[AlignmentScope]}
  lazy val position = attributes.get("@position") map { _.as[String]}
  lazy val recordMakingScope = attributes.get("@record-making-scope") map { _.as[String]}
  lazy val scopingLabel = attributes.get("@scoping-label") map { _.as[String]}
  lazy val periodValue = attributes.get("@period-value") map { _.as[String]}
  lazy val periodType = attributes.get("@period-type") map { _.as[String]}
  lazy val startDateTime = attributes.get("@start-date-time") map { _.as[String]}
  lazy val endDateTime = attributes.get("@end-date-time") map { _.as[String]}
  lazy val periodStartDateTime = attributes.get("@period-start-date-time") map { _.as[String]}
  lazy val periodEndDateTime = attributes.get("@period-end-date-time") map { _.as[String]}
  lazy val temporalUnitType = attributes.get("@temporal-unit-type") map { _.as[String]}
  lazy val temporalUnitValue = attributes.get("@temporal-unit-value") map { _.as[String]}
  lazy val eventSpan = attributes.get("@event-span") map { _.as[BigInt]}
  lazy val opponentValue = attributes.get("@opponent-value") map { _.as[String]}
  lazy val opponentType = attributes.get("@opponent-type") map { _.as[String]}
  lazy val team = attributes.get("@team") map { _.as[String]}
  lazy val competition = attributes.get("@competition") map { _.as[String]}
  lazy val unitValue = attributes.get("@unit-value") map { _.as[String]}
  lazy val unitType = attributes.get("@unit-type") map { _.as[String]}
  lazy val situation = attributes.get("@situation") map { _.as[String]}
  lazy val locationKey = attributes.get("@location-key") map { _.as[String]}
  lazy val venueType = attributes.get("@venue-type") map { _.as[String]}
  lazy val surfaceType = attributes.get("@surface-type") map { _.as[String]}
  lazy val weatherType = attributes.get("@weather-type") map { _.as[String]}
  lazy val scopeValue = attributes.get("@scope-value") map { _.as[String]}
  lazy val distance = attributes.get("@distance") map { _.as[String]}
  lazy val distanceMaximum = attributes.get("@distance-maximum") map { _.as[String]}
  lazy val distanceMinimum = attributes.get("@distance-minimum") map { _.as[String]}
  lazy val measurementUnits = attributes.get("@measurement-units") map { _.as[String]}
  lazy val typeValue = attributes.get("@type") map { _.as[String]}
  lazy val key = attributes.get("@key") map { _.as[String]}
  lazy val comment = attributes.get("@comment") map { _.as[String]}
}

      


/** A medal, ribbon, placement, or other type of award. | Can be assigned to an event, a team, or a player.
*/
case class AwardComplexType(name: Seq[org.iptc.sportsml.v3.ConceptNameType] = Nil,
  attributes: Map[String, scalaxb.DataRecord[Any]] = Map()) {
  lazy val id = attributes.get("@id") map { _.as[String]}
  lazy val classValue = attributes.get("@class") map { _.as[String]}
  lazy val style = attributes.get("@style") map { _.as[String]}
  lazy val awardType = attributes.get("@award-type") map { _.as[String]}
  lazy val playerOrTeamIdref = attributes.get("@player-or-team-idref") map { _.as[String]}
  lazy val total = attributes.get("@total") map { _.as[BigInt]}
  lazy val place = attributes.get("@place") map { _.as[String]}
  lazy val valueAttribute = attributes.get("@value") map { _.as[String]}
  lazy val currency = attributes.get("@currency") map { _.as[String]}
}

      


/** A world, national, state, or school record. | More than one record can be set by one participant at one sports-event.
*/
case class EventRecordComplexType(attributes: Map[String, scalaxb.DataRecord[Any]] = Map()) {
  lazy val typeValue = attributes.get("@type") map { _.as[String]}
  lazy val previousRecord = attributes.get("@previous-record") map { _.as[String]}
}

      


/** How a team is doing in comparison to other teams or players. | May be qualified, so that one ranks teams or players according to, say, how they play at home, or within their division.
*/
case class RankComplexType(attributes: Map[String, scalaxb.DataRecord[Any]] = Map()) {
  lazy val id = attributes.get("@id") map { _.as[String]}
  lazy val classValue = attributes.get("@class") map { _.as[String]}
  lazy val style = attributes.get("@style") map { _.as[String]}
  lazy val statsCoverage = attributes.get("@stats-coverage") map { _.as[String]}
  lazy val teamCoverage = attributes.get("@team-coverage") map { _.as[TeamCoverage]}
  lazy val durationScope = attributes.get("@duration-scope") map { _.as[String]}
  lazy val alignmentScope = attributes.get("@alignment-scope") map { _.as[AlignmentScope]}
  lazy val position = attributes.get("@position") map { _.as[String]}
  lazy val recordMakingScope = attributes.get("@record-making-scope") map { _.as[String]}
  lazy val scopingLabel = attributes.get("@scoping-label") map { _.as[String]}
  lazy val periodValue = attributes.get("@period-value") map { _.as[String]}
  lazy val periodType = attributes.get("@period-type") map { _.as[String]}
  lazy val startDateTime = attributes.get("@start-date-time") map { _.as[String]}
  lazy val endDateTime = attributes.get("@end-date-time") map { _.as[String]}
  lazy val periodStartDateTime = attributes.get("@period-start-date-time") map { _.as[String]}
  lazy val periodEndDateTime = attributes.get("@period-end-date-time") map { _.as[String]}
  lazy val temporalUnitType = attributes.get("@temporal-unit-type") map { _.as[String]}
  lazy val temporalUnitValue = attributes.get("@temporal-unit-value") map { _.as[String]}
  lazy val eventSpan = attributes.get("@event-span") map { _.as[BigInt]}
  lazy val opponentValue = attributes.get("@opponent-value") map { _.as[String]}
  lazy val opponentType = attributes.get("@opponent-type") map { _.as[String]}
  lazy val team = attributes.get("@team") map { _.as[String]}
  lazy val competition = attributes.get("@competition") map { _.as[String]}
  lazy val unitValue = attributes.get("@unit-value") map { _.as[String]}
  lazy val unitType = attributes.get("@unit-type") map { _.as[String]}
  lazy val situation = attributes.get("@situation") map { _.as[String]}
  lazy val locationKey = attributes.get("@location-key") map { _.as[String]}
  lazy val venueType = attributes.get("@venue-type") map { _.as[String]}
  lazy val surfaceType = attributes.get("@surface-type") map { _.as[String]}
  lazy val weatherType = attributes.get("@weather-type") map { _.as[String]}
  lazy val scopeValue = attributes.get("@scope-value") map { _.as[String]}
  lazy val distance = attributes.get("@distance") map { _.as[String]}
  lazy val distanceMaximum = attributes.get("@distance-maximum") map { _.as[String]}
  lazy val distanceMinimum = attributes.get("@distance-minimum") map { _.as[String]}
  lazy val measurementUnits = attributes.get("@measurement-units") map { _.as[String]}
  lazy val typeValue = attributes.get("@type") map { _.as[String]}
  lazy val issuer = attributes.get("@issuer") map { _.as[String]}
  lazy val valueAttribute = attributes.get("@value") map { _.as[String]}
  lazy val valuePrevious = attributes.get("@value-previous") map { _.as[String]}
}

      


/** A judged value placed on the team or individual. | Often used in British soccer.
*/
case class RatingComplexType(attributes: Map[String, scalaxb.DataRecord[Any]] = Map()) {
  lazy val id = attributes.get("@id") map { _.as[String]}
  lazy val classValue = attributes.get("@class") map { _.as[String]}
  lazy val style = attributes.get("@style") map { _.as[String]}
  lazy val ratingType = attributes.get("@rating-type") map { _.as[String]}
  lazy val ratingIssuer = attributes.get("@rating-issuer") map { _.as[String]}
  lazy val ratingValue = attributes.get("@rating-value") map { _.as[String]}
  lazy val ratingMaximum = attributes.get("@rating-maximum") map { _.as[String]}
}

      


/** A competitor. | Their athletic talents help them decide who wins a sports-event.
*/
case class PlayerComplexType(playerMetadata: org.iptc.sportsml.v3.PlayerMetadataComplexType,
  playerStats: Seq[org.iptc.sportsml.v3.PlayerStatsComplexType] = Nil,
  wageringStats: Seq[org.iptc.sportsml.v3.WageringStats] = Nil,
  associate: Seq[org.iptc.sportsml.v3.AssociateComplexType] = Nil,
  affiliation: Seq[org.iptc.sportsml.v3.AffiliationComplexType] = Nil,
  attributes: Map[String, scalaxb.DataRecord[Any]] = Map()) extends SportsEventComplexTypeOption with StandingComplexTypeOption {
  lazy val id = attributes.get("@id") map { _.as[String]}
  lazy val classValue = attributes.get("@class") map { _.as[String]}
  lazy val style = attributes.get("@style") map { _.as[String]}
}

      


/** A set of officials. | May hold zero or more.
*/
case class OfficialsComplexType(official: Seq[org.iptc.sportsml.v3.OfficialComplexType] = Nil,
  attributes: Map[String, scalaxb.DataRecord[Any]] = Map()) {
  lazy val id = attributes.get("@id") map { _.as[String]}
  lazy val classValue = attributes.get("@class") map { _.as[String]}
  lazy val style = attributes.get("@style") map { _.as[String]}
}

      


/** Also referred to as umpire or referree. | Ensures that the
                sports-event is played according to its rules.
*/
case class OfficialComplexType(officialMetadata: org.iptc.sportsml.v3.OfficialMetadataComplexType,
  officialStats: Option[org.iptc.sportsml.v3.OfficialStatsComplexType] = None,
  affiliation: Seq[org.iptc.sportsml.v3.AffiliationComplexType] = Nil,
  attributes: Map[String, scalaxb.DataRecord[Any]] = Map()) {
  lazy val id = attributes.get("@id") map { _.as[String]}
  lazy val classValue = attributes.get("@class") map { _.as[String]}
  lazy val style = attributes.get("@style") map { _.as[String]}
}

      


/** Manager or coach or jockey, etc. | An individual or a group that assists a team or player, and functions in a supporting capacity.
*/
case class AssociateComplexType(associateMetadata: org.iptc.sportsml.v3.AssociateMetadataComplexType,
  associateStats: Option[org.iptc.sportsml.v3.AssociateStatsComplexType] = None,
  affiliation: Seq[org.iptc.sportsml.v3.AffiliationComplexType] = Nil,
  attributes: Map[String, scalaxb.DataRecord[Any]] = Map()) {
  lazy val id = attributes.get("@id") map { _.as[String]}
  lazy val classValue = attributes.get("@class") map { _.as[String]}
  lazy val style = attributes.get("@style") map { _.as[String]}
}

      


/** A mechanism for assigning the membership of a player, team, or associate within a division or larger organizational structure. Also, to indicate an official's affiliation with a team, club or federation, for
                example.
*/
case class AffiliationComplexType(attributes: Map[String, scalaxb.DataRecord[Any]] = Map()) {
  lazy val id = attributes.get("@id") map { _.as[String]}
  lazy val classValue = attributes.get("@class") map { _.as[String]}
  lazy val style = attributes.get("@style") map { _.as[String]}
  lazy val statsCoverage = attributes.get("@stats-coverage") map { _.as[String]}
  lazy val teamCoverage = attributes.get("@team-coverage") map { _.as[TeamCoverage]}
  lazy val durationScope = attributes.get("@duration-scope") map { _.as[String]}
  lazy val alignmentScope = attributes.get("@alignment-scope") map { _.as[AlignmentScope]}
  lazy val position = attributes.get("@position") map { _.as[String]}
  lazy val recordMakingScope = attributes.get("@record-making-scope") map { _.as[String]}
  lazy val scopingLabel = attributes.get("@scoping-label") map { _.as[String]}
  lazy val periodValue = attributes.get("@period-value") map { _.as[String]}
  lazy val periodType = attributes.get("@period-type") map { _.as[String]}
  lazy val startDateTime = attributes.get("@start-date-time") map { _.as[String]}
  lazy val endDateTime = attributes.get("@end-date-time") map { _.as[String]}
  lazy val periodStartDateTime = attributes.get("@period-start-date-time") map { _.as[String]}
  lazy val periodEndDateTime = attributes.get("@period-end-date-time") map { _.as[String]}
  lazy val temporalUnitType = attributes.get("@temporal-unit-type") map { _.as[String]}
  lazy val temporalUnitValue = attributes.get("@temporal-unit-value") map { _.as[String]}
  lazy val eventSpan = attributes.get("@event-span") map { _.as[BigInt]}
  lazy val opponentValue = attributes.get("@opponent-value") map { _.as[String]}
  lazy val opponentType = attributes.get("@opponent-type") map { _.as[String]}
  lazy val team = attributes.get("@team") map { _.as[String]}
  lazy val competition = attributes.get("@competition") map { _.as[String]}
  lazy val unitValue = attributes.get("@unit-value") map { _.as[String]}
  lazy val unitType = attributes.get("@unit-type") map { _.as[String]}
  lazy val situation = attributes.get("@situation") map { _.as[String]}
  lazy val locationKey = attributes.get("@location-key") map { _.as[String]}
  lazy val venueType = attributes.get("@venue-type") map { _.as[String]}
  lazy val surfaceType = attributes.get("@surface-type") map { _.as[String]}
  lazy val weatherType = attributes.get("@weather-type") map { _.as[String]}
  lazy val scopeValue = attributes.get("@scope-value") map { _.as[String]}
  lazy val distance = attributes.get("@distance") map { _.as[String]}
  lazy val distanceMaximum = attributes.get("@distance-maximum") map { _.as[String]}
  lazy val distanceMinimum = attributes.get("@distance-minimum") map { _.as[String]}
  lazy val measurementUnits = attributes.get("@measurement-units") map { _.as[String]}
  lazy val membershipIdref = attributes.get("@membership-idref") map { _.as[String]}
  lazy val membershipType = attributes.get("@membership-type") map { _.as[String]}
  lazy val membershipKey = attributes.get("@membership-key") map { _.as[String]}
  lazy val membershipName = attributes.get("@membership-name") map { _.as[String]}
}

      


/** A structured series of competitions within one sport. | Generally organized by a particular sponsoring body. Can happen all in one day, or be spread out - like the Davis Cup in tennis.
*/
case class TournamentComplexType(tournamentMetadata: Option[org.iptc.sportsml.v3.TournamentMetadataComplexType] = None,
  standing: Seq[org.iptc.sportsml.v3.StandingComplexType] = Nil,
  tournamentcomplextypeoption: Seq[scalaxb.DataRecord[org.iptc.sportsml.v3.TournamentComplexTypeOption]] = Nil,
  attributes: Map[String, scalaxb.DataRecord[Any]] = Map()) extends SportsContentOption {
  lazy val id = attributes.get("@id") map { _.as[String]}
  lazy val classValue = attributes.get("@class") map { _.as[String]}
  lazy val style = attributes.get("@style") map { _.as[String]}
}

      

trait TournamentComplexTypeOption

/** A tournament subcategory, often with its own trophy and prize. | Use
                it to divide specific overall competitions in a large multi-sport tournament such as
                Olympics. Can also divide gender competitions, for example in tennis tournaments.
                Can be nested to divide gender at a higher level (tournament/tournament-division)
                and then to divide specific sport competitions futher down the tree
                (tournament-part/tournament-division). 
*/
case class TournamentDivisionComplexType(tournamentDivisionMetadata: Option[org.iptc.sportsml.v3.TournamentDivisionMetadataComplexType] = None,
  standing: Seq[org.iptc.sportsml.v3.StandingComplexType] = Nil,
  tournamentdivisioncomplextypeoption: Seq[scalaxb.DataRecord[org.iptc.sportsml.v3.TournamentDivisionComplexTypeOption]] = Nil,
  attributes: Map[String, scalaxb.DataRecord[Any]] = Map()) extends TournamentComplexTypeOption {
  lazy val id = attributes.get("@id") map { _.as[String]}
  lazy val classValue = attributes.get("@class") map { _.as[String]}
  lazy val style = attributes.get("@style") map { _.as[String]}
}

      

trait TournamentDivisionComplexTypeOption

/** A tournament part. Use it do group specific parts of a tournament, like a stage or a round. 
*/
case class TournamentPartComplexType(tournamentPartMetadata: Option[org.iptc.sportsml.v3.TournamentPartMetadataComplexType] = None,
  standing: Seq[org.iptc.sportsml.v3.StandingComplexType] = Nil,
  tournamentpartcomplextypeoption: Seq[scalaxb.DataRecord[org.iptc.sportsml.v3.TournamentPartComplexTypeOption]] = Nil,
  attributes: Map[String, scalaxb.DataRecord[Any]] = Map()) extends TournamentComplexTypeOption with TournamentDivisionComplexTypeOption with TournamentPartComplexTypeOption {
  lazy val id = attributes.get("@id") map { _.as[String]}
  lazy val classValue = attributes.get("@class") map { _.as[String]}
  lazy val style = attributes.get("@style") map { _.as[String]}
  lazy val partIndex = attributes.get("@part-index") map { _.as[String]}
}

      

trait TournamentPartComplexTypeOption

/** Holds either an article or a reference to an article. Format of the content is up to the provider. NITF from IPTC or HTML are common alternatives.
*/
case class ArticleComplexType(any: Seq[scalaxb.DataRecord[Any]] = Nil,
  attributes: Map[String, scalaxb.DataRecord[Any]] = Map()) extends SportsContentOption {
  lazy val id = attributes.get("@id") map { _.as[String]}
  lazy val classValue = attributes.get("@class") map { _.as[String]}
  lazy val style = attributes.get("@style") map { _.as[String]}
  lazy val format = attributes.get("@format") map { _.as[String]}
  lazy val articleRef = attributes.get("@article-ref") map { _.as[String]}
}

      


case class StandingComplexType(standingMetadata: Option[org.iptc.sportsml.v3.StandingMetadataComplexType] = None,
  standingcomplextypeoption: Seq[scalaxb.DataRecord[org.iptc.sportsml.v3.StandingComplexTypeOption]] = Nil,
  attributes: Map[String, scalaxb.DataRecord[Any]] = Map()) extends SportsContentOption {
  lazy val id = attributes.get("@id") map { _.as[String]}
  lazy val classValue = attributes.get("@class") map { _.as[String]}
  lazy val style = attributes.get("@style") map { _.as[String]}
  lazy val contentLabel = attributes.get("@content-label") map { _.as[String]}
}

      

trait StandingComplexTypeOption

/** A series of team or individual records. | A series of team or individual records.
*/
case class StandingMetadataComplexType(sportsContentCodes: Option[org.iptc.sportsml.v3.SportsContentCodesComplexType] = None,
  sportsProperty: Seq[org.iptc.sportsml.v3.SportsPropertyComplexType] = Nil,
  attributes: Map[String, scalaxb.DataRecord[Any]] = Map()) extends BaseMetadataComplexTypable {
  lazy val id = attributes.get("@id") map { _.as[String]}
  lazy val classValue = attributes.get("@class") map { _.as[String]}
  lazy val style = attributes.get("@style") map { _.as[String]}
  lazy val statsCoverage = attributes.get("@stats-coverage") map { _.as[String]}
  lazy val teamCoverage = attributes.get("@team-coverage") map { _.as[TeamCoverage]}
  lazy val durationScope = attributes.get("@duration-scope") map { _.as[String]}
  lazy val alignmentScope = attributes.get("@alignment-scope") map { _.as[AlignmentScope]}
  lazy val position = attributes.get("@position") map { _.as[String]}
  lazy val recordMakingScope = attributes.get("@record-making-scope") map { _.as[String]}
  lazy val scopingLabel = attributes.get("@scoping-label") map { _.as[String]}
  lazy val periodValue = attributes.get("@period-value") map { _.as[String]}
  lazy val periodType = attributes.get("@period-type") map { _.as[String]}
  lazy val startDateTime = attributes.get("@start-date-time") map { _.as[String]}
  lazy val endDateTime = attributes.get("@end-date-time") map { _.as[String]}
  lazy val periodStartDateTime = attributes.get("@period-start-date-time") map { _.as[String]}
  lazy val periodEndDateTime = attributes.get("@period-end-date-time") map { _.as[String]}
  lazy val temporalUnitType = attributes.get("@temporal-unit-type") map { _.as[String]}
  lazy val temporalUnitValue = attributes.get("@temporal-unit-value") map { _.as[String]}
  lazy val eventSpan = attributes.get("@event-span") map { _.as[BigInt]}
  lazy val opponentValue = attributes.get("@opponent-value") map { _.as[String]}
  lazy val opponentType = attributes.get("@opponent-type") map { _.as[String]}
  lazy val team = attributes.get("@team") map { _.as[String]}
  lazy val competition = attributes.get("@competition") map { _.as[String]}
  lazy val unitValue = attributes.get("@unit-value") map { _.as[String]}
  lazy val unitType = attributes.get("@unit-type") map { _.as[String]}
  lazy val situation = attributes.get("@situation") map { _.as[String]}
  lazy val locationKey = attributes.get("@location-key") map { _.as[String]}
  lazy val venueType = attributes.get("@venue-type") map { _.as[String]}
  lazy val surfaceType = attributes.get("@surface-type") map { _.as[String]}
  lazy val weatherType = attributes.get("@weather-type") map { _.as[String]}
  lazy val scopeValue = attributes.get("@scope-value") map { _.as[String]}
  lazy val distance = attributes.get("@distance") map { _.as[String]}
  lazy val distanceMaximum = attributes.get("@distance-maximum") map { _.as[String]}
  lazy val distanceMinimum = attributes.get("@distance-minimum") map { _.as[String]}
  lazy val measurementUnits = attributes.get("@measurement-units") map { _.as[String]}
}

      


/** A series of games. | Usually grouped by date.
*/
case class ScheduleComplexType(scheduleMetadata: org.iptc.sportsml.v3.ScheduleMetadataComplexType,
  sportsEvent: Seq[org.iptc.sportsml.v3.SportsEventComplexType] = Nil,
  attributes: Map[String, scalaxb.DataRecord[Any]] = Map()) extends SportsContentOption {
  lazy val id = attributes.get("@id") map { _.as[String]}
  lazy val classValue = attributes.get("@class") map { _.as[String]}
  lazy val style = attributes.get("@style") map { _.as[String]}
  lazy val dateLabel = attributes.get("@date-label") map { _.as[String]}
  lazy val contentLabel = attributes.get("@content-label") map { _.as[String]}
}

      


/** Background information about the schedule. | Describes the time period which the schedule covers, and which teams or events may be covered.
*/
case class ScheduleMetadataComplexType(sportsContentCodes: Option[org.iptc.sportsml.v3.SportsContentCodesComplexType] = None,
  sportsProperty: Seq[org.iptc.sportsml.v3.SportsPropertyComplexType] = Nil,
  attributes: Map[String, scalaxb.DataRecord[Any]] = Map()) extends BaseMetadataComplexTypable {
  lazy val id = attributes.get("@id") map { _.as[String]}
  lazy val classValue = attributes.get("@class") map { _.as[String]}
  lazy val style = attributes.get("@style") map { _.as[String]}
  lazy val statsCoverage = attributes.get("@stats-coverage") map { _.as[String]}
  lazy val teamCoverage = attributes.get("@team-coverage") map { _.as[TeamCoverage]}
  lazy val durationScope = attributes.get("@duration-scope") map { _.as[String]}
  lazy val alignmentScope = attributes.get("@alignment-scope") map { _.as[AlignmentScope]}
  lazy val position = attributes.get("@position") map { _.as[String]}
  lazy val recordMakingScope = attributes.get("@record-making-scope") map { _.as[String]}
  lazy val scopingLabel = attributes.get("@scoping-label") map { _.as[String]}
  lazy val periodValue = attributes.get("@period-value") map { _.as[String]}
  lazy val periodType = attributes.get("@period-type") map { _.as[String]}
  lazy val startDateTime = attributes.get("@start-date-time") map { _.as[String]}
  lazy val endDateTime = attributes.get("@end-date-time") map { _.as[String]}
  lazy val periodStartDateTime = attributes.get("@period-start-date-time") map { _.as[String]}
  lazy val periodEndDateTime = attributes.get("@period-end-date-time") map { _.as[String]}
  lazy val temporalUnitType = attributes.get("@temporal-unit-type") map { _.as[String]}
  lazy val temporalUnitValue = attributes.get("@temporal-unit-value") map { _.as[String]}
  lazy val eventSpan = attributes.get("@event-span") map { _.as[BigInt]}
  lazy val opponentValue = attributes.get("@opponent-value") map { _.as[String]}
  lazy val opponentType = attributes.get("@opponent-type") map { _.as[String]}
  lazy val team = attributes.get("@team") map { _.as[String]}
  lazy val competition = attributes.get("@competition") map { _.as[String]}
  lazy val unitValue = attributes.get("@unit-value") map { _.as[String]}
  lazy val unitType = attributes.get("@unit-type") map { _.as[String]}
  lazy val situation = attributes.get("@situation") map { _.as[String]}
  lazy val locationKey = attributes.get("@location-key") map { _.as[String]}
  lazy val venueType = attributes.get("@venue-type") map { _.as[String]}
  lazy val surfaceType = attributes.get("@surface-type") map { _.as[String]}
  lazy val weatherType = attributes.get("@weather-type") map { _.as[String]}
  lazy val scopeValue = attributes.get("@scope-value") map { _.as[String]}
  lazy val distance = attributes.get("@distance") map { _.as[String]}
  lazy val distanceMaximum = attributes.get("@distance-maximum") map { _.as[String]}
  lazy val distanceMinimum = attributes.get("@distance-minimum") map { _.as[String]}
  lazy val measurementUnits = attributes.get("@measurement-units") map { _.as[String]}
}

      


/** A table that generally compares the performance of teams or players. |
                The fixture-key can identify which regulary-running statistics are being presented.
                Also appropriate for rosters (squad listings).
*/
case class StatisticComplexType(statisticMetadata: org.iptc.sportsml.v3.StatisticMetadataComplexType,
  group: Seq[org.iptc.sportsml.v3.GroupComplexType] = Nil,
  teamComplexType: Seq[org.iptc.sportsml.v3.TeamComplexType] = Nil,
  player: Seq[org.iptc.sportsml.v3.PlayerComplexType] = Nil,
  associate: Seq[org.iptc.sportsml.v3.AssociateComplexType] = Nil,
  statusChange: Seq[org.iptc.sportsml.v3.StatusChangeComplexType] = Nil,
  attributes: Map[String, scalaxb.DataRecord[Any]] = Map()) extends SportsContentOption {
  lazy val id = attributes.get("@id") map { _.as[String]}
  lazy val classValue = attributes.get("@class") map { _.as[String]}
  lazy val style = attributes.get("@style") map { _.as[String]}
  lazy val statsCoverage = attributes.get("@stats-coverage") map { _.as[String]}
  lazy val teamCoverage = attributes.get("@team-coverage") map { _.as[TeamCoverage]}
  lazy val durationScope = attributes.get("@duration-scope") map { _.as[String]}
  lazy val alignmentScope = attributes.get("@alignment-scope") map { _.as[AlignmentScope]}
  lazy val position = attributes.get("@position") map { _.as[String]}
  lazy val recordMakingScope = attributes.get("@record-making-scope") map { _.as[String]}
  lazy val scopingLabel = attributes.get("@scoping-label") map { _.as[String]}
  lazy val periodValue = attributes.get("@period-value") map { _.as[String]}
  lazy val periodType = attributes.get("@period-type") map { _.as[String]}
  lazy val startDateTime = attributes.get("@start-date-time") map { _.as[String]}
  lazy val endDateTime = attributes.get("@end-date-time") map { _.as[String]}
  lazy val periodStartDateTime = attributes.get("@period-start-date-time") map { _.as[String]}
  lazy val periodEndDateTime = attributes.get("@period-end-date-time") map { _.as[String]}
  lazy val temporalUnitType = attributes.get("@temporal-unit-type") map { _.as[String]}
  lazy val temporalUnitValue = attributes.get("@temporal-unit-value") map { _.as[String]}
  lazy val eventSpan = attributes.get("@event-span") map { _.as[BigInt]}
  lazy val opponentValue = attributes.get("@opponent-value") map { _.as[String]}
  lazy val opponentType = attributes.get("@opponent-type") map { _.as[String]}
  lazy val team = attributes.get("@team") map { _.as[String]}
  lazy val competition = attributes.get("@competition") map { _.as[String]}
  lazy val unitValue = attributes.get("@unit-value") map { _.as[String]}
  lazy val unitType = attributes.get("@unit-type") map { _.as[String]}
  lazy val situation = attributes.get("@situation") map { _.as[String]}
  lazy val locationKey = attributes.get("@location-key") map { _.as[String]}
  lazy val venueType = attributes.get("@venue-type") map { _.as[String]}
  lazy val surfaceType = attributes.get("@surface-type") map { _.as[String]}
  lazy val weatherType = attributes.get("@weather-type") map { _.as[String]}
  lazy val scopeValue = attributes.get("@scope-value") map { _.as[String]}
  lazy val distance = attributes.get("@distance") map { _.as[String]}
  lazy val distanceMaximum = attributes.get("@distance-maximum") map { _.as[String]}
  lazy val distanceMinimum = attributes.get("@distance-minimum") map { _.as[String]}
  lazy val measurementUnits = attributes.get("@measurement-units") map { _.as[String]}
  lazy val typeValue = attributes.get("@type") map { _.as[String]}
  lazy val contentLabel = attributes.get("@content-label") map { _.as[String]}
}

      


/** Identifies which teams are being covered. | Also indicates the date ranges for which these stats cover.
*/
case class StatisticMetadataComplexType(sportsContentCodes: Option[org.iptc.sportsml.v3.SportsContentCodesComplexType] = None,
  sportsProperty: Seq[org.iptc.sportsml.v3.SportsPropertyComplexType] = Nil,
  attributes: Map[String, scalaxb.DataRecord[Any]] = Map()) extends BaseMetadataComplexTypable {
  lazy val id = attributes.get("@id") map { _.as[String]}
  lazy val classValue = attributes.get("@class") map { _.as[String]}
  lazy val style = attributes.get("@style") map { _.as[String]}
  lazy val statsCoverage = attributes.get("@stats-coverage") map { _.as[String]}
  lazy val teamCoverage = attributes.get("@team-coverage") map { _.as[TeamCoverage]}
  lazy val durationScope = attributes.get("@duration-scope") map { _.as[String]}
  lazy val alignmentScope = attributes.get("@alignment-scope") map { _.as[AlignmentScope]}
  lazy val position = attributes.get("@position") map { _.as[String]}
  lazy val recordMakingScope = attributes.get("@record-making-scope") map { _.as[String]}
  lazy val scopingLabel = attributes.get("@scoping-label") map { _.as[String]}
  lazy val periodValue = attributes.get("@period-value") map { _.as[String]}
  lazy val periodType = attributes.get("@period-type") map { _.as[String]}
  lazy val startDateTime = attributes.get("@start-date-time") map { _.as[String]}
  lazy val endDateTime = attributes.get("@end-date-time") map { _.as[String]}
  lazy val periodStartDateTime = attributes.get("@period-start-date-time") map { _.as[String]}
  lazy val periodEndDateTime = attributes.get("@period-end-date-time") map { _.as[String]}
  lazy val temporalUnitType = attributes.get("@temporal-unit-type") map { _.as[String]}
  lazy val temporalUnitValue = attributes.get("@temporal-unit-value") map { _.as[String]}
  lazy val eventSpan = attributes.get("@event-span") map { _.as[BigInt]}
  lazy val opponentValue = attributes.get("@opponent-value") map { _.as[String]}
  lazy val opponentType = attributes.get("@opponent-type") map { _.as[String]}
  lazy val team = attributes.get("@team") map { _.as[String]}
  lazy val competition = attributes.get("@competition") map { _.as[String]}
  lazy val unitValue = attributes.get("@unit-value") map { _.as[String]}
  lazy val unitType = attributes.get("@unit-type") map { _.as[String]}
  lazy val situation = attributes.get("@situation") map { _.as[String]}
  lazy val locationKey = attributes.get("@location-key") map { _.as[String]}
  lazy val venueType = attributes.get("@venue-type") map { _.as[String]}
  lazy val surfaceType = attributes.get("@surface-type") map { _.as[String]}
  lazy val weatherType = attributes.get("@weather-type") map { _.as[String]}
  lazy val scopeValue = attributes.get("@scope-value") map { _.as[String]}
  lazy val distance = attributes.get("@distance") map { _.as[String]}
  lazy val distanceMaximum = attributes.get("@distance-maximum") map { _.as[String]}
  lazy val distanceMinimum = attributes.get("@distance-minimum") map { _.as[String]}
  lazy val measurementUnits = attributes.get("@measurement-units") map { _.as[String]}
}

      


/** Indicates status change of an entity.
*/
case class StatusChangeComplexType(attributes: Map[String, scalaxb.DataRecord[Any]] = Map()) {
  lazy val id = attributes.get("@id") map { _.as[String]}
  lazy val classValue = attributes.get("@class") map { _.as[String]}
  lazy val style = attributes.get("@style") map { _.as[String]}
  lazy val statsCoverage = attributes.get("@stats-coverage") map { _.as[String]}
  lazy val teamCoverage = attributes.get("@team-coverage") map { _.as[TeamCoverage]}
  lazy val durationScope = attributes.get("@duration-scope") map { _.as[String]}
  lazy val alignmentScope = attributes.get("@alignment-scope") map { _.as[AlignmentScope]}
  lazy val position = attributes.get("@position") map { _.as[String]}
  lazy val recordMakingScope = attributes.get("@record-making-scope") map { _.as[String]}
  lazy val scopingLabel = attributes.get("@scoping-label") map { _.as[String]}
  lazy val periodValue = attributes.get("@period-value") map { _.as[String]}
  lazy val periodType = attributes.get("@period-type") map { _.as[String]}
  lazy val startDateTime = attributes.get("@start-date-time") map { _.as[String]}
  lazy val endDateTime = attributes.get("@end-date-time") map { _.as[String]}
  lazy val periodStartDateTime = attributes.get("@period-start-date-time") map { _.as[String]}
  lazy val periodEndDateTime = attributes.get("@period-end-date-time") map { _.as[String]}
  lazy val temporalUnitType = attributes.get("@temporal-unit-type") map { _.as[String]}
  lazy val temporalUnitValue = attributes.get("@temporal-unit-value") map { _.as[String]}
  lazy val eventSpan = attributes.get("@event-span") map { _.as[BigInt]}
  lazy val opponentValue = attributes.get("@opponent-value") map { _.as[String]}
  lazy val opponentType = attributes.get("@opponent-type") map { _.as[String]}
  lazy val team = attributes.get("@team") map { _.as[String]}
  lazy val competition = attributes.get("@competition") map { _.as[String]}
  lazy val unitValue = attributes.get("@unit-value") map { _.as[String]}
  lazy val unitType = attributes.get("@unit-type") map { _.as[String]}
  lazy val situation = attributes.get("@situation") map { _.as[String]}
  lazy val locationKey = attributes.get("@location-key") map { _.as[String]}
  lazy val venueType = attributes.get("@venue-type") map { _.as[String]}
  lazy val surfaceType = attributes.get("@surface-type") map { _.as[String]}
  lazy val weatherType = attributes.get("@weather-type") map { _.as[String]}
  lazy val scopeValue = attributes.get("@scope-value") map { _.as[String]}
  lazy val distance = attributes.get("@distance") map { _.as[String]}
  lazy val distanceMaximum = attributes.get("@distance-maximum") map { _.as[String]}
  lazy val distanceMinimum = attributes.get("@distance-minimum") map { _.as[String]}
  lazy val measurementUnits = attributes.get("@measurement-units") map { _.as[String]}
  lazy val changerIdref = attributes("@changer-idref").as[String]
  lazy val statusChangeType = attributes("@status-change-type").as[String]
  lazy val originalStatus = attributes.get("@original-status") map { _.as[String]}
  lazy val newStatus = attributes.get("@new-status") map { _.as[String]}
  lazy val originalIdref = attributes.get("@original-idref") map { _.as[String]}
  lazy val newIdref = attributes.get("@new-idref") map { _.as[String]}
}

      


/** A holder for statistics about a particular bracket or division or
                conference or league. | Holds metadata and stats. Also appropriate for expressing
                general organization/league membership and structure.
*/
case class GroupComplexType(groupMetadata: org.iptc.sportsml.v3.GroupMetadataComplexType,
  groupStats: Seq[org.iptc.sportsml.v3.GroupStatsComplexType] = Nil,
  group: Seq[org.iptc.sportsml.v3.GroupComplexType] = Nil,
  team: Seq[org.iptc.sportsml.v3.TeamComplexType] = Nil,
  player: Seq[org.iptc.sportsml.v3.PlayerComplexType] = Nil,
  affiliation: Seq[org.iptc.sportsml.v3.AffiliationComplexType] = Nil,
  attributes: Map[String, scalaxb.DataRecord[Any]] = Map()) {
  lazy val id = attributes.get("@id") map { _.as[String]}
  lazy val classValue = attributes.get("@class") map { _.as[String]}
  lazy val style = attributes.get("@style") map { _.as[String]}
}

      


/** Metadata about the group.
*/
case class GroupMetadataComplexType(sportsContentCodes: Option[org.iptc.sportsml.v3.SportsContentCodesComplexType] = None,
  sportsProperty: Seq[org.iptc.sportsml.v3.SportsPropertyComplexType] = Nil,
  name: Seq[org.iptc.sportsml.v3.ConceptNameType] = Nil,
  site: Seq[org.iptc.sportsml.v3.SiteComplexType] = Nil,
  award: Seq[org.iptc.sportsml.v3.AwardComplexType] = Nil,
  attributes: Map[String, scalaxb.DataRecord[Any]] = Map()) extends Base2MetadataComplexTypable {
  lazy val id = attributes.get("@id") map { _.as[String]}
  lazy val classValue = attributes.get("@class") map { _.as[String]}
  lazy val style = attributes.get("@style") map { _.as[String]}
  lazy val statsCoverage = attributes.get("@stats-coverage") map { _.as[String]}
  lazy val teamCoverage = attributes.get("@team-coverage") map { _.as[TeamCoverage]}
  lazy val durationScope = attributes.get("@duration-scope") map { _.as[String]}
  lazy val alignmentScope = attributes.get("@alignment-scope") map { _.as[AlignmentScope]}
  lazy val position = attributes.get("@position") map { _.as[String]}
  lazy val recordMakingScope = attributes.get("@record-making-scope") map { _.as[String]}
  lazy val scopingLabel = attributes.get("@scoping-label") map { _.as[String]}
  lazy val periodValue = attributes.get("@period-value") map { _.as[String]}
  lazy val periodType = attributes.get("@period-type") map { _.as[String]}
  lazy val startDateTime = attributes.get("@start-date-time") map { _.as[String]}
  lazy val endDateTime = attributes.get("@end-date-time") map { _.as[String]}
  lazy val periodStartDateTime = attributes.get("@period-start-date-time") map { _.as[String]}
  lazy val periodEndDateTime = attributes.get("@period-end-date-time") map { _.as[String]}
  lazy val temporalUnitType = attributes.get("@temporal-unit-type") map { _.as[String]}
  lazy val temporalUnitValue = attributes.get("@temporal-unit-value") map { _.as[String]}
  lazy val eventSpan = attributes.get("@event-span") map { _.as[BigInt]}
  lazy val opponentValue = attributes.get("@opponent-value") map { _.as[String]}
  lazy val opponentType = attributes.get("@opponent-type") map { _.as[String]}
  lazy val team = attributes.get("@team") map { _.as[String]}
  lazy val competition = attributes.get("@competition") map { _.as[String]}
  lazy val unitValue = attributes.get("@unit-value") map { _.as[String]}
  lazy val unitType = attributes.get("@unit-type") map { _.as[String]}
  lazy val situation = attributes.get("@situation") map { _.as[String]}
  lazy val locationKey = attributes.get("@location-key") map { _.as[String]}
  lazy val venueType = attributes.get("@venue-type") map { _.as[String]}
  lazy val surfaceType = attributes.get("@surface-type") map { _.as[String]}
  lazy val weatherType = attributes.get("@weather-type") map { _.as[String]}
  lazy val scopeValue = attributes.get("@scope-value") map { _.as[String]}
  lazy val distance = attributes.get("@distance") map { _.as[String]}
  lazy val distanceMaximum = attributes.get("@distance-maximum") map { _.as[String]}
  lazy val distanceMinimum = attributes.get("@distance-minimum") map { _.as[String]}
  lazy val measurementUnits = attributes.get("@measurement-units") map { _.as[String]}
  lazy val key = attributes.get("@key") map { _.as[String]}
  lazy val groupType = attributes.get("@group-type") map { _.as[String]}
  lazy val homePageUrl = attributes.get("@home-page-url") map { _.as[String]}
}

      


/** Statistics that apply to the group as a whole. | Not all stats are used in every sport.
*/
case class GroupStatsComplexType(rating: Seq[org.iptc.sportsml.v3.RatingComplexType] = Nil,
  sportsProperty: Seq[org.iptc.sportsml.v3.SportsPropertyComplexType] = Nil,
  stats: Seq[org.iptc.sportsml.v3.GenericStatComplexType] = Nil,
  outcomeTotals: Seq[org.iptc.sportsml.v3.OutcomeTotalsComplexType] = Nil,
  outcomeResult: Seq[org.iptc.sportsml.v3.OutcomeResultComplexType] = Nil,
  penaltyStats: Seq[org.iptc.sportsml.v3.PenaltyStatsComplexType] = Nil,
  award: Seq[org.iptc.sportsml.v3.AwardComplexType] = Nil,
  rank: Seq[org.iptc.sportsml.v3.RankComplexType] = Nil,
  attributes: Map[String, scalaxb.DataRecord[Any]] = Map()) extends Base3StatsComplexTypable {
  lazy val id = attributes.get("@id") map { _.as[String]}
  lazy val classValue = attributes.get("@class") map { _.as[String]}
  lazy val style = attributes.get("@style") map { _.as[String]}
  lazy val points = attributes.get("@points") map { _.as[BigInt]}
  lazy val statsCoverage = attributes.get("@stats-coverage") map { _.as[String]}
  lazy val teamCoverage = attributes.get("@team-coverage") map { _.as[TeamCoverage]}
  lazy val durationScope = attributes.get("@duration-scope") map { _.as[String]}
  lazy val alignmentScope = attributes.get("@alignment-scope") map { _.as[AlignmentScope]}
  lazy val position = attributes.get("@position") map { _.as[String]}
  lazy val recordMakingScope = attributes.get("@record-making-scope") map { _.as[String]}
  lazy val scopingLabel = attributes.get("@scoping-label") map { _.as[String]}
  lazy val periodValue = attributes.get("@period-value") map { _.as[String]}
  lazy val periodType = attributes.get("@period-type") map { _.as[String]}
  lazy val startDateTime = attributes.get("@start-date-time") map { _.as[String]}
  lazy val endDateTime = attributes.get("@end-date-time") map { _.as[String]}
  lazy val periodStartDateTime = attributes.get("@period-start-date-time") map { _.as[String]}
  lazy val periodEndDateTime = attributes.get("@period-end-date-time") map { _.as[String]}
  lazy val temporalUnitType = attributes.get("@temporal-unit-type") map { _.as[String]}
  lazy val temporalUnitValue = attributes.get("@temporal-unit-value") map { _.as[String]}
  lazy val eventSpan = attributes.get("@event-span") map { _.as[BigInt]}
  lazy val opponentValue = attributes.get("@opponent-value") map { _.as[String]}
  lazy val opponentType = attributes.get("@opponent-type") map { _.as[String]}
  lazy val team = attributes.get("@team") map { _.as[String]}
  lazy val competition = attributes.get("@competition") map { _.as[String]}
  lazy val unitValue = attributes.get("@unit-value") map { _.as[String]}
  lazy val unitType = attributes.get("@unit-type") map { _.as[String]}
  lazy val situation = attributes.get("@situation") map { _.as[String]}
  lazy val locationKey = attributes.get("@location-key") map { _.as[String]}
  lazy val venueType = attributes.get("@venue-type") map { _.as[String]}
  lazy val surfaceType = attributes.get("@surface-type") map { _.as[String]}
  lazy val weatherType = attributes.get("@weather-type") map { _.as[String]}
  lazy val scopeValue = attributes.get("@scope-value") map { _.as[String]}
  lazy val distance = attributes.get("@distance") map { _.as[String]}
  lazy val distanceMaximum = attributes.get("@distance-maximum") map { _.as[String]}
  lazy val distanceMinimum = attributes.get("@distance-minimum") map { _.as[String]}
  lazy val measurementUnits = attributes.get("@measurement-units") map { _.as[String]}
  lazy val score = attributes.get("@score") map { _.as[String]}
  lazy val scoreOpposing = attributes.get("@score-opposing") map { _.as[String]}
  lazy val scoreAverage = attributes.get("@score-average") map { _.as[String]}
  lazy val scoreOpposingAverage = attributes.get("@score-opposing-average") map { _.as[String]}
  lazy val scoreUnits = attributes.get("@score-units") map { _.as[String]}
  lazy val scoreBehind = attributes.get("@score-behind") map { _.as[String]}
  lazy val scoreAttempts = attributes.get("@score-attempts") map { _.as[String]}
  lazy val scoreAttemptsOpposing = attributes.get("@score-attempts-opposing") map { _.as[String]}
  lazy val scoreAttemptsOnGoal = attributes.get("@score-attempts-on-goal") map { _.as[String]}
  lazy val scoreAttemptsOnGoalOpposing = attributes.get("@score-attempts-on-goal-opposing") map { _.as[String]}
  lazy val scorePercentage = attributes.get("@score-percentage") map { _.as[String]}
  lazy val scorePercentageOpposing = attributes.get("@score-percentage-opposing") map { _.as[String]}
  lazy val resultEffect = attributes.get("@result-effect") map { _.as[String]}
  lazy val eventOutcome = attributes.get("@event-outcome") map { _.as[String]}
  lazy val eventStandingPoints = attributes.get("@event-standing-points") map { _.as[String]}
  lazy val eventStandingPointsAgainst = attributes.get("@event-standing-points-against") map { _.as[String]}
  lazy val scoreType = attributes.get("@score-type") map { _.as[String]}
  lazy val eventsRemaining = attributes.get("@events-remaining") map { _.as[String]}
  lazy val timeOfPossession = attributes.get("@time-of-possession") map { _.as[String]}
  lazy val timeOfPossessionPercentage = attributes.get("@time-of-possession-percentage") map { _.as[String]}
  lazy val timeOfPossessionPercentageOpposing = attributes.get("@time-of-possession-percentage-opposing") map { _.as[String]}
  lazy val timeOfPossessionAverage = attributes.get("@time-of-possession-average") map { _.as[String]}
  lazy val timeOfPossessionAverageOpposing = attributes.get("@time-of-possession-average-opposing") map { _.as[String]}
  lazy val seriesScore = attributes.get("@series-score") map { _.as[String]}
  lazy val seriesScoreOpposing = attributes.get("@series-score-opposing") map { _.as[String]}
  lazy val adjustedScoreFor = attributes.get("@adjusted-score-for") map { _.as[String]}
  lazy val adjustedScoreAgainst = attributes.get("@adjusted-score-against") map { _.as[String]}
}

      


/** A generic stat element that can be used together with or instead of
                more specific stat element and attributes. With nested stats the lower levels should
                be regarded as having the same value as their parents if that attribute is not
                specifically set.
*/
case class GenericStatComplexType(name: Seq[org.iptc.sportsml.v3.ConceptNameType] = Nil,
  stat: Seq[org.iptc.sportsml.v3.GenericStatComplexType] = Nil,
  attributes: Map[String, scalaxb.DataRecord[Any]] = Map()) {
  lazy val sport = attributes.get("@sport") map { _.as[String]}
  lazy val classValue = attributes.get("@class") map { _.as[String]}
  lazy val statType = attributes.get("@stat-type") map { _.as[String]}
  lazy val valueType = attributes.get("@value-type") map { _.as[String]}
  lazy val valueAttribute = attributes.get("@value") map { _.as[String]}
  lazy val statsCoverage = attributes.get("@stats-coverage") map { _.as[String]}
  lazy val teamCoverage = attributes.get("@team-coverage") map { _.as[TeamCoverage]}
  lazy val durationScope = attributes.get("@duration-scope") map { _.as[String]}
  lazy val alignmentScope = attributes.get("@alignment-scope") map { _.as[AlignmentScope]}
  lazy val position = attributes.get("@position") map { _.as[String]}
  lazy val recordMakingScope = attributes.get("@record-making-scope") map { _.as[String]}
  lazy val scopingLabel = attributes.get("@scoping-label") map { _.as[String]}
  lazy val periodValue = attributes.get("@period-value") map { _.as[String]}
  lazy val periodType = attributes.get("@period-type") map { _.as[String]}
  lazy val startDateTime = attributes.get("@start-date-time") map { _.as[String]}
  lazy val endDateTime = attributes.get("@end-date-time") map { _.as[String]}
  lazy val periodStartDateTime = attributes.get("@period-start-date-time") map { _.as[String]}
  lazy val periodEndDateTime = attributes.get("@period-end-date-time") map { _.as[String]}
  lazy val temporalUnitType = attributes.get("@temporal-unit-type") map { _.as[String]}
  lazy val temporalUnitValue = attributes.get("@temporal-unit-value") map { _.as[String]}
  lazy val eventSpan = attributes.get("@event-span") map { _.as[BigInt]}
  lazy val opponentValue = attributes.get("@opponent-value") map { _.as[String]}
  lazy val opponentType = attributes.get("@opponent-type") map { _.as[String]}
  lazy val team = attributes.get("@team") map { _.as[String]}
  lazy val competition = attributes.get("@competition") map { _.as[String]}
  lazy val unitValue = attributes.get("@unit-value") map { _.as[String]}
  lazy val unitType = attributes.get("@unit-type") map { _.as[String]}
  lazy val situation = attributes.get("@situation") map { _.as[String]}
  lazy val locationKey = attributes.get("@location-key") map { _.as[String]}
  lazy val venueType = attributes.get("@venue-type") map { _.as[String]}
  lazy val surfaceType = attributes.get("@surface-type") map { _.as[String]}
  lazy val weatherType = attributes.get("@weather-type") map { _.as[String]}
  lazy val scopeValue = attributes.get("@scope-value") map { _.as[String]}
  lazy val distance = attributes.get("@distance") map { _.as[String]}
  lazy val distanceMaximum = attributes.get("@distance-maximum") map { _.as[String]}
  lazy val distanceMinimum = attributes.get("@distance-minimum") map { _.as[String]}
  lazy val measurementUnits = attributes.get("@measurement-units") map { _.as[String]}
}

      


/** An element to house lines and odds for wagering. | Includes moneylines, spreads, etc.
*/
case class WageringStats(wageringStatsoption: Seq[scalaxb.DataRecord[org.iptc.sportsml.v3.WageringStatsOption]] = Nil,
  attributes: Map[String, scalaxb.DataRecord[Any]] = Map()) {
  lazy val id = attributes.get("@id") map { _.as[String]}
  lazy val classValue = attributes.get("@class") map { _.as[String]}
  lazy val style = attributes.get("@style") map { _.as[String]}
  lazy val comment = attributes.get("@comment") map { _.as[String]}
}

      

trait WageringStatsOption

/** Odds in terms of money. | Negative amount indicates wagerer must lay
                that amount to win say a hundred dollars. Positive amount indicates wagerer gets
                that amount for every hundred dollars wagered.
*/
case class WageringMoneyline(attributes: Map[String, scalaxb.DataRecord[Any]] = Map()) extends WageringStatsOption {
  lazy val id = attributes.get("@id") map { _.as[String]}
  lazy val classValue = attributes.get("@class") map { _.as[String]}
  lazy val style = attributes.get("@style") map { _.as[String]}
  lazy val bookmakerKey = attributes.get("@bookmaker-key") map { _.as[String]}
  lazy val bookmakerName = attributes.get("@bookmaker-name") map { _.as[String]}
  lazy val rotationKey = attributes.get("@rotation-key") map { _.as[String]}
  lazy val comment = attributes.get("@comment") map { _.as[String]}
  lazy val dateTime = attributes.get("@date-time") map { _.as[String]}
  lazy val context = attributes.get("@context") map { _.as[Context]}
  lazy val prediction = attributes.get("@prediction") map { _.as[String]}
  lazy val predictionOpening = attributes.get("@prediction-opening") map { _.as[String]}
  lazy val vigorish = attributes.get("@vigorish") map { _.as[String]}
  lazy val line = attributes.get("@line") map { _.as[String]}
  lazy val lineOpening = attributes.get("@line-opening") map { _.as[String]}
}

      


/** A line used in baseball.
*/
case class WageringRunline(attributes: Map[String, scalaxb.DataRecord[Any]] = Map()) extends WageringStatsOption {
  lazy val id = attributes.get("@id") map { _.as[String]}
  lazy val classValue = attributes.get("@class") map { _.as[String]}
  lazy val style = attributes.get("@style") map { _.as[String]}
  lazy val bookmakerKey = attributes.get("@bookmaker-key") map { _.as[String]}
  lazy val bookmakerName = attributes.get("@bookmaker-name") map { _.as[String]}
  lazy val rotationKey = attributes.get("@rotation-key") map { _.as[String]}
  lazy val comment = attributes.get("@comment") map { _.as[String]}
  lazy val dateTime = attributes.get("@date-time") map { _.as[String]}
  lazy val context = attributes.get("@context") map { _.as[Context]}
  lazy val prediction = attributes.get("@prediction") map { _.as[String]}
  lazy val predictionOpening = attributes.get("@prediction-opening") map { _.as[String]}
  lazy val vigorish = attributes.get("@vigorish") map { _.as[String]}
  lazy val line = attributes.get("@line") map { _.as[String]}
  lazy val lineOpening = attributes.get("@line-opening") map { _.as[String]}
  lazy val valueAttribute = attributes.get("@value") map { _.as[String]}
  lazy val valueOpening = attributes.get("@value-opening") map { _.as[String]}
}

      


/** A wager built around the different between the scores of two teams.
*/
case class WageringStraightSpread(attributes: Map[String, scalaxb.DataRecord[Any]] = Map()) extends WageringStatsOption {
  lazy val id = attributes.get("@id") map { _.as[String]}
  lazy val classValue = attributes.get("@class") map { _.as[String]}
  lazy val style = attributes.get("@style") map { _.as[String]}
  lazy val bookmakerKey = attributes.get("@bookmaker-key") map { _.as[String]}
  lazy val bookmakerName = attributes.get("@bookmaker-name") map { _.as[String]}
  lazy val rotationKey = attributes.get("@rotation-key") map { _.as[String]}
  lazy val comment = attributes.get("@comment") map { _.as[String]}
  lazy val dateTime = attributes.get("@date-time") map { _.as[String]}
  lazy val context = attributes.get("@context") map { _.as[Context]}
  lazy val prediction = attributes.get("@prediction") map { _.as[String]}
  lazy val predictionOpening = attributes.get("@prediction-opening") map { _.as[String]}
  lazy val vigorish = attributes.get("@vigorish") map { _.as[String]}
  lazy val line = attributes.get("@line") map { _.as[String]}
  lazy val lineOpening = attributes.get("@line-opening") map { _.as[String]}
  lazy val valueAttribute = attributes.get("@value") map { _.as[String]}
  lazy val valueOpening = attributes.get("@value-opening") map { _.as[String]}
}

      


/** Total combined point/runs/goals scored in a game.
*/
case class WageringTotalScore(attributes: Map[String, scalaxb.DataRecord[Any]] = Map()) extends WageringStatsOption {
  lazy val id = attributes.get("@id") map { _.as[String]}
  lazy val classValue = attributes.get("@class") map { _.as[String]}
  lazy val style = attributes.get("@style") map { _.as[String]}
  lazy val bookmakerKey = attributes.get("@bookmaker-key") map { _.as[String]}
  lazy val bookmakerName = attributes.get("@bookmaker-name") map { _.as[String]}
  lazy val rotationKey = attributes.get("@rotation-key") map { _.as[String]}
  lazy val comment = attributes.get("@comment") map { _.as[String]}
  lazy val dateTime = attributes.get("@date-time") map { _.as[String]}
  lazy val context = attributes.get("@context") map { _.as[Context]}
  lazy val prediction = attributes.get("@prediction") map { _.as[String]}
  lazy val predictionOpening = attributes.get("@prediction-opening") map { _.as[String]}
  lazy val vigorish = attributes.get("@vigorish") map { _.as[String]}
  lazy val lineOver = attributes.get("@line-over") map { _.as[String]}
  lazy val lineUnder = attributes.get("@line-under") map { _.as[String]}
  lazy val total = attributes.get("@total") map { _.as[String]}
  lazy val lineOverOpening = attributes.get("@line-over-opening") map { _.as[String]}
  lazy val lineUnderOpening = attributes.get("@line-under-opening") map { _.as[String]}
  lazy val totalOpening = attributes.get("@total-opening") map { _.as[String]}
}

      


/** A line that gives formal odds on a team or player winning, such as 3-to-1 odds.
*/
case class WageringOdds(wageringOddssequence1: Seq[org.iptc.sportsml.v3.WageringOddsSequence1] = Nil,
  attributes: Map[String, scalaxb.DataRecord[Any]] = Map()) extends WageringStatsOption {
  lazy val id = attributes.get("@id") map { _.as[String]}
  lazy val classValue = attributes.get("@class") map { _.as[String]}
  lazy val style = attributes.get("@style") map { _.as[String]}
  lazy val bookmakerKey = attributes.get("@bookmaker-key") map { _.as[String]}
  lazy val bookmakerName = attributes.get("@bookmaker-name") map { _.as[String]}
  lazy val rotationKey = attributes.get("@rotation-key") map { _.as[String]}
  lazy val comment = attributes.get("@comment") map { _.as[String]}
  lazy val dateTime = attributes.get("@date-time") map { _.as[String]}
  lazy val context = attributes.get("@context") map { _.as[Context]}
  lazy val numerator = attributes.get("@numerator") map { _.as[String]}
  lazy val denominator = attributes.get("@denominator") map { _.as[String]}
  lazy val numeratorOpening = attributes.get("@numerator-opening") map { _.as[String]}
  lazy val denominatorOpening = attributes.get("@denominator-opening") map { _.as[String]}
  lazy val payoutCalcluation = attributes.get("@payout-calcluation") map { _.as[String]}
  lazy val paybackAmount = attributes.get("@payback-amount") map { _.as[String]}
}

      

case class WageringOddsSequence1(wageringPrediction: org.iptc.sportsml.v3.WageringPrediction)

/** A prediction as to whether a team or player is a favorite or an underdog.
*/
case class WageringPrediction(attributes: Map[String, scalaxb.DataRecord[Any]] = Map()) {
  lazy val id = attributes.get("@id") map { _.as[String]}
  lazy val classValue = attributes.get("@class") map { _.as[String]}
  lazy val style = attributes.get("@style") map { _.as[String]}
  lazy val statsCoverage = attributes.get("@stats-coverage") map { _.as[String]}
  lazy val teamCoverage = attributes.get("@team-coverage") map { _.as[TeamCoverage]}
  lazy val durationScope = attributes.get("@duration-scope") map { _.as[String]}
  lazy val alignmentScope = attributes.get("@alignment-scope") map { _.as[AlignmentScope]}
  lazy val position = attributes.get("@position") map { _.as[String]}
  lazy val recordMakingScope = attributes.get("@record-making-scope") map { _.as[String]}
  lazy val scopingLabel = attributes.get("@scoping-label") map { _.as[String]}
  lazy val periodValue = attributes.get("@period-value") map { _.as[String]}
  lazy val periodType = attributes.get("@period-type") map { _.as[String]}
  lazy val startDateTime = attributes.get("@start-date-time") map { _.as[String]}
  lazy val endDateTime = attributes.get("@end-date-time") map { _.as[String]}
  lazy val periodStartDateTime = attributes.get("@period-start-date-time") map { _.as[String]}
  lazy val periodEndDateTime = attributes.get("@period-end-date-time") map { _.as[String]}
  lazy val temporalUnitType = attributes.get("@temporal-unit-type") map { _.as[String]}
  lazy val temporalUnitValue = attributes.get("@temporal-unit-value") map { _.as[String]}
  lazy val eventSpan = attributes.get("@event-span") map { _.as[BigInt]}
  lazy val opponentValue = attributes.get("@opponent-value") map { _.as[String]}
  lazy val opponentType = attributes.get("@opponent-type") map { _.as[String]}
  lazy val team = attributes.get("@team") map { _.as[String]}
  lazy val competition = attributes.get("@competition") map { _.as[String]}
  lazy val unitValue = attributes.get("@unit-value") map { _.as[String]}
  lazy val unitType = attributes.get("@unit-type") map { _.as[String]}
  lazy val situation = attributes.get("@situation") map { _.as[String]}
  lazy val locationKey = attributes.get("@location-key") map { _.as[String]}
  lazy val venueType = attributes.get("@venue-type") map { _.as[String]}
  lazy val surfaceType = attributes.get("@surface-type") map { _.as[String]}
  lazy val weatherType = attributes.get("@weather-type") map { _.as[String]}
  lazy val scopeValue = attributes.get("@scope-value") map { _.as[String]}
  lazy val distance = attributes.get("@distance") map { _.as[String]}
  lazy val distanceMaximum = attributes.get("@distance-maximum") map { _.as[String]}
  lazy val distanceMinimum = attributes.get("@distance-minimum") map { _.as[String]}
  lazy val measurementUnits = attributes.get("@measurement-units") map { _.as[String]}
  lazy val prediction = attributes.get("@prediction") map { _.as[String]}
}

      


/** Basic metadata elements and attributes. Used directly by sports, standing, schedule and statistic and extended further by base2MetadataComplexType
*/
trait BaseMetadataComplexTypable {
  def sportsContentCodes: Option[org.iptc.sportsml.v3.SportsContentCodesComplexType]
  def sportsProperty: Seq[org.iptc.sportsml.v3.SportsPropertyComplexType]
  def id: Option[String]
  def classValue: Option[String]
  def style: Option[String]
  def statsCoverage: Option[String]
  def teamCoverage: Option[org.iptc.sportsml.v3.TeamCoverage]
  def durationScope: Option[String]
  def alignmentScope: Option[org.iptc.sportsml.v3.AlignmentScope]
  def position: Option[String]
  def recordMakingScope: Option[String]
  def scopingLabel: Option[String]
  def periodValue: Option[String]
  def periodType: Option[String]
  def startDateTime: Option[String]
  def endDateTime: Option[String]
  def periodStartDateTime: Option[String]
  def periodEndDateTime: Option[String]
  def temporalUnitType: Option[String]
  def temporalUnitValue: Option[String]
  def eventSpan: Option[BigInt]
  def opponentValue: Option[String]
  def opponentType: Option[String]
  def team: Option[String]
  def competition: Option[String]
  def unitValue: Option[String]
  def unitType: Option[String]
  def situation: Option[String]
  def locationKey: Option[String]
  def venueType: Option[String]
  def surfaceType: Option[String]
  def weatherType: Option[String]
  def scopeValue: Option[String]
  def distance: Option[String]
  def distanceMaximum: Option[String]
  def distanceMinimum: Option[String]
  def measurementUnits: Option[String]
}


/** Basic metadata elements and attributes. Used directly by sports, standing, schedule and statistic and extended further by base2MetadataComplexType
*/
case class BaseMetadataComplexType(sportsContentCodes: Option[org.iptc.sportsml.v3.SportsContentCodesComplexType] = None,
  sportsProperty: Seq[org.iptc.sportsml.v3.SportsPropertyComplexType] = Nil,
  attributes: Map[String, scalaxb.DataRecord[Any]] = Map()) extends BaseMetadataComplexTypable {
  lazy val id = attributes.get("@id") map { _.as[String]}
  lazy val classValue = attributes.get("@class") map { _.as[String]}
  lazy val style = attributes.get("@style") map { _.as[String]}
  lazy val statsCoverage = attributes.get("@stats-coverage") map { _.as[String]}
  lazy val teamCoverage = attributes.get("@team-coverage") map { _.as[TeamCoverage]}
  lazy val durationScope = attributes.get("@duration-scope") map { _.as[String]}
  lazy val alignmentScope = attributes.get("@alignment-scope") map { _.as[AlignmentScope]}
  lazy val position = attributes.get("@position") map { _.as[String]}
  lazy val recordMakingScope = attributes.get("@record-making-scope") map { _.as[String]}
  lazy val scopingLabel = attributes.get("@scoping-label") map { _.as[String]}
  lazy val periodValue = attributes.get("@period-value") map { _.as[String]}
  lazy val periodType = attributes.get("@period-type") map { _.as[String]}
  lazy val startDateTime = attributes.get("@start-date-time") map { _.as[String]}
  lazy val endDateTime = attributes.get("@end-date-time") map { _.as[String]}
  lazy val periodStartDateTime = attributes.get("@period-start-date-time") map { _.as[String]}
  lazy val periodEndDateTime = attributes.get("@period-end-date-time") map { _.as[String]}
  lazy val temporalUnitType = attributes.get("@temporal-unit-type") map { _.as[String]}
  lazy val temporalUnitValue = attributes.get("@temporal-unit-value") map { _.as[String]}
  lazy val eventSpan = attributes.get("@event-span") map { _.as[BigInt]}
  lazy val opponentValue = attributes.get("@opponent-value") map { _.as[String]}
  lazy val opponentType = attributes.get("@opponent-type") map { _.as[String]}
  lazy val team = attributes.get("@team") map { _.as[String]}
  lazy val competition = attributes.get("@competition") map { _.as[String]}
  lazy val unitValue = attributes.get("@unit-value") map { _.as[String]}
  lazy val unitType = attributes.get("@unit-type") map { _.as[String]}
  lazy val situation = attributes.get("@situation") map { _.as[String]}
  lazy val locationKey = attributes.get("@location-key") map { _.as[String]}
  lazy val venueType = attributes.get("@venue-type") map { _.as[String]}
  lazy val surfaceType = attributes.get("@surface-type") map { _.as[String]}
  lazy val weatherType = attributes.get("@weather-type") map { _.as[String]}
  lazy val scopeValue = attributes.get("@scope-value") map { _.as[String]}
  lazy val distance = attributes.get("@distance") map { _.as[String]}
  lazy val distanceMaximum = attributes.get("@distance-maximum") map { _.as[String]}
  lazy val distanceMinimum = attributes.get("@distance-minimum") map { _.as[String]}
  lazy val measurementUnits = attributes.get("@measurement-units") map { _.as[String]}
}

      


/** Extends the baseMetadata with more elements and attributes. Used by baseEvent and baseTournament
*/
trait Base2MetadataComplexTypable extends BaseMetadataComplexTypable {
  def sportsContentCodes: Option[org.iptc.sportsml.v3.SportsContentCodesComplexType]
  def sportsProperty: Seq[org.iptc.sportsml.v3.SportsPropertyComplexType]
  def name: Seq[org.iptc.sportsml.v3.ConceptNameType]
  def site: Seq[org.iptc.sportsml.v3.SiteComplexType]
  def award: Seq[org.iptc.sportsml.v3.AwardComplexType]
  def id: Option[String]
  def classValue: Option[String]
  def style: Option[String]
  def statsCoverage: Option[String]
  def teamCoverage: Option[org.iptc.sportsml.v3.TeamCoverage]
  def durationScope: Option[String]
  def alignmentScope: Option[org.iptc.sportsml.v3.AlignmentScope]
  def position: Option[String]
  def recordMakingScope: Option[String]
  def scopingLabel: Option[String]
  def periodValue: Option[String]
  def periodType: Option[String]
  def startDateTime: Option[String]
  def endDateTime: Option[String]
  def periodStartDateTime: Option[String]
  def periodEndDateTime: Option[String]
  def temporalUnitType: Option[String]
  def temporalUnitValue: Option[String]
  def eventSpan: Option[BigInt]
  def opponentValue: Option[String]
  def opponentType: Option[String]
  def team: Option[String]
  def competition: Option[String]
  def unitValue: Option[String]
  def unitType: Option[String]
  def situation: Option[String]
  def locationKey: Option[String]
  def venueType: Option[String]
  def surfaceType: Option[String]
  def weatherType: Option[String]
  def scopeValue: Option[String]
  def distance: Option[String]
  def distanceMaximum: Option[String]
  def distanceMinimum: Option[String]
  def measurementUnits: Option[String]
  def key: Option[String]
}


/** Extends the baseMetadata with more elements and attributes. Used by baseEvent and baseTournament
*/
case class Base2MetadataComplexType(sportsContentCodes: Option[org.iptc.sportsml.v3.SportsContentCodesComplexType] = None,
  sportsProperty: Seq[org.iptc.sportsml.v3.SportsPropertyComplexType] = Nil,
  name: Seq[org.iptc.sportsml.v3.ConceptNameType] = Nil,
  site: Seq[org.iptc.sportsml.v3.SiteComplexType] = Nil,
  award: Seq[org.iptc.sportsml.v3.AwardComplexType] = Nil,
  attributes: Map[String, scalaxb.DataRecord[Any]] = Map()) extends Base2MetadataComplexTypable {
  lazy val id = attributes.get("@id") map { _.as[String]}
  lazy val classValue = attributes.get("@class") map { _.as[String]}
  lazy val style = attributes.get("@style") map { _.as[String]}
  lazy val statsCoverage = attributes.get("@stats-coverage") map { _.as[String]}
  lazy val teamCoverage = attributes.get("@team-coverage") map { _.as[TeamCoverage]}
  lazy val durationScope = attributes.get("@duration-scope") map { _.as[String]}
  lazy val alignmentScope = attributes.get("@alignment-scope") map { _.as[AlignmentScope]}
  lazy val position = attributes.get("@position") map { _.as[String]}
  lazy val recordMakingScope = attributes.get("@record-making-scope") map { _.as[String]}
  lazy val scopingLabel = attributes.get("@scoping-label") map { _.as[String]}
  lazy val periodValue = attributes.get("@period-value") map { _.as[String]}
  lazy val periodType = attributes.get("@period-type") map { _.as[String]}
  lazy val startDateTime = attributes.get("@start-date-time") map { _.as[String]}
  lazy val endDateTime = attributes.get("@end-date-time") map { _.as[String]}
  lazy val periodStartDateTime = attributes.get("@period-start-date-time") map { _.as[String]}
  lazy val periodEndDateTime = attributes.get("@period-end-date-time") map { _.as[String]}
  lazy val temporalUnitType = attributes.get("@temporal-unit-type") map { _.as[String]}
  lazy val temporalUnitValue = attributes.get("@temporal-unit-value") map { _.as[String]}
  lazy val eventSpan = attributes.get("@event-span") map { _.as[BigInt]}
  lazy val opponentValue = attributes.get("@opponent-value") map { _.as[String]}
  lazy val opponentType = attributes.get("@opponent-type") map { _.as[String]}
  lazy val team = attributes.get("@team") map { _.as[String]}
  lazy val competition = attributes.get("@competition") map { _.as[String]}
  lazy val unitValue = attributes.get("@unit-value") map { _.as[String]}
  lazy val unitType = attributes.get("@unit-type") map { _.as[String]}
  lazy val situation = attributes.get("@situation") map { _.as[String]}
  lazy val locationKey = attributes.get("@location-key") map { _.as[String]}
  lazy val venueType = attributes.get("@venue-type") map { _.as[String]}
  lazy val surfaceType = attributes.get("@surface-type") map { _.as[String]}
  lazy val weatherType = attributes.get("@weather-type") map { _.as[String]}
  lazy val scopeValue = attributes.get("@scope-value") map { _.as[String]}
  lazy val distance = attributes.get("@distance") map { _.as[String]}
  lazy val distanceMaximum = attributes.get("@distance-maximum") map { _.as[String]}
  lazy val distanceMinimum = attributes.get("@distance-minimum") map { _.as[String]}
  lazy val measurementUnits = attributes.get("@measurement-units") map { _.as[String]}
  lazy val key = attributes.get("@key") map { _.as[String]}
}

      


/** The very basic stats type for persons and teams, Extended by base2stats and used directly by officalstats. 
*/
trait BaseStatsComplexTypable {
  def rating: Seq[org.iptc.sportsml.v3.RatingComplexType]
  def sportsProperty: Seq[org.iptc.sportsml.v3.SportsPropertyComplexType]
  def stats: Seq[org.iptc.sportsml.v3.GenericStatComplexType]
  def id: Option[String]
  def classValue: Option[String]
  def style: Option[String]
}


/** The very basic stats type for persons and teams, Extended by base2stats and used directly by officalstats. 
*/
case class BaseStatsComplexType(rating: Seq[org.iptc.sportsml.v3.RatingComplexType] = Nil,
  sportsProperty: Seq[org.iptc.sportsml.v3.SportsPropertyComplexType] = Nil,
  stats: Seq[org.iptc.sportsml.v3.GenericStatComplexType] = Nil,
  attributes: Map[String, scalaxb.DataRecord[Any]] = Map()) extends BaseStatsComplexTypable {
  lazy val id = attributes.get("@id") map { _.as[String]}
  lazy val classValue = attributes.get("@class") map { _.as[String]}
  lazy val style = attributes.get("@style") map { _.as[String]}
}

      


/** Second level stats. Extends baseStats. Extended further in base3stats and used directly in associate
*/
trait Base2StatsComplexTypable extends BaseStatsComplexTypable {
  def rating: Seq[org.iptc.sportsml.v3.RatingComplexType]
  def sportsProperty: Seq[org.iptc.sportsml.v3.SportsPropertyComplexType]
  def stats: Seq[org.iptc.sportsml.v3.GenericStatComplexType]
  def outcomeTotals: Seq[org.iptc.sportsml.v3.OutcomeTotalsComplexType]
  def outcomeResult: Seq[org.iptc.sportsml.v3.OutcomeResultComplexType]
  def id: Option[String]
  def classValue: Option[String]
  def style: Option[String]
  def points: Option[BigInt]
}


/** Second level stats. Extends baseStats. Extended further in base3stats and used directly in associate
*/
case class Base2StatsComplexType(rating: Seq[org.iptc.sportsml.v3.RatingComplexType] = Nil,
  sportsProperty: Seq[org.iptc.sportsml.v3.SportsPropertyComplexType] = Nil,
  stats: Seq[org.iptc.sportsml.v3.GenericStatComplexType] = Nil,
  outcomeTotals: Seq[org.iptc.sportsml.v3.OutcomeTotalsComplexType] = Nil,
  outcomeResult: Seq[org.iptc.sportsml.v3.OutcomeResultComplexType] = Nil,
  attributes: Map[String, scalaxb.DataRecord[Any]] = Map()) extends Base2StatsComplexTypable {
  lazy val id = attributes.get("@id") map { _.as[String]}
  lazy val classValue = attributes.get("@class") map { _.as[String]}
  lazy val style = attributes.get("@style") map { _.as[String]}
  lazy val points = attributes.get("@points") map { _.as[BigInt]}
}

      


/** Extends base2stats. Further extended in genericEntitystats. Used directly by groupStats
*/
trait Base3StatsComplexTypable extends Base2StatsComplexTypable {
  def rating: Seq[org.iptc.sportsml.v3.RatingComplexType]
  def sportsProperty: Seq[org.iptc.sportsml.v3.SportsPropertyComplexType]
  def stats: Seq[org.iptc.sportsml.v3.GenericStatComplexType]
  def outcomeTotals: Seq[org.iptc.sportsml.v3.OutcomeTotalsComplexType]
  def outcomeResult: Seq[org.iptc.sportsml.v3.OutcomeResultComplexType]
  def penaltyStats: Seq[org.iptc.sportsml.v3.PenaltyStatsComplexType]
  def award: Seq[org.iptc.sportsml.v3.AwardComplexType]
  def rank: Seq[org.iptc.sportsml.v3.RankComplexType]
  def id: Option[String]
  def classValue: Option[String]
  def style: Option[String]
  def points: Option[BigInt]
  def statsCoverage: Option[String]
  def teamCoverage: Option[org.iptc.sportsml.v3.TeamCoverage]
  def durationScope: Option[String]
  def alignmentScope: Option[org.iptc.sportsml.v3.AlignmentScope]
  def position: Option[String]
  def recordMakingScope: Option[String]
  def scopingLabel: Option[String]
  def periodValue: Option[String]
  def periodType: Option[String]
  def startDateTime: Option[String]
  def endDateTime: Option[String]
  def periodStartDateTime: Option[String]
  def periodEndDateTime: Option[String]
  def temporalUnitType: Option[String]
  def temporalUnitValue: Option[String]
  def eventSpan: Option[BigInt]
  def opponentValue: Option[String]
  def opponentType: Option[String]
  def team: Option[String]
  def competition: Option[String]
  def unitValue: Option[String]
  def unitType: Option[String]
  def situation: Option[String]
  def locationKey: Option[String]
  def venueType: Option[String]
  def surfaceType: Option[String]
  def weatherType: Option[String]
  def scopeValue: Option[String]
  def distance: Option[String]
  def distanceMaximum: Option[String]
  def distanceMinimum: Option[String]
  def measurementUnits: Option[String]
  def score: Option[String]
  def scoreOpposing: Option[String]
  def scoreAverage: Option[String]
  def scoreOpposingAverage: Option[String]
  def scoreUnits: Option[String]
  def scoreBehind: Option[String]
  def scoreAttempts: Option[String]
  def scoreAttemptsOpposing: Option[String]
  def scoreAttemptsOnGoal: Option[String]
  def scoreAttemptsOnGoalOpposing: Option[String]
  def scorePercentage: Option[String]
  def scorePercentageOpposing: Option[String]
  def resultEffect: Option[String]
  def eventOutcome: Option[String]
  def eventStandingPoints: Option[String]
  def eventStandingPointsAgainst: Option[String]
  def scoreType: Option[String]
  def eventsRemaining: Option[String]
  def timeOfPossession: Option[String]
  def timeOfPossessionPercentage: Option[String]
  def timeOfPossessionPercentageOpposing: Option[String]
  def timeOfPossessionAverage: Option[String]
  def timeOfPossessionAverageOpposing: Option[String]
  def seriesScore: Option[String]
  def seriesScoreOpposing: Option[String]
  def adjustedScoreFor: Option[String]
  def adjustedScoreAgainst: Option[String]
}


/** Extends base2stats. Further extended in genericEntitystats. Used directly by groupStats
*/
case class Base3StatsComplexType(rating: Seq[org.iptc.sportsml.v3.RatingComplexType] = Nil,
  sportsProperty: Seq[org.iptc.sportsml.v3.SportsPropertyComplexType] = Nil,
  stats: Seq[org.iptc.sportsml.v3.GenericStatComplexType] = Nil,
  outcomeTotals: Seq[org.iptc.sportsml.v3.OutcomeTotalsComplexType] = Nil,
  outcomeResult: Seq[org.iptc.sportsml.v3.OutcomeResultComplexType] = Nil,
  penaltyStats: Seq[org.iptc.sportsml.v3.PenaltyStatsComplexType] = Nil,
  award: Seq[org.iptc.sportsml.v3.AwardComplexType] = Nil,
  rank: Seq[org.iptc.sportsml.v3.RankComplexType] = Nil,
  attributes: Map[String, scalaxb.DataRecord[Any]] = Map()) extends Base3StatsComplexTypable {
  lazy val id = attributes.get("@id") map { _.as[String]}
  lazy val classValue = attributes.get("@class") map { _.as[String]}
  lazy val style = attributes.get("@style") map { _.as[String]}
  lazy val points = attributes.get("@points") map { _.as[BigInt]}
  lazy val statsCoverage = attributes.get("@stats-coverage") map { _.as[String]}
  lazy val teamCoverage = attributes.get("@team-coverage") map { _.as[TeamCoverage]}
  lazy val durationScope = attributes.get("@duration-scope") map { _.as[String]}
  lazy val alignmentScope = attributes.get("@alignment-scope") map { _.as[AlignmentScope]}
  lazy val position = attributes.get("@position") map { _.as[String]}
  lazy val recordMakingScope = attributes.get("@record-making-scope") map { _.as[String]}
  lazy val scopingLabel = attributes.get("@scoping-label") map { _.as[String]}
  lazy val periodValue = attributes.get("@period-value") map { _.as[String]}
  lazy val periodType = attributes.get("@period-type") map { _.as[String]}
  lazy val startDateTime = attributes.get("@start-date-time") map { _.as[String]}
  lazy val endDateTime = attributes.get("@end-date-time") map { _.as[String]}
  lazy val periodStartDateTime = attributes.get("@period-start-date-time") map { _.as[String]}
  lazy val periodEndDateTime = attributes.get("@period-end-date-time") map { _.as[String]}
  lazy val temporalUnitType = attributes.get("@temporal-unit-type") map { _.as[String]}
  lazy val temporalUnitValue = attributes.get("@temporal-unit-value") map { _.as[String]}
  lazy val eventSpan = attributes.get("@event-span") map { _.as[BigInt]}
  lazy val opponentValue = attributes.get("@opponent-value") map { _.as[String]}
  lazy val opponentType = attributes.get("@opponent-type") map { _.as[String]}
  lazy val team = attributes.get("@team") map { _.as[String]}
  lazy val competition = attributes.get("@competition") map { _.as[String]}
  lazy val unitValue = attributes.get("@unit-value") map { _.as[String]}
  lazy val unitType = attributes.get("@unit-type") map { _.as[String]}
  lazy val situation = attributes.get("@situation") map { _.as[String]}
  lazy val locationKey = attributes.get("@location-key") map { _.as[String]}
  lazy val venueType = attributes.get("@venue-type") map { _.as[String]}
  lazy val surfaceType = attributes.get("@surface-type") map { _.as[String]}
  lazy val weatherType = attributes.get("@weather-type") map { _.as[String]}
  lazy val scopeValue = attributes.get("@scope-value") map { _.as[String]}
  lazy val distance = attributes.get("@distance") map { _.as[String]}
  lazy val distanceMaximum = attributes.get("@distance-maximum") map { _.as[String]}
  lazy val distanceMinimum = attributes.get("@distance-minimum") map { _.as[String]}
  lazy val measurementUnits = attributes.get("@measurement-units") map { _.as[String]}
  lazy val score = attributes.get("@score") map { _.as[String]}
  lazy val scoreOpposing = attributes.get("@score-opposing") map { _.as[String]}
  lazy val scoreAverage = attributes.get("@score-average") map { _.as[String]}
  lazy val scoreOpposingAverage = attributes.get("@score-opposing-average") map { _.as[String]}
  lazy val scoreUnits = attributes.get("@score-units") map { _.as[String]}
  lazy val scoreBehind = attributes.get("@score-behind") map { _.as[String]}
  lazy val scoreAttempts = attributes.get("@score-attempts") map { _.as[String]}
  lazy val scoreAttemptsOpposing = attributes.get("@score-attempts-opposing") map { _.as[String]}
  lazy val scoreAttemptsOnGoal = attributes.get("@score-attempts-on-goal") map { _.as[String]}
  lazy val scoreAttemptsOnGoalOpposing = attributes.get("@score-attempts-on-goal-opposing") map { _.as[String]}
  lazy val scorePercentage = attributes.get("@score-percentage") map { _.as[String]}
  lazy val scorePercentageOpposing = attributes.get("@score-percentage-opposing") map { _.as[String]}
  lazy val resultEffect = attributes.get("@result-effect") map { _.as[String]}
  lazy val eventOutcome = attributes.get("@event-outcome") map { _.as[String]}
  lazy val eventStandingPoints = attributes.get("@event-standing-points") map { _.as[String]}
  lazy val eventStandingPointsAgainst = attributes.get("@event-standing-points-against") map { _.as[String]}
  lazy val scoreType = attributes.get("@score-type") map { _.as[String]}
  lazy val eventsRemaining = attributes.get("@events-remaining") map { _.as[String]}
  lazy val timeOfPossession = attributes.get("@time-of-possession") map { _.as[String]}
  lazy val timeOfPossessionPercentage = attributes.get("@time-of-possession-percentage") map { _.as[String]}
  lazy val timeOfPossessionPercentageOpposing = attributes.get("@time-of-possession-percentage-opposing") map { _.as[String]}
  lazy val timeOfPossessionAverage = attributes.get("@time-of-possession-average") map { _.as[String]}
  lazy val timeOfPossessionAverageOpposing = attributes.get("@time-of-possession-average-opposing") map { _.as[String]}
  lazy val seriesScore = attributes.get("@series-score") map { _.as[String]}
  lazy val seriesScoreOpposing = attributes.get("@series-score-opposing") map { _.as[String]}
  lazy val adjustedScoreFor = attributes.get("@adjusted-score-for") map { _.as[String]}
  lazy val adjustedScoreAgainst = attributes.get("@adjusted-score-against") map { _.as[String]}
}

      


/** Statistics that apply to a team as a whole or a player. | Not all stats are used in every sport.
*/
trait BaseGenericEntityStatsComplexTypable extends Base3StatsComplexTypable {
  def rating: Seq[org.iptc.sportsml.v3.RatingComplexType]
  def sportsProperty: Seq[org.iptc.sportsml.v3.SportsPropertyComplexType]
  def stats: Seq[org.iptc.sportsml.v3.GenericStatComplexType]
  def outcomeTotals: Seq[org.iptc.sportsml.v3.OutcomeTotalsComplexType]
  def outcomeResult: Seq[org.iptc.sportsml.v3.OutcomeResultComplexType]
  def penaltyStats: Seq[org.iptc.sportsml.v3.PenaltyStatsComplexType]
  def award: Seq[org.iptc.sportsml.v3.AwardComplexType]
  def rank: Seq[org.iptc.sportsml.v3.RankComplexType]
  def subScore: Seq[org.iptc.sportsml.v3.SubScoreComplexType]
  def eventRecord: Seq[org.iptc.sportsml.v3.EventRecordComplexType]
  def id: Option[String]
  def classValue: Option[String]
  def style: Option[String]
  def points: Option[BigInt]
  def statsCoverage: Option[String]
  def teamCoverage: Option[org.iptc.sportsml.v3.TeamCoverage]
  def durationScope: Option[String]
  def alignmentScope: Option[org.iptc.sportsml.v3.AlignmentScope]
  def position: Option[String]
  def recordMakingScope: Option[String]
  def scopingLabel: Option[String]
  def periodValue: Option[String]
  def periodType: Option[String]
  def startDateTime: Option[String]
  def endDateTime: Option[String]
  def periodStartDateTime: Option[String]
  def periodEndDateTime: Option[String]
  def temporalUnitType: Option[String]
  def temporalUnitValue: Option[String]
  def eventSpan: Option[BigInt]
  def opponentValue: Option[String]
  def opponentType: Option[String]
  def team: Option[String]
  def competition: Option[String]
  def unitValue: Option[String]
  def unitType: Option[String]
  def situation: Option[String]
  def locationKey: Option[String]
  def venueType: Option[String]
  def surfaceType: Option[String]
  def weatherType: Option[String]
  def scopeValue: Option[String]
  def distance: Option[String]
  def distanceMaximum: Option[String]
  def distanceMinimum: Option[String]
  def measurementUnits: Option[String]
  def score: Option[String]
  def scoreOpposing: Option[String]
  def scoreAverage: Option[String]
  def scoreOpposingAverage: Option[String]
  def scoreUnits: Option[String]
  def scoreBehind: Option[String]
  def scoreAttempts: Option[String]
  def scoreAttemptsOpposing: Option[String]
  def scoreAttemptsOnGoal: Option[String]
  def scoreAttemptsOnGoalOpposing: Option[String]
  def scorePercentage: Option[String]
  def scorePercentageOpposing: Option[String]
  def resultEffect: Option[String]
  def eventOutcome: Option[String]
  def eventStandingPoints: Option[String]
  def eventStandingPointsAgainst: Option[String]
  def scoreType: Option[String]
  def eventsRemaining: Option[String]
  def timeOfPossession: Option[String]
  def timeOfPossessionPercentage: Option[String]
  def timeOfPossessionPercentageOpposing: Option[String]
  def timeOfPossessionAverage: Option[String]
  def timeOfPossessionAverageOpposing: Option[String]
  def seriesScore: Option[String]
  def seriesScoreOpposing: Option[String]
  def adjustedScoreFor: Option[String]
  def adjustedScoreAgainst: Option[String]
  def eventsPlayed: Option[BigInt]
  def timePlayedTotal: Option[String]
}


/** Statistics that apply to a team as a whole or a player. | Not all stats are used in every sport.
*/
case class BaseGenericEntityStatsComplexType(rating: Seq[org.iptc.sportsml.v3.RatingComplexType] = Nil,
  sportsProperty: Seq[org.iptc.sportsml.v3.SportsPropertyComplexType] = Nil,
  stats: Seq[org.iptc.sportsml.v3.GenericStatComplexType] = Nil,
  outcomeTotals: Seq[org.iptc.sportsml.v3.OutcomeTotalsComplexType] = Nil,
  outcomeResult: Seq[org.iptc.sportsml.v3.OutcomeResultComplexType] = Nil,
  penaltyStats: Seq[org.iptc.sportsml.v3.PenaltyStatsComplexType] = Nil,
  award: Seq[org.iptc.sportsml.v3.AwardComplexType] = Nil,
  rank: Seq[org.iptc.sportsml.v3.RankComplexType] = Nil,
  subScore: Seq[org.iptc.sportsml.v3.SubScoreComplexType] = Nil,
  eventRecord: Seq[org.iptc.sportsml.v3.EventRecordComplexType] = Nil,
  attributes: Map[String, scalaxb.DataRecord[Any]] = Map()) extends BaseGenericEntityStatsComplexTypable {
  lazy val id = attributes.get("@id") map { _.as[String]}
  lazy val classValue = attributes.get("@class") map { _.as[String]}
  lazy val style = attributes.get("@style") map { _.as[String]}
  lazy val points = attributes.get("@points") map { _.as[BigInt]}
  lazy val statsCoverage = attributes.get("@stats-coverage") map { _.as[String]}
  lazy val teamCoverage = attributes.get("@team-coverage") map { _.as[TeamCoverage]}
  lazy val durationScope = attributes.get("@duration-scope") map { _.as[String]}
  lazy val alignmentScope = attributes.get("@alignment-scope") map { _.as[AlignmentScope]}
  lazy val position = attributes.get("@position") map { _.as[String]}
  lazy val recordMakingScope = attributes.get("@record-making-scope") map { _.as[String]}
  lazy val scopingLabel = attributes.get("@scoping-label") map { _.as[String]}
  lazy val periodValue = attributes.get("@period-value") map { _.as[String]}
  lazy val periodType = attributes.get("@period-type") map { _.as[String]}
  lazy val startDateTime = attributes.get("@start-date-time") map { _.as[String]}
  lazy val endDateTime = attributes.get("@end-date-time") map { _.as[String]}
  lazy val periodStartDateTime = attributes.get("@period-start-date-time") map { _.as[String]}
  lazy val periodEndDateTime = attributes.get("@period-end-date-time") map { _.as[String]}
  lazy val temporalUnitType = attributes.get("@temporal-unit-type") map { _.as[String]}
  lazy val temporalUnitValue = attributes.get("@temporal-unit-value") map { _.as[String]}
  lazy val eventSpan = attributes.get("@event-span") map { _.as[BigInt]}
  lazy val opponentValue = attributes.get("@opponent-value") map { _.as[String]}
  lazy val opponentType = attributes.get("@opponent-type") map { _.as[String]}
  lazy val team = attributes.get("@team") map { _.as[String]}
  lazy val competition = attributes.get("@competition") map { _.as[String]}
  lazy val unitValue = attributes.get("@unit-value") map { _.as[String]}
  lazy val unitType = attributes.get("@unit-type") map { _.as[String]}
  lazy val situation = attributes.get("@situation") map { _.as[String]}
  lazy val locationKey = attributes.get("@location-key") map { _.as[String]}
  lazy val venueType = attributes.get("@venue-type") map { _.as[String]}
  lazy val surfaceType = attributes.get("@surface-type") map { _.as[String]}
  lazy val weatherType = attributes.get("@weather-type") map { _.as[String]}
  lazy val scopeValue = attributes.get("@scope-value") map { _.as[String]}
  lazy val distance = attributes.get("@distance") map { _.as[String]}
  lazy val distanceMaximum = attributes.get("@distance-maximum") map { _.as[String]}
  lazy val distanceMinimum = attributes.get("@distance-minimum") map { _.as[String]}
  lazy val measurementUnits = attributes.get("@measurement-units") map { _.as[String]}
  lazy val score = attributes.get("@score") map { _.as[String]}
  lazy val scoreOpposing = attributes.get("@score-opposing") map { _.as[String]}
  lazy val scoreAverage = attributes.get("@score-average") map { _.as[String]}
  lazy val scoreOpposingAverage = attributes.get("@score-opposing-average") map { _.as[String]}
  lazy val scoreUnits = attributes.get("@score-units") map { _.as[String]}
  lazy val scoreBehind = attributes.get("@score-behind") map { _.as[String]}
  lazy val scoreAttempts = attributes.get("@score-attempts") map { _.as[String]}
  lazy val scoreAttemptsOpposing = attributes.get("@score-attempts-opposing") map { _.as[String]}
  lazy val scoreAttemptsOnGoal = attributes.get("@score-attempts-on-goal") map { _.as[String]}
  lazy val scoreAttemptsOnGoalOpposing = attributes.get("@score-attempts-on-goal-opposing") map { _.as[String]}
  lazy val scorePercentage = attributes.get("@score-percentage") map { _.as[String]}
  lazy val scorePercentageOpposing = attributes.get("@score-percentage-opposing") map { _.as[String]}
  lazy val resultEffect = attributes.get("@result-effect") map { _.as[String]}
  lazy val eventOutcome = attributes.get("@event-outcome") map { _.as[String]}
  lazy val eventStandingPoints = attributes.get("@event-standing-points") map { _.as[String]}
  lazy val eventStandingPointsAgainst = attributes.get("@event-standing-points-against") map { _.as[String]}
  lazy val scoreType = attributes.get("@score-type") map { _.as[String]}
  lazy val eventsRemaining = attributes.get("@events-remaining") map { _.as[String]}
  lazy val timeOfPossession = attributes.get("@time-of-possession") map { _.as[String]}
  lazy val timeOfPossessionPercentage = attributes.get("@time-of-possession-percentage") map { _.as[String]}
  lazy val timeOfPossessionPercentageOpposing = attributes.get("@time-of-possession-percentage-opposing") map { _.as[String]}
  lazy val timeOfPossessionAverage = attributes.get("@time-of-possession-average") map { _.as[String]}
  lazy val timeOfPossessionAverageOpposing = attributes.get("@time-of-possession-average-opposing") map { _.as[String]}
  lazy val seriesScore = attributes.get("@series-score") map { _.as[String]}
  lazy val seriesScoreOpposing = attributes.get("@series-score-opposing") map { _.as[String]}
  lazy val adjustedScoreFor = attributes.get("@adjusted-score-for") map { _.as[String]}
  lazy val adjustedScoreAgainst = attributes.get("@adjusted-score-against") map { _.as[String]}
  lazy val eventsPlayed = attributes.get("@events-played") map { _.as[BigInt]}
  lazy val timePlayedTotal = attributes.get("@time-played-total") map { _.as[String]}
}

      


/** Statistics that apply to the team as a whole. | Not all stats are used in every sport.
*/
trait BaseTeamStatsComplexTypable extends BaseGenericEntityStatsComplexTypable {
  def rating: Seq[org.iptc.sportsml.v3.RatingComplexType]
  def sportsProperty: Seq[org.iptc.sportsml.v3.SportsPropertyComplexType]
  def stats: Seq[org.iptc.sportsml.v3.GenericStatComplexType]
  def outcomeTotals: Seq[org.iptc.sportsml.v3.OutcomeTotalsComplexType]
  def outcomeResult: Seq[org.iptc.sportsml.v3.OutcomeResultComplexType]
  def penaltyStats: Seq[org.iptc.sportsml.v3.PenaltyStatsComplexType]
  def award: Seq[org.iptc.sportsml.v3.AwardComplexType]
  def rank: Seq[org.iptc.sportsml.v3.RankComplexType]
  def subScore: Seq[org.iptc.sportsml.v3.SubScoreComplexType]
  def eventRecord: Seq[org.iptc.sportsml.v3.EventRecordComplexType]
  def id: Option[String]
  def classValue: Option[String]
  def style: Option[String]
  def points: Option[BigInt]
  def statsCoverage: Option[String]
  def teamCoverage: Option[org.iptc.sportsml.v3.TeamCoverage]
  def durationScope: Option[String]
  def alignmentScope: Option[org.iptc.sportsml.v3.AlignmentScope]
  def position: Option[String]
  def recordMakingScope: Option[String]
  def scopingLabel: Option[String]
  def periodValue: Option[String]
  def periodType: Option[String]
  def startDateTime: Option[String]
  def endDateTime: Option[String]
  def periodStartDateTime: Option[String]
  def periodEndDateTime: Option[String]
  def temporalUnitType: Option[String]
  def temporalUnitValue: Option[String]
  def eventSpan: Option[BigInt]
  def opponentValue: Option[String]
  def opponentType: Option[String]
  def team: Option[String]
  def competition: Option[String]
  def unitValue: Option[String]
  def unitType: Option[String]
  def situation: Option[String]
  def locationKey: Option[String]
  def venueType: Option[String]
  def surfaceType: Option[String]
  def weatherType: Option[String]
  def scopeValue: Option[String]
  def distance: Option[String]
  def distanceMaximum: Option[String]
  def distanceMinimum: Option[String]
  def measurementUnits: Option[String]
  def score: Option[String]
  def scoreOpposing: Option[String]
  def scoreAverage: Option[String]
  def scoreOpposingAverage: Option[String]
  def scoreUnits: Option[String]
  def scoreBehind: Option[String]
  def scoreAttempts: Option[String]
  def scoreAttemptsOpposing: Option[String]
  def scoreAttemptsOnGoal: Option[String]
  def scoreAttemptsOnGoalOpposing: Option[String]
  def scorePercentage: Option[String]
  def scorePercentageOpposing: Option[String]
  def resultEffect: Option[String]
  def eventOutcome: Option[String]
  def eventStandingPoints: Option[String]
  def eventStandingPointsAgainst: Option[String]
  def scoreType: Option[String]
  def eventsRemaining: Option[String]
  def timeOfPossession: Option[String]
  def timeOfPossessionPercentage: Option[String]
  def timeOfPossessionPercentageOpposing: Option[String]
  def timeOfPossessionAverage: Option[String]
  def timeOfPossessionAverageOpposing: Option[String]
  def seriesScore: Option[String]
  def seriesScoreOpposing: Option[String]
  def adjustedScoreFor: Option[String]
  def adjustedScoreAgainst: Option[String]
  def eventsPlayed: Option[BigInt]
  def timePlayedTotal: Option[String]
}


/** Statistics that apply to the team as a whole. | Not all stats are used in every sport.
*/
case class BaseTeamStatsComplexType(rating: Seq[org.iptc.sportsml.v3.RatingComplexType] = Nil,
  sportsProperty: Seq[org.iptc.sportsml.v3.SportsPropertyComplexType] = Nil,
  stats: Seq[org.iptc.sportsml.v3.GenericStatComplexType] = Nil,
  outcomeTotals: Seq[org.iptc.sportsml.v3.OutcomeTotalsComplexType] = Nil,
  outcomeResult: Seq[org.iptc.sportsml.v3.OutcomeResultComplexType] = Nil,
  penaltyStats: Seq[org.iptc.sportsml.v3.PenaltyStatsComplexType] = Nil,
  award: Seq[org.iptc.sportsml.v3.AwardComplexType] = Nil,
  rank: Seq[org.iptc.sportsml.v3.RankComplexType] = Nil,
  subScore: Seq[org.iptc.sportsml.v3.SubScoreComplexType] = Nil,
  eventRecord: Seq[org.iptc.sportsml.v3.EventRecordComplexType] = Nil,
  attributes: Map[String, scalaxb.DataRecord[Any]] = Map()) extends BaseTeamStatsComplexTypable {
  lazy val id = attributes.get("@id") map { _.as[String]}
  lazy val classValue = attributes.get("@class") map { _.as[String]}
  lazy val style = attributes.get("@style") map { _.as[String]}
  lazy val points = attributes.get("@points") map { _.as[BigInt]}
  lazy val statsCoverage = attributes.get("@stats-coverage") map { _.as[String]}
  lazy val teamCoverage = attributes.get("@team-coverage") map { _.as[TeamCoverage]}
  lazy val durationScope = attributes.get("@duration-scope") map { _.as[String]}
  lazy val alignmentScope = attributes.get("@alignment-scope") map { _.as[AlignmentScope]}
  lazy val position = attributes.get("@position") map { _.as[String]}
  lazy val recordMakingScope = attributes.get("@record-making-scope") map { _.as[String]}
  lazy val scopingLabel = attributes.get("@scoping-label") map { _.as[String]}
  lazy val periodValue = attributes.get("@period-value") map { _.as[String]}
  lazy val periodType = attributes.get("@period-type") map { _.as[String]}
  lazy val startDateTime = attributes.get("@start-date-time") map { _.as[String]}
  lazy val endDateTime = attributes.get("@end-date-time") map { _.as[String]}
  lazy val periodStartDateTime = attributes.get("@period-start-date-time") map { _.as[String]}
  lazy val periodEndDateTime = attributes.get("@period-end-date-time") map { _.as[String]}
  lazy val temporalUnitType = attributes.get("@temporal-unit-type") map { _.as[String]}
  lazy val temporalUnitValue = attributes.get("@temporal-unit-value") map { _.as[String]}
  lazy val eventSpan = attributes.get("@event-span") map { _.as[BigInt]}
  lazy val opponentValue = attributes.get("@opponent-value") map { _.as[String]}
  lazy val opponentType = attributes.get("@opponent-type") map { _.as[String]}
  lazy val team = attributes.get("@team") map { _.as[String]}
  lazy val competition = attributes.get("@competition") map { _.as[String]}
  lazy val unitValue = attributes.get("@unit-value") map { _.as[String]}
  lazy val unitType = attributes.get("@unit-type") map { _.as[String]}
  lazy val situation = attributes.get("@situation") map { _.as[String]}
  lazy val locationKey = attributes.get("@location-key") map { _.as[String]}
  lazy val venueType = attributes.get("@venue-type") map { _.as[String]}
  lazy val surfaceType = attributes.get("@surface-type") map { _.as[String]}
  lazy val weatherType = attributes.get("@weather-type") map { _.as[String]}
  lazy val scopeValue = attributes.get("@scope-value") map { _.as[String]}
  lazy val distance = attributes.get("@distance") map { _.as[String]}
  lazy val distanceMaximum = attributes.get("@distance-maximum") map { _.as[String]}
  lazy val distanceMinimum = attributes.get("@distance-minimum") map { _.as[String]}
  lazy val measurementUnits = attributes.get("@measurement-units") map { _.as[String]}
  lazy val score = attributes.get("@score") map { _.as[String]}
  lazy val scoreOpposing = attributes.get("@score-opposing") map { _.as[String]}
  lazy val scoreAverage = attributes.get("@score-average") map { _.as[String]}
  lazy val scoreOpposingAverage = attributes.get("@score-opposing-average") map { _.as[String]}
  lazy val scoreUnits = attributes.get("@score-units") map { _.as[String]}
  lazy val scoreBehind = attributes.get("@score-behind") map { _.as[String]}
  lazy val scoreAttempts = attributes.get("@score-attempts") map { _.as[String]}
  lazy val scoreAttemptsOpposing = attributes.get("@score-attempts-opposing") map { _.as[String]}
  lazy val scoreAttemptsOnGoal = attributes.get("@score-attempts-on-goal") map { _.as[String]}
  lazy val scoreAttemptsOnGoalOpposing = attributes.get("@score-attempts-on-goal-opposing") map { _.as[String]}
  lazy val scorePercentage = attributes.get("@score-percentage") map { _.as[String]}
  lazy val scorePercentageOpposing = attributes.get("@score-percentage-opposing") map { _.as[String]}
  lazy val resultEffect = attributes.get("@result-effect") map { _.as[String]}
  lazy val eventOutcome = attributes.get("@event-outcome") map { _.as[String]}
  lazy val eventStandingPoints = attributes.get("@event-standing-points") map { _.as[String]}
  lazy val eventStandingPointsAgainst = attributes.get("@event-standing-points-against") map { _.as[String]}
  lazy val scoreType = attributes.get("@score-type") map { _.as[String]}
  lazy val eventsRemaining = attributes.get("@events-remaining") map { _.as[String]}
  lazy val timeOfPossession = attributes.get("@time-of-possession") map { _.as[String]}
  lazy val timeOfPossessionPercentage = attributes.get("@time-of-possession-percentage") map { _.as[String]}
  lazy val timeOfPossessionPercentageOpposing = attributes.get("@time-of-possession-percentage-opposing") map { _.as[String]}
  lazy val timeOfPossessionAverage = attributes.get("@time-of-possession-average") map { _.as[String]}
  lazy val timeOfPossessionAverageOpposing = attributes.get("@time-of-possession-average-opposing") map { _.as[String]}
  lazy val seriesScore = attributes.get("@series-score") map { _.as[String]}
  lazy val seriesScoreOpposing = attributes.get("@series-score-opposing") map { _.as[String]}
  lazy val adjustedScoreFor = attributes.get("@adjusted-score-for") map { _.as[String]}
  lazy val adjustedScoreAgainst = attributes.get("@adjusted-score-against") map { _.as[String]}
  lazy val eventsPlayed = attributes.get("@events-played") map { _.as[BigInt]}
  lazy val timePlayedTotal = attributes.get("@time-played-total") map { _.as[String]}
}

      

trait AlignmentType

object AlignmentType {
  def fromString(value: String, scope: scala.xml.NamespaceBinding)(implicit fmt: scalaxb.XMLFormat[org.iptc.sportsml.v3.AlignmentType]): AlignmentType = fmt.reads(scala.xml.Text(value), Nil) match {
    case Right(x: AlignmentType) => x
    case x => throw new RuntimeException(s"fromString returned unexpected value $x for input $value")
  }
}

case object HomeValue2 extends AlignmentType { override def toString = "home" }
case object AwayValue extends AlignmentType { override def toString = "away" }
case object NoneType extends AlignmentType { override def toString = "none" }


/** Info about the team. Properties of a team that are not based on their competitive performance. | An included sports-content-code element can hold what division it is in, etc.
*/
trait BaseTeamMetadataComplexTypable extends BaseEntityMetadataComplexTypable {
  def name: Seq[org.iptc.sportsml.v3.ConceptNameType]
  def homeLocation: Option[org.iptc.sportsml.v3.FlexLocationPropTypable]
  def sportsProperty: Seq[org.iptc.sportsml.v3.SportsPropertyComplexType]
  def site: Seq[org.iptc.sportsml.v3.SiteComplexType]
  def sportsContentCodes: Seq[org.iptc.sportsml.v3.SportsContentCodesComplexType]
  def id: Option[String]
  def classValue: Option[String]
  def style: Option[String]
  def key: Option[String]
  def nationality: Option[String]
  def alignment: Option[org.iptc.sportsml.v3.AlignmentType]
  def established: Option[String]
  def dissolved: Option[String]
  def teamIdref: Option[String]
  def homePageUrl: Option[java.net.URI]
  def roundPosition: Option[String]
}


/** Info about the team. Properties of a team that are not based on their competitive performance. | An included sports-content-code element can hold what division it is in, etc.
*/
case class BaseTeamMetadataComplexType(name: Seq[org.iptc.sportsml.v3.ConceptNameType] = Nil,
  homeLocation: Option[org.iptc.sportsml.v3.FlexLocationPropTypable] = None,
  sportsProperty: Seq[org.iptc.sportsml.v3.SportsPropertyComplexType] = Nil,
  site: Seq[org.iptc.sportsml.v3.SiteComplexType] = Nil,
  sportsContentCodes: Seq[org.iptc.sportsml.v3.SportsContentCodesComplexType] = Nil,
  attributes: Map[String, scalaxb.DataRecord[Any]] = Map()) extends BaseTeamMetadataComplexTypable {
  lazy val id = attributes.get("@id") map { _.as[String]}
  lazy val classValue = attributes.get("@class") map { _.as[String]}
  lazy val style = attributes.get("@style") map { _.as[String]}
  lazy val key = attributes.get("@key") map { _.as[String]}
  lazy val nationality = attributes.get("@nationality") map { _.as[String]}
  lazy val alignment = attributes.get("@alignment") map { _.as[AlignmentType]}
  lazy val established = attributes.get("@established") map { _.as[String]}
  lazy val dissolved = attributes.get("@dissolved") map { _.as[String]}
  lazy val teamIdref = attributes.get("@team-idref") map { _.as[String]}
  lazy val homePageUrl = attributes.get("@home-page-url") map { _.as[java.net.URI]}
  lazy val roundPosition = attributes.get("@round-position") map { _.as[String]}
}

      


/** Statistics that capture how a player has performed. | Generally does change over the course of a sports-event.
*/
trait BasePlayerStatsComplexTypable extends BaseGenericEntityStatsComplexTypable {
  def rating: Seq[org.iptc.sportsml.v3.RatingComplexType]
  def sportsProperty: Seq[org.iptc.sportsml.v3.SportsPropertyComplexType]
  def stats: Seq[org.iptc.sportsml.v3.GenericStatComplexType]
  def outcomeTotals: Seq[org.iptc.sportsml.v3.OutcomeTotalsComplexType]
  def outcomeResult: Seq[org.iptc.sportsml.v3.OutcomeResultComplexType]
  def penaltyStats: Seq[org.iptc.sportsml.v3.PenaltyStatsComplexType]
  def award: Seq[org.iptc.sportsml.v3.AwardComplexType]
  def rank: Seq[org.iptc.sportsml.v3.RankComplexType]
  def subScore: Seq[org.iptc.sportsml.v3.SubScoreComplexType]
  def eventRecord: Seq[org.iptc.sportsml.v3.EventRecordComplexType]
  def id: Option[String]
  def classValue: Option[String]
  def style: Option[String]
  def points: Option[BigInt]
  def statsCoverage: Option[String]
  def teamCoverage: Option[org.iptc.sportsml.v3.TeamCoverage]
  def durationScope: Option[String]
  def alignmentScope: Option[org.iptc.sportsml.v3.AlignmentScope]
  def position: Option[String]
  def recordMakingScope: Option[String]
  def scopingLabel: Option[String]
  def periodValue: Option[String]
  def periodType: Option[String]
  def startDateTime: Option[String]
  def endDateTime: Option[String]
  def periodStartDateTime: Option[String]
  def periodEndDateTime: Option[String]
  def temporalUnitType: Option[String]
  def temporalUnitValue: Option[String]
  def eventSpan: Option[BigInt]
  def opponentValue: Option[String]
  def opponentType: Option[String]
  def team: Option[String]
  def competition: Option[String]
  def unitValue: Option[String]
  def unitType: Option[String]
  def situation: Option[String]
  def locationKey: Option[String]
  def venueType: Option[String]
  def surfaceType: Option[String]
  def weatherType: Option[String]
  def scopeValue: Option[String]
  def distance: Option[String]
  def distanceMaximum: Option[String]
  def distanceMinimum: Option[String]
  def measurementUnits: Option[String]
  def score: Option[String]
  def scoreOpposing: Option[String]
  def scoreAverage: Option[String]
  def scoreOpposingAverage: Option[String]
  def scoreUnits: Option[String]
  def scoreBehind: Option[String]
  def scoreAttempts: Option[String]
  def scoreAttemptsOpposing: Option[String]
  def scoreAttemptsOnGoal: Option[String]
  def scoreAttemptsOnGoalOpposing: Option[String]
  def scorePercentage: Option[String]
  def scorePercentageOpposing: Option[String]
  def resultEffect: Option[String]
  def eventOutcome: Option[String]
  def eventStandingPoints: Option[String]
  def eventStandingPointsAgainst: Option[String]
  def scoreType: Option[String]
  def eventsRemaining: Option[String]
  def timeOfPossession: Option[String]
  def timeOfPossessionPercentage: Option[String]
  def timeOfPossessionPercentageOpposing: Option[String]
  def timeOfPossessionAverage: Option[String]
  def timeOfPossessionAverageOpposing: Option[String]
  def seriesScore: Option[String]
  def seriesScoreOpposing: Option[String]
  def adjustedScoreFor: Option[String]
  def adjustedScoreAgainst: Option[String]
  def eventsPlayed: Option[BigInt]
  def timePlayedTotal: Option[String]
  def timePlayedEvent: Option[String]
  def timePlayedEventAverage: Option[String]
  def eventsStarted: Option[BigInt]
  def dateTimeEntered: Option[javax.xml.datatype.XMLGregorianCalendar]
  def dateTimeExited: Option[javax.xml.datatype.XMLGregorianCalendar]
  def eventTimeEntered: Option[String]
  def eventTimeExited: Option[String]
}


/** Statistics that capture how a player has performed. | Generally does change over the course of a sports-event.
*/
case class BasePlayerStatsComplexType(rating: Seq[org.iptc.sportsml.v3.RatingComplexType] = Nil,
  sportsProperty: Seq[org.iptc.sportsml.v3.SportsPropertyComplexType] = Nil,
  stats: Seq[org.iptc.sportsml.v3.GenericStatComplexType] = Nil,
  outcomeTotals: Seq[org.iptc.sportsml.v3.OutcomeTotalsComplexType] = Nil,
  outcomeResult: Seq[org.iptc.sportsml.v3.OutcomeResultComplexType] = Nil,
  penaltyStats: Seq[org.iptc.sportsml.v3.PenaltyStatsComplexType] = Nil,
  award: Seq[org.iptc.sportsml.v3.AwardComplexType] = Nil,
  rank: Seq[org.iptc.sportsml.v3.RankComplexType] = Nil,
  subScore: Seq[org.iptc.sportsml.v3.SubScoreComplexType] = Nil,
  eventRecord: Seq[org.iptc.sportsml.v3.EventRecordComplexType] = Nil,
  attributes: Map[String, scalaxb.DataRecord[Any]] = Map()) extends BasePlayerStatsComplexTypable {
  lazy val id = attributes.get("@id") map { _.as[String]}
  lazy val classValue = attributes.get("@class") map { _.as[String]}
  lazy val style = attributes.get("@style") map { _.as[String]}
  lazy val points = attributes.get("@points") map { _.as[BigInt]}
  lazy val statsCoverage = attributes.get("@stats-coverage") map { _.as[String]}
  lazy val teamCoverage = attributes.get("@team-coverage") map { _.as[TeamCoverage]}
  lazy val durationScope = attributes.get("@duration-scope") map { _.as[String]}
  lazy val alignmentScope = attributes.get("@alignment-scope") map { _.as[AlignmentScope]}
  lazy val position = attributes.get("@position") map { _.as[String]}
  lazy val recordMakingScope = attributes.get("@record-making-scope") map { _.as[String]}
  lazy val scopingLabel = attributes.get("@scoping-label") map { _.as[String]}
  lazy val periodValue = attributes.get("@period-value") map { _.as[String]}
  lazy val periodType = attributes.get("@period-type") map { _.as[String]}
  lazy val startDateTime = attributes.get("@start-date-time") map { _.as[String]}
  lazy val endDateTime = attributes.get("@end-date-time") map { _.as[String]}
  lazy val periodStartDateTime = attributes.get("@period-start-date-time") map { _.as[String]}
  lazy val periodEndDateTime = attributes.get("@period-end-date-time") map { _.as[String]}
  lazy val temporalUnitType = attributes.get("@temporal-unit-type") map { _.as[String]}
  lazy val temporalUnitValue = attributes.get("@temporal-unit-value") map { _.as[String]}
  lazy val eventSpan = attributes.get("@event-span") map { _.as[BigInt]}
  lazy val opponentValue = attributes.get("@opponent-value") map { _.as[String]}
  lazy val opponentType = attributes.get("@opponent-type") map { _.as[String]}
  lazy val team = attributes.get("@team") map { _.as[String]}
  lazy val competition = attributes.get("@competition") map { _.as[String]}
  lazy val unitValue = attributes.get("@unit-value") map { _.as[String]}
  lazy val unitType = attributes.get("@unit-type") map { _.as[String]}
  lazy val situation = attributes.get("@situation") map { _.as[String]}
  lazy val locationKey = attributes.get("@location-key") map { _.as[String]}
  lazy val venueType = attributes.get("@venue-type") map { _.as[String]}
  lazy val surfaceType = attributes.get("@surface-type") map { _.as[String]}
  lazy val weatherType = attributes.get("@weather-type") map { _.as[String]}
  lazy val scopeValue = attributes.get("@scope-value") map { _.as[String]}
  lazy val distance = attributes.get("@distance") map { _.as[String]}
  lazy val distanceMaximum = attributes.get("@distance-maximum") map { _.as[String]}
  lazy val distanceMinimum = attributes.get("@distance-minimum") map { _.as[String]}
  lazy val measurementUnits = attributes.get("@measurement-units") map { _.as[String]}
  lazy val score = attributes.get("@score") map { _.as[String]}
  lazy val scoreOpposing = attributes.get("@score-opposing") map { _.as[String]}
  lazy val scoreAverage = attributes.get("@score-average") map { _.as[String]}
  lazy val scoreOpposingAverage = attributes.get("@score-opposing-average") map { _.as[String]}
  lazy val scoreUnits = attributes.get("@score-units") map { _.as[String]}
  lazy val scoreBehind = attributes.get("@score-behind") map { _.as[String]}
  lazy val scoreAttempts = attributes.get("@score-attempts") map { _.as[String]}
  lazy val scoreAttemptsOpposing = attributes.get("@score-attempts-opposing") map { _.as[String]}
  lazy val scoreAttemptsOnGoal = attributes.get("@score-attempts-on-goal") map { _.as[String]}
  lazy val scoreAttemptsOnGoalOpposing = attributes.get("@score-attempts-on-goal-opposing") map { _.as[String]}
  lazy val scorePercentage = attributes.get("@score-percentage") map { _.as[String]}
  lazy val scorePercentageOpposing = attributes.get("@score-percentage-opposing") map { _.as[String]}
  lazy val resultEffect = attributes.get("@result-effect") map { _.as[String]}
  lazy val eventOutcome = attributes.get("@event-outcome") map { _.as[String]}
  lazy val eventStandingPoints = attributes.get("@event-standing-points") map { _.as[String]}
  lazy val eventStandingPointsAgainst = attributes.get("@event-standing-points-against") map { _.as[String]}
  lazy val scoreType = attributes.get("@score-type") map { _.as[String]}
  lazy val eventsRemaining = attributes.get("@events-remaining") map { _.as[String]}
  lazy val timeOfPossession = attributes.get("@time-of-possession") map { _.as[String]}
  lazy val timeOfPossessionPercentage = attributes.get("@time-of-possession-percentage") map { _.as[String]}
  lazy val timeOfPossessionPercentageOpposing = attributes.get("@time-of-possession-percentage-opposing") map { _.as[String]}
  lazy val timeOfPossessionAverage = attributes.get("@time-of-possession-average") map { _.as[String]}
  lazy val timeOfPossessionAverageOpposing = attributes.get("@time-of-possession-average-opposing") map { _.as[String]}
  lazy val seriesScore = attributes.get("@series-score") map { _.as[String]}
  lazy val seriesScoreOpposing = attributes.get("@series-score-opposing") map { _.as[String]}
  lazy val adjustedScoreFor = attributes.get("@adjusted-score-for") map { _.as[String]}
  lazy val adjustedScoreAgainst = attributes.get("@adjusted-score-against") map { _.as[String]}
  lazy val eventsPlayed = attributes.get("@events-played") map { _.as[BigInt]}
  lazy val timePlayedTotal = attributes.get("@time-played-total") map { _.as[String]}
  lazy val timePlayedEvent = attributes.get("@time-played-event") map { _.as[String]}
  lazy val timePlayedEventAverage = attributes.get("@time-played-event-average") map { _.as[String]}
  lazy val eventsStarted = attributes.get("@events-started") map { _.as[BigInt]}
  lazy val dateTimeEntered = attributes.get("@date-time-entered") map { _.as[javax.xml.datatype.XMLGregorianCalendar]}
  lazy val dateTimeExited = attributes.get("@date-time-exited") map { _.as[javax.xml.datatype.XMLGregorianCalendar]}
  lazy val eventTimeEntered = attributes.get("@event-time-entered") map { _.as[String]}
  lazy val eventTimeExited = attributes.get("@event-time-exited") map { _.as[String]}
}

      


case class BaseActionComplexType(action: Seq[org.iptc.sportsml.v3.BaseActionComplexType] = Nil,
  participant: Seq[org.iptc.sportsml.v3.BaseParticipantComplexType] = Nil,
  attributes: Map[String, scalaxb.DataRecord[Any]] = Map()) {
  lazy val id = attributes.get("@id") map { _.as[String]}
  lazy val classValue = attributes.get("@class") map { _.as[String]}
  lazy val style = attributes.get("@style") map { _.as[String]}
  lazy val minutesElapsed = attributes.get("@minutes-elapsed") map { _.as[String]}
  lazy val periodMinuteElapsed = attributes.get("@period-minute-elapsed") map { _.as[String]}
  lazy val periodTimeElapsed = attributes.get("@period-time-elapsed") map { _.as[String]}
  lazy val periodTimeRemaining = attributes.get("@period-time-remaining") map { _.as[String]}
  lazy val teamIdref = attributes.get("@team-idref") map { _.as[String]}
  lazy val opposingTeamIdref = attributes.get("@opposing-team-idref") map { _.as[String]}
  lazy val created = attributes.get("@created") map { _.as[javax.xml.datatype.XMLGregorianCalendar]}
  lazy val lastModified = attributes.get("@last-modified") map { _.as[javax.xml.datatype.XMLGregorianCalendar]}
  lazy val dateTime = attributes.get("@date-time") map { _.as[javax.xml.datatype.XMLGregorianCalendar]}
  lazy val result = attributes.get("@result") map { _.as[String]}
  lazy val sequenceNumber = attributes.get("@sequence-number") map { _.as[BigInt]}
  lazy val comment = attributes.get("@comment") map { _.as[String]}
  lazy val typeValue = attributes.get("@type") map { _.as[String]}
  lazy val timeElapsed = attributes.get("@time-elapsed") map { _.as[String]}
  lazy val timeRemaining = attributes.get("@time-remaining") map { _.as[String]}
  lazy val playerCount = attributes.get("@player-count") map { _.as[BigInt]}
  lazy val playerCountOpposing = attributes.get("@player-count-opposing") map { _.as[BigInt]}
  lazy val startLocation = attributes.get("@start-location") map { _.as[String]}
  lazy val endLocation = attributes.get("@end-location") map { _.as[String]}
  lazy val zone = attributes.get("@zone") map { _.as[String]}
  lazy val powerPlayTimeRemaining = attributes.get("@power-play-time-remaining") map { _.as[String]}
  lazy val powerPlayAdvantage = attributes.get("@power-play-advantage") map { _.as[BigInt]}
  lazy val callerType = attributes.get("@caller-type") map { _.as[String]}
  lazy val strength = attributes.get("@strength") map { _.as[String]}
  lazy val points = attributes.get("@points") map { _.as[BigInt]}
  lazy val turnoverType = attributes.get("@turnover-type") map { _.as[String]}
  lazy val periodValue = attributes.get("@period-value") map { _.as[String]}
  lazy val periodLength = attributes.get("@period-length") map { _.as[String]}
  lazy val scoreTeam = attributes.get("@score-team") map { _.as[String]}
  lazy val scoreTeamOpposing = attributes.get("@score-team-opposing") map { _.as[String]}
  lazy val timeoutsLeft = attributes.get("@timeouts-left") map { _.as[BigInt]}
  lazy val timeoutDuration = attributes.get("@timeout-duration") map { _.as[String]}
  lazy val timeoutType = attributes.get("@timeout-type") map { _.as[String]}
  lazy val scoreType = attributes.get("@score-type") map { _.as[String]}
  lazy val saveType = attributes.get("@save-type") map { _.as[String]}
  lazy val saveMethod = attributes.get("@save-method") map { _.as[String]}
  lazy val passType = attributes.get("@pass-type") map { _.as[String]}
  lazy val passDescription = attributes.get("@pass-description") map { _.as[String]}
  lazy val passMethod = attributes.get("@pass-method") map { _.as[String]}
  lazy val shotType = attributes.get("@shot-type") map { _.as[String]}
  lazy val shotDistance = attributes.get("@shot-distance") map { _.as[Double]}
  lazy val shotDistanceUnits = attributes.get("@shot-distance-units") map { _.as[String]}
  lazy val penaltyType = attributes.get("@penalty-type") map { _.as[String]}
  lazy val penaltyLevel = attributes.get("@penalty-level") map { _.as[String]}
  lazy val penaltyResult = attributes.get("@penalty-result") map { _.as[String]}
  lazy val penaltySide = attributes.get("@penalty-side") map { _.as[String]}
  lazy val penaltyLength = attributes.get("@penalty-length") map { _.as[String]}
  lazy val penaltyName = attributes.get("@penalty-name") map { _.as[String]}
  lazy val penaltyCount = attributes.get("@penalty-count") map { _.as[BigInt]}
  lazy val penaltyStatus = attributes.get("@penalty-status") map { _.as[PenaltyStatus]}
  lazy val recipientType = attributes.get("@recipient-type") map { _.as[String]}
  lazy val scoreAttemptType = attributes.get("@score-attempt-type") map { _.as[String]}
  lazy val scoreAttemptResult = attributes.get("@score-attempt-result") map { _.as[String]}
  lazy val scoreAttemptSide = attributes.get("@score-attempt-side") map { _.as[BodySideList]}
  lazy val scoreAttemptMethod = attributes.get("@score-attempt-method") map { _.as[String]}
  lazy val scoreAttemptSituation = attributes.get("@score-attempt-situation") map { _.as[String]}
  lazy val goalZone = attributes.get("@goal-zone") map { _.as[String]}
  lazy val angle = attributes.get("@angle") map { _.as[String]}
  lazy val distance = attributes.get("@distance") map { _.as[String]}
  lazy val bodyPart = attributes.get("@body-part") map { _.as[String]}
  lazy val fieldLocation = attributes.get("@field-location") map { _.as[String]}
  lazy val goalLocation = attributes.get("@goal-location") map { _.as[String]}
  lazy val timeAddition = attributes.get("@time-addition") map { _.as[String]}
  lazy val shootoutShotOrder = attributes.get("@shootout-shot-order") map { _.as[BigInt]}
  lazy val faceoffWinner = attributes.get("@faceoff-winner") map { _.as[String]}
  lazy val substitutionReason = attributes.get("@substitution-reason") map { _.as[String]}
  lazy val touchdownType = attributes.get("@touchdown-type") map { _.as[String]}
  lazy val clockState = attributes.get("@clock-state") map { _.as[ClockStateType]}
  lazy val distanceFor1stDown = attributes.get("@distance-for-1st-down") map { _.as[BigInt]}
  lazy val fieldSide = attributes.get("@field-side") map { _.as[FieldSideType]}
  lazy val fieldLine = attributes.get("@field-line") map { _.as[BigInt]}
  lazy val drivePlays = attributes.get("@drive-plays") map { _.as[BigInt]}
  lazy val driveYards = attributes.get("@drive-yards") map { _.as[BigInt]}
  lazy val driveDuration = attributes.get("@drive-duration") map { _.as[javax.xml.datatype.Duration]}
  lazy val driveResult = attributes.get("@drive-result") map { _.as[String]}
  lazy val down = attributes.get("@down") map { _.as[BigInt]}
  lazy val yardsGained = attributes.get("@yards-gained") map { _.as[BigInt]}
  lazy val penaltyYards = attributes.get("@penalty-yards") map { _.as[String]}
  lazy val penaltyAcceptance = attributes.get("@penalty-acceptance") map { _.as[String]}
  lazy val penaltyChallenge = attributes.get("@penalty-challenge") map { _.as[String]}
  lazy val penaltyReview = attributes.get("@penalty-review") map { _.as[String]}
  lazy val penaltyReviewRuling = attributes.get("@penalty-review-ruling") map { _.as[String]}
  lazy val kickType = attributes.get("@kick-type") map { _.as[String]}
  lazy val atBatNumber = attributes.get("@at-bat-number") map { _.as[BigInt]}
  lazy val balls = attributes.get("@balls") map { _.as[BigInt]}
  lazy val batterAdvance = attributes.get("@batter-advance") map { _.as[BigInt]}
  lazy val batterSide = attributes.get("@batter-side") map { _.as[BodySideList]}
  lazy val earnedRunsScored = attributes.get("@earned-runs-scored") map { _.as[BigInt]}
  lazy val errorType = attributes.get("@error-type") map { _.as[String]}
  lazy val hitByPitchType = attributes.get("@hit-by-pitch-type") map { _.as[HitByPitchType]}
  lazy val hitLocation = attributes.get("@hit-location") map { _.as[String]}
  lazy val hitType = attributes.get("@hit-type") map { _.as[String]}
  lazy val inningExiting = attributes.get("@inning-exiting") map { _.as[String]}
  lazy val inningHalf = attributes.get("@inning-half") map { _.as[InningHalf]}
  lazy val inningValue = attributes.get("@inning-value") map { _.as[BigInt]}
  lazy val interferenceType = attributes.get("@interference-type") map { _.as[String]}
  lazy val leadEntering = attributes.get("@lead-entering") map { _.as[String]}
  lazy val leadExiting = attributes.get("@lead-exiting") map { _.as[String]}
  lazy val outType = attributes.get("@out-type") map { _.as[String]}
  lazy val outs = attributes.get("@outs") map { _.as[BigInt]}
  lazy val outsRecorded = attributes.get("@outs-recorded") map { _.as[BigInt]}
  lazy val pitcherSide = attributes.get("@pitcher-side") map { _.as[BodySideList]}
  lazy val playScorekeepersNotation = attributes.get("@play-scorekeepers-notation") map { _.as[String]}
  lazy val rbi = attributes.get("@rbi") map { _.as[BigInt]}
  lazy val runnerOnFirst = attributes.get("@runner-on-first") map { _.as[Boolean]}
  lazy val runnerOnFirstAdvance = attributes.get("@runner-on-first-advance") map { _.as[String]}
  lazy val runnerOnFirstIdref = attributes.get("@runner-on-first-idref") map { _.as[String]}
  lazy val runnerOnSecond = attributes.get("@runner-on-second") map { _.as[Boolean]}
  lazy val runnerOnSecondAdvance = attributes.get("@runner-on-second-advance") map { _.as[String]}
  lazy val runnerOnSecondIdref = attributes.get("@runner-on-second-idref") map { _.as[String]}
  lazy val runnerOnThird = attributes.get("@runner-on-third") map { _.as[Boolean]}
  lazy val runnerOnThirdAdvance = attributes.get("@runner-on-third-advance") map { _.as[String]}
  lazy val runnerOnThirdIdref = attributes.get("@runner-on-third-idref") map { _.as[String]}
  lazy val runnersOnBase = attributes.get("@runners-on-base") map { _.as[Boolean]}
  lazy val runsScored = attributes.get("@runs-scored") map { _.as[BigInt]}
  lazy val runsThisInningHalf = attributes.get("@runs-this-inning-half") map { _.as[BigInt]}
  lazy val sacrificeType = attributes.get("@sacrifice-type") map { _.as[String]}
  lazy val strikeoutType = attributes.get("@strikeout-type") map { _.as[StrikeoutType]}
  lazy val strikes = attributes.get("@strikes") map { _.as[BigInt]}
  lazy val trajectoryCoordinates = attributes.get("@trajectory-coordinates") map { _.as[String]}
  lazy val velocity = attributes.get("@velocity") map { _.as[String]}
  lazy val walkType = attributes.get("@walk-type") map { _.as[WalkType]}
  lazy val ballLocation = attributes.get("@ball-location") map { _.as[String]}
  lazy val ballLocationHorizontal = attributes.get("@ball-location-horizontal") map { _.as[String]}
  lazy val ballLocationVertical = attributes.get("@ball-location-vertical") map { _.as[String]}
  lazy val pitchType = attributes.get("@pitch-type") map { _.as[String]}
  lazy val pitchVelocity = attributes.get("@pitch-velocity") map { _.as[BigDecimal]}
  lazy val pitchUnits = attributes.get("@pitch-units") map { _.as[PitchUnits]}
  lazy val strikeType = attributes.get("@strike-type") map { _.as[StrikeType]}
  lazy val umpireCall = attributes.get("@umpire-call") map { _.as[UmpireCall]}
  lazy val endNumber = attributes.get("@end-number") map { _.as[BigInt]}
  lazy val stoneNumber = attributes.get("@stone-number") map { _.as[BigInt]}
  lazy val timeUsed = attributes.get("@time-used") map { _.as[String]}
  lazy val turn = attributes.get("@turn") map { _.as[Turn]}
  lazy val stoneSpeed = attributes.get("@stone-speed") map { _.as[String]}
  lazy val round = attributes.get("@round") map { _.as[BigInt]}
  lazy val hole = attributes.get("@hole") map { _.as[BigInt]}
  lazy val strokes = attributes.get("@strokes") map { _.as[BigInt]}
  lazy val score = attributes.get("@score") map { _.as[BigInt]}
  lazy val scoreAgainstPar = attributes.get("@score-against-par") map { _.as[BigInt]}
  lazy val club = attributes.get("@club") map { _.as[String]}
  lazy val startDistance = attributes.get("@start-distance") map { _.as[BigInt]}
  lazy val endDistance = attributes.get("@end-distance") map { _.as[BigInt]}
  lazy val landing = attributes.get("@landing") map { _.as[String]}
  lazy val lap = attributes.get("@lap") map { _.as[BigInt]}
  lazy val lapsRemaining = attributes.get("@laps-remaining") map { _.as[BigInt]}
  lazy val flagState = attributes.get("@flag-state") map { _.as[String]}
  lazy val flagOriginal = attributes.get("@flag-original") map { _.as[String]}
  lazy val flagNew = attributes.get("@flag-new") map { _.as[String]}
  lazy val passerType = attributes.get("@passer-type") map { _.as[String]}
  lazy val passerKey = attributes.get("@passer-key") map { _.as[String]}
  lazy val positionOriginal = attributes.get("@position-original") map { _.as[String]}
  lazy val positionNew = attributes.get("@position-new") map { _.as[String]}
  lazy val cautionValue = attributes.get("@caution-value") map { _.as[String]}
  lazy val set = attributes.get("@set") map { _.as[BigInt]}
  lazy val game = attributes.get("@game") map { _.as[BigInt]}
  lazy val winType = attributes.get("@win-type") map { _.as[WinType]}
  lazy val serverScore = attributes.get("@server-score") map { _.as[String]}
  lazy val receiverScore = attributes.get("@receiver-score") map { _.as[String]}
  lazy val serveNumber = attributes.get("@serve-number") map { _.as[String]}
}

      

trait PenaltyStatus

object PenaltyStatus {
  def fromString(value: String, scope: scala.xml.NamespaceBinding)(implicit fmt: scalaxb.XMLFormat[org.iptc.sportsml.v3.PenaltyStatus]): PenaltyStatus = fmt.reads(scala.xml.Text(value), Nil) match {
    case Right(x: PenaltyStatus) => x
    case x => throw new RuntimeException(s"fromString returned unexpected value $x for input $value")
  }
}

case object Start extends PenaltyStatus { override def toString = "start" }
case object End extends PenaltyStatus { override def toString = "end" }

trait ScoreCredit

object ScoreCredit {
  def fromString(value: String, scope: scala.xml.NamespaceBinding)(implicit fmt: scalaxb.XMLFormat[org.iptc.sportsml.v3.ScoreCredit]): ScoreCredit = fmt.reads(scala.xml.Text(value), Nil) match {
    case Right(x: ScoreCredit) => x
    case x => throw new RuntimeException(s"fromString returned unexpected value $x for input $value")
  }
}

case object Number1Value extends ScoreCredit { override def toString = "1" }
case object Number0 extends ScoreCredit { override def toString = "0" }


/** Base structure for a participant.
*/
case class BaseParticipantComplexType(attributes: Map[String, scalaxb.DataRecord[Any]] = Map()) {
  lazy val id = attributes.get("@id") map { _.as[String]}
  lazy val classValue = attributes.get("@class") map { _.as[String]}
  lazy val style = attributes.get("@style") map { _.as[String]}
  lazy val idref = attributes("@idref").as[String]
  lazy val teamIdref = attributes.get("@team-idref") map { _.as[String]}
  lazy val role = attributes.get("@role") map { _.as[String]}
  lazy val stoneColor = attributes.get("@stone-color") map { _.as[String]}
  lazy val stoneId = attributes.get("@stone-id") map { _.as[String]}
  lazy val stoneNumber = attributes.get("@stone-number") map { _.as[BigInt]}
  lazy val fieldLocation = attributes.get("@field-location") map { _.as[String]}
  lazy val goalsCumulative = attributes.get("@goals-cumulative") map { _.as[String]}
  lazy val assistsCumulative = attributes.get("@assists-cumulative") map { _.as[String]}
  lazy val lineupSlot = attributes.get("@lineup-slot") map { _.as[BigInt]}
  lazy val yardsGained = attributes.get("@yards-gained") map { _.as[BigInt]}
  lazy val scoreCredit = attributes.get("@score-credit") map { _.as[ScoreCredit]}
}

      

trait TimeCertainty

object TimeCertainty {
  def fromString(value: String, scope: scala.xml.NamespaceBinding)(implicit fmt: scalaxb.XMLFormat[org.iptc.sportsml.v3.TimeCertainty]): TimeCertainty = fmt.reads(scala.xml.Text(value), Nil) match {
    case Right(x: TimeCertainty) => x
    case x => throw new RuntimeException(s"fromString returned unexpected value $x for input $value")
  }
}

case object Certain extends TimeCertainty { override def toString = "certain" }
case object ToBeAnnounced extends TimeCertainty { override def toString = "to-be-announced" }


/** Background information about an event. | Where, when, and what an event is.
*/
trait BaseEventMetadataComplexTypable extends Base2MetadataComplexTypable {
  def sportsContentCodes: Option[org.iptc.sportsml.v3.SportsContentCodesComplexType]
  def sportsProperty: Seq[org.iptc.sportsml.v3.SportsPropertyComplexType]
  def name: Seq[org.iptc.sportsml.v3.ConceptNameType]
  def site: Seq[org.iptc.sportsml.v3.SiteComplexType]
  def award: Seq[org.iptc.sportsml.v3.AwardComplexType]
  def eventSponsor: Seq[org.iptc.sportsml.v3.EventSponsorComplexType]
  def eventRecurringName: Seq[org.iptc.sportsml.v3.ConceptNameType]
  def id: Option[String]
  def classValue: Option[String]
  def style: Option[String]
  def statsCoverage: Option[String]
  def teamCoverage: Option[org.iptc.sportsml.v3.TeamCoverage]
  def durationScope: Option[String]
  def alignmentScope: Option[org.iptc.sportsml.v3.AlignmentScope]
  def position: Option[String]
  def recordMakingScope: Option[String]
  def scopingLabel: Option[String]
  def periodValue: Option[String]
  def periodType: Option[String]
  def startDateTime: Option[String]
  def endDateTime: Option[String]
  def periodStartDateTime: Option[String]
  def periodEndDateTime: Option[String]
  def temporalUnitType: Option[String]
  def temporalUnitValue: Option[String]
  def eventSpan: Option[BigInt]
  def opponentValue: Option[String]
  def opponentType: Option[String]
  def team: Option[String]
  def competition: Option[String]
  def unitValue: Option[String]
  def unitType: Option[String]
  def situation: Option[String]
  def locationKey: Option[String]
  def venueType: Option[String]
  def surfaceType: Option[String]
  def weatherType: Option[String]
  def scopeValue: Option[String]
  def distance: Option[String]
  def distanceMaximum: Option[String]
  def distanceMinimum: Option[String]
  def measurementUnits: Option[String]
  def key: Option[String]
  def minutesElapsed: Option[String]
  def periodMinuteElapsed: Option[String]
  def periodTimeElapsed: Option[String]
  def periodTimeRemaining: Option[String]
  def eventRecurringKey: Option[String]
  def eventStyle: Option[String]
  def eventNumber: Option[BigInt]
  def eventStatus: Option[String]
  def eventType: Option[String]
  def eventStatusReason: Option[String]
  def eventStatusNote: Option[String]
  def eventOfDay: Option[String]
  def eventsDayTotal: Option[String]
  def startWeekday: Option[String]
  def endWeekday: Option[String]
  def heatNumber: Option[String]
  def duration: Option[javax.xml.datatype.Duration]
  def timeCertainty: Option[org.iptc.sportsml.v3.TimeCertainty]
  def seasonKey: Option[String]
  def seasonType: Option[String]
  def seriesIndex: Option[String]
  def eventOutcomeType: Option[String]
}


/** Background information about an event. | Where, when, and what an event is.
*/
case class BaseEventMetadataComplexType(sportsContentCodes: Option[org.iptc.sportsml.v3.SportsContentCodesComplexType] = None,
  sportsProperty: Seq[org.iptc.sportsml.v3.SportsPropertyComplexType] = Nil,
  name: Seq[org.iptc.sportsml.v3.ConceptNameType] = Nil,
  site: Seq[org.iptc.sportsml.v3.SiteComplexType] = Nil,
  award: Seq[org.iptc.sportsml.v3.AwardComplexType] = Nil,
  eventSponsor: Seq[org.iptc.sportsml.v3.EventSponsorComplexType] = Nil,
  eventRecurringName: Seq[org.iptc.sportsml.v3.ConceptNameType] = Nil,
  attributes: Map[String, scalaxb.DataRecord[Any]] = Map()) extends BaseEventMetadataComplexTypable {
  lazy val id = attributes.get("@id") map { _.as[String]}
  lazy val classValue = attributes.get("@class") map { _.as[String]}
  lazy val style = attributes.get("@style") map { _.as[String]}
  lazy val statsCoverage = attributes.get("@stats-coverage") map { _.as[String]}
  lazy val teamCoverage = attributes.get("@team-coverage") map { _.as[TeamCoverage]}
  lazy val durationScope = attributes.get("@duration-scope") map { _.as[String]}
  lazy val alignmentScope = attributes.get("@alignment-scope") map { _.as[AlignmentScope]}
  lazy val position = attributes.get("@position") map { _.as[String]}
  lazy val recordMakingScope = attributes.get("@record-making-scope") map { _.as[String]}
  lazy val scopingLabel = attributes.get("@scoping-label") map { _.as[String]}
  lazy val periodValue = attributes.get("@period-value") map { _.as[String]}
  lazy val periodType = attributes.get("@period-type") map { _.as[String]}
  lazy val startDateTime = attributes.get("@start-date-time") map { _.as[String]}
  lazy val endDateTime = attributes.get("@end-date-time") map { _.as[String]}
  lazy val periodStartDateTime = attributes.get("@period-start-date-time") map { _.as[String]}
  lazy val periodEndDateTime = attributes.get("@period-end-date-time") map { _.as[String]}
  lazy val temporalUnitType = attributes.get("@temporal-unit-type") map { _.as[String]}
  lazy val temporalUnitValue = attributes.get("@temporal-unit-value") map { _.as[String]}
  lazy val eventSpan = attributes.get("@event-span") map { _.as[BigInt]}
  lazy val opponentValue = attributes.get("@opponent-value") map { _.as[String]}
  lazy val opponentType = attributes.get("@opponent-type") map { _.as[String]}
  lazy val team = attributes.get("@team") map { _.as[String]}
  lazy val competition = attributes.get("@competition") map { _.as[String]}
  lazy val unitValue = attributes.get("@unit-value") map { _.as[String]}
  lazy val unitType = attributes.get("@unit-type") map { _.as[String]}
  lazy val situation = attributes.get("@situation") map { _.as[String]}
  lazy val locationKey = attributes.get("@location-key") map { _.as[String]}
  lazy val venueType = attributes.get("@venue-type") map { _.as[String]}
  lazy val surfaceType = attributes.get("@surface-type") map { _.as[String]}
  lazy val weatherType = attributes.get("@weather-type") map { _.as[String]}
  lazy val scopeValue = attributes.get("@scope-value") map { _.as[String]}
  lazy val distance = attributes.get("@distance") map { _.as[String]}
  lazy val distanceMaximum = attributes.get("@distance-maximum") map { _.as[String]}
  lazy val distanceMinimum = attributes.get("@distance-minimum") map { _.as[String]}
  lazy val measurementUnits = attributes.get("@measurement-units") map { _.as[String]}
  lazy val key = attributes.get("@key") map { _.as[String]}
  lazy val minutesElapsed = attributes.get("@minutes-elapsed") map { _.as[String]}
  lazy val periodMinuteElapsed = attributes.get("@period-minute-elapsed") map { _.as[String]}
  lazy val periodTimeElapsed = attributes.get("@period-time-elapsed") map { _.as[String]}
  lazy val periodTimeRemaining = attributes.get("@period-time-remaining") map { _.as[String]}
  lazy val eventRecurringKey = attributes.get("@event-recurring-key") map { _.as[String]}
  lazy val eventStyle = attributes.get("@event-style") map { _.as[String]}
  lazy val eventNumber = attributes.get("@event-number") map { _.as[BigInt]}
  lazy val eventStatus = attributes.get("@event-status") map { _.as[String]}
  lazy val eventType = attributes.get("@event-type") map { _.as[String]}
  lazy val eventStatusReason = attributes.get("@event-status-reason") map { _.as[String]}
  lazy val eventStatusNote = attributes.get("@event-status-note") map { _.as[String]}
  lazy val eventOfDay = attributes.get("@event-of-day") map { _.as[String]}
  lazy val eventsDayTotal = attributes.get("@events-day-total") map { _.as[String]}
  lazy val startWeekday = attributes.get("@start-weekday") map { _.as[String]}
  lazy val endWeekday = attributes.get("@end-weekday") map { _.as[String]}
  lazy val heatNumber = attributes.get("@heat-number") map { _.as[String]}
  lazy val duration = attributes.get("@duration") map { _.as[javax.xml.datatype.Duration]}
  lazy val timeCertainty = attributes.get("@time-certainty") map { _.as[TimeCertainty]}
  lazy val seasonKey = attributes.get("@season-key") map { _.as[String]}
  lazy val seasonType = attributes.get("@season-type") map { _.as[String]}
  lazy val seriesIndex = attributes.get("@series-index") map { _.as[String]}
  lazy val eventOutcomeType = attributes.get("@event-outcome-type") map { _.as[String]}
}

      


/** Base metadata for different entities. Extended by baseTeamMetadata and basePersonMetadata and siteMetadata 
*/
trait BaseEntityMetadataComplexTypable {
  def name: Seq[org.iptc.sportsml.v3.ConceptNameType]
  def homeLocation: Option[org.iptc.sportsml.v3.FlexLocationPropTypable]
  def sportsProperty: Seq[org.iptc.sportsml.v3.SportsPropertyComplexType]
  def id: Option[String]
  def classValue: Option[String]
  def style: Option[String]
  def key: Option[String]
  def nationality: Option[String]
}


/** Base metadata for different entities. Extended by baseTeamMetadata and basePersonMetadata and siteMetadata 
*/
case class BaseEntityMetadataComplexType(name: Seq[org.iptc.sportsml.v3.ConceptNameType] = Nil,
  homeLocation: Option[org.iptc.sportsml.v3.FlexLocationPropTypable] = None,
  sportsProperty: Seq[org.iptc.sportsml.v3.SportsPropertyComplexType] = Nil,
  attributes: Map[String, scalaxb.DataRecord[Any]] = Map()) extends BaseEntityMetadataComplexTypable {
  lazy val id = attributes.get("@id") map { _.as[String]}
  lazy val classValue = attributes.get("@class") map { _.as[String]}
  lazy val style = attributes.get("@style") map { _.as[String]}
  lazy val key = attributes.get("@key") map { _.as[String]}
  lazy val nationality = attributes.get("@nationality") map { _.as[String]}
}

      

trait GenderType

object GenderType {
  def fromString(value: String, scope: scala.xml.NamespaceBinding)(implicit fmt: scalaxb.XMLFormat[org.iptc.sportsml.v3.GenderType]): GenderType = fmt.reads(scala.xml.Text(value), Nil) match {
    case Right(x: GenderType) => x
    case x => throw new RuntimeException(s"fromString returned unexpected value $x for input $value")
  }
}

case object MaleValue extends GenderType { override def toString = "male" }
case object FemaleValue extends GenderType { override def toString = "female" }


/** Metadata that describes a person. | Generally does not change over the course of a sports-events. Extends the baseEntityMetadata type
*/
trait BasePersonMetadataComplexTypable extends BaseEntityMetadataComplexTypable {
  def name: Seq[org.iptc.sportsml.v3.ConceptNameType]
  def homeLocation: Option[org.iptc.sportsml.v3.FlexLocationPropTypable]
  def sportsProperty: Seq[org.iptc.sportsml.v3.SportsPropertyComplexType]
  def id: Option[String]
  def classValue: Option[String]
  def style: Option[String]
  def key: Option[String]
  def nationality: Option[String]
  def dateOfBirth: Option[String]
  def dateOfDeath: Option[String]
  def height: Option[String]
  def weight: Option[BigInt]
  def positionRegular: Option[String]
  def positionEvent: Option[String]
  def positionDepth: Option[String]
  def health: Option[String]
  def gender: Option[org.iptc.sportsml.v3.GenderType]
}


/** Metadata that describes a person. | Generally does not change over the course of a sports-events. Extends the baseEntityMetadata type
*/
case class BasePersonMetadataComplexType(name: Seq[org.iptc.sportsml.v3.ConceptNameType] = Nil,
  homeLocation: Option[org.iptc.sportsml.v3.FlexLocationPropTypable] = None,
  sportsProperty: Seq[org.iptc.sportsml.v3.SportsPropertyComplexType] = Nil,
  attributes: Map[String, scalaxb.DataRecord[Any]] = Map()) extends BasePersonMetadataComplexTypable {
  lazy val id = attributes.get("@id") map { _.as[String]}
  lazy val classValue = attributes.get("@class") map { _.as[String]}
  lazy val style = attributes.get("@style") map { _.as[String]}
  lazy val key = attributes.get("@key") map { _.as[String]}
  lazy val nationality = attributes.get("@nationality") map { _.as[String]}
  lazy val dateOfBirth = attributes.get("@date-of-birth") map { _.as[String]}
  lazy val dateOfDeath = attributes.get("@date-of-death") map { _.as[String]}
  lazy val height = attributes.get("@height") map { _.as[String]}
  lazy val weight = attributes.get("@weight") map { _.as[BigInt]}
  lazy val positionRegular = attributes.get("@position-regular") map { _.as[String]}
  lazy val positionEvent = attributes.get("@position-event") map { _.as[String]}
  lazy val positionDepth = attributes.get("@position-depth") map { _.as[String]}
  lazy val health = attributes.get("@health") map { _.as[String]}
  lazy val gender = attributes.get("@gender") map { _.as[GenderType]}
}

      


/** Metadata that describes a person. | Generally does not change over the course of a sports-events.
*/
trait BasePlayerMetadataComplexTypable extends BasePersonMetadataComplexTypable {
  def name: Seq[org.iptc.sportsml.v3.ConceptNameType]
  def homeLocation: Option[org.iptc.sportsml.v3.FlexLocationPropTypable]
  def sportsProperty: Seq[org.iptc.sportsml.v3.SportsPropertyComplexType]
  def baseplayermetadatacomplextypableoption: Option[scalaxb.DataRecord[org.iptc.sportsml.v3.BasePlayerMetadataComplexTypableOption]]
  def id: Option[String]
  def classValue: Option[String]
  def style: Option[String]
  def key: Option[String]
  def nationality: Option[String]
  def dateOfBirth: Option[String]
  def dateOfDeath: Option[String]
  def height: Option[String]
  def weight: Option[BigInt]
  def positionRegular: Option[String]
  def positionEvent: Option[String]
  def positionDepth: Option[String]
  def health: Option[String]
  def gender: Option[org.iptc.sportsml.v3.GenderType]
  def teamIdref: Option[String]
  def status: Option[String]
  def lineupSlot: Option[String]
  def lineupSlotSequence: Option[String]
  def scratchReason: Option[String]
  def uniformNumber: Option[String]
  def homePageUrl: Option[java.net.URI]
  def roundPosition: Option[String]
}


/** Metadata that describes a person. | Generally does not change over the course of a sports-events.
*/
case class BasePlayerMetadataComplexType(name: Seq[org.iptc.sportsml.v3.ConceptNameType] = Nil,
  homeLocation: Option[org.iptc.sportsml.v3.FlexLocationPropTypable] = None,
  sportsProperty: Seq[org.iptc.sportsml.v3.SportsPropertyComplexType] = Nil,
  baseplayermetadatacomplextypableoption: Option[scalaxb.DataRecord[org.iptc.sportsml.v3.BasePlayerMetadataComplexTypableOption]] = None,
  attributes: Map[String, scalaxb.DataRecord[Any]] = Map()) extends BasePlayerMetadataComplexTypable {
  lazy val id = attributes.get("@id") map { _.as[String]}
  lazy val classValue = attributes.get("@class") map { _.as[String]}
  lazy val style = attributes.get("@style") map { _.as[String]}
  lazy val key = attributes.get("@key") map { _.as[String]}
  lazy val nationality = attributes.get("@nationality") map { _.as[String]}
  lazy val dateOfBirth = attributes.get("@date-of-birth") map { _.as[String]}
  lazy val dateOfDeath = attributes.get("@date-of-death") map { _.as[String]}
  lazy val height = attributes.get("@height") map { _.as[String]}
  lazy val weight = attributes.get("@weight") map { _.as[BigInt]}
  lazy val positionRegular = attributes.get("@position-regular") map { _.as[String]}
  lazy val positionEvent = attributes.get("@position-event") map { _.as[String]}
  lazy val positionDepth = attributes.get("@position-depth") map { _.as[String]}
  lazy val health = attributes.get("@health") map { _.as[String]}
  lazy val gender = attributes.get("@gender") map { _.as[GenderType]}
  lazy val teamIdref = attributes.get("@team-idref") map { _.as[String]}
  lazy val status = attributes.get("@status") map { _.as[String]}
  lazy val lineupSlot = attributes.get("@lineup-slot") map { _.as[String]}
  lazy val lineupSlotSequence = attributes.get("@lineup-slot-sequence") map { _.as[String]}
  lazy val scratchReason = attributes.get("@scratch-reason") map { _.as[String]}
  lazy val uniformNumber = attributes.get("@uniform-number") map { _.as[String]}
  lazy val homePageUrl = attributes.get("@home-page-url") map { _.as[java.net.URI]}
  lazy val roundPosition = attributes.get("@round-position") map { _.as[String]}
}

      

trait BasePlayerMetadataComplexTypableOption

/** A description of where a player is playing, or has previously played. | Can be used to state where the player went to college. Can also list previous teams of the player.
*/
case class BaseCareerPhaseMetadataComplexType(name: Seq[org.iptc.sportsml.v3.ConceptNameType] = Nil,
  homeLocation: Option[org.iptc.sportsml.v3.FlexLocationPropTypable] = None,
  sportsProperty: Seq[org.iptc.sportsml.v3.SportsPropertyComplexType] = Nil,
  baseplayermetadatacomplextypableoption: Option[scalaxb.DataRecord[org.iptc.sportsml.v3.BasePlayerMetadataComplexTypableOption]] = None,
  attributes: Map[String, scalaxb.DataRecord[Any]] = Map()) extends BasePlayerMetadataComplexTypable with BasePlayerMetadataComplexTypableOption {
  lazy val id = attributes.get("@id") map { _.as[String]}
  lazy val classValue = attributes.get("@class") map { _.as[String]}
  lazy val style = attributes.get("@style") map { _.as[String]}
  lazy val key = attributes.get("@key") map { _.as[String]}
  lazy val nationality = attributes.get("@nationality") map { _.as[String]}
  lazy val dateOfBirth = attributes.get("@date-of-birth") map { _.as[String]}
  lazy val dateOfDeath = attributes.get("@date-of-death") map { _.as[String]}
  lazy val height = attributes.get("@height") map { _.as[String]}
  lazy val weight = attributes.get("@weight") map { _.as[BigInt]}
  lazy val positionRegular = attributes.get("@position-regular") map { _.as[String]}
  lazy val positionEvent = attributes.get("@position-event") map { _.as[String]}
  lazy val positionDepth = attributes.get("@position-depth") map { _.as[String]}
  lazy val health = attributes.get("@health") map { _.as[String]}
  lazy val gender = attributes.get("@gender") map { _.as[GenderType]}
  lazy val teamIdref = attributes.get("@team-idref") map { _.as[String]}
  lazy val status = attributes.get("@status") map { _.as[String]}
  lazy val lineupSlot = attributes.get("@lineup-slot") map { _.as[String]}
  lazy val lineupSlotSequence = attributes.get("@lineup-slot-sequence") map { _.as[String]}
  lazy val scratchReason = attributes.get("@scratch-reason") map { _.as[String]}
  lazy val uniformNumber = attributes.get("@uniform-number") map { _.as[String]}
  lazy val homePageUrl = attributes.get("@home-page-url") map { _.as[java.net.URI]}
  lazy val roundPosition = attributes.get("@round-position") map { _.as[String]}
  lazy val phaseType = attributes.get("@phase-type") map { _.as[String]}
  lazy val startDate = attributes.get("@start-date") map { _.as[String]}
  lazy val endDate = attributes.get("@end-date") map { _.as[String]}
  lazy val duration = attributes.get("@duration") map { _.as[String]}
  lazy val subphaseType = attributes.get("@subphase-type") map { _.as[String]}
  lazy val phaseStatus = attributes.get("@phase-status") map { _.as[String]}
  lazy val phaseCaliber = attributes.get("@phase-caliber") map { _.as[String]}
  lazy val phaseCaliberKey = attributes.get("@phase-caliber-key") map { _.as[String]}
  lazy val entryReason = attributes.get("@entry-reason") map { _.as[String]}
  lazy val selectionLevel = attributes.get("@selection-level") map { _.as[BigInt]}
  lazy val selectionSublevel = attributes.get("@selection-sublevel") map { _.as[BigInt]}
  lazy val selectionOverall = attributes.get("@selection-overall") map { _.as[BigInt]}
  lazy val exitReason = attributes.get("@exit-reason") map { _.as[String]}
}

      


/** A description of where a player is playing, or has previously played. | Can be used to state where the player went to college. Can also list previous teams of the player.
*/
case class BaseInjuryPhaseMetadataComplexType(name: Seq[org.iptc.sportsml.v3.ConceptNameType] = Nil,
  homeLocation: Option[org.iptc.sportsml.v3.FlexLocationPropTypable] = None,
  sportsProperty: Seq[org.iptc.sportsml.v3.SportsPropertyComplexType] = Nil,
  baseplayermetadatacomplextypableoption: Option[scalaxb.DataRecord[org.iptc.sportsml.v3.BasePlayerMetadataComplexTypableOption]] = None,
  attributes: Map[String, scalaxb.DataRecord[Any]] = Map()) extends BasePlayerMetadataComplexTypable with BasePlayerMetadataComplexTypableOption {
  lazy val id = attributes.get("@id") map { _.as[String]}
  lazy val classValue = attributes.get("@class") map { _.as[String]}
  lazy val style = attributes.get("@style") map { _.as[String]}
  lazy val key = attributes.get("@key") map { _.as[String]}
  lazy val nationality = attributes.get("@nationality") map { _.as[String]}
  lazy val dateOfBirth = attributes.get("@date-of-birth") map { _.as[String]}
  lazy val dateOfDeath = attributes.get("@date-of-death") map { _.as[String]}
  lazy val height = attributes.get("@height") map { _.as[String]}
  lazy val weight = attributes.get("@weight") map { _.as[BigInt]}
  lazy val positionRegular = attributes.get("@position-regular") map { _.as[String]}
  lazy val positionEvent = attributes.get("@position-event") map { _.as[String]}
  lazy val positionDepth = attributes.get("@position-depth") map { _.as[String]}
  lazy val health = attributes.get("@health") map { _.as[String]}
  lazy val gender = attributes.get("@gender") map { _.as[GenderType]}
  lazy val teamIdref = attributes.get("@team-idref") map { _.as[String]}
  lazy val status = attributes.get("@status") map { _.as[String]}
  lazy val lineupSlot = attributes.get("@lineup-slot") map { _.as[String]}
  lazy val lineupSlotSequence = attributes.get("@lineup-slot-sequence") map { _.as[String]}
  lazy val scratchReason = attributes.get("@scratch-reason") map { _.as[String]}
  lazy val uniformNumber = attributes.get("@uniform-number") map { _.as[String]}
  lazy val homePageUrl = attributes.get("@home-page-url") map { _.as[java.net.URI]}
  lazy val roundPosition = attributes.get("@round-position") map { _.as[String]}
  lazy val phaseType = attributes.get("@phase-type") map { _.as[String]}
  lazy val startDate = attributes.get("@start-date") map { _.as[String]}
  lazy val endDate = attributes.get("@end-date") map { _.as[String]}
  lazy val phaseStatus = attributes.get("@phase-status") map { _.as[String]}
  lazy val injuryType = attributes.get("@injury-type") map { _.as[String]}
  lazy val injurySide = attributes.get("@injury-side") map { _.as[BodySideList]}
  lazy val upcomingEventDate = attributes.get("@upcoming-event-date") map { _.as[String]}
  lazy val upcomingEventKey = attributes.get("@upcoming-event-key") map { _.as[String]}
  lazy val upcomingEventStatus = attributes.get("@upcoming-event-status") map { _.as[String]}
  lazy val comment = attributes.get("@comment") map { _.as[String]}
}

      


/** Metadata about the official. | Generally does not change over the course of a sports-events.
*/
trait BaseOfficialMetadataComplexTypable extends BasePersonMetadataComplexTypable {
  def name: Seq[org.iptc.sportsml.v3.ConceptNameType]
  def homeLocation: Option[org.iptc.sportsml.v3.FlexLocationPropTypable]
  def sportsProperty: Seq[org.iptc.sportsml.v3.SportsPropertyComplexType]
  def id: Option[String]
  def classValue: Option[String]
  def style: Option[String]
  def key: Option[String]
  def nationality: Option[String]
  def dateOfBirth: Option[String]
  def dateOfDeath: Option[String]
  def height: Option[String]
  def weight: Option[BigInt]
  def positionRegular: Option[String]
  def positionEvent: Option[String]
  def positionDepth: Option[String]
  def health: Option[String]
  def gender: Option[org.iptc.sportsml.v3.GenderType]
  def uniformNumber: Option[String]
}


/** Metadata about the official. | Generally does not change over the course of a sports-events.
*/
case class BaseOfficialMetadataComplexType(name: Seq[org.iptc.sportsml.v3.ConceptNameType] = Nil,
  homeLocation: Option[org.iptc.sportsml.v3.FlexLocationPropTypable] = None,
  sportsProperty: Seq[org.iptc.sportsml.v3.SportsPropertyComplexType] = Nil,
  attributes: Map[String, scalaxb.DataRecord[Any]] = Map()) extends BaseOfficialMetadataComplexTypable {
  lazy val id = attributes.get("@id") map { _.as[String]}
  lazy val classValue = attributes.get("@class") map { _.as[String]}
  lazy val style = attributes.get("@style") map { _.as[String]}
  lazy val key = attributes.get("@key") map { _.as[String]}
  lazy val nationality = attributes.get("@nationality") map { _.as[String]}
  lazy val dateOfBirth = attributes.get("@date-of-birth") map { _.as[String]}
  lazy val dateOfDeath = attributes.get("@date-of-death") map { _.as[String]}
  lazy val height = attributes.get("@height") map { _.as[String]}
  lazy val weight = attributes.get("@weight") map { _.as[BigInt]}
  lazy val positionRegular = attributes.get("@position-regular") map { _.as[String]}
  lazy val positionEvent = attributes.get("@position-event") map { _.as[String]}
  lazy val positionDepth = attributes.get("@position-depth") map { _.as[String]}
  lazy val health = attributes.get("@health") map { _.as[String]}
  lazy val gender = attributes.get("@gender") map { _.as[GenderType]}
  lazy val uniformNumber = attributes.get("@uniform-number") map { _.as[String]}
}

      


/** Metadata that describes an associate | Generally does not change over the course of a sports-events.
*/
trait BaseAssociateMetadataComplexTypable extends BasePersonMetadataComplexTypable {
  def name: Seq[org.iptc.sportsml.v3.ConceptNameType]
  def homeLocation: Option[org.iptc.sportsml.v3.FlexLocationPropTypable]
  def sportsProperty: Seq[org.iptc.sportsml.v3.SportsPropertyComplexType]
  def id: Option[String]
  def classValue: Option[String]
  def style: Option[String]
  def key: Option[String]
  def nationality: Option[String]
  def dateOfBirth: Option[String]
  def dateOfDeath: Option[String]
  def height: Option[String]
  def weight: Option[BigInt]
  def positionRegular: Option[String]
  def positionEvent: Option[String]
  def positionDepth: Option[String]
  def health: Option[String]
  def gender: Option[org.iptc.sportsml.v3.GenderType]
}


/** Metadata that describes an associate | Generally does not change over the course of a sports-events.
*/
case class BaseAssociateMetadataComplexType(name: Seq[org.iptc.sportsml.v3.ConceptNameType] = Nil,
  homeLocation: Option[org.iptc.sportsml.v3.FlexLocationPropTypable] = None,
  sportsProperty: Seq[org.iptc.sportsml.v3.SportsPropertyComplexType] = Nil,
  attributes: Map[String, scalaxb.DataRecord[Any]] = Map()) extends BaseAssociateMetadataComplexTypable {
  lazy val id = attributes.get("@id") map { _.as[String]}
  lazy val classValue = attributes.get("@class") map { _.as[String]}
  lazy val style = attributes.get("@style") map { _.as[String]}
  lazy val key = attributes.get("@key") map { _.as[String]}
  lazy val nationality = attributes.get("@nationality") map { _.as[String]}
  lazy val dateOfBirth = attributes.get("@date-of-birth") map { _.as[String]}
  lazy val dateOfDeath = attributes.get("@date-of-death") map { _.as[String]}
  lazy val height = attributes.get("@height") map { _.as[String]}
  lazy val weight = attributes.get("@weight") map { _.as[BigInt]}
  lazy val positionRegular = attributes.get("@position-regular") map { _.as[String]}
  lazy val positionEvent = attributes.get("@position-event") map { _.as[String]}
  lazy val positionDepth = attributes.get("@position-depth") map { _.as[String]}
  lazy val health = attributes.get("@health") map { _.as[String]}
  lazy val gender = attributes.get("@gender") map { _.as[GenderType]}
}

      


/** Background data about a tournament or tournament part. | Where and when the this tournament took place.
*/
trait BaseTournamentMetadataComplexTypable extends Base2MetadataComplexTypable {
  def sportsContentCodes: Option[org.iptc.sportsml.v3.SportsContentCodesComplexType]
  def sportsProperty: Seq[org.iptc.sportsml.v3.SportsPropertyComplexType]
  def name: Seq[org.iptc.sportsml.v3.ConceptNameType]
  def site: Seq[org.iptc.sportsml.v3.SiteComplexType]
  def award: Seq[org.iptc.sportsml.v3.AwardComplexType]
  def id: Option[String]
  def classValue: Option[String]
  def style: Option[String]
  def statsCoverage: Option[String]
  def teamCoverage: Option[org.iptc.sportsml.v3.TeamCoverage]
  def durationScope: Option[String]
  def alignmentScope: Option[org.iptc.sportsml.v3.AlignmentScope]
  def position: Option[String]
  def recordMakingScope: Option[String]
  def scopingLabel: Option[String]
  def periodValue: Option[String]
  def periodType: Option[String]
  def startDateTime: Option[String]
  def endDateTime: Option[String]
  def periodStartDateTime: Option[String]
  def periodEndDateTime: Option[String]
  def temporalUnitType: Option[String]
  def temporalUnitValue: Option[String]
  def eventSpan: Option[BigInt]
  def opponentValue: Option[String]
  def opponentType: Option[String]
  def team: Option[String]
  def competition: Option[String]
  def unitValue: Option[String]
  def unitType: Option[String]
  def situation: Option[String]
  def locationKey: Option[String]
  def venueType: Option[String]
  def surfaceType: Option[String]
  def weatherType: Option[String]
  def scopeValue: Option[String]
  def distance: Option[String]
  def distanceMaximum: Option[String]
  def distanceMinimum: Option[String]
  def measurementUnits: Option[String]
  def key: Option[String]
  def status: Option[String]
  def minimumSubparts: Option[BigInt]
  def maximumSubparts: Option[BigInt]
  def number: Option[BigInt]
}


/** Background data about a tournament or tournament part. | Where and when the this tournament took place.
*/
case class BaseTournamentMetadataComplexType(sportsContentCodes: Option[org.iptc.sportsml.v3.SportsContentCodesComplexType] = None,
  sportsProperty: Seq[org.iptc.sportsml.v3.SportsPropertyComplexType] = Nil,
  name: Seq[org.iptc.sportsml.v3.ConceptNameType] = Nil,
  site: Seq[org.iptc.sportsml.v3.SiteComplexType] = Nil,
  award: Seq[org.iptc.sportsml.v3.AwardComplexType] = Nil,
  attributes: Map[String, scalaxb.DataRecord[Any]] = Map()) extends BaseTournamentMetadataComplexTypable {
  lazy val id = attributes.get("@id") map { _.as[String]}
  lazy val classValue = attributes.get("@class") map { _.as[String]}
  lazy val style = attributes.get("@style") map { _.as[String]}
  lazy val statsCoverage = attributes.get("@stats-coverage") map { _.as[String]}
  lazy val teamCoverage = attributes.get("@team-coverage") map { _.as[TeamCoverage]}
  lazy val durationScope = attributes.get("@duration-scope") map { _.as[String]}
  lazy val alignmentScope = attributes.get("@alignment-scope") map { _.as[AlignmentScope]}
  lazy val position = attributes.get("@position") map { _.as[String]}
  lazy val recordMakingScope = attributes.get("@record-making-scope") map { _.as[String]}
  lazy val scopingLabel = attributes.get("@scoping-label") map { _.as[String]}
  lazy val periodValue = attributes.get("@period-value") map { _.as[String]}
  lazy val periodType = attributes.get("@period-type") map { _.as[String]}
  lazy val startDateTime = attributes.get("@start-date-time") map { _.as[String]}
  lazy val endDateTime = attributes.get("@end-date-time") map { _.as[String]}
  lazy val periodStartDateTime = attributes.get("@period-start-date-time") map { _.as[String]}
  lazy val periodEndDateTime = attributes.get("@period-end-date-time") map { _.as[String]}
  lazy val temporalUnitType = attributes.get("@temporal-unit-type") map { _.as[String]}
  lazy val temporalUnitValue = attributes.get("@temporal-unit-value") map { _.as[String]}
  lazy val eventSpan = attributes.get("@event-span") map { _.as[BigInt]}
  lazy val opponentValue = attributes.get("@opponent-value") map { _.as[String]}
  lazy val opponentType = attributes.get("@opponent-type") map { _.as[String]}
  lazy val team = attributes.get("@team") map { _.as[String]}
  lazy val competition = attributes.get("@competition") map { _.as[String]}
  lazy val unitValue = attributes.get("@unit-value") map { _.as[String]}
  lazy val unitType = attributes.get("@unit-type") map { _.as[String]}
  lazy val situation = attributes.get("@situation") map { _.as[String]}
  lazy val locationKey = attributes.get("@location-key") map { _.as[String]}
  lazy val venueType = attributes.get("@venue-type") map { _.as[String]}
  lazy val surfaceType = attributes.get("@surface-type") map { _.as[String]}
  lazy val weatherType = attributes.get("@weather-type") map { _.as[String]}
  lazy val scopeValue = attributes.get("@scope-value") map { _.as[String]}
  lazy val distance = attributes.get("@distance") map { _.as[String]}
  lazy val distanceMaximum = attributes.get("@distance-maximum") map { _.as[String]}
  lazy val distanceMinimum = attributes.get("@distance-minimum") map { _.as[String]}
  lazy val measurementUnits = attributes.get("@measurement-units") map { _.as[String]}
  lazy val key = attributes.get("@key") map { _.as[String]}
  lazy val status = attributes.get("@status") map { _.as[String]}
  lazy val minimumSubparts = attributes.get("@minimum-subparts") map { _.as[BigInt]}
  lazy val maximumSubparts = attributes.get("@maximum-subparts") map { _.as[BigInt]}
  lazy val number = attributes.get("@number") map { _.as[BigInt]}
}

      


/** Record time added by referee. | Holds values for the time added by the referee and how much extra time was actually played.
*/
trait BaseTimeAdjustmentComplexTypable {
  def id: Option[String]
  def classValue: Option[String]
  def style: Option[String]
  def periodExtraTimeAdded: Option[String]
  def periodExtraTimeElapsed: Option[String]
}


/** Record time added by referee. | Holds values for the time added by the referee and how much extra time was actually played.
*/
case class BaseTimeAdjustmentComplexType(attributes: Map[String, scalaxb.DataRecord[Any]] = Map()) extends BaseTimeAdjustmentComplexTypable {
  lazy val id = attributes.get("@id") map { _.as[String]}
  lazy val classValue = attributes.get("@class") map { _.as[String]}
  lazy val style = attributes.get("@style") map { _.as[String]}
  lazy val periodExtraTimeAdded = attributes.get("@period-extra-time-added") map { _.as[String]}
  lazy val periodExtraTimeElapsed = attributes.get("@period-extra-time-elapsed") map { _.as[String]}
}

      

trait TeamCoverage

object TeamCoverage {
  def fromString(value: String, scope: scala.xml.NamespaceBinding)(implicit fmt: scalaxb.XMLFormat[org.iptc.sportsml.v3.TeamCoverage]): TeamCoverage = fmt.reads(scala.xml.Text(value), Nil) match {
    case Right(x: TeamCoverage) => x
    case x => throw new RuntimeException(s"fromString returned unexpected value $x for input $value")
  }
}

case object SingleTeam extends TeamCoverage { override def toString = "single-team" }
case object MultiTeam extends TeamCoverage { override def toString = "multi-team" }

trait AlignmentScope

object AlignmentScope {
  def fromString(value: String, scope: scala.xml.NamespaceBinding)(implicit fmt: scalaxb.XMLFormat[org.iptc.sportsml.v3.AlignmentScope]): AlignmentScope = fmt.reads(scala.xml.Text(value), Nil) match {
    case Right(x: AlignmentScope) => x
    case x => throw new RuntimeException(s"fromString returned unexpected value $x for input $value")
  }
}

case object EventsAll extends AlignmentScope { override def toString = "events-all" }
case object EventsHome extends AlignmentScope { override def toString = "events-home" }
case object EventsAway extends AlignmentScope { override def toString = "events-away" }

trait ClockStateType

object ClockStateType {
  def fromString(value: String, scope: scala.xml.NamespaceBinding)(implicit fmt: scalaxb.XMLFormat[org.iptc.sportsml.v3.ClockStateType]): ClockStateType = fmt.reads(scala.xml.Text(value), Nil) match {
    case Right(x: ClockStateType) => x
    case x => throw new RuntimeException(s"fromString returned unexpected value $x for input $value")
  }
}

case object StoppedValue extends ClockStateType { override def toString = "stopped" }
case object RunningValue extends ClockStateType { override def toString = "running" }

trait FieldSideType

object FieldSideType {
  def fromString(value: String, scope: scala.xml.NamespaceBinding)(implicit fmt: scalaxb.XMLFormat[org.iptc.sportsml.v3.FieldSideType]): FieldSideType = fmt.reads(scala.xml.Text(value), Nil) match {
    case Right(x: FieldSideType) => x
    case x => throw new RuntimeException(s"fromString returned unexpected value $x for input $value")
  }
}

case object HomeValue3 extends FieldSideType { override def toString = "home" }
case object AwayValue2 extends FieldSideType { override def toString = "away" }

trait HitByPitchType

object HitByPitchType {
  def fromString(value: String, scope: scala.xml.NamespaceBinding)(implicit fmt: scalaxb.XMLFormat[org.iptc.sportsml.v3.HitByPitchType]): HitByPitchType = fmt.reads(scala.xml.Text(value), Nil) match {
    case Right(x: HitByPitchType) => x
    case x => throw new RuntimeException(s"fromString returned unexpected value $x for input $value")
  }
}

case object Intentional extends HitByPitchType { override def toString = "intentional" }
case object Unintentional extends HitByPitchType { override def toString = "unintentional" }

trait InningHalf

object InningHalf {
  def fromString(value: String, scope: scala.xml.NamespaceBinding)(implicit fmt: scalaxb.XMLFormat[org.iptc.sportsml.v3.InningHalf]): InningHalf = fmt.reads(scala.xml.Text(value), Nil) match {
    case Right(x: InningHalf) => x
    case x => throw new RuntimeException(s"fromString returned unexpected value $x for input $value")
  }
}

case object Top extends InningHalf { override def toString = "top" }
case object Bottom extends InningHalf { override def toString = "bottom" }

trait StrikeoutType

object StrikeoutType {
  def fromString(value: String, scope: scala.xml.NamespaceBinding)(implicit fmt: scalaxb.XMLFormat[org.iptc.sportsml.v3.StrikeoutType]): StrikeoutType = fmt.reads(scala.xml.Text(value), Nil) match {
    case Right(x: StrikeoutType) => x
    case x => throw new RuntimeException(s"fromString returned unexpected value $x for input $value")
  }
}

case object Called extends StrikeoutType { override def toString = "called" }
case object Swinging extends StrikeoutType { override def toString = "swinging" }

trait WalkType

object WalkType {
  def fromString(value: String, scope: scala.xml.NamespaceBinding)(implicit fmt: scalaxb.XMLFormat[org.iptc.sportsml.v3.WalkType]): WalkType = fmt.reads(scala.xml.Text(value), Nil) match {
    case Right(x: WalkType) => x
    case x => throw new RuntimeException(s"fromString returned unexpected value $x for input $value")
  }
}

case object IntentionalValue extends WalkType { override def toString = "intentional" }
case object UnintentionalValue extends WalkType { override def toString = "unintentional" }

trait PitchUnits

object PitchUnits {
  def fromString(value: String, scope: scala.xml.NamespaceBinding)(implicit fmt: scalaxb.XMLFormat[org.iptc.sportsml.v3.PitchUnits]): PitchUnits = fmt.reads(scala.xml.Text(value), Nil) match {
    case Right(x: PitchUnits) => x
    case x => throw new RuntimeException(s"fromString returned unexpected value $x for input $value")
  }
}

case object Kph extends PitchUnits { override def toString = "kph" }
case object Mph extends PitchUnits { override def toString = "mph" }

trait StrikeType

object StrikeType {
  def fromString(value: String, scope: scala.xml.NamespaceBinding)(implicit fmt: scalaxb.XMLFormat[org.iptc.sportsml.v3.StrikeType]): StrikeType = fmt.reads(scala.xml.Text(value), Nil) match {
    case Right(x: StrikeType) => x
    case x => throw new RuntimeException(s"fromString returned unexpected value $x for input $value")
  }
}

case object CalledValue extends StrikeType { override def toString = "called" }
case object SwingingValue extends StrikeType { override def toString = "swinging" }
case object Foul extends StrikeType { override def toString = "foul" }

trait UmpireCall

object UmpireCall {
  def fromString(value: String, scope: scala.xml.NamespaceBinding)(implicit fmt: scalaxb.XMLFormat[org.iptc.sportsml.v3.UmpireCall]): UmpireCall = fmt.reads(scala.xml.Text(value), Nil) match {
    case Right(x: UmpireCall) => x
    case x => throw new RuntimeException(s"fromString returned unexpected value $x for input $value")
  }
}

case object Ball extends UmpireCall { override def toString = "ball" }
case object Strike extends UmpireCall { override def toString = "strike" }
case object InPlay extends UmpireCall { override def toString = "in-play" }

trait Turn

object Turn {
  def fromString(value: String, scope: scala.xml.NamespaceBinding)(implicit fmt: scalaxb.XMLFormat[org.iptc.sportsml.v3.Turn]): Turn = fmt.reads(scala.xml.Text(value), Nil) match {
    case Right(x: Turn) => x
    case x => throw new RuntimeException(s"fromString returned unexpected value $x for input $value")
  }
}

case object Inturn extends Turn { override def toString = "inturn" }
case object Outturn extends Turn { override def toString = "outturn" }

trait WinType

object WinType {
  def fromString(value: String, scope: scala.xml.NamespaceBinding)(implicit fmt: scalaxb.XMLFormat[org.iptc.sportsml.v3.WinType]): WinType = fmt.reads(scala.xml.Text(value), Nil) match {
    case Right(x: WinType) => x
    case x => throw new RuntimeException(s"fromString returned unexpected value $x for input $value")
  }
}

case object Forced extends WinType { override def toString = "forced" }
case object Unforced extends WinType { override def toString = "unforced" }

trait BodySideList

object BodySideList {
  def fromString(value: String, scope: scala.xml.NamespaceBinding)(implicit fmt: scalaxb.XMLFormat[org.iptc.sportsml.v3.BodySideList]): BodySideList = fmt.reads(scala.xml.Text(value), Nil) match {
    case Right(x: BodySideList) => x
    case x => throw new RuntimeException(s"fromString returned unexpected value $x for input $value")
  }
}

case object RightType extends BodySideList { override def toString = "right" }
case object LeftType extends BodySideList { override def toString = "left" }
case object Both extends BodySideList { override def toString = "both" }

trait Context

object Context {
  def fromString(value: String, scope: scala.xml.NamespaceBinding)(implicit fmt: scalaxb.XMLFormat[org.iptc.sportsml.v3.Context]): Context = fmt.reads(scala.xml.Text(value), Nil) match {
    case Right(x: Context) => x
    case x => throw new RuntimeException(s"fromString returned unexpected value $x for input $value")
  }
}

case object Opening extends Context { override def toString = "opening" }
case object Closing extends Context { override def toString = "closing" }
case object Current extends Context { override def toString = "current" }


case class BaseEventStateAttributeGroup(minutesElapsed: Option[String] = None,
  periodMinuteElapsed: Option[String] = None,
  periodTimeElapsed: Option[String] = None,
  periodTimeRemaining: Option[String] = None)


case class Wagering2Attributes(bookmakerKey: Option[String] = None,
  bookmakerName: Option[String] = None,
  rotationKey: Option[String] = None,
  comment: Option[String] = None,
  dateTime: Option[String] = None,
  context: Option[org.iptc.sportsml.v3.Context] = None,
  prediction: Option[String] = None,
  predictionOpening: Option[String] = None,
  vigorish: Option[String] = None)


/** List of attributes used in generic stats
*/
case class GenericStatAttributes(sport: Option[String] = None,
  classValue: Option[String] = None,
  statType: Option[String] = None,
  valueType: Option[String] = None,
  valueAttribute: Option[String] = None)


/** Attributes that are used in all tournament constructions.
*/
case class TournamentAttributes(status: Option[String] = None,
  minimumSubparts: Option[BigInt] = None,
  maximumSubparts: Option[BigInt] = None,
  number: Option[BigInt] = None)


case class SoccerActionAttributes(cautionValue: Option[String] = None)


case class GolfActionAttributes(round: Option[BigInt] = None,
  hole: Option[BigInt] = None,
  strokes: Option[BigInt] = None,
  score: Option[BigInt] = None,
  scoreAgainstPar: Option[BigInt] = None,
  club: Option[String] = None,
  startDistance: Option[BigInt] = None,
  endDistance: Option[BigInt] = None,
  landing: Option[String] = None)


case class BaseballActionAttributes(atBatNumber: Option[BigInt] = None,
  balls: Option[BigInt] = None,
  batterAdvance: Option[BigInt] = None,
  batterSide: Option[org.iptc.sportsml.v3.BodySideList] = None,
  earnedRunsScored: Option[BigInt] = None,
  errorType: Option[String] = None,
  hitByPitchType: Option[org.iptc.sportsml.v3.HitByPitchType] = None,
  hitLocation: Option[String] = None,
  hitType: Option[String] = None,
  inningExiting: Option[String] = None,
  inningHalf: Option[org.iptc.sportsml.v3.InningHalf] = None,
  inningValue: Option[BigInt] = None,
  interferenceType: Option[String] = None,
  leadEntering: Option[String] = None,
  leadExiting: Option[String] = None,
  outType: Option[String] = None,
  outs: Option[BigInt] = None,
  outsRecorded: Option[BigInt] = None,
  pitcherSide: Option[org.iptc.sportsml.v3.BodySideList] = None,
  playScorekeepersNotation: Option[String] = None,
  rbi: Option[BigInt] = None,
  runnerOnFirst: Option[Boolean] = None,
  runnerOnFirstAdvance: Option[String] = None,
  runnerOnFirstIdref: Option[String] = None,
  runnerOnSecond: Option[Boolean] = None,
  runnerOnSecondAdvance: Option[String] = None,
  runnerOnSecondIdref: Option[String] = None,
  runnerOnThird: Option[Boolean] = None,
  runnerOnThirdAdvance: Option[String] = None,
  runnerOnThirdIdref: Option[String] = None,
  runnersOnBase: Option[Boolean] = None,
  runsScored: Option[BigInt] = None,
  runsThisInningHalf: Option[BigInt] = None,
  sacrificeType: Option[String] = None,
  strikeoutType: Option[org.iptc.sportsml.v3.StrikeoutType] = None,
  strikes: Option[BigInt] = None,
  trajectoryCoordinates: Option[String] = None,
  velocity: Option[String] = None,
  walkType: Option[org.iptc.sportsml.v3.WalkType] = None,
  ballLocation: Option[String] = None,
  ballLocationHorizontal: Option[String] = None,
  ballLocationVertical: Option[String] = None,
  pitchType: Option[String] = None,
  pitchVelocity: Option[BigDecimal] = None,
  pitchUnits: Option[org.iptc.sportsml.v3.PitchUnits] = None,
  strikeType: Option[org.iptc.sportsml.v3.StrikeType] = None,
  umpireCall: Option[org.iptc.sportsml.v3.UmpireCall] = None)


case class StatAttributes(score: Option[String] = None,
  scoreOpposing: Option[String] = None,
  scoreAverage: Option[String] = None,
  scoreOpposingAverage: Option[String] = None,
  scoreUnits: Option[String] = None,
  scoreBehind: Option[String] = None,
  scoreAttempts: Option[String] = None,
  scoreAttemptsOpposing: Option[String] = None,
  scoreAttemptsOnGoal: Option[String] = None,
  scoreAttemptsOnGoalOpposing: Option[String] = None,
  scorePercentage: Option[String] = None,
  scorePercentageOpposing: Option[String] = None,
  resultEffect: Option[String] = None,
  eventOutcome: Option[String] = None,
  eventStandingPoints: Option[String] = None,
  eventStandingPointsAgainst: Option[String] = None,
  scoreType: Option[String] = None,
  eventsRemaining: Option[String] = None,
  timeOfPossession: Option[String] = None,
  timeOfPossessionPercentage: Option[String] = None,
  timeOfPossessionPercentageOpposing: Option[String] = None,
  timeOfPossessionAverage: Option[String] = None,
  timeOfPossessionAverageOpposing: Option[String] = None,
  seriesScore: Option[String] = None,
  seriesScoreOpposing: Option[String] = None,
  adjustedScoreFor: Option[String] = None,
  adjustedScoreAgainst: Option[String] = None)


case class CurlingEquipmentAttributes(stoneColor: Option[String] = None,
  stoneId: Option[String] = None,
  stoneNumber: Option[BigInt] = None)


case class ParticipantAttributes(idref: String,
  teamIdref: Option[String] = None,
  role: Option[String] = None,
  stoneColor: Option[String] = None,
  stoneId: Option[String] = None,
  stoneNumber: Option[BigInt] = None)


case class ActionAttributes(id: Option[String] = None,
  classValue: Option[String] = None,
  style: Option[String] = None,
  minutesElapsed: Option[String] = None,
  periodMinuteElapsed: Option[String] = None,
  periodTimeElapsed: Option[String] = None,
  periodTimeRemaining: Option[String] = None,
  teamIdref: Option[String] = None,
  opposingTeamIdref: Option[String] = None,
  created: Option[javax.xml.datatype.XMLGregorianCalendar] = None,
  lastModified: Option[javax.xml.datatype.XMLGregorianCalendar] = None,
  dateTime: Option[javax.xml.datatype.XMLGregorianCalendar] = None,
  result: Option[String] = None,
  sequenceNumber: Option[BigInt] = None,
  comment: Option[String] = None,
  typeValue: Option[String] = None,
  timeElapsed: Option[String] = None,
  timeRemaining: Option[String] = None,
  playerCount: Option[BigInt] = None,
  playerCountOpposing: Option[BigInt] = None,
  startLocation: Option[String] = None,
  endLocation: Option[String] = None,
  zone: Option[String] = None,
  powerPlayTimeRemaining: Option[String] = None,
  powerPlayAdvantage: Option[BigInt] = None,
  callerType: Option[String] = None,
  strength: Option[String] = None,
  points: Option[BigInt] = None,
  turnoverType: Option[String] = None,
  periodValue: Option[String] = None,
  periodLength: Option[String] = None,
  scoreTeam: Option[String] = None,
  scoreTeamOpposing: Option[String] = None,
  timeoutsLeft: Option[BigInt] = None,
  timeoutDuration: Option[String] = None,
  timeoutType: Option[String] = None,
  scoreType: Option[String] = None,
  saveType: Option[String] = None,
  saveMethod: Option[String] = None,
  passType: Option[String] = None,
  passDescription: Option[String] = None,
  passMethod: Option[String] = None,
  shotType: Option[String] = None,
  shotDistance: Option[Double] = None,
  shotDistanceUnits: Option[String] = None,
  penaltyType: Option[String] = None,
  penaltyLevel: Option[String] = None,
  penaltyResult: Option[String] = None,
  penaltySide: Option[String] = None,
  penaltyLength: Option[String] = None,
  penaltyName: Option[String] = None,
  penaltyCount: Option[BigInt] = None,
  penaltyStatus: Option[org.iptc.sportsml.v3.PenaltyStatus] = None,
  recipientType: Option[String] = None,
  scoreAttemptType: Option[String] = None,
  scoreAttemptResult: Option[String] = None,
  scoreAttemptSide: Option[org.iptc.sportsml.v3.BodySideList] = None,
  scoreAttemptMethod: Option[String] = None,
  scoreAttemptSituation: Option[String] = None,
  goalZone: Option[String] = None,
  angle: Option[String] = None,
  distance: Option[String] = None,
  bodyPart: Option[String] = None,
  fieldLocation: Option[String] = None,
  goalLocation: Option[String] = None,
  timeAddition: Option[String] = None,
  shootoutShotOrder: Option[BigInt] = None,
  faceoffWinner: Option[String] = None,
  substitutionReason: Option[String] = None,
  touchdownType: Option[String] = None,
  clockState: Option[org.iptc.sportsml.v3.ClockStateType] = None,
  distanceFor1stDown: Option[BigInt] = None,
  fieldSide: Option[org.iptc.sportsml.v3.FieldSideType] = None,
  fieldLine: Option[BigInt] = None,
  drivePlays: Option[BigInt] = None,
  driveYards: Option[BigInt] = None,
  driveDuration: Option[javax.xml.datatype.Duration] = None,
  driveResult: Option[String] = None,
  down: Option[BigInt] = None,
  yardsGained: Option[BigInt] = None,
  penaltyYards: Option[String] = None,
  penaltyAcceptance: Option[String] = None,
  penaltyChallenge: Option[String] = None,
  penaltyReview: Option[String] = None,
  penaltyReviewRuling: Option[String] = None,
  kickType: Option[String] = None,
  atBatNumber: Option[BigInt] = None,
  balls: Option[BigInt] = None,
  batterAdvance: Option[BigInt] = None,
  batterSide: Option[org.iptc.sportsml.v3.BodySideList] = None,
  earnedRunsScored: Option[BigInt] = None,
  errorType: Option[String] = None,
  hitByPitchType: Option[org.iptc.sportsml.v3.HitByPitchType] = None,
  hitLocation: Option[String] = None,
  hitType: Option[String] = None,
  inningExiting: Option[String] = None,
  inningHalf: Option[org.iptc.sportsml.v3.InningHalf] = None,
  inningValue: Option[BigInt] = None,
  interferenceType: Option[String] = None,
  leadEntering: Option[String] = None,
  leadExiting: Option[String] = None,
  outType: Option[String] = None,
  outs: Option[BigInt] = None,
  outsRecorded: Option[BigInt] = None,
  pitcherSide: Option[org.iptc.sportsml.v3.BodySideList] = None,
  playScorekeepersNotation: Option[String] = None,
  rbi: Option[BigInt] = None,
  runnerOnFirst: Option[Boolean] = None,
  runnerOnFirstAdvance: Option[String] = None,
  runnerOnFirstIdref: Option[String] = None,
  runnerOnSecond: Option[Boolean] = None,
  runnerOnSecondAdvance: Option[String] = None,
  runnerOnSecondIdref: Option[String] = None,
  runnerOnThird: Option[Boolean] = None,
  runnerOnThirdAdvance: Option[String] = None,
  runnerOnThirdIdref: Option[String] = None,
  runnersOnBase: Option[Boolean] = None,
  runsScored: Option[BigInt] = None,
  runsThisInningHalf: Option[BigInt] = None,
  sacrificeType: Option[String] = None,
  strikeoutType: Option[org.iptc.sportsml.v3.StrikeoutType] = None,
  strikes: Option[BigInt] = None,
  trajectoryCoordinates: Option[String] = None,
  velocity: Option[String] = None,
  walkType: Option[org.iptc.sportsml.v3.WalkType] = None,
  ballLocation: Option[String] = None,
  ballLocationHorizontal: Option[String] = None,
  ballLocationVertical: Option[String] = None,
  pitchType: Option[String] = None,
  pitchVelocity: Option[BigDecimal] = None,
  pitchUnits: Option[org.iptc.sportsml.v3.PitchUnits] = None,
  strikeType: Option[org.iptc.sportsml.v3.StrikeType] = None,
  umpireCall: Option[org.iptc.sportsml.v3.UmpireCall] = None,
  endNumber: Option[BigInt] = None,
  stoneNumber: Option[BigInt] = None,
  timeUsed: Option[String] = None,
  turn: Option[org.iptc.sportsml.v3.Turn] = None,
  stoneSpeed: Option[String] = None,
  round: Option[BigInt] = None,
  hole: Option[BigInt] = None,
  strokes: Option[BigInt] = None,
  score: Option[BigInt] = None,
  scoreAgainstPar: Option[BigInt] = None,
  club: Option[String] = None,
  startDistance: Option[BigInt] = None,
  endDistance: Option[BigInt] = None,
  landing: Option[String] = None,
  lap: Option[BigInt] = None,
  lapsRemaining: Option[BigInt] = None,
  flagState: Option[String] = None,
  flagOriginal: Option[String] = None,
  flagNew: Option[String] = None,
  passerType: Option[String] = None,
  passerKey: Option[String] = None,
  positionOriginal: Option[String] = None,
  positionNew: Option[String] = None,
  cautionValue: Option[String] = None,
  set: Option[BigInt] = None,
  game: Option[BigInt] = None,
  winType: Option[org.iptc.sportsml.v3.WinType] = None,
  serverScore: Option[String] = None,
  receiverScore: Option[String] = None,
  serveNumber: Option[String] = None)


case class CommonParticipantAttributes(idref: String,
  teamIdref: Option[String] = None,
  role: Option[String] = None)


case class CoverageAttributes(statsCoverage: Option[String] = None,
  teamCoverage: Option[org.iptc.sportsml.v3.TeamCoverage] = None,
  durationScope: Option[String] = None,
  alignmentScope: Option[org.iptc.sportsml.v3.AlignmentScope] = None,
  position: Option[String] = None,
  recordMakingScope: Option[String] = None,
  scopingLabel: Option[String] = None,
  periodValue: Option[String] = None,
  periodType: Option[String] = None,
  startDateTime: Option[String] = None,
  endDateTime: Option[String] = None,
  periodStartDateTime: Option[String] = None,
  periodEndDateTime: Option[String] = None,
  temporalUnitType: Option[String] = None,
  temporalUnitValue: Option[String] = None,
  eventSpan: Option[BigInt] = None,
  opponentValue: Option[String] = None,
  opponentType: Option[String] = None,
  team: Option[String] = None,
  competition: Option[String] = None,
  unitValue: Option[String] = None,
  unitType: Option[String] = None,
  situation: Option[String] = None,
  locationKey: Option[String] = None,
  venueType: Option[String] = None,
  surfaceType: Option[String] = None,
  weatherType: Option[String] = None,
  scopeValue: Option[String] = None,
  distance: Option[String] = None,
  distanceMaximum: Option[String] = None,
  distanceMinimum: Option[String] = None,
  measurementUnits: Option[String] = None)


case class AmericanFootballActionAttributes(touchdownType: Option[String] = None,
  clockState: Option[org.iptc.sportsml.v3.ClockStateType] = None,
  distanceFor1stDown: Option[BigInt] = None,
  fieldSide: Option[org.iptc.sportsml.v3.FieldSideType] = None,
  fieldLine: Option[BigInt] = None,
  drivePlays: Option[BigInt] = None,
  driveYards: Option[BigInt] = None,
  driveDuration: Option[javax.xml.datatype.Duration] = None,
  driveResult: Option[String] = None,
  down: Option[BigInt] = None,
  yardsGained: Option[BigInt] = None,
  penaltyYards: Option[String] = None,
  penaltyAcceptance: Option[String] = None,
  penaltyChallenge: Option[String] = None,
  penaltyReview: Option[String] = None,
  penaltyReviewRuling: Option[String] = None,
  kickType: Option[String] = None)


case class CurlingActionAttributes(endNumber: Option[BigInt] = None,
  stoneNumber: Option[BigInt] = None,
  timeUsed: Option[String] = None,
  turn: Option[org.iptc.sportsml.v3.Turn] = None,
  stoneSpeed: Option[String] = None)


case class MotorRacingActionAttributes(lap: Option[BigInt] = None,
  lapsRemaining: Option[BigInt] = None,
  flagState: Option[String] = None,
  flagOriginal: Option[String] = None,
  flagNew: Option[String] = None,
  passerType: Option[String] = None,
  passerKey: Option[String] = None,
  positionOriginal: Option[String] = None,
  positionNew: Option[String] = None)


case class TennisActionAttributes(set: Option[BigInt] = None,
  game: Option[BigInt] = None,
  winType: Option[org.iptc.sportsml.v3.WinType] = None,
  serverScore: Option[String] = None,
  receiverScore: Option[String] = None,
  serveNumber: Option[String] = None)


case class CommonAttributes(id: Option[String] = None,
  classValue: Option[String] = None,
  style: Option[String] = None)


/** Basic wagering attributes, used in all wagering elements
*/
case class WageringAttributes(bookmakerKey: Option[String] = None,
  bookmakerName: Option[String] = None,
  rotationKey: Option[String] = None,
  comment: Option[String] = None,
  dateTime: Option[String] = None,
  context: Option[org.iptc.sportsml.v3.Context] = None)


case class Wagering3Attributes(bookmakerKey: Option[String] = None,
  bookmakerName: Option[String] = None,
  rotationKey: Option[String] = None,
  comment: Option[String] = None,
  dateTime: Option[String] = None,
  context: Option[org.iptc.sportsml.v3.Context] = None,
  prediction: Option[String] = None,
  predictionOpening: Option[String] = None,
  vigorish: Option[String] = None,
  line: Option[String] = None,
  lineOpening: Option[String] = None)


