// Generated by <a href="http://scalaxb.org/">scalaxb</a>.
package org.iptc.sportsml.v3


/** Tennis scoring: A game is a subpart of a set and a tennis match is played in best of 3 or 5 sets. A set is played within matches and you need 6 games to win the set. Sets are won by two games unless games are tied 6-6, in which case a tie-breaker ensues with the set won 7-6. The tie-break is counted point by point and is won at 7 by a two-point margin. Play will continue past 7 until that margin is achieved. In games the count proceeds from "love" (0) to 15, 30 and 40, after which the game must be won. If it is not 40-40, the player winning the next point has an "advantage" and if winning the next point too it means winning the game. Otherwise it is back to 40-40 and a continued play for advantage followed by a second winning point to win the game. A game won off an opponent's serve is called a break.
*/


/** For holding metadata having to do with a tennis tournament. Includes an attribute for the name of the tennis tour.
*/
case class TennisTournamentMetadataComplexType(tourName: Seq[org.iptc.sportsml.v3.ConceptNameType] = Nil,
  attributes: Map[String, scalaxb.DataRecord[Any]] = Map()) extends TournamentMetadataComplexTypeOption {
  lazy val id = attributes.get("@id") map { _.as[String]}
  lazy val classValue = attributes.get("@class") map { _.as[String]}
  lazy val style = attributes.get("@style") map { _.as[String]}
}

      


/** Metadata about the specific tennis match. | When in the match this document was issued.
*/
case class TennisEventMetadataComplexType(attributes: Map[String, scalaxb.DataRecord[Any]] = Map()) extends EventMetadataComplexTypeOption {
  lazy val set = attributes.get("@set") map { _.as[String]}
  lazy val game = attributes.get("@game") map { _.as[String]}
  lazy val serverIdref = attributes.get("@server-idref") map { _.as[String]}
  lazy val serverScore = attributes.get("@server-score") map { _.as[GameResultu46Tennis]}
  lazy val receiverIdref = attributes.get("@receiver-idref") map { _.as[String]}
  lazy val receiverScore = attributes.get("@receiver-score") map { _.as[GameResultu46Tennis]}
  lazy val serveNumber = attributes.get("@serve-number") map { _.as[ServeNumber]}
  lazy val numberOfSets = attributes.get("@number-of-sets") map { _.as[String]}
}

      


/** Holds tennis-specific stats. Used for singles matches. | Generally having to do with the score of the match.
*/
case class TennisPlayerStatsComplexType(statsTennisService: Seq[org.iptc.sportsml.v3.TennisStatsServiceComplexType] = Nil,
  statsTennisReturn: Seq[org.iptc.sportsml.v3.TennisStatsReturnComplexType] = Nil,
  statsTennisSet: Seq[org.iptc.sportsml.v3.TennisStatsSetComplexType] = Nil,
  attributes: Map[String, scalaxb.DataRecord[Any]] = Map()) extends BaseTennisStatsComplexTypable with PlayerStatsComplexTypeOption {
  lazy val id = attributes.get("@id") map { _.as[String]}
  lazy val classValue = attributes.get("@class") map { _.as[String]}
  lazy val style = attributes.get("@style") map { _.as[String]}
  lazy val statsCoverage = attributes.get("@stats-coverage") map { _.as[String]}
  lazy val teamCoverage = attributes.get("@team-coverage") map { _.as[TeamCoverage]}
  lazy val durationScope = attributes.get("@duration-scope") map { _.as[String]}
  lazy val alignmentScope = attributes.get("@alignment-scope") map { _.as[AlignmentScope]}
  lazy val position = attributes.get("@position") map { _.as[String]}
  lazy val recordMakingScope = attributes.get("@record-making-scope") map { _.as[String]}
  lazy val scopingLabel = attributes.get("@scoping-label") map { _.as[String]}
  lazy val periodValue = attributes.get("@period-value") map { _.as[String]}
  lazy val periodType = attributes.get("@period-type") map { _.as[String]}
  lazy val startDateTime = attributes.get("@start-date-time") map { _.as[String]}
  lazy val endDateTime = attributes.get("@end-date-time") map { _.as[String]}
  lazy val periodStartDateTime = attributes.get("@period-start-date-time") map { _.as[String]}
  lazy val periodEndDateTime = attributes.get("@period-end-date-time") map { _.as[String]}
  lazy val temporalUnitType = attributes.get("@temporal-unit-type") map { _.as[String]}
  lazy val temporalUnitValue = attributes.get("@temporal-unit-value") map { _.as[String]}
  lazy val eventSpan = attributes.get("@event-span") map { _.as[BigInt]}
  lazy val opponentValue = attributes.get("@opponent-value") map { _.as[String]}
  lazy val opponentType = attributes.get("@opponent-type") map { _.as[String]}
  lazy val team = attributes.get("@team") map { _.as[String]}
  lazy val competition = attributes.get("@competition") map { _.as[String]}
  lazy val unitValue = attributes.get("@unit-value") map { _.as[String]}
  lazy val unitType = attributes.get("@unit-type") map { _.as[String]}
  lazy val situation = attributes.get("@situation") map { _.as[String]}
  lazy val locationKey = attributes.get("@location-key") map { _.as[String]}
  lazy val venueType = attributes.get("@venue-type") map { _.as[String]}
  lazy val surfaceType = attributes.get("@surface-type") map { _.as[String]}
  lazy val weatherType = attributes.get("@weather-type") map { _.as[String]}
  lazy val scopeValue = attributes.get("@scope-value") map { _.as[String]}
  lazy val distance = attributes.get("@distance") map { _.as[String]}
  lazy val distanceMaximum = attributes.get("@distance-maximum") map { _.as[String]}
  lazy val distanceMinimum = attributes.get("@distance-minimum") map { _.as[String]}
  lazy val measurementUnits = attributes.get("@measurement-units") map { _.as[String]}
  lazy val netPointsWon = attributes.get("@net-points-won") map { _.as[String]}
  lazy val netPointsPlayed = attributes.get("@net-points-played") map { _.as[String]}
  lazy val netPointsWonPct = attributes.get("@net-points-won-pct") map { _.as[String]}
  lazy val pointsWon = attributes.get("@points-won") map { _.as[String]}
  lazy val winners = attributes.get("@winners") map { _.as[String]}
  lazy val winnersForehand = attributes.get("@winners-forehand") map { _.as[String]}
  lazy val winnersBackhand = attributes.get("@winners-backhand") map { _.as[String]}
  lazy val winnersVolley = attributes.get("@winners-volley") map { _.as[String]}
  lazy val unforcedErrors = attributes.get("@unforced-errors") map { _.as[String]}
}

      


/** Holds tennis-specific stats. Used for doubles matches. | Generally having to do with the score of the match.
*/
case class TennisTeamStatsComplexType(statsTennisService: Seq[org.iptc.sportsml.v3.TennisStatsServiceComplexType] = Nil,
  statsTennisReturn: Seq[org.iptc.sportsml.v3.TennisStatsReturnComplexType] = Nil,
  statsTennisSet: Seq[org.iptc.sportsml.v3.TennisStatsSetComplexType] = Nil,
  attributes: Map[String, scalaxb.DataRecord[Any]] = Map()) extends BaseTennisStatsComplexTypable with TeamStatsComplexTypeOption {
  lazy val id = attributes.get("@id") map { _.as[String]}
  lazy val classValue = attributes.get("@class") map { _.as[String]}
  lazy val style = attributes.get("@style") map { _.as[String]}
  lazy val statsCoverage = attributes.get("@stats-coverage") map { _.as[String]}
  lazy val teamCoverage = attributes.get("@team-coverage") map { _.as[TeamCoverage]}
  lazy val durationScope = attributes.get("@duration-scope") map { _.as[String]}
  lazy val alignmentScope = attributes.get("@alignment-scope") map { _.as[AlignmentScope]}
  lazy val position = attributes.get("@position") map { _.as[String]}
  lazy val recordMakingScope = attributes.get("@record-making-scope") map { _.as[String]}
  lazy val scopingLabel = attributes.get("@scoping-label") map { _.as[String]}
  lazy val periodValue = attributes.get("@period-value") map { _.as[String]}
  lazy val periodType = attributes.get("@period-type") map { _.as[String]}
  lazy val startDateTime = attributes.get("@start-date-time") map { _.as[String]}
  lazy val endDateTime = attributes.get("@end-date-time") map { _.as[String]}
  lazy val periodStartDateTime = attributes.get("@period-start-date-time") map { _.as[String]}
  lazy val periodEndDateTime = attributes.get("@period-end-date-time") map { _.as[String]}
  lazy val temporalUnitType = attributes.get("@temporal-unit-type") map { _.as[String]}
  lazy val temporalUnitValue = attributes.get("@temporal-unit-value") map { _.as[String]}
  lazy val eventSpan = attributes.get("@event-span") map { _.as[BigInt]}
  lazy val opponentValue = attributes.get("@opponent-value") map { _.as[String]}
  lazy val opponentType = attributes.get("@opponent-type") map { _.as[String]}
  lazy val team = attributes.get("@team") map { _.as[String]}
  lazy val competition = attributes.get("@competition") map { _.as[String]}
  lazy val unitValue = attributes.get("@unit-value") map { _.as[String]}
  lazy val unitType = attributes.get("@unit-type") map { _.as[String]}
  lazy val situation = attributes.get("@situation") map { _.as[String]}
  lazy val locationKey = attributes.get("@location-key") map { _.as[String]}
  lazy val venueType = attributes.get("@venue-type") map { _.as[String]}
  lazy val surfaceType = attributes.get("@surface-type") map { _.as[String]}
  lazy val weatherType = attributes.get("@weather-type") map { _.as[String]}
  lazy val scopeValue = attributes.get("@scope-value") map { _.as[String]}
  lazy val distance = attributes.get("@distance") map { _.as[String]}
  lazy val distanceMaximum = attributes.get("@distance-maximum") map { _.as[String]}
  lazy val distanceMinimum = attributes.get("@distance-minimum") map { _.as[String]}
  lazy val measurementUnits = attributes.get("@measurement-units") map { _.as[String]}
  lazy val netPointsWon = attributes.get("@net-points-won") map { _.as[String]}
  lazy val netPointsPlayed = attributes.get("@net-points-played") map { _.as[String]}
  lazy val netPointsWonPct = attributes.get("@net-points-won-pct") map { _.as[String]}
  lazy val pointsWon = attributes.get("@points-won") map { _.as[String]}
  lazy val winners = attributes.get("@winners") map { _.as[String]}
  lazy val winnersForehand = attributes.get("@winners-forehand") map { _.as[String]}
  lazy val winnersBackhand = attributes.get("@winners-backhand") map { _.as[String]}
  lazy val winnersVolley = attributes.get("@winners-volley") map { _.as[String]}
  lazy val unforcedErrors = attributes.get("@unforced-errors") map { _.as[String]}
}

      


/** Holds the score of a set. | Includes an attribute for a set's tiebreaker score.
*/
case class TennisStatsSetComplexType(statsTennisService: Seq[org.iptc.sportsml.v3.TennisStatsServiceComplexType] = Nil,
  statsTennisReturn: Seq[org.iptc.sportsml.v3.TennisStatsReturnComplexType] = Nil,
  statsTennisGame: Seq[org.iptc.sportsml.v3.TennisStatsGameComplexType] = Nil,
  attributes: Map[String, scalaxb.DataRecord[Any]] = Map()) extends BaseTennisStatsComplexTypable {
  lazy val id = attributes.get("@id") map { _.as[String]}
  lazy val classValue = attributes.get("@class") map { _.as[String]}
  lazy val style = attributes.get("@style") map { _.as[String]}
  lazy val statsCoverage = attributes.get("@stats-coverage") map { _.as[String]}
  lazy val teamCoverage = attributes.get("@team-coverage") map { _.as[TeamCoverage]}
  lazy val durationScope = attributes.get("@duration-scope") map { _.as[String]}
  lazy val alignmentScope = attributes.get("@alignment-scope") map { _.as[AlignmentScope]}
  lazy val position = attributes.get("@position") map { _.as[String]}
  lazy val recordMakingScope = attributes.get("@record-making-scope") map { _.as[String]}
  lazy val scopingLabel = attributes.get("@scoping-label") map { _.as[String]}
  lazy val periodValue = attributes.get("@period-value") map { _.as[String]}
  lazy val periodType = attributes.get("@period-type") map { _.as[String]}
  lazy val startDateTime = attributes.get("@start-date-time") map { _.as[String]}
  lazy val endDateTime = attributes.get("@end-date-time") map { _.as[String]}
  lazy val periodStartDateTime = attributes.get("@period-start-date-time") map { _.as[String]}
  lazy val periodEndDateTime = attributes.get("@period-end-date-time") map { _.as[String]}
  lazy val temporalUnitType = attributes.get("@temporal-unit-type") map { _.as[String]}
  lazy val temporalUnitValue = attributes.get("@temporal-unit-value") map { _.as[String]}
  lazy val eventSpan = attributes.get("@event-span") map { _.as[BigInt]}
  lazy val opponentValue = attributes.get("@opponent-value") map { _.as[String]}
  lazy val opponentType = attributes.get("@opponent-type") map { _.as[String]}
  lazy val team = attributes.get("@team") map { _.as[String]}
  lazy val competition = attributes.get("@competition") map { _.as[String]}
  lazy val unitValue = attributes.get("@unit-value") map { _.as[String]}
  lazy val unitType = attributes.get("@unit-type") map { _.as[String]}
  lazy val situation = attributes.get("@situation") map { _.as[String]}
  lazy val locationKey = attributes.get("@location-key") map { _.as[String]}
  lazy val venueType = attributes.get("@venue-type") map { _.as[String]}
  lazy val surfaceType = attributes.get("@surface-type") map { _.as[String]}
  lazy val weatherType = attributes.get("@weather-type") map { _.as[String]}
  lazy val scopeValue = attributes.get("@scope-value") map { _.as[String]}
  lazy val distance = attributes.get("@distance") map { _.as[String]}
  lazy val distanceMaximum = attributes.get("@distance-maximum") map { _.as[String]}
  lazy val distanceMinimum = attributes.get("@distance-minimum") map { _.as[String]}
  lazy val measurementUnits = attributes.get("@measurement-units") map { _.as[String]}
  lazy val netPointsWon = attributes.get("@net-points-won") map { _.as[String]}
  lazy val netPointsPlayed = attributes.get("@net-points-played") map { _.as[String]}
  lazy val netPointsWonPct = attributes.get("@net-points-won-pct") map { _.as[String]}
  lazy val pointsWon = attributes.get("@points-won") map { _.as[String]}
  lazy val winners = attributes.get("@winners") map { _.as[String]}
  lazy val winnersForehand = attributes.get("@winners-forehand") map { _.as[String]}
  lazy val winnersBackhand = attributes.get("@winners-backhand") map { _.as[String]}
  lazy val winnersVolley = attributes.get("@winners-volley") map { _.as[String]}
  lazy val unforcedErrors = attributes.get("@unforced-errors") map { _.as[String]}
  lazy val score = attributes.get("@score") map { _.as[String]}
  lazy val duration = attributes.get("@duration") map { _.as[String]}
  lazy val setNumber = attributes.get("@set-number") map { _.as[String]}
  lazy val scoreTiebreaker = attributes.get("@score-tiebreaker") map { _.as[String]}
}

      


/** Holds the score of a game. | Also holds details of each point.
*/
case class TennisStatsGameComplexType(statsTennisService: Seq[org.iptc.sportsml.v3.TennisStatsServiceComplexType] = Nil,
  statsTennisReturn: Seq[org.iptc.sportsml.v3.TennisStatsReturnComplexType] = Nil,
  attributes: Map[String, scalaxb.DataRecord[Any]] = Map()) extends BaseTennisStatsComplexTypable {
  lazy val id = attributes.get("@id") map { _.as[String]}
  lazy val classValue = attributes.get("@class") map { _.as[String]}
  lazy val style = attributes.get("@style") map { _.as[String]}
  lazy val statsCoverage = attributes.get("@stats-coverage") map { _.as[String]}
  lazy val teamCoverage = attributes.get("@team-coverage") map { _.as[TeamCoverage]}
  lazy val durationScope = attributes.get("@duration-scope") map { _.as[String]}
  lazy val alignmentScope = attributes.get("@alignment-scope") map { _.as[AlignmentScope]}
  lazy val position = attributes.get("@position") map { _.as[String]}
  lazy val recordMakingScope = attributes.get("@record-making-scope") map { _.as[String]}
  lazy val scopingLabel = attributes.get("@scoping-label") map { _.as[String]}
  lazy val periodValue = attributes.get("@period-value") map { _.as[String]}
  lazy val periodType = attributes.get("@period-type") map { _.as[String]}
  lazy val startDateTime = attributes.get("@start-date-time") map { _.as[String]}
  lazy val endDateTime = attributes.get("@end-date-time") map { _.as[String]}
  lazy val periodStartDateTime = attributes.get("@period-start-date-time") map { _.as[String]}
  lazy val periodEndDateTime = attributes.get("@period-end-date-time") map { _.as[String]}
  lazy val temporalUnitType = attributes.get("@temporal-unit-type") map { _.as[String]}
  lazy val temporalUnitValue = attributes.get("@temporal-unit-value") map { _.as[String]}
  lazy val eventSpan = attributes.get("@event-span") map { _.as[BigInt]}
  lazy val opponentValue = attributes.get("@opponent-value") map { _.as[String]}
  lazy val opponentType = attributes.get("@opponent-type") map { _.as[String]}
  lazy val team = attributes.get("@team") map { _.as[String]}
  lazy val competition = attributes.get("@competition") map { _.as[String]}
  lazy val unitValue = attributes.get("@unit-value") map { _.as[String]}
  lazy val unitType = attributes.get("@unit-type") map { _.as[String]}
  lazy val situation = attributes.get("@situation") map { _.as[String]}
  lazy val locationKey = attributes.get("@location-key") map { _.as[String]}
  lazy val venueType = attributes.get("@venue-type") map { _.as[String]}
  lazy val surfaceType = attributes.get("@surface-type") map { _.as[String]}
  lazy val weatherType = attributes.get("@weather-type") map { _.as[String]}
  lazy val scopeValue = attributes.get("@scope-value") map { _.as[String]}
  lazy val distance = attributes.get("@distance") map { _.as[String]}
  lazy val distanceMaximum = attributes.get("@distance-maximum") map { _.as[String]}
  lazy val distanceMinimum = attributes.get("@distance-minimum") map { _.as[String]}
  lazy val measurementUnits = attributes.get("@measurement-units") map { _.as[String]}
  lazy val netPointsWon = attributes.get("@net-points-won") map { _.as[String]}
  lazy val netPointsPlayed = attributes.get("@net-points-played") map { _.as[String]}
  lazy val netPointsWonPct = attributes.get("@net-points-won-pct") map { _.as[String]}
  lazy val pointsWon = attributes.get("@points-won") map { _.as[String]}
  lazy val winners = attributes.get("@winners") map { _.as[String]}
  lazy val winnersForehand = attributes.get("@winners-forehand") map { _.as[String]}
  lazy val winnersBackhand = attributes.get("@winners-backhand") map { _.as[String]}
  lazy val winnersVolley = attributes.get("@winners-volley") map { _.as[String]}
  lazy val unforcedErrors = attributes.get("@unforced-errors") map { _.as[String]}
  lazy val score = attributes.get("@score") map { _.as[GameResultu46Tennis]}
  lazy val duration = attributes.get("@duration") map { _.as[String]}
}

      


/** Basic elements and attributes for tennis statistics
*/
trait BaseTennisStatsComplexTypable {
  def statsTennisService: Seq[org.iptc.sportsml.v3.TennisStatsServiceComplexType]
  def statsTennisReturn: Seq[org.iptc.sportsml.v3.TennisStatsReturnComplexType]
  def id: Option[String]
  def classValue: Option[String]
  def style: Option[String]
  def statsCoverage: Option[String]
  def teamCoverage: Option[org.iptc.sportsml.v3.TeamCoverage]
  def durationScope: Option[String]
  def alignmentScope: Option[org.iptc.sportsml.v3.AlignmentScope]
  def position: Option[String]
  def recordMakingScope: Option[String]
  def scopingLabel: Option[String]
  def periodValue: Option[String]
  def periodType: Option[String]
  def startDateTime: Option[String]
  def endDateTime: Option[String]
  def periodStartDateTime: Option[String]
  def periodEndDateTime: Option[String]
  def temporalUnitType: Option[String]
  def temporalUnitValue: Option[String]
  def eventSpan: Option[BigInt]
  def opponentValue: Option[String]
  def opponentType: Option[String]
  def team: Option[String]
  def competition: Option[String]
  def unitValue: Option[String]
  def unitType: Option[String]
  def situation: Option[String]
  def locationKey: Option[String]
  def venueType: Option[String]
  def surfaceType: Option[String]
  def weatherType: Option[String]
  def scopeValue: Option[String]
  def distance: Option[String]
  def distanceMaximum: Option[String]
  def distanceMinimum: Option[String]
  def measurementUnits: Option[String]
  def netPointsWon: Option[String]
  def netPointsPlayed: Option[String]
  def netPointsWonPct: Option[String]
  def pointsWon: Option[String]
  def winners: Option[String]
  def winnersForehand: Option[String]
  def winnersBackhand: Option[String]
  def winnersVolley: Option[String]
  def unforcedErrors: Option[String]
}


/** Basic elements and attributes for tennis statistics
*/
case class BaseTennisStatsComplexType(statsTennisService: Seq[org.iptc.sportsml.v3.TennisStatsServiceComplexType] = Nil,
  statsTennisReturn: Seq[org.iptc.sportsml.v3.TennisStatsReturnComplexType] = Nil,
  attributes: Map[String, scalaxb.DataRecord[Any]] = Map()) extends BaseTennisStatsComplexTypable {
  lazy val id = attributes.get("@id") map { _.as[String]}
  lazy val classValue = attributes.get("@class") map { _.as[String]}
  lazy val style = attributes.get("@style") map { _.as[String]}
  lazy val statsCoverage = attributes.get("@stats-coverage") map { _.as[String]}
  lazy val teamCoverage = attributes.get("@team-coverage") map { _.as[TeamCoverage]}
  lazy val durationScope = attributes.get("@duration-scope") map { _.as[String]}
  lazy val alignmentScope = attributes.get("@alignment-scope") map { _.as[AlignmentScope]}
  lazy val position = attributes.get("@position") map { _.as[String]}
  lazy val recordMakingScope = attributes.get("@record-making-scope") map { _.as[String]}
  lazy val scopingLabel = attributes.get("@scoping-label") map { _.as[String]}
  lazy val periodValue = attributes.get("@period-value") map { _.as[String]}
  lazy val periodType = attributes.get("@period-type") map { _.as[String]}
  lazy val startDateTime = attributes.get("@start-date-time") map { _.as[String]}
  lazy val endDateTime = attributes.get("@end-date-time") map { _.as[String]}
  lazy val periodStartDateTime = attributes.get("@period-start-date-time") map { _.as[String]}
  lazy val periodEndDateTime = attributes.get("@period-end-date-time") map { _.as[String]}
  lazy val temporalUnitType = attributes.get("@temporal-unit-type") map { _.as[String]}
  lazy val temporalUnitValue = attributes.get("@temporal-unit-value") map { _.as[String]}
  lazy val eventSpan = attributes.get("@event-span") map { _.as[BigInt]}
  lazy val opponentValue = attributes.get("@opponent-value") map { _.as[String]}
  lazy val opponentType = attributes.get("@opponent-type") map { _.as[String]}
  lazy val team = attributes.get("@team") map { _.as[String]}
  lazy val competition = attributes.get("@competition") map { _.as[String]}
  lazy val unitValue = attributes.get("@unit-value") map { _.as[String]}
  lazy val unitType = attributes.get("@unit-type") map { _.as[String]}
  lazy val situation = attributes.get("@situation") map { _.as[String]}
  lazy val locationKey = attributes.get("@location-key") map { _.as[String]}
  lazy val venueType = attributes.get("@venue-type") map { _.as[String]}
  lazy val surfaceType = attributes.get("@surface-type") map { _.as[String]}
  lazy val weatherType = attributes.get("@weather-type") map { _.as[String]}
  lazy val scopeValue = attributes.get("@scope-value") map { _.as[String]}
  lazy val distance = attributes.get("@distance") map { _.as[String]}
  lazy val distanceMaximum = attributes.get("@distance-maximum") map { _.as[String]}
  lazy val distanceMinimum = attributes.get("@distance-minimum") map { _.as[String]}
  lazy val measurementUnits = attributes.get("@measurement-units") map { _.as[String]}
  lazy val netPointsWon = attributes.get("@net-points-won") map { _.as[String]}
  lazy val netPointsPlayed = attributes.get("@net-points-played") map { _.as[String]}
  lazy val netPointsWonPct = attributes.get("@net-points-won-pct") map { _.as[String]}
  lazy val pointsWon = attributes.get("@points-won") map { _.as[String]}
  lazy val winners = attributes.get("@winners") map { _.as[String]}
  lazy val winnersForehand = attributes.get("@winners-forehand") map { _.as[String]}
  lazy val winnersBackhand = attributes.get("@winners-backhand") map { _.as[String]}
  lazy val winnersVolley = attributes.get("@winners-volley") map { _.as[String]}
  lazy val unforcedErrors = attributes.get("@unforced-errors") map { _.as[String]}
}

      


/** Stats for the play where the player served.
*/
case class TennisStatsServiceComplexType(attributes: Map[String, scalaxb.DataRecord[Any]] = Map()) {
  lazy val id = attributes.get("@id") map { _.as[String]}
  lazy val classValue = attributes.get("@class") map { _.as[String]}
  lazy val style = attributes.get("@style") map { _.as[String]}
  lazy val statsCoverage = attributes.get("@stats-coverage") map { _.as[String]}
  lazy val teamCoverage = attributes.get("@team-coverage") map { _.as[TeamCoverage]}
  lazy val durationScope = attributes.get("@duration-scope") map { _.as[String]}
  lazy val alignmentScope = attributes.get("@alignment-scope") map { _.as[AlignmentScope]}
  lazy val position = attributes.get("@position") map { _.as[String]}
  lazy val recordMakingScope = attributes.get("@record-making-scope") map { _.as[String]}
  lazy val scopingLabel = attributes.get("@scoping-label") map { _.as[String]}
  lazy val periodValue = attributes.get("@period-value") map { _.as[String]}
  lazy val periodType = attributes.get("@period-type") map { _.as[String]}
  lazy val startDateTime = attributes.get("@start-date-time") map { _.as[String]}
  lazy val endDateTime = attributes.get("@end-date-time") map { _.as[String]}
  lazy val periodStartDateTime = attributes.get("@period-start-date-time") map { _.as[String]}
  lazy val periodEndDateTime = attributes.get("@period-end-date-time") map { _.as[String]}
  lazy val temporalUnitType = attributes.get("@temporal-unit-type") map { _.as[String]}
  lazy val temporalUnitValue = attributes.get("@temporal-unit-value") map { _.as[String]}
  lazy val eventSpan = attributes.get("@event-span") map { _.as[BigInt]}
  lazy val opponentValue = attributes.get("@opponent-value") map { _.as[String]}
  lazy val opponentType = attributes.get("@opponent-type") map { _.as[String]}
  lazy val team = attributes.get("@team") map { _.as[String]}
  lazy val competition = attributes.get("@competition") map { _.as[String]}
  lazy val unitValue = attributes.get("@unit-value") map { _.as[String]}
  lazy val unitType = attributes.get("@unit-type") map { _.as[String]}
  lazy val situation = attributes.get("@situation") map { _.as[String]}
  lazy val locationKey = attributes.get("@location-key") map { _.as[String]}
  lazy val venueType = attributes.get("@venue-type") map { _.as[String]}
  lazy val surfaceType = attributes.get("@surface-type") map { _.as[String]}
  lazy val weatherType = attributes.get("@weather-type") map { _.as[String]}
  lazy val scopeValue = attributes.get("@scope-value") map { _.as[String]}
  lazy val distance = attributes.get("@distance") map { _.as[String]}
  lazy val distanceMaximum = attributes.get("@distance-maximum") map { _.as[String]}
  lazy val distanceMinimum = attributes.get("@distance-minimum") map { _.as[String]}
  lazy val measurementUnits = attributes.get("@measurement-units") map { _.as[String]}
  lazy val aces = attributes.get("@aces") map { _.as[String]}
  lazy val firstServicesGood = attributes.get("@first-services-good") map { _.as[String]}
  lazy val firstServicesGoodPct = attributes.get("@first-services-good-pct") map { _.as[String]}
  lazy val firstServicesPointsWon = attributes.get("@first-services-points-won") map { _.as[String]}
  lazy val firstServicesPointsWonPct = attributes.get("@first-services-points-won-pct") map { _.as[String]}
  lazy val secondServicesPointsWon = attributes.get("@second-services-points-won") map { _.as[String]}
  lazy val secondServicesPointsWonPct = attributes.get("@second-services-points-won-pct") map { _.as[String]}
  lazy val serviceGamesPlayed = attributes.get("@service-games-played") map { _.as[String]}
  lazy val serviceGamesWon = attributes.get("@service-games-won") map { _.as[String]}
  lazy val serviceGamesWonPct = attributes.get("@service-games-won-pct") map { _.as[String]}
  lazy val breakPointsAgainst = attributes.get("@break-points-against") map { _.as[String]}
  lazy val breakPointsSaved = attributes.get("@break-points-saved") map { _.as[String]}
  lazy val breakPointsSavedPct = attributes.get("@break-points-saved-pct") map { _.as[String]}
  lazy val servePointsPlayed = attributes.get("@serve-points-played") map { _.as[String]}
  lazy val servicePointsWon = attributes.get("@service-points-won") map { _.as[String]}
  lazy val servicePointsWonPct = attributes.get("@service-points-won-pct") map { _.as[String]}
  lazy val doubleFaults = attributes.get("@double-faults") map { _.as[String]}
  lazy val firstServiceTopSpeed = attributes.get("@first-service-top-speed") map { _.as[String]}
  lazy val firstServeAverageSpeed = attributes.get("@first-serve-average-speed") map { _.as[String]}
  lazy val secondServicesGood = attributes.get("@second-services-good") map { _.as[String]}
  lazy val secondServicesGoodPct = attributes.get("@second-services-good-pct") map { _.as[String]}
  lazy val secondServeAverageSpeed = attributes.get("@second-serve-average-speed") map { _.as[String]}
  lazy val speedUnits = attributes.get("@speed-units") map { _.as[String]}
}

      


/** Stats for play where the player is receiving the serve.
*/
case class TennisStatsReturnComplexType(attributes: Map[String, scalaxb.DataRecord[Any]] = Map()) {
  lazy val id = attributes.get("@id") map { _.as[String]}
  lazy val classValue = attributes.get("@class") map { _.as[String]}
  lazy val style = attributes.get("@style") map { _.as[String]}
  lazy val statsCoverage = attributes.get("@stats-coverage") map { _.as[String]}
  lazy val teamCoverage = attributes.get("@team-coverage") map { _.as[TeamCoverage]}
  lazy val durationScope = attributes.get("@duration-scope") map { _.as[String]}
  lazy val alignmentScope = attributes.get("@alignment-scope") map { _.as[AlignmentScope]}
  lazy val position = attributes.get("@position") map { _.as[String]}
  lazy val recordMakingScope = attributes.get("@record-making-scope") map { _.as[String]}
  lazy val scopingLabel = attributes.get("@scoping-label") map { _.as[String]}
  lazy val periodValue = attributes.get("@period-value") map { _.as[String]}
  lazy val periodType = attributes.get("@period-type") map { _.as[String]}
  lazy val startDateTime = attributes.get("@start-date-time") map { _.as[String]}
  lazy val endDateTime = attributes.get("@end-date-time") map { _.as[String]}
  lazy val periodStartDateTime = attributes.get("@period-start-date-time") map { _.as[String]}
  lazy val periodEndDateTime = attributes.get("@period-end-date-time") map { _.as[String]}
  lazy val temporalUnitType = attributes.get("@temporal-unit-type") map { _.as[String]}
  lazy val temporalUnitValue = attributes.get("@temporal-unit-value") map { _.as[String]}
  lazy val eventSpan = attributes.get("@event-span") map { _.as[BigInt]}
  lazy val opponentValue = attributes.get("@opponent-value") map { _.as[String]}
  lazy val opponentType = attributes.get("@opponent-type") map { _.as[String]}
  lazy val team = attributes.get("@team") map { _.as[String]}
  lazy val competition = attributes.get("@competition") map { _.as[String]}
  lazy val unitValue = attributes.get("@unit-value") map { _.as[String]}
  lazy val unitType = attributes.get("@unit-type") map { _.as[String]}
  lazy val situation = attributes.get("@situation") map { _.as[String]}
  lazy val locationKey = attributes.get("@location-key") map { _.as[String]}
  lazy val venueType = attributes.get("@venue-type") map { _.as[String]}
  lazy val surfaceType = attributes.get("@surface-type") map { _.as[String]}
  lazy val weatherType = attributes.get("@weather-type") map { _.as[String]}
  lazy val scopeValue = attributes.get("@scope-value") map { _.as[String]}
  lazy val distance = attributes.get("@distance") map { _.as[String]}
  lazy val distanceMaximum = attributes.get("@distance-maximum") map { _.as[String]}
  lazy val distanceMinimum = attributes.get("@distance-minimum") map { _.as[String]}
  lazy val measurementUnits = attributes.get("@measurement-units") map { _.as[String]}
  lazy val returnsPlayed = attributes.get("@returns-played") map { _.as[String]}
  lazy val receivePointsWon = attributes.get("@receive-points-won") map { _.as[String]}
  lazy val receivePointsWonPct = attributes.get("@receive-points-won-pct") map { _.as[String]}
  lazy val firstServiceReturnPointsWon = attributes.get("@first-service-return-points-won") map { _.as[String]}
  lazy val firstServiceReturnPointsWonPct = attributes.get("@first-service-return-points-won-pct") map { _.as[String]}
  lazy val secondServiceReturnPointsWon = attributes.get("@second-service-return-points-won") map { _.as[String]}
  lazy val secondServiceReturnPointsWonPct = attributes.get("@second-service-return-points-won-pct") map { _.as[String]}
  lazy val returnGamesPlayed = attributes.get("@return-games-played") map { _.as[String]}
  lazy val returnGamesWon = attributes.get("@return-games-won") map { _.as[String]}
  lazy val returnGamesWonPct = attributes.get("@return-games-won-pct") map { _.as[String]}
  lazy val breakPointsPlayed = attributes.get("@break-points-played") map { _.as[String]}
  lazy val breakPointsConverted = attributes.get("@break-points-converted") map { _.as[String]}
  lazy val breakPointsConvertedPct = attributes.get("@break-points-converted-pct") map { _.as[String]}
}

      

trait ServeNumber

object ServeNumber {
  def fromString(value: String, scope: scala.xml.NamespaceBinding)(implicit fmt: scalaxb.XMLFormat[org.iptc.sportsml.v3.ServeNumber]): ServeNumber = fmt.reads(scala.xml.Text(value), Nil) match {
    case Right(x: ServeNumber) => x
    case x => throw new RuntimeException(s"fromString returned unexpected value $x for input $value")
  }
}

case object FirstValue extends ServeNumber { override def toString = "first" }
case object Second extends ServeNumber { override def toString = "second" }

trait GameResultu46Tennis

object GameResultu46Tennis {
  def fromString(value: String, scope: scala.xml.NamespaceBinding)(implicit fmt: scalaxb.XMLFormat[org.iptc.sportsml.v3.GameResultu46Tennis]): GameResultu46Tennis = fmt.reads(scala.xml.Text(value), Nil) match {
    case Right(x: GameResultu46Tennis) => x
    case x => throw new RuntimeException(s"fromString returned unexpected value $x for input $value")
  }
}

case object Love extends GameResultu46Tennis { override def toString = "love" }
case object Number15 extends GameResultu46Tennis { override def toString = "15" }
case object Number30 extends GameResultu46Tennis { override def toString = "30" }
case object Number40 extends GameResultu46Tennis { override def toString = "40" }
case object Game extends GameResultu46Tennis { override def toString = "game" }
case object Ad extends GameResultu46Tennis { override def toString = "ad" }
case object Deuce extends GameResultu46Tennis { override def toString = "deuce" }


/** A group of attributes (set, game, server, server-score, receiver receiver-score, serve-number) that can be used for tennis actions.
*/
case class EventStateTennis(set: Option[String] = None,
  game: Option[String] = None,
  serverIdref: Option[String] = None,
  serverScore: Option[org.iptc.sportsml.v3.GameResultu46Tennis] = None,
  receiverIdref: Option[String] = None,
  receiverScore: Option[org.iptc.sportsml.v3.GameResultu46Tennis] = None,
  serveNumber: Option[org.iptc.sportsml.v3.ServeNumber] = None)


case class StatsTennis(netPointsWon: Option[String] = None,
  netPointsPlayed: Option[String] = None,
  netPointsWonPct: Option[String] = None,
  pointsWon: Option[String] = None,
  winners: Option[String] = None,
  winnersForehand: Option[String] = None,
  winnersBackhand: Option[String] = None,
  winnersVolley: Option[String] = None,
  unforcedErrors: Option[String] = None)


