// Generated by <a href="http://scalaxb.org/">scalaxb</a>.
package org.iptc.sportsml.v3


/** Holds metadata about a golf tournament. | Currently only holds the rank of the team. ???
*/
case class GolfTournamentMetadataComplexType(attributes: Map[String, scalaxb.DataRecord[Any]] = Map()) extends TournamentMetadataComplexTypeOption {
  lazy val id = attributes.get("@id") map { _.as[String]}
  lazy val classValue = attributes.get("@class") map { _.as[String]}
  lazy val style = attributes.get("@style") map { _.as[String]}
}

      


/** Metadata about a particular division within a golf tournament. | Includes information about the course as a whole.
*/
case class GolfTournamentDivisionMetadataComplexType(attributes: Map[String, scalaxb.DataRecord[Any]] = Map()) extends TournamentDivisionMetadataComplexTypeOption {
  lazy val id = attributes.get("@id") map { _.as[String]}
  lazy val classValue = attributes.get("@class") map { _.as[String]}
  lazy val style = attributes.get("@style") map { _.as[String]}
  lazy val courseYardage = attributes.get("@course-yardage") map { _.as[String]}
  lazy val coursePar = attributes.get("@course-par") map { _.as[String]}
}

      


/** Holds event metadata specific to golf. | Includes data about the course on which the event is held.
*/
case class GolfEventMetadataComplexType(attributes: Map[String, scalaxb.DataRecord[Any]] = Map()) extends EventMetadataComplexTypeOption {
  lazy val id = attributes.get("@id") map { _.as[String]}
  lazy val classValue = attributes.get("@class") map { _.as[String]}
  lazy val style = attributes.get("@style") map { _.as[String]}
  lazy val round = attributes.get("@round") map { _.as[String]}
  lazy val hole = attributes.get("@hole") map { _.as[String]}
  lazy val strokes = attributes.get("@strokes") map { _.as[String]}
  lazy val score = attributes.get("@score") map { _.as[String]}
  lazy val scoreAgainstPar = attributes.get("@score-against-par") map { _.as[String]}
  lazy val courseYardage = attributes.get("@course-yardage") map { _.as[String]}
  lazy val coursePar = attributes.get("@course-par") map { _.as[String]}
  lazy val courseRating = attributes.get("@course-rating") map { _.as[String]}
  lazy val slopeRating = attributes.get("@slope-rating") map { _.as[String]}
}

      


/** Holds metadata about a team (foursome perhaps) playing in the match. | Currently only holds the rank of the team.
*/
case class GolfTeamMetadataComplexType(attributes: Map[String, scalaxb.DataRecord[Any]] = Map()) extends BaseGolfMetadataComplexTypable with TeamMetadataComplexTypeOption {
  lazy val id = attributes.get("@id") map { _.as[String]}
  lazy val classValue = attributes.get("@class") map { _.as[String]}
  lazy val style = attributes.get("@style") map { _.as[String]}
  lazy val rank = attributes.get("@rank") map { _.as[String]}
}

      


/** Holds metadata about a golf player. | Currently only holds the rank of the player.
*/
case class GolfPlayerMetadataComplexType(attributes: Map[String, scalaxb.DataRecord[Any]] = Map()) extends BaseGolfMetadataComplexTypable with PlayerMetadataComplexTypeOption {
  lazy val id = attributes.get("@id") map { _.as[String]}
  lazy val classValue = attributes.get("@class") map { _.as[String]}
  lazy val style = attributes.get("@style") map { _.as[String]}
  lazy val rank = attributes.get("@rank") map { _.as[String]}
}

      


/** Holds metadata about a golf player. | Currently only holds the rank of the player.
*/
trait BaseGolfMetadataComplexTypable {
  def id: Option[String]
  def classValue: Option[String]
  def style: Option[String]
  def rank: Option[String]
}


/** Holds metadata about a golf player. | Currently only holds the rank of the player.
*/
case class BaseGolfMetadataComplexType(attributes: Map[String, scalaxb.DataRecord[Any]] = Map()) extends BaseGolfMetadataComplexTypable {
  lazy val id = attributes.get("@id") map { _.as[String]}
  lazy val classValue = attributes.get("@class") map { _.as[String]}
  lazy val style = attributes.get("@style") map { _.as[String]}
  lazy val rank = attributes.get("@rank") map { _.as[String]}
}

      


/** Holds statistics particular to the player. | Includes performance statistics during the timespan described in date-coverage-scope attributes.
*/
case class GolfPlayerStatsComplexType(statsGolf: Option[org.iptc.sportsml.v3.GolfStatsComplexType] = None,
  statsGolfRound: Seq[org.iptc.sportsml.v3.GolfStatsRoundComplexType] = Nil,
  attributes: Map[String, scalaxb.DataRecord[Any]] = Map()) extends BaseGolfStatsComplexTypable with PlayerStatsComplexTypeOption {
  lazy val id = attributes.get("@id") map { _.as[String]}
  lazy val classValue = attributes.get("@class") map { _.as[String]}
  lazy val style = attributes.get("@style") map { _.as[String]}
  lazy val statsCoverage = attributes.get("@stats-coverage") map { _.as[String]}
  lazy val teamCoverage = attributes.get("@team-coverage") map { _.as[TeamCoverage]}
  lazy val durationScope = attributes.get("@duration-scope") map { _.as[String]}
  lazy val alignmentScope = attributes.get("@alignment-scope") map { _.as[AlignmentScope]}
  lazy val position = attributes.get("@position") map { _.as[String]}
  lazy val recordMakingScope = attributes.get("@record-making-scope") map { _.as[String]}
  lazy val scopingLabel = attributes.get("@scoping-label") map { _.as[String]}
  lazy val periodValue = attributes.get("@period-value") map { _.as[String]}
  lazy val periodType = attributes.get("@period-type") map { _.as[String]}
  lazy val startDateTime = attributes.get("@start-date-time") map { _.as[String]}
  lazy val endDateTime = attributes.get("@end-date-time") map { _.as[String]}
  lazy val periodStartDateTime = attributes.get("@period-start-date-time") map { _.as[String]}
  lazy val periodEndDateTime = attributes.get("@period-end-date-time") map { _.as[String]}
  lazy val temporalUnitType = attributes.get("@temporal-unit-type") map { _.as[String]}
  lazy val temporalUnitValue = attributes.get("@temporal-unit-value") map { _.as[String]}
  lazy val eventSpan = attributes.get("@event-span") map { _.as[BigInt]}
  lazy val opponentValue = attributes.get("@opponent-value") map { _.as[String]}
  lazy val opponentType = attributes.get("@opponent-type") map { _.as[String]}
  lazy val team = attributes.get("@team") map { _.as[String]}
  lazy val competition = attributes.get("@competition") map { _.as[String]}
  lazy val unitValue = attributes.get("@unit-value") map { _.as[String]}
  lazy val unitType = attributes.get("@unit-type") map { _.as[String]}
  lazy val situation = attributes.get("@situation") map { _.as[String]}
  lazy val locationKey = attributes.get("@location-key") map { _.as[String]}
  lazy val venueType = attributes.get("@venue-type") map { _.as[String]}
  lazy val surfaceType = attributes.get("@surface-type") map { _.as[String]}
  lazy val weatherType = attributes.get("@weather-type") map { _.as[String]}
  lazy val scopeValue = attributes.get("@scope-value") map { _.as[String]}
  lazy val distance = attributes.get("@distance") map { _.as[String]}
  lazy val distanceMaximum = attributes.get("@distance-maximum") map { _.as[String]}
  lazy val distanceMinimum = attributes.get("@distance-minimum") map { _.as[String]}
  lazy val measurementUnits = attributes.get("@measurement-units") map { _.as[String]}
  lazy val handicap = attributes.get("@handicap") map { _.as[String]}
}

      


/** Holds statistics particular to a team of golf players.
*/
trait BaseGolfStatsComplexTypable {
  def statsGolf: Option[org.iptc.sportsml.v3.GolfStatsComplexType]
  def statsGolfRound: Seq[org.iptc.sportsml.v3.GolfStatsRoundComplexType]
  def id: Option[String]
  def classValue: Option[String]
  def style: Option[String]
  def statsCoverage: Option[String]
  def teamCoverage: Option[org.iptc.sportsml.v3.TeamCoverage]
  def durationScope: Option[String]
  def alignmentScope: Option[org.iptc.sportsml.v3.AlignmentScope]
  def position: Option[String]
  def recordMakingScope: Option[String]
  def scopingLabel: Option[String]
  def periodValue: Option[String]
  def periodType: Option[String]
  def startDateTime: Option[String]
  def endDateTime: Option[String]
  def periodStartDateTime: Option[String]
  def periodEndDateTime: Option[String]
  def temporalUnitType: Option[String]
  def temporalUnitValue: Option[String]
  def eventSpan: Option[BigInt]
  def opponentValue: Option[String]
  def opponentType: Option[String]
  def team: Option[String]
  def competition: Option[String]
  def unitValue: Option[String]
  def unitType: Option[String]
  def situation: Option[String]
  def locationKey: Option[String]
  def venueType: Option[String]
  def surfaceType: Option[String]
  def weatherType: Option[String]
  def scopeValue: Option[String]
  def distance: Option[String]
  def distanceMaximum: Option[String]
  def distanceMinimum: Option[String]
  def measurementUnits: Option[String]
}


/** Holds statistics particular to a team of golf players.
*/
case class BaseGolfStatsComplexType(statsGolf: Option[org.iptc.sportsml.v3.GolfStatsComplexType] = None,
  statsGolfRound: Seq[org.iptc.sportsml.v3.GolfStatsRoundComplexType] = Nil,
  attributes: Map[String, scalaxb.DataRecord[Any]] = Map()) extends BaseGolfStatsComplexTypable {
  lazy val id = attributes.get("@id") map { _.as[String]}
  lazy val classValue = attributes.get("@class") map { _.as[String]}
  lazy val style = attributes.get("@style") map { _.as[String]}
  lazy val statsCoverage = attributes.get("@stats-coverage") map { _.as[String]}
  lazy val teamCoverage = attributes.get("@team-coverage") map { _.as[TeamCoverage]}
  lazy val durationScope = attributes.get("@duration-scope") map { _.as[String]}
  lazy val alignmentScope = attributes.get("@alignment-scope") map { _.as[AlignmentScope]}
  lazy val position = attributes.get("@position") map { _.as[String]}
  lazy val recordMakingScope = attributes.get("@record-making-scope") map { _.as[String]}
  lazy val scopingLabel = attributes.get("@scoping-label") map { _.as[String]}
  lazy val periodValue = attributes.get("@period-value") map { _.as[String]}
  lazy val periodType = attributes.get("@period-type") map { _.as[String]}
  lazy val startDateTime = attributes.get("@start-date-time") map { _.as[String]}
  lazy val endDateTime = attributes.get("@end-date-time") map { _.as[String]}
  lazy val periodStartDateTime = attributes.get("@period-start-date-time") map { _.as[String]}
  lazy val periodEndDateTime = attributes.get("@period-end-date-time") map { _.as[String]}
  lazy val temporalUnitType = attributes.get("@temporal-unit-type") map { _.as[String]}
  lazy val temporalUnitValue = attributes.get("@temporal-unit-value") map { _.as[String]}
  lazy val eventSpan = attributes.get("@event-span") map { _.as[BigInt]}
  lazy val opponentValue = attributes.get("@opponent-value") map { _.as[String]}
  lazy val opponentType = attributes.get("@opponent-type") map { _.as[String]}
  lazy val team = attributes.get("@team") map { _.as[String]}
  lazy val competition = attributes.get("@competition") map { _.as[String]}
  lazy val unitValue = attributes.get("@unit-value") map { _.as[String]}
  lazy val unitType = attributes.get("@unit-type") map { _.as[String]}
  lazy val situation = attributes.get("@situation") map { _.as[String]}
  lazy val locationKey = attributes.get("@location-key") map { _.as[String]}
  lazy val venueType = attributes.get("@venue-type") map { _.as[String]}
  lazy val surfaceType = attributes.get("@surface-type") map { _.as[String]}
  lazy val weatherType = attributes.get("@weather-type") map { _.as[String]}
  lazy val scopeValue = attributes.get("@scope-value") map { _.as[String]}
  lazy val distance = attributes.get("@distance") map { _.as[String]}
  lazy val distanceMaximum = attributes.get("@distance-maximum") map { _.as[String]}
  lazy val distanceMinimum = attributes.get("@distance-minimum") map { _.as[String]}
  lazy val measurementUnits = attributes.get("@measurement-units") map { _.as[String]}
}

      


case class GolfStatsComplexType(attributes: Map[String, scalaxb.DataRecord[Any]] = Map()) {
  lazy val id = attributes.get("@id") map { _.as[String]}
  lazy val classValue = attributes.get("@class") map { _.as[String]}
  lazy val style = attributes.get("@style") map { _.as[String]}
  lazy val statsCoverage = attributes.get("@stats-coverage") map { _.as[String]}
  lazy val teamCoverage = attributes.get("@team-coverage") map { _.as[TeamCoverage]}
  lazy val durationScope = attributes.get("@duration-scope") map { _.as[String]}
  lazy val alignmentScope = attributes.get("@alignment-scope") map { _.as[AlignmentScope]}
  lazy val position = attributes.get("@position") map { _.as[String]}
  lazy val recordMakingScope = attributes.get("@record-making-scope") map { _.as[String]}
  lazy val scopingLabel = attributes.get("@scoping-label") map { _.as[String]}
  lazy val periodValue = attributes.get("@period-value") map { _.as[String]}
  lazy val periodType = attributes.get("@period-type") map { _.as[String]}
  lazy val startDateTime = attributes.get("@start-date-time") map { _.as[String]}
  lazy val endDateTime = attributes.get("@end-date-time") map { _.as[String]}
  lazy val periodStartDateTime = attributes.get("@period-start-date-time") map { _.as[String]}
  lazy val periodEndDateTime = attributes.get("@period-end-date-time") map { _.as[String]}
  lazy val temporalUnitType = attributes.get("@temporal-unit-type") map { _.as[String]}
  lazy val temporalUnitValue = attributes.get("@temporal-unit-value") map { _.as[String]}
  lazy val eventSpan = attributes.get("@event-span") map { _.as[BigInt]}
  lazy val opponentValue = attributes.get("@opponent-value") map { _.as[String]}
  lazy val opponentType = attributes.get("@opponent-type") map { _.as[String]}
  lazy val team = attributes.get("@team") map { _.as[String]}
  lazy val competition = attributes.get("@competition") map { _.as[String]}
  lazy val unitValue = attributes.get("@unit-value") map { _.as[String]}
  lazy val unitType = attributes.get("@unit-type") map { _.as[String]}
  lazy val situation = attributes.get("@situation") map { _.as[String]}
  lazy val locationKey = attributes.get("@location-key") map { _.as[String]}
  lazy val venueType = attributes.get("@venue-type") map { _.as[String]}
  lazy val surfaceType = attributes.get("@surface-type") map { _.as[String]}
  lazy val weatherType = attributes.get("@weather-type") map { _.as[String]}
  lazy val scopeValue = attributes.get("@scope-value") map { _.as[String]}
  lazy val distance = attributes.get("@distance") map { _.as[String]}
  lazy val distanceMaximum = attributes.get("@distance-maximum") map { _.as[String]}
  lazy val distanceMinimum = attributes.get("@distance-minimum") map { _.as[String]}
  lazy val measurementUnits = attributes.get("@measurement-units") map { _.as[String]}
  lazy val rounds = attributes.get("@rounds") map { _.as[String]}
  lazy val average = attributes.get("@average") map { _.as[String]}
  lazy val distanceLongest = attributes.get("@distance-longest") map { _.as[String]}
  lazy val distanceRank = attributes.get("@distance-rank") map { _.as[String]}
  lazy val drives = attributes.get("@drives") map { _.as[String]}
  lazy val totalRounds = attributes.get("@total-rounds") map { _.as[String]}
  lazy val totalStrokes = attributes.get("@total-strokes") map { _.as[String]}
  lazy val totalHoles = attributes.get("@total-holes") map { _.as[String]}
  lazy val totalPutts = attributes.get("@total-putts") map { _.as[String]}
  lazy val totalPoints = attributes.get("@total-points") map { _.as[String]}
  lazy val totalDriving = attributes.get("@total-driving") map { _.as[String]}
  lazy val totalParOrLess = attributes.get("@total-par-or-less") map { _.as[String]}
  lazy val birdies = attributes.get("@birdies") map { _.as[String]}
  lazy val birdiesRank = attributes.get("@birdies-rank") map { _.as[String]}
  lazy val eagles = attributes.get("@eagles") map { _.as[String]}
  lazy val eaglesRank = attributes.get("@eagles-rank") map { _.as[String]}
  lazy val saves = attributes.get("@saves") map { _.as[String]}
  lazy val savesRank = attributes.get("@saves-rank") map { _.as[String]}
  lazy val bunkers = attributes.get("@bunkers") map { _.as[String]}
  lazy val eaglePerHolesFrequency = attributes.get("@eagle-per-holes-frequency") map { _.as[String]}
  lazy val greensHit = attributes.get("@greens-hit") map { _.as[String]}
  lazy val greensHitRank = attributes.get("@greens-hit-rank") map { _.as[String]}
  lazy val greensInRegulationMissed = attributes.get("@greens-in-regulation-missed") map { _.as[String]}
  lazy val greensInRegulationPutting = attributes.get("@greens-in-regulation-putting") map { _.as[String]}
  lazy val greensInRegulationRank = attributes.get("@greens-in-regulation-rank") map { _.as[String]}
  lazy val fairwaysHit = attributes.get("@fairways-hit") map { _.as[String]}
  lazy val fairwaysPossible = attributes.get("@fairways-possible") map { _.as[String]}
  lazy val puttsPerRound = attributes.get("@putts-per-round") map { _.as[String]}
  lazy val puttsPerRoundRank = attributes.get("@putts-per-round-rank") map { _.as[String]}
  lazy val holesUnderPar = attributes.get("@holes-under-par") map { _.as[String]}
  lazy val scoringAdjustment = attributes.get("@scoring-adjustment") map { _.as[String]}
  lazy val finishesTop10 = attributes.get("@finishes-top-10") map { _.as[String]}
  lazy val finishesFirstPlace = attributes.get("@finishes-first-place") map { _.as[String]}
  lazy val finishesSecondPlace = attributes.get("@finishes-second-place") map { _.as[String]}
  lazy val performanceParu453 = attributes.get("@performance-par-3") map { _.as[String]}
  lazy val performanceParu454 = attributes.get("@performance-par-4") map { _.as[String]}
  lazy val performanceParu455 = attributes.get("@performance-par-5") map { _.as[String]}
  lazy val money = attributes.get("@money") map { _.as[String]}
  lazy val moneyValue = attributes.get("@money-value") map { _.as[String]}
  lazy val points = attributes.get("@points") map { _.as[String]}
  lazy val pointsLost = attributes.get("@points-lost") map { _.as[String]}
  lazy val pointsGained = attributes.get("@points-gained") map { _.as[String]}
  lazy val driveAccuracy = attributes.get("@drive-accuracy") map { _.as[String]}
  lazy val driveAccuracyRank = attributes.get("@drive-accuracy-rank") map { _.as[String]}
  lazy val roundsUnderPar = attributes.get("@rounds-under-par") map { _.as[String]}
  lazy val bogeys = attributes.get("@bogeys") map { _.as[String]}
  lazy val bogeysRank = attributes.get("@bogeys-rank") map { _.as[String]}
  lazy val doubleBogeys = attributes.get("@double-bogeys") map { _.as[String]}
  lazy val doubleBogeysRank = attributes.get("@double-bogeys-rank") map { _.as[String]}
  lazy val finishOther = attributes.get("@finish-other") map { _.as[String]}
  lazy val finishOtherRank = attributes.get("@finish-other-rank") map { _.as[String]}
  lazy val pars = attributes.get("@pars") map { _.as[String]}
  lazy val parsRank = attributes.get("@pars-rank") map { _.as[String]}
}

      


/** Statistics pertinent to a round within a tournament. | Allows for hole-by-hole breakdowns.
*/
case class GolfStatsRoundComplexType(statsGolf: Option[org.iptc.sportsml.v3.GolfStatsComplexType] = None,
  statsGolfHole: Seq[org.iptc.sportsml.v3.GolfStatsHoleComplexType] = Nil,
  attributes: Map[String, scalaxb.DataRecord[Any]] = Map()) {
  lazy val id = attributes.get("@id") map { _.as[String]}
  lazy val classValue = attributes.get("@class") map { _.as[String]}
  lazy val style = attributes.get("@style") map { _.as[String]}
  lazy val statsCoverage = attributes.get("@stats-coverage") map { _.as[String]}
  lazy val teamCoverage = attributes.get("@team-coverage") map { _.as[TeamCoverage]}
  lazy val durationScope = attributes.get("@duration-scope") map { _.as[String]}
  lazy val alignmentScope = attributes.get("@alignment-scope") map { _.as[AlignmentScope]}
  lazy val position = attributes.get("@position") map { _.as[String]}
  lazy val recordMakingScope = attributes.get("@record-making-scope") map { _.as[String]}
  lazy val scopingLabel = attributes.get("@scoping-label") map { _.as[String]}
  lazy val periodValue = attributes.get("@period-value") map { _.as[String]}
  lazy val periodType = attributes.get("@period-type") map { _.as[String]}
  lazy val startDateTime = attributes.get("@start-date-time") map { _.as[String]}
  lazy val endDateTime = attributes.get("@end-date-time") map { _.as[String]}
  lazy val periodStartDateTime = attributes.get("@period-start-date-time") map { _.as[String]}
  lazy val periodEndDateTime = attributes.get("@period-end-date-time") map { _.as[String]}
  lazy val temporalUnitType = attributes.get("@temporal-unit-type") map { _.as[String]}
  lazy val temporalUnitValue = attributes.get("@temporal-unit-value") map { _.as[String]}
  lazy val eventSpan = attributes.get("@event-span") map { _.as[BigInt]}
  lazy val opponentValue = attributes.get("@opponent-value") map { _.as[String]}
  lazy val opponentType = attributes.get("@opponent-type") map { _.as[String]}
  lazy val team = attributes.get("@team") map { _.as[String]}
  lazy val competition = attributes.get("@competition") map { _.as[String]}
  lazy val unitValue = attributes.get("@unit-value") map { _.as[String]}
  lazy val unitType = attributes.get("@unit-type") map { _.as[String]}
  lazy val situation = attributes.get("@situation") map { _.as[String]}
  lazy val locationKey = attributes.get("@location-key") map { _.as[String]}
  lazy val venueType = attributes.get("@venue-type") map { _.as[String]}
  lazy val surfaceType = attributes.get("@surface-type") map { _.as[String]}
  lazy val weatherType = attributes.get("@weather-type") map { _.as[String]}
  lazy val scopeValue = attributes.get("@scope-value") map { _.as[String]}
  lazy val distance = attributes.get("@distance") map { _.as[String]}
  lazy val distanceMaximum = attributes.get("@distance-maximum") map { _.as[String]}
  lazy val distanceMinimum = attributes.get("@distance-minimum") map { _.as[String]}
  lazy val measurementUnits = attributes.get("@measurement-units") map { _.as[String]}
  lazy val par = attributes.get("@par") map { _.as[String]}
  lazy val strokes = attributes.get("@strokes") map { _.as[String]}
  lazy val score = attributes.get("@score") map { _.as[String]}
  lazy val scoreAgainstPar = attributes.get("@score-against-par") map { _.as[String]}
  lazy val roundNumber = attributes.get("@round-number") map { _.as[String]}
}

      

trait HoleType

object HoleType {
  def fromString(value: String, scope: scala.xml.NamespaceBinding)(implicit fmt: scalaxb.XMLFormat[org.iptc.sportsml.v3.HoleType]): HoleType = fmt.reads(scala.xml.Text(value), Nil) match {
    case Right(x: HoleType) => x
    case x => throw new RuntimeException(s"fromString returned unexpected value $x for input $value")
  }
}

case object Regular extends HoleType { override def toString = "regular" }
case object Playoff extends HoleType { override def toString = "playoff" }
case object SuddenDeath extends HoleType { override def toString = "sudden-death" }


/** Statistics pertinent to a particular hole within a golf round. | Includes what score was recorded at that hole, and the par value of the hole.
*/
case class GolfStatsHoleComplexType(attributes: Map[String, scalaxb.DataRecord[Any]] = Map()) {
  lazy val id = attributes.get("@id") map { _.as[String]}
  lazy val classValue = attributes.get("@class") map { _.as[String]}
  lazy val style = attributes.get("@style") map { _.as[String]}
  lazy val statsCoverage = attributes.get("@stats-coverage") map { _.as[String]}
  lazy val teamCoverage = attributes.get("@team-coverage") map { _.as[TeamCoverage]}
  lazy val durationScope = attributes.get("@duration-scope") map { _.as[String]}
  lazy val alignmentScope = attributes.get("@alignment-scope") map { _.as[AlignmentScope]}
  lazy val position = attributes.get("@position") map { _.as[String]}
  lazy val recordMakingScope = attributes.get("@record-making-scope") map { _.as[String]}
  lazy val scopingLabel = attributes.get("@scoping-label") map { _.as[String]}
  lazy val periodValue = attributes.get("@period-value") map { _.as[String]}
  lazy val periodType = attributes.get("@period-type") map { _.as[String]}
  lazy val startDateTime = attributes.get("@start-date-time") map { _.as[String]}
  lazy val endDateTime = attributes.get("@end-date-time") map { _.as[String]}
  lazy val periodStartDateTime = attributes.get("@period-start-date-time") map { _.as[String]}
  lazy val periodEndDateTime = attributes.get("@period-end-date-time") map { _.as[String]}
  lazy val temporalUnitType = attributes.get("@temporal-unit-type") map { _.as[String]}
  lazy val temporalUnitValue = attributes.get("@temporal-unit-value") map { _.as[String]}
  lazy val eventSpan = attributes.get("@event-span") map { _.as[BigInt]}
  lazy val opponentValue = attributes.get("@opponent-value") map { _.as[String]}
  lazy val opponentType = attributes.get("@opponent-type") map { _.as[String]}
  lazy val team = attributes.get("@team") map { _.as[String]}
  lazy val competition = attributes.get("@competition") map { _.as[String]}
  lazy val unitValue = attributes.get("@unit-value") map { _.as[String]}
  lazy val unitType = attributes.get("@unit-type") map { _.as[String]}
  lazy val situation = attributes.get("@situation") map { _.as[String]}
  lazy val locationKey = attributes.get("@location-key") map { _.as[String]}
  lazy val venueType = attributes.get("@venue-type") map { _.as[String]}
  lazy val surfaceType = attributes.get("@surface-type") map { _.as[String]}
  lazy val weatherType = attributes.get("@weather-type") map { _.as[String]}
  lazy val scopeValue = attributes.get("@scope-value") map { _.as[String]}
  lazy val distance = attributes.get("@distance") map { _.as[String]}
  lazy val distanceMaximum = attributes.get("@distance-maximum") map { _.as[String]}
  lazy val distanceMinimum = attributes.get("@distance-minimum") map { _.as[String]}
  lazy val measurementUnits = attributes.get("@measurement-units") map { _.as[String]}
  lazy val par = attributes.get("@par") map { _.as[String]}
  lazy val strokes = attributes.get("@strokes") map { _.as[String]}
  lazy val score = attributes.get("@score") map { _.as[String]}
  lazy val scoreAgainstPar = attributes.get("@score-against-par") map { _.as[String]}
  lazy val holeType = attributes.get("@hole-type") map { _.as[HoleType]}
  lazy val hole = attributes.get("@hole") map { _.as[String]}
}

      


case class EventStateGolf(round: Option[String] = None,
  hole: Option[String] = None,
  strokes: Option[String] = None,
  score: Option[String] = None,
  scoreAgainstPar: Option[String] = None)


case class BaseGolfStats(id: Option[String] = None,
  classValue: Option[String] = None,
  style: Option[String] = None,
  statsCoverage: Option[String] = None,
  teamCoverage: Option[org.iptc.sportsml.v3.TeamCoverage] = None,
  durationScope: Option[String] = None,
  alignmentScope: Option[org.iptc.sportsml.v3.AlignmentScope] = None,
  position: Option[String] = None,
  recordMakingScope: Option[String] = None,
  scopingLabel: Option[String] = None,
  periodValue: Option[String] = None,
  periodType: Option[String] = None,
  startDateTime: Option[String] = None,
  endDateTime: Option[String] = None,
  periodStartDateTime: Option[String] = None,
  periodEndDateTime: Option[String] = None,
  temporalUnitType: Option[String] = None,
  temporalUnitValue: Option[String] = None,
  eventSpan: Option[BigInt] = None,
  opponentValue: Option[String] = None,
  opponentType: Option[String] = None,
  team: Option[String] = None,
  competition: Option[String] = None,
  unitValue: Option[String] = None,
  unitType: Option[String] = None,
  situation: Option[String] = None,
  locationKey: Option[String] = None,
  venueType: Option[String] = None,
  surfaceType: Option[String] = None,
  weatherType: Option[String] = None,
  scopeValue: Option[String] = None,
  distance: Option[String] = None,
  distanceMaximum: Option[String] = None,
  distanceMinimum: Option[String] = None,
  measurementUnits: Option[String] = None,
  par: Option[String] = None,
  strokes: Option[String] = None,
  score: Option[String] = None,
  scoreAgainstPar: Option[String] = None)


