/*
 * Decompiled with CFR 0.152.
 */
package net.sigmalab.graph;

import java.util.ArrayList;
import java.util.List;
import javolution.lang.ValueType;
import javolution.text.Text;
import net.sigmalab.graph.GraphUtils;
import net.sigmalab.graph.INode;
import net.sigmalab.graph.INodeVisitor;
import net.sigmalab.graph.IVisitableNode;
import org.jscience.mathematics.structure.GroupAdditive;
import org.jscience.mathematics.structure.GroupMultiplicative;

public class Expression<T extends ValueType>
implements IVisitableNode<T> {
    private List<INode<T>> operands = new ArrayList<INode<T>>();
    private Op opCode;

    public String toString() {
        return "Expression [opCode=" + (Object)((Object)this.opCode) + ", operands=" + this.operands + "] evals to: " + this.evaluate().toString();
    }

    public static <T extends ValueType> Expression<T> Add(T ... values) {
        return new Expression<T>(Op.Add, GraphUtils.valsToNodes(values).toArray(new INode[values.length]));
    }

    public static <T extends ValueType> Expression<T> Multiply(T ... values) {
        return new Expression<T>(Op.Multiply, GraphUtils.valsToNodes(values).toArray(new INode[values.length]));
    }

    public static <T extends ValueType> Expression<T> Subtract(T ... values) {
        return new Expression<T>(Op.Subtract, GraphUtils.valsToNodes(values).toArray(new INode[values.length]));
    }

    public static <T extends ValueType> Expression<T> Divide(T ... values) {
        return new Expression<T>(Op.Divide, GraphUtils.valsToNodes(values).toArray(new INode[values.length]));
    }

    public static <T extends ValueType> Expression<T> Concat(T ... values) {
        return new Expression<T>(Op.Concat, GraphUtils.valsToNodes(values).toArray(new INode[values.length]));
    }

    public Expression(Op opCode, INode<T> ... operands) {
        this.operands.clear();
        for (INode<T> operand : operands) {
            this.operands.add(operand);
        }
        this.opCode = opCode;
    }

    public Expression(Op opCode, T ... operands) {
        this.operands.clear();
        for (int i = 0; i < operands.length; ++i) {
            this.operands.add(GraphUtils.valToNode(operands[i]));
        }
        this.opCode = opCode;
    }

    @Override
    public T evaluate() {
        T firstOperand;
        this.assertOperandsInStructure();
        Object result = firstOperand = this.operands.get(0).evaluate();
        switch (this.opCode) {
            case Add: {
                for (int i = 1; i < this.operands.size(); ++i) {
                    INode<T> node = this.operands.get(i);
                    result = (ValueType)((GroupAdditive)node.evaluate()).plus(result);
                }
                break;
            }
            case Subtract: {
                for (int i = 1; i < this.operands.size(); ++i) {
                    INode<T> node = this.operands.get(i);
                    result = (ValueType)((GroupAdditive)((GroupAdditive)node.evaluate()).opposite()).plus(result);
                }
                break;
            }
            case Multiply: {
                for (int i = 1; i < this.operands.size(); ++i) {
                    INode<T> node = this.operands.get(i);
                    result = (ValueType)((GroupMultiplicative)node.evaluate()).times(result);
                }
                break;
            }
            case Divide: {
                for (int i = 1; i < this.operands.size(); ++i) {
                    INode<T> node = this.operands.get(i);
                    result = (ValueType)((GroupMultiplicative)((GroupMultiplicative)node.evaluate()).inverse()).times(result);
                }
                break;
            }
            case Concat: {
                for (int i = 1; i < this.operands.size(); ++i) {
                    INode<T> node = this.operands.get(i);
                    result = ((Text)result).concat((Text)node.evaluate());
                }
                break;
            }
            default: {
                throw new UnsupportedOperationException("Operation not supported.");
            }
        }
        return result;
    }

    private void assertOperandsInStructure() {
        switch (this.opCode) {
            case Add: {
                for (INode<T> node : this.operands) {
                    if (node.evaluate() instanceof GroupAdditive) continue;
                    throw new UnsupportedOperationException("Not additive group.");
                }
                break;
            }
            case Divide: {
                for (INode<T> node : this.operands) {
                    if (node.evaluate() instanceof GroupMultiplicative) continue;
                    throw new UnsupportedOperationException("Not multiplicative group.");
                }
                break;
            }
            case Multiply: {
                for (INode<T> node : this.operands) {
                    if (node.evaluate() instanceof GroupMultiplicative) continue;
                    throw new UnsupportedOperationException("Not multiplicative group.");
                }
                break;
            }
            case Subtract: {
                for (INode<T> node : this.operands) {
                    if (node.evaluate() instanceof GroupAdditive) continue;
                    throw new UnsupportedOperationException("Not additive group.");
                }
                break;
            }
            case Concat: {
                for (INode<T> node : this.operands) {
                    if (node.evaluate() instanceof Text) continue;
                    throw new UnsupportedOperationException("Not text.");
                }
                break;
            }
        }
    }

    @Override
    public void accept(INodeVisitor visitor) {
        visitor.visit(this);
        for (INode<T> node : this.operands) {
            if (node instanceof IVisitableNode) {
                ((IVisitableNode)node).accept(visitor);
                continue;
            }
            throw new UnsupportedOperationException("Node not visitable");
        }
    }

    public static enum Op {
        Add,
        Multiply,
        Subtract,
        Divide,
        Concat;

    }
}

