/*
 * Decompiled with CFR 0.152.
 */
package net.servicestack.client;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.net.CookieHandler;
import java.net.CookieManager;
import java.net.HttpCookie;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.servicestack.client.ConnectionFilter;
import net.servicestack.client.ExceptionFilter;
import net.servicestack.client.GetAccessToken;
import net.servicestack.client.GetAccessTokenResponse;
import net.servicestack.client.IDelete;
import net.servicestack.client.IGet;
import net.servicestack.client.IPatch;
import net.servicestack.client.IPost;
import net.servicestack.client.IPut;
import net.servicestack.client.IReturn;
import net.servicestack.client.IReturnVoid;
import net.servicestack.client.JsonSerializers;
import net.servicestack.client.Log;
import net.servicestack.client.RefreshTokenException;
import net.servicestack.client.ServiceClient;
import net.servicestack.client.TimeSpan;
import net.servicestack.client.Utils;
import net.servicestack.client.WebServiceException;

public class JsonServiceClient
implements ServiceClient {
    static Charset UTF8 = Charset.forName("UTF-8");
    String baseUrl;
    URI baseUri;
    String replyUrl;
    boolean alwaysSendBasicAuthHeaders;
    String userName;
    String password;
    String bearerToken;
    String refreshToken;
    Integer timeoutMs;
    public ConnectionFilter RequestFilter;
    public ConnectionFilter ResponseFilter;
    public ExceptionFilter ExceptionFilter;
    public static ConnectionFilter GlobalRequestFilter;
    public static ConnectionFilter GlobalResponseFilter;
    public static ExceptionFilter GlobalExceptionFilter;
    Gson gson;

    public JsonServiceClient(String baseUrl) {
        this(baseUrl, true);
    }

    public JsonServiceClient(String baseUrl, boolean initCookies) {
        this.setBaseUrl(baseUrl);
        if (initCookies) {
            this.initCookieHandler();
        }
    }

    public void initCookieHandler() {
        if (CookieHandler.getDefault() == null) {
            CookieHandler.setDefault(new CookieManager());
        }
    }

    public void setBaseUrl(String baseUrl) {
        this.baseUrl = baseUrl.endsWith("/") ? baseUrl : baseUrl + "/";
        try {
            this.baseUri = new URI(this.baseUrl);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
        this.replyUrl = this.baseUrl + "json/reply/";
    }

    public void setTimeout(int timeoutMs) {
        this.timeoutMs = timeoutMs;
    }

    public GsonBuilder getGsonBuilder() {
        return new GsonBuilder().registerTypeAdapterFactory(JsonSerializers.getCaseInsensitiveEnumTypeAdapterFactory()).registerTypeAdapter(Date.class, JsonSerializers.getDateSerializer()).registerTypeAdapter(Date.class, JsonSerializers.getDateDeserializer()).registerTypeAdapter(TimeSpan.class, JsonSerializers.getTimeSpanSerializer()).registerTypeAdapter(TimeSpan.class, JsonSerializers.getTimeSpanDeserializer()).registerTypeAdapter(UUID.class, JsonSerializers.getGuidSerializer()).registerTypeAdapter(UUID.class, JsonSerializers.getGuidDeserializer()).registerTypeAdapter(byte[].class, JsonSerializers.getByteArraySerializer()).registerTypeAdapter(byte[].class, JsonSerializers.getByteArrayDeserializer());
    }

    public Gson getGson() {
        if (this.gson == null) {
            this.gson = this.getGsonBuilder().disableHtmlEscaping().create();
        }
        return this.gson;
    }

    public String toJson(Object o) {
        String json = this.getGson().toJson(o);
        return json;
    }

    public Object fromJson(String json, Class c) {
        Object o = this.getGson().fromJson(json, c);
        return o;
    }

    public void setGson(Gson gson) {
        this.gson = gson;
    }

    public String createUrl(Object requestDto) {
        return this.createUrl(requestDto, null);
    }

    public String createUrl(Object requestDto, Map<String, String> query) {
        String requestUrl = this.replyUrl + requestDto.getClass().getSimpleName();
        StringBuilder sb = new StringBuilder();
        Object lastField = null;
        try {
            for (Field f : Utils.getSerializableFields(requestDto.getClass())) {
                Object val = f.get(requestDto);
                if (val == null) continue;
                sb.append(sb.length() == 0 ? "?" : "&");
                sb.append(URLEncoder.encode(f.getName(), "UTF-8"));
                sb.append("=");
                sb.append(URLEncoder.encode(Utils.stripQuotes(this.getGson().toJson(val)), "UTF-8"));
            }
            if (query != null) {
                for (Map.Entry entry : query.entrySet()) {
                    String key = (String)entry.getKey();
                    String val = (String)entry.getValue();
                    sb.append(sb.length() == 0 ? "?" : "&");
                    sb.append(URLEncoder.encode(key, "UTF-8"));
                    sb.append("=");
                    if (val == null) continue;
                    sb.append(URLEncoder.encode(val, "UTF-8"));
                }
            }
        }
        catch (UnsupportedEncodingException | IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        return requestUrl + sb.toString();
    }

    public HttpURLConnection createRequest(String requestUrl, String httpMethod, byte[] requestBody, String requestType) {
        return this.createRequest(requestUrl, httpMethod, requestBody, requestType, false);
    }

    public HttpURLConnection createRequest(String requestUrl, String httpMethod, byte[] requestBody, String requestType, Boolean forceAuthentication) {
        try {
            URL url = new URL(requestUrl);
            HttpURLConnection req = (HttpURLConnection)url.openConnection();
            if (this.timeoutMs != null) {
                req.setConnectTimeout(this.timeoutMs);
                req.setReadTimeout(this.timeoutMs);
            }
            req.setRequestMethod(httpMethod);
            req.setRequestProperty("Accept", "application/json");
            if (requestType != null) {
                req.setRequestProperty("Content-Type", requestType);
            }
            if (this.bearerToken != null) {
                req.setRequestProperty("Authorization", "Bearer " + this.bearerToken);
                req.setRequestProperty("X-Auth", "Bearer");
            } else if (this.getTokenCookie() == null && (forceAuthentication.booleanValue() || this.alwaysSendBasicAuthHeaders)) {
                req.setRequestProperty("Authorization", "Basic " + Utils.toBase64String(this.userName + ":" + this.password));
                req.setRequestProperty("X-Auth", "Basic");
            }
            if (this.RequestFilter != null) {
                this.RequestFilter.exec(req);
            }
            if (GlobalRequestFilter != null) {
                GlobalRequestFilter.exec(req);
            }
            if (requestBody != null) {
                req.setDoOutput(true);
                req.setRequestProperty("Content-Length", Integer.toString(requestBody.length));
                DataOutputStream wr = new DataOutputStream(req.getOutputStream());
                wr.write(requestBody);
                wr.flush();
                Utils.closeQuietly(wr);
            }
            return req;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static boolean shouldAuthenticate(HttpURLConnection req, boolean hasAuthInfo) {
        try {
            return req.getResponseCode() == 401 && req.getRequestProperty("X-Auth") == null && hasAuthInfo;
        }
        catch (IOException e) {
            return false;
        }
    }

    public static RuntimeException createException(HttpURLConnection res, int responseCode) {
        WebServiceException webEx = null;
        try {
            Gson gson;
            JsonElement element;
            InputStream errorStream = res.getErrorStream();
            String responseBody = errorStream != null ? Utils.readToEnd(errorStream, UTF8.name()) : null;
            webEx = new WebServiceException(responseCode, res.getResponseMessage(), responseBody);
            if (res.getHeaderFields().containsKey("Content-Type") && Utils.matchesContentType(res.getHeaderField("Content-Type"), "application/json") && (element = (JsonElement)(gson = new Gson()).fromJson(responseBody, JsonElement.class)) != null) {
                JsonObject jsonObj = element.getAsJsonObject();
                for (Map.Entry jsonElementEntry : jsonObj.entrySet()) {
                    if (!((String)jsonElementEntry.getKey()).toLowerCase().equals("responsestatus")) continue;
                    webEx.setResponseStatus(Utils.createResponseStatus(jsonObj.get((String)jsonElementEntry.getKey())));
                    break;
                }
            }
            return webEx;
        }
        catch (IOException e) {
            if (webEx != null) {
                return webEx;
            }
            return new RuntimeException(e);
        }
    }

    public static String GetSendMethod(Object request) {
        return request instanceof IGet ? "GET" : (request instanceof IPost ? "POST" : (request instanceof IPut ? "PUT" : (request instanceof IDelete ? "DELETE" : (request instanceof IPatch ? "PATCH" : "POST"))));
    }

    public static boolean hasRequestBody(String httpMethod) {
        switch (httpMethod) {
            case "GET": 
            case "DELETE": 
            case "HEAD": 
            case "OPTIONS": {
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean getAlwaysSendBasicAuthHeaders() {
        return this.alwaysSendBasicAuthHeaders;
    }

    @Override
    public void setAlwaysSendBasicAuthHeaders(boolean value) {
        this.alwaysSendBasicAuthHeaders = value;
    }

    @Override
    public void setBearerToken(String bearerToken) {
        this.bearerToken = bearerToken;
    }

    @Override
    public String getBearerToken() {
        return this.bearerToken;
    }

    @Override
    public void setTokenCookie(String value) {
        this.setCookie("ss-tok", value, 31536000L);
    }

    @Override
    public void setRefreshToken(String bearerToken) {
        this.refreshToken = bearerToken;
    }

    @Override
    public String getRefreshToken() {
        return this.refreshToken;
    }

    @Override
    public void setRefreshTokenCookie(String value) {
        this.setCookie("ss-reftok", value, 31536000L);
    }

    @Override
    public void setCredentials(String userName, String password) {
        this.userName = userName;
        this.password = password;
    }

    public <TResponse> TResponse sendRequest(Object request, Object responseClass) {
        String httpMethod = JsonServiceClient.GetSendMethod(request);
        if (JsonServiceClient.hasRequestBody(httpMethod)) {
            return this.send(Utils.combinePath(this.replyUrl, JsonServiceClient.typeName(request)), httpMethod, request, responseClass);
        }
        String url = this.createUrl(request);
        return this.send(url, httpMethod, null, null, responseClass);
    }

    @Override
    public <TResponse> TResponse send(IReturn<TResponse> request) {
        return this.sendRequest(request, request.getResponseType());
    }

    @Override
    public void send(IReturnVoid request) {
        String httpMethod = JsonServiceClient.GetSendMethod(request);
        this.send(Utils.combinePath(this.replyUrl, JsonServiceClient.typeName(request)), httpMethod, request, IReturnVoid.class);
    }

    public <TResponse> TResponse send(String url, String httpMethod, Object responseClass) {
        return this.send(url, httpMethod, null, null, responseClass);
    }

    public <TResponse> TResponse send(String url, String httpMethod, Object request, Object responseClass) {
        String contentType = null;
        byte[] requestBody = null;
        if (request != null) {
            contentType = "application/json";
            String json = this.getGson().toJson(request);
            if (Log.isDebugEnabled()) {
                Log.d(json);
            }
            requestBody = json.getBytes(UTF8);
        }
        return this.send(url, httpMethod, requestBody, contentType, responseClass);
    }

    public <TResponse> TResponse send(String requestUrl, String httpMethod, byte[] requestBody, String requestType, Object responseClass) {
        HttpURLConnection req = null;
        Class resClass = null;
        try {
            Object object;
            Type resType;
            req = this.createRequest(requestUrl, httpMethod, requestBody, requestType);
            resClass = responseClass instanceof Class ? (Class)responseClass : null;
            Type type = resType = responseClass instanceof Type ? (Type)responseClass : null;
            if (resClass == null && resType == null) {
                throw new RuntimeException("responseClass '" + responseClass.getClass().getSimpleName() + "' must be a Class or Type");
            }
            int responseCode = req.getResponseCode();
            if (responseCode >= 400) {
                boolean success = false;
                boolean hasRefreshTokenCookie = this.getRefreshTokenCookie() != null;
                boolean hasRefreshToken = this.refreshToken != null || hasRefreshTokenCookie;
                if (JsonServiceClient.shouldAuthenticate(req, this.userName != null && this.password != null || this.bearerToken != null || hasRefreshToken)) {
                    req.disconnect();
                    if (hasRefreshToken) {
                        GetAccessToken refreshRequest = new GetAccessToken().setRefreshToken(this.refreshToken);
                        try {
                            GetAccessTokenResponse response = this.post(refreshRequest);
                            if (response.getAccessToken() != null) {
                                this.setBearerToken(response.getAccessToken());
                            }
                        }
                        catch (WebServiceException e) {
                            throw new RefreshTokenException(e);
                        }
                    }
                    boolean bl = success = (req = this.createRequest(requestUrl, httpMethod, requestBody, requestType, true)).getResponseCode() < 400;
                }
                if (!success) {
                    RuntimeException ex = JsonServiceClient.createException(req, responseCode);
                    if (this.ExceptionFilter != null) {
                        this.ExceptionFilter.exec(req, ex);
                    }
                    if (GlobalExceptionFilter != null) {
                        GlobalExceptionFilter.exec(req, ex);
                    }
                    throw ex;
                }
            }
            InputStream is = req.getInputStream();
            if (resClass == IReturnVoid.class) {
                Utils.readBytesToEnd(is);
                TResponse hasRefreshTokenCookie = null;
                return hasRefreshTokenCookie;
            }
            if (this.ResponseFilter != null) {
                this.ResponseFilter.exec(req);
            }
            if (GlobalResponseFilter != null) {
                GlobalResponseFilter.exec(req);
            }
            if (resClass == byte[].class) {
                byte[] hasRefreshTokenCookie = Utils.readBytesToEnd(req);
                return (TResponse)hasRefreshTokenCookie;
            }
            if (resClass == String.class) {
                String hasRefreshTokenCookie = Utils.readToEnd(is, UTF8.name());
                return (TResponse)hasRefreshTokenCookie;
            }
            if (resClass == InputStream.class) {
                InputStream hasRefreshTokenCookie = is;
                return (TResponse)hasRefreshTokenCookie;
            }
            if (Log.isDebugEnabled()) {
                Object response;
                String json = Utils.readToEnd(is, UTF8.name());
                Log.d(json);
                object = response = resClass != null ? this.getGson().fromJson(json, resClass) : this.getGson().fromJson(json, resType);
                return (TResponse)object;
            }
            BufferedReader reader = new BufferedReader(new InputStreamReader(is));
            Object response = resClass != null ? this.getGson().fromJson((Reader)reader, resClass) : this.getGson().fromJson((Reader)reader, resType);
            Utils.closeQuietly(reader);
            object = response;
            return (TResponse)object;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            if (req != null && resClass != InputStream.class) {
                req.disconnect();
            }
        }
    }

    static String typeName(Object o) {
        return o.getClass().getSimpleName();
    }

    private String resolveUrl(String relativeOrAbsoluteUrl) {
        return relativeOrAbsoluteUrl.startsWith("http:") || relativeOrAbsoluteUrl.startsWith("https:") ? relativeOrAbsoluteUrl : Utils.combinePath(this.baseUrl, relativeOrAbsoluteUrl);
    }

    @Override
    public <TResponse> TResponse get(IReturn<TResponse> request) {
        return this.send(this.createUrl(request), "GET", request.getResponseType());
    }

    @Override
    public void get(IReturnVoid request) {
        this.send(this.createUrl(request), "GET", IReturnVoid.class);
    }

    @Override
    public <TResponse> TResponse get(IReturn<TResponse> request, Map<String, String> queryParams) {
        return this.send(this.createUrl(request, queryParams), "GET", request.getResponseType());
    }

    @Override
    public <TResponse> TResponse get(String path, Class responseType) {
        return this.send(this.resolveUrl(path), "GET", responseType);
    }

    @Override
    public <TResponse> TResponse get(String path, Type responseType) {
        return this.send(this.resolveUrl(path), "GET", responseType);
    }

    @Override
    public HttpURLConnection get(String path) {
        return this.createRequest(this.resolveUrl(path), "GET", null, null);
    }

    @Override
    public <TResponse> TResponse post(IReturn<TResponse> request) {
        return this.send(Utils.combinePath(this.replyUrl, JsonServiceClient.typeName(request)), "POST", request, request.getResponseType());
    }

    @Override
    public void post(IReturnVoid request) {
        this.send(Utils.combinePath(this.replyUrl, JsonServiceClient.typeName(request)), "POST", request, IReturnVoid.class);
    }

    @Override
    public <TResponse> TResponse post(String path, Object request, Class responseType) {
        return this.send(this.resolveUrl(path), "POST", request, responseType);
    }

    @Override
    public <TResponse> TResponse post(String path, Object request, Type responseType) {
        return this.send(this.resolveUrl(path), "POST", request, responseType);
    }

    @Override
    public <TResponse> TResponse post(String path, byte[] requestBody, String contentType, Class responseType) {
        return this.send(this.resolveUrl(path), "POST", requestBody, contentType, responseType);
    }

    @Override
    public <TResponse> TResponse post(String path, byte[] requestBody, String contentType, Type responseType) {
        return this.send(this.resolveUrl(path), "POST", requestBody, contentType, responseType);
    }

    @Override
    public HttpURLConnection post(String path, byte[] requestBody, String contentType) {
        return this.createRequest(this.resolveUrl(path), "POST", requestBody, contentType);
    }

    @Override
    public <TResponse> TResponse put(IReturn<TResponse> request) {
        return this.send(Utils.combinePath(this.replyUrl, JsonServiceClient.typeName(request)), "PUT", request, request.getResponseType());
    }

    @Override
    public void put(IReturnVoid request) {
        this.send(Utils.combinePath(this.replyUrl, JsonServiceClient.typeName(request)), "PUT", request, IReturnVoid.class);
    }

    @Override
    public <TResponse> TResponse put(String path, Object request, Class responseType) {
        return this.send(this.resolveUrl(path), "PUT", request, responseType);
    }

    @Override
    public <TResponse> TResponse put(String path, Object request, Type responseType) {
        return this.send(this.resolveUrl(path), "PUT", request, responseType);
    }

    @Override
    public <TResponse> TResponse put(String path, byte[] requestBody, String contentType, Class responseType) {
        return this.send(this.resolveUrl(path), "PUT", requestBody, contentType, responseType);
    }

    @Override
    public <TResponse> TResponse put(String path, byte[] requestBody, String contentType, Type responseType) {
        return this.send(this.resolveUrl(path), "PUT", requestBody, contentType, responseType);
    }

    @Override
    public HttpURLConnection put(String path, byte[] requestBody, String contentType) {
        return this.createRequest(this.resolveUrl(path), "PUT", requestBody, contentType);
    }

    @Override
    public <TResponse> TResponse delete(IReturn<TResponse> request) {
        return this.send(this.createUrl(request), "DELETE", request.getResponseType());
    }

    @Override
    public void delete(IReturnVoid request) {
        this.send(this.createUrl(request), "DELETE", IReturnVoid.class);
    }

    @Override
    public <TResponse> TResponse delete(IReturn<TResponse> request, Map<String, String> queryParams) {
        return this.send(this.createUrl(request, queryParams), "DELETE", request.getResponseType());
    }

    @Override
    public <TResponse> TResponse delete(String path, Class responseType) {
        return this.send(this.resolveUrl(path), "DELETE", responseType);
    }

    @Override
    public <TResponse> TResponse delete(String path, Type responseType) {
        return this.send(this.resolveUrl(path), "DELETE", responseType);
    }

    @Override
    public HttpURLConnection delete(String path) {
        return this.createRequest(this.resolveUrl(path), "DELETE", null, null);
    }

    public List<HttpCookie> getCookies() {
        CookieManager cookieManager = (CookieManager)CookieHandler.getDefault();
        return cookieManager.getCookieStore().getCookies();
    }

    @Override
    public String getCookieValue(String name) {
        CookieManager cookieManager = (CookieManager)CookieHandler.getDefault();
        for (HttpCookie cookie : cookieManager.getCookieStore().getCookies()) {
            if (!cookie.getName().equals(name)) continue;
            return cookie.getValue();
        }
        return null;
    }

    @Override
    public String getTokenCookie() {
        return this.getCookieValue("ss-tok");
    }

    @Override
    public String getRefreshTokenCookie() {
        return this.getCookieValue("ss-reftok");
    }

    @Override
    public void setCookie(String name, String value) {
        this.setCookie(name, value, null);
    }

    @Override
    public void setCookie(String name, String value, Long expiresInSecs) {
        CookieManager cookieManager = (CookieManager)CookieHandler.getDefault();
        HttpCookie cookie = new HttpCookie(name, value);
        cookie.setVersion(0);
        if (expiresInSecs != null) {
            cookie.setMaxAge(expiresInSecs);
        }
        cookieManager.getCookieStore().add(this.baseUri, cookie);
    }

    @Override
    public void clearCookies() {
        CookieManager cookieManager = (CookieManager)CookieHandler.getDefault();
        cookieManager.getCookieStore().removeAll();
    }
}

