/*
 * Decompiled with CFR 0.152.
 */
package net.servicestack.client;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import java.io.BufferedReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.servicestack.client.Utils;

public final class Inspect {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void vars(Map args) {
        String inspectVarsPath = System.getenv("INSPECT_VARS");
        if (inspectVarsPath == null) {
            return;
        }
        OutputStreamWriter writer = null;
        try {
            inspectVarsPath = System.getProperty("os.name").toLowerCase().contains("win") ? inspectVarsPath.replace("/", "\\") : inspectVarsPath.replace("\\", "/");
            Path dirPath = Paths.get(inspectVarsPath, new String[0]).getParent();
            Files.createDirectories(dirPath, new FileAttribute[0]);
            writer = new FileWriter(inspectVarsPath);
            new Gson().toJson((Object)args, (Appendable)writer);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public static final String dump(Object obj) {
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        String json = gson.toJson(obj);
        return json.replace("\"", "");
    }

    public static final void printDump(Object obj) {
        System.out.println(Inspect.dump(obj));
    }

    public static final String dumpTable(Iterable objs, Iterable headers) {
        ArrayList rows = Utils.toList(objs);
        List<Map<String, Object>> mapRows = Inspect.toListMap(rows);
        List<Object> keys = headers != null ? Utils.toList(headers) : Inspect.allKeys(mapRows);
        HashMap<String, Integer> colSizes = new HashMap<String, Integer>();
        for (String string : keys) {
            int max = string.length();
            for (Map<String, Object> row : mapRows) {
                Object object;
                int valSize;
                if (!row.containsKey(string) || (valSize = (object = row.get(string)).toString().length()) <= max) continue;
                max = valSize;
            }
            colSizes.put(string, max);
        }
        int rowWidth = Utils.sum(colSizes.values()) + colSizes.size() * 2 + (colSizes.size() + 1);
        StringBuilder stringBuilder = new StringBuilder();
        Utils.appendLine(stringBuilder.append("+").append(Utils.repeat("-", rowWidth - 2)).append("+"));
        stringBuilder.append("|");
        for (String string : keys) {
            stringBuilder.append(Inspect.alignCenter(string, (Integer)colSizes.get(string))).append("|");
        }
        Utils.appendLine(stringBuilder);
        Utils.appendLine(stringBuilder.append("|").append(Utils.repeat("-", rowWidth - 2)).append("|"));
        for (Map map : mapRows) {
            stringBuilder.append("|");
            for (String string : keys) {
                stringBuilder.append(Inspect.alignAuto(map.get(string), (Integer)colSizes.get(string))).append("|");
            }
            Utils.appendLine(stringBuilder);
        }
        Utils.appendLine(stringBuilder.append("+").append(Utils.repeat("-", rowWidth - 2)).append("+"));
        return stringBuilder.toString();
    }

    public static final void printDumpTable(Iterable objs) {
        System.out.println(Inspect.dumpTable(objs, null));
    }

    public static final void printDumpTable(Iterable objs, Iterable headers) {
        System.out.println(Inspect.dumpTable(objs, headers));
    }

    public static final List<String> allKeys(List<Map<String, Object>> rows) {
        ArrayList<String> to = new ArrayList<String>();
        for (Map<String, Object> row : rows) {
            for (String key : row.keySet()) {
                if (to.contains(key)) continue;
                to.add(key);
            }
        }
        return to;
    }

    public static final boolean isNumber(Object obj) {
        return obj instanceof Long || obj instanceof Integer || obj instanceof Short || obj instanceof Byte || obj instanceof Double || obj instanceof Float;
    }

    private static final String fmtNumber(Object d) {
        if (d instanceof Double) {
            Double dbl = ((Number)d).doubleValue();
            return dbl == Math.floor(dbl) ? String.valueOf(((Number)dbl).longValue()) : String.valueOf(dbl);
        }
        if (d instanceof Float) {
            Float f = Float.valueOf(((Number)d).floatValue());
            return (double)f.floatValue() == Math.floor(f.floatValue()) ? String.valueOf(((Number)f).longValue()) : String.valueOf(f);
        }
        return d.toString();
    }

    public static final String alignLeft(String str, Integer len) {
        return Inspect.alignLeft(str, len, " ");
    }

    public static final String alignLeft(String str, int len, String pad) {
        if (len < 0) {
            return "";
        }
        int aLen = len + 1 - str.length();
        return aLen <= 0 ? str : pad + str + Utils.repeat(pad, aLen);
    }

    public static final String alignCenter(String str, int len) {
        return Inspect.alignCenter(str, len, " ");
    }

    public static final String alignCenter(String str, int len, String pad) {
        if (len < 0) {
            return "";
        }
        int nLen = str.length();
        int half = (int)Math.floor((double)len / 2.0 - (double)nLen / 2.0);
        int odds = Math.abs(nLen % 2 - len % 2);
        return Utils.repeat(pad, half + 1) + str + Utils.repeat(pad, half + 1 + odds);
    }

    public static final String alignRight(String str, int len) {
        return Inspect.alignRight(str, len, " ");
    }

    public static final String alignRight(String str, int len, String pad) {
        if (len < 0) {
            return "";
        }
        int aLen = len + 1 - str.length();
        return aLen <= 0 ? str : Utils.repeat(pad, aLen) + str + pad;
    }

    public static final String alignAuto(Object obj, int len) {
        return Inspect.alignAuto(obj, len, " ");
    }

    public static final String alignAuto(Object obj, int len, String pad) {
        String str;
        String string = str = obj == null ? "" : String.valueOf(obj);
        if (str.length() <= len) {
            return Inspect.isNumber(obj) ? Inspect.alignRight(Inspect.fmtNumber(obj), len, pad) : Inspect.alignLeft(str, len, pad);
        }
        return str;
    }

    public static final List<Map<String, Object>> toListMap(List objs) {
        Gson gson = new Gson();
        String json = gson.toJson((Object)objs);
        return (List)gson.fromJson(json, new TypeToken<List<Map<String, Object>>>(){}.getType());
    }

    public static final Map<String, Object> toMap(Object obj) {
        Gson gson = new Gson();
        String json = gson.toJson(obj);
        return (Map)gson.fromJson(json, new TypeToken<Map<String, Object>>(){}.getType());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final String readUrlAsText(URL url) {
        StringBuilder sb = new StringBuilder();
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new InputStreamReader(url.openStream()));
            String line = null;
            while ((line = reader.readLine()) != null) {
                sb.append(line);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return sb.toString();
    }
}

