/*
 * Decompiled with CFR 0.152.
 */
package net.servicestack.client.sse;

import com.google.gson.JsonObject;
import net.servicestack.client.JsonUtils;
import net.servicestack.client.Utils;
import net.servicestack.client.sse.ServerEventMessage;

public class ServerEventCommand
extends ServerEventMessage {
    private String userId;
    private String displayName;
    private String profileUrl;
    private boolean isAuthenticated;
    private String[] channels;

    public String getUserId() {
        return this.userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public String getProfileUrl() {
        return this.profileUrl;
    }

    public void setProfileUrl(String profileUrl) {
        this.profileUrl = profileUrl;
    }

    public boolean isAuthenticated() {
        return this.isAuthenticated;
    }

    public void setAuthenticated(boolean authenticated) {
        this.isAuthenticated = authenticated;
    }

    public String[] getChannels() {
        return this.channels;
    }

    public void setChannels(String[] channels) {
        this.channels = channels;
    }

    @Override
    protected void populate(JsonObject obj) {
        super.populate(obj);
        this.userId = JsonUtils.asString(obj, "userId");
        this.displayName = JsonUtils.asString(obj, "displayName");
        this.isAuthenticated = "true".equals(JsonUtils.asString(obj, "isAuthenticated"));
        this.profileUrl = JsonUtils.asString(obj, "profileUrl");
        String channels = JsonUtils.asString(obj, "channels");
        if (!Utils.isNullOrEmpty(channels)) {
            this.channels = channels.split(",");
        }
    }

    public String toString() {
        return "(" + this.getClass().getSimpleName() + "\n eventId: " + this.eventId + "\n userId: " + this.userId + "\n displayName: " + this.displayName + "\n profileUrl: " + this.profileUrl + "\n isAuthenticated: " + this.isAuthenticated + "\n channels: " + Utils.join(this.channels, ",") + "\n)";
    }
}

