/*
 * Decompiled with CFR 0.152.
 */
package net.servicestack.client.sse;

import com.google.gson.JsonObject;
import java.io.Closeable;
import java.io.FileNotFoundException;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import net.servicestack.client.IReceiver;
import net.servicestack.client.IResolver;
import net.servicestack.client.JsonServiceClient;
import net.servicestack.client.JsonUtils;
import net.servicestack.client.Log;
import net.servicestack.client.Utils;
import net.servicestack.client.sse.EventStream;
import net.servicestack.client.sse.ExceptionCallback;
import net.servicestack.client.sse.GetEventSubscribers;
import net.servicestack.client.sse.HttpRequestFilter;
import net.servicestack.client.sse.NewInstanceResolver;
import net.servicestack.client.sse.ServerEventCallback;
import net.servicestack.client.sse.ServerEventConnect;
import net.servicestack.client.sse.ServerEventConnectCallback;
import net.servicestack.client.sse.ServerEventHeartbeat;
import net.servicestack.client.sse.ServerEventJoin;
import net.servicestack.client.sse.ServerEventJoinCallback;
import net.servicestack.client.sse.ServerEventLeave;
import net.servicestack.client.sse.ServerEventLeaveCallback;
import net.servicestack.client.sse.ServerEventMessage;
import net.servicestack.client.sse.ServerEventMessageCallback;
import net.servicestack.client.sse.ServerEventReceiver;
import net.servicestack.client.sse.ServerEventUpdate;
import net.servicestack.client.sse.ServerEventUpdateCallback;
import net.servicestack.client.sse.ServerEventUser;
import net.servicestack.client.sse.UpdateEventSubscriber;
import net.servicestack.func.Action;
import net.servicestack.func.ActionVoid;
import net.servicestack.func.Func;
import net.servicestack.func.Function;

public class ServerEventsClient
implements Closeable {
    protected String baseUri;
    protected String[] channels;
    protected String eventStreamPath;
    protected String eventStreamUri;
    protected JsonServiceClient serviceClient;
    protected IResolver resolver;
    protected Map<String, ServerEventCallback> handlers;
    protected Map<String, ServerEventCallback> namedReceivers;
    protected Map<String, List<Action<ServerEventMessage>>> listeners;
    protected ServerEventConnectCallback onConnect;
    protected ServerEventMessageCallback onMessage;
    protected ServerEventJoinCallback onJoin;
    protected ServerEventLeaveCallback onLeave;
    protected ServerEventUpdateCallback onUpdate;
    protected ServerEventMessageCallback onCommand;
    protected ServerEventMessageCallback onHeartbeat;
    protected ActionVoid onReconnect;
    protected ExceptionCallback onException;
    protected HttpRequestFilter heartbeatRequestFilter;
    protected ServerEventConnect connectionInfo;
    protected Date lastPulseAt;
    protected Thread bgThread;
    protected EventStream bgEventStream;
    protected final AtomicBoolean stopped = new AtomicBoolean(false);
    protected final AtomicBoolean running = new AtomicBoolean(false);
    protected final AtomicInteger errorsCount = new AtomicInteger();
    static int DefaultHeartbeatMs = 10000;
    static int DefaultIdleTimeoutMs = 30000;
    public static String UnknownChannel = "*";
    ScheduledThreadPoolExecutor heartbeatTimer;

    public ServerEventsClient(String baseUri, String ... channels) {
        this.setBaseUri(baseUri);
        this.setChannels(channels);
        this.serviceClient = new JsonServiceClient(baseUri);
        this.resolver = new NewInstanceResolver();
        this.handlers = new HashMap<String, ServerEventCallback>();
        this.namedReceivers = new HashMap<String, ServerEventCallback>();
        this.listeners = new HashMap<String, List<Action<ServerEventMessage>>>();
    }

    public ServerEventsClient(String baseUrl, String channel) {
        this(baseUrl, new String[]{channel});
    }

    public ServerEventsClient(String baseUrl) {
        this(baseUrl, new String[0]);
    }

    public String getBaseUri() {
        return this.baseUri;
    }

    public void setBaseUri(String baseUri) {
        this.baseUri = baseUri;
        this.eventStreamPath = Utils.combinePath(baseUri, "event-stream");
        this.buildEventStreamUri();
        if (this.serviceClient != null) {
            this.serviceClient.setBaseUrl(baseUri);
        }
    }

    public String[] getChannels() {
        return this.channels;
    }

    public void setChannels(String[] channels) {
        if (channels == null) {
            channels = new String[]{};
        }
        this.channels = channels;
        this.buildEventStreamUri();
    }

    private void buildEventStreamUri() {
        ArrayList<String> encodedChannels = Func.map(this.channels != null ? this.channels : new String[]{}, new Function<String, String>(){

            @Override
            public String apply(String x) {
                try {
                    return URLEncoder.encode(x, "UTF-8");
                }
                catch (UnsupportedEncodingException e) {
                    return x;
                }
            }
        });
        this.eventStreamUri = Utils.addQueryParam(this.eventStreamPath, "channels", Utils.join(encodedChannels, ","), false);
    }

    public String getEventStreamUri() {
        return this.eventStreamUri;
    }

    public JsonServiceClient getServiceClient() {
        return this.serviceClient;
    }

    public IResolver getResolver() {
        return this.resolver;
    }

    public ServerEventsClient setResolver(IResolver resolver) {
        this.resolver = resolver;
        return this;
    }

    public ServerEventsClient setOnConnect(ServerEventConnectCallback onConnect) {
        this.onConnect = onConnect;
        return this;
    }

    public ServerEventsClient setOnMessage(ServerEventMessageCallback onMessage) {
        this.onMessage = onMessage;
        return this;
    }

    public ServerEventsClient setOnJoin(ServerEventJoinCallback onJoin) {
        this.onJoin = onJoin;
        return this;
    }

    public ServerEventsClient setOnLeave(ServerEventLeaveCallback onLeave) {
        this.onLeave = onLeave;
        return this;
    }

    public ServerEventsClient setOnUpdate(ServerEventUpdateCallback onUpdate) {
        this.onUpdate = onUpdate;
        return this;
    }

    public ServerEventsClient setOnCommand(ServerEventMessageCallback onCommand) {
        this.onCommand = onCommand;
        return this;
    }

    public ServerEventsClient setOnReconnect(ActionVoid onReconnect) {
        this.onReconnect = onReconnect;
        return this;
    }

    public ServerEventsClient setOnException(ExceptionCallback onException) {
        this.onException = onException;
        return this;
    }

    public ServerEventsClient setHeartbeatRequestFilter(HttpRequestFilter heartbeatRequestFilter) {
        this.heartbeatRequestFilter = heartbeatRequestFilter;
        return this;
    }

    public ServerEventsClient setOnHeartbeat(ServerEventMessageCallback onHeartbeat) {
        this.onHeartbeat = onHeartbeat;
        return this;
    }

    public Map<String, ServerEventCallback> getHandlers() {
        return this.handlers;
    }

    public void setHandlers(Map<String, ServerEventCallback> handlers) {
        this.handlers = handlers;
    }

    public ServerEventsClient registerHandler(String name, ServerEventCallback handler) {
        this.handlers.put(name, handler);
        return this;
    }

    public Map<String, ServerEventCallback> getNamedReceivers() {
        return this.namedReceivers;
    }

    public ServerEventsClient registerReceiver(Class<?> receiverClass) {
        return this.registerNamedReceiver("cmd", receiverClass);
    }

    public ServerEventsClient registerNamedReceiver(String name, final Class<?> namedReceiverClass) {
        if (!IReceiver.class.isAssignableFrom(namedReceiverClass)) {
            throw new IllegalArgumentException(namedReceiverClass.getSimpleName() + " must implement IReceiver");
        }
        this.namedReceivers.put(name, new ServerEventCallback(){

            @Override
            public void execute(ServerEventsClient client, ServerEventMessage msg) {
                try {
                    IReceiver receiver = (IReceiver)ServerEventsClient.this.resolver.TryResolve(namedReceiverClass);
                    if (receiver instanceof ServerEventReceiver) {
                        ServerEventReceiver injectReceiver = (ServerEventReceiver)receiver;
                        injectReceiver.setClient(client);
                        injectReceiver.setRequest(msg);
                    }
                    String target = msg.getTarget().replace("-", "");
                    for (Method mi : namedReceiverClass.getDeclaredMethods()) {
                        Class<?>[] args;
                        if (!Modifier.isPublic(mi.getModifiers()) || Modifier.isStatic(mi.getModifiers()) || (args = mi.getParameterTypes()).length > 1 || "equals".equals(mi.getName())) continue;
                        String actionName = mi.getName();
                        if (!target.equalsIgnoreCase(actionName) && actionName.startsWith("set")) {
                            actionName = actionName.substring(3);
                        }
                        if (args.length == 0) {
                            if (!target.equalsIgnoreCase(actionName)) continue;
                            mi.invoke((Object)receiver, null);
                            return;
                        }
                        Class<?> requestType = args[0];
                        if (target.equals(requestType.getSimpleName()) && mi.getName().toLowerCase().equals(target.toLowerCase())) {
                            Object request = !Utils.isNullOrEmpty(msg.getJson()) ? JsonUtils.fromJson(msg.getJson(), requestType) : requestType.newInstance();
                            mi.invoke((Object)receiver, request);
                            return;
                        }
                        if (!target.equalsIgnoreCase(actionName)) continue;
                        Object request = !Utils.isNullOrEmpty(msg.getJson()) ? JsonUtils.fromJson(msg.getJson(), requestType) : requestType.newInstance();
                        mi.invoke((Object)receiver, request);
                        return;
                    }
                    receiver.noSuchMethod(msg.getTarget(), msg);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        });
        return this;
    }

    public ServerEventConnect getConnectionInfo() {
        return this.connectionInfo;
    }

    public String getSubscriptionId() {
        return this.connectionInfo != null ? this.connectionInfo.getId() : null;
    }

    public String getConnectionDisplayName() {
        return this.connectionInfo != null ? this.connectionInfo.getDisplayName() : "(not connected)";
    }

    protected synchronized void stopBackgroundThread() {
        if (this.bgThread != null) {
            this.bgEventStream.cancel();
            this.bgThread.interrupt();
            try {
                this.bgThread.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.bgThread = null;
        }
    }

    protected EventStream createEventStream() {
        return new EventStream(this);
    }

    public synchronized ServerEventsClient start() {
        this.stopBackgroundThread();
        this.stopped.set(false);
        this.bgEventStream = this.createEventStream();
        this.bgThread = new Thread(this.bgEventStream);
        this.bgThread.start();
        this.lastPulseAt = new Date();
        return this;
    }

    public synchronized void restart() {
        try {
            this.internalStop();
            if (this.stopped.get()) {
                return;
            }
            try {
                this.sleepBackOffMultiplier(this.errorsCount.intValue());
                this.start();
            }
            catch (Exception e) {
                this.onExceptionReceived(e);
            }
            if (this.onReconnect != null) {
                this.onReconnect.apply();
            }
        }
        catch (Exception ex) {
            Log.e("[SSE-CLIENT] Error whilst restarting: " + ex.getMessage(), ex);
            ex.printStackTrace();
        }
    }

    private void sleepBackOffMultiplier(int continuousErrorsCount) throws InterruptedException {
        if (continuousErrorsCount <= 1) {
            return;
        }
        int MaxSleepMs = 60000;
        Random rand = new Random();
        int min = (int)Math.pow(continuousErrorsCount, 3.0);
        int max = (int)Math.pow(continuousErrorsCount + 1, 3.0);
        int nextTry = Math.min(rand.nextInt(max - min + 1) + min, 60000);
        Log.info("Sleeping for " + nextTry + "ms after " + continuousErrorsCount + " continuous errors");
        Thread.sleep(nextTry);
    }

    public synchronized void stop() {
        this.stopped.set(true);
        this.internalStop();
    }

    public ServerEventsClient waitTillConnected() throws Exception {
        return this.waitTillConnected(Integer.MAX_VALUE);
    }

    public ServerEventsClient waitTillConnected(int timeoutMs) throws Exception {
        Date startedAt = new Date();
        while (this.connectionInfo == null) {
            Thread.sleep(50L);
            if (new Date().getTime() - startedAt.getTime() <= (long)timeoutMs) continue;
            throw new TimeoutException("Not connected after " + timeoutMs + "ms");
        }
        return this;
    }

    private synchronized void internalStop() {
        if (Log.isDebugEnabled()) {
            Log.d("Stop() " + this.getConnectionDisplayName());
        }
        if (this.connectionInfo != null && this.connectionInfo.getUnRegisterUrl() != null) {
            try {
                Utils.readToEnd(this.connectionInfo.getUnRegisterUrl());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.heartbeatTimer != null) {
            try {
                this.heartbeatTimer.shutdown();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.heartbeatTimer = null;
        }
        this.connectionInfo = null;
        this.stopBackgroundThread();
    }

    private void onJoinReceived(ServerEventJoin e) {
        if (Log.isDebugEnabled()) {
            Log.d("[SSE-CLIENT] OnJoinReceived: (" + e.getClass().getSimpleName() + ") #" + e.getEventId() + " on #" + this.getConnectionDisplayName() + " (" + Utils.join(this.channels, ",") + ")");
        }
        if (this.onJoin != null) {
            this.onJoin.execute(e);
        }
    }

    private void onLeaveReceived(ServerEventLeave e) {
        if (Log.isDebugEnabled()) {
            Log.d("[SSE-CLIENT] OnLeaveReceived: (" + e.getClass().getSimpleName() + ") #" + e.getEventId() + " on #" + this.getConnectionDisplayName() + " (" + Utils.join(this.channels, ",") + ")");
        }
        if (this.onLeave != null) {
            this.onLeave.execute(e);
        }
    }

    private void onUpdateReceived(ServerEventUpdate e) {
        if (Log.isDebugEnabled()) {
            Log.d("[SSE-CLIENT] OnUpdateReceived: (" + e.getClass().getSimpleName() + ") #" + e.getEventId() + " on #" + this.getConnectionDisplayName() + " (" + Utils.join(this.channels, ",") + ")");
        }
        if (this.onUpdate != null) {
            this.onUpdate.execute(e);
        }
    }

    private void onCommandReceived(ServerEventMessage e) {
        if (Log.isDebugEnabled()) {
            Log.d("[SSE-CLIENT] OnCommandReceived: (" + e.getClass().getSimpleName() + ") #" + e.getEventId() + " on #" + this.getConnectionDisplayName() + " (" + Utils.join(this.channels, ",") + ")");
        }
        if (this.onCommand != null) {
            this.onCommand.execute(e);
        }
    }

    protected void onTriggerReceived(ServerEventMessage e) {
        if (Log.isDebugEnabled()) {
            Log.d("[SSE-CLIENT] OnTriggerReceived: (" + e.getClass().getSimpleName() + ") #" + e.getEventId() + " on #" + this.getConnectionDisplayName() + " (" + Utils.join(this.channels, ",") + ")");
        }
        this.raiseEvent(e.getTarget(), e);
    }

    private void onHeartbeatReceived(ServerEventMessage e) {
        if (Log.isDebugEnabled()) {
            Log.d("[SSE-CLIENT] OnHeartbeatReceived: (" + e.getClass().getSimpleName() + ") #" + e.getEventId() + " on #" + this.getConnectionDisplayName() + " (" + Utils.join(this.channels, ",") + ")");
        }
        if (this.onHeartbeat != null) {
            this.onHeartbeat.execute(e);
        }
    }

    protected void onMessageReceived(ServerEventMessage e) {
        if (Log.isDebugEnabled()) {
            Log.d("[SSE-CLIENT] OnMessageReceived: " + e.getEventId() + " on #" + this.getConnectionDisplayName() + " " + Utils.join(this.channels, ","));
        }
        if (this.onMessage != null) {
            this.onMessage.execute(e);
        }
    }

    protected void onExceptionReceived(Exception ex) {
        this.errorsCount.incrementAndGet();
        Log.e("[SSE-CLIENT] OnExceptionReceived: " + ex.getMessage() + " on #" + this.getConnectionDisplayName(), ex);
        if (Log.isDebugEnabled()) {
            Log.d(Utils.getStackTrace(ex));
        }
        if (this.onException != null) {
            this.onException.execute(ex);
        }
        this.restart();
    }

    private void onConnectReceived() {
        if (Log.isDebugEnabled()) {
            Log.d(String.format("[SSE-CLIENT] OnConnectReceived: %s on #%s / %s on (%s)", this.connectionInfo.getEventId(), this.getConnectionDisplayName(), this.connectionInfo.getId(), Utils.join(this.channels, ",")));
        }
        if (this.onConnect != null) {
            this.onConnect.execute(this.connectionInfo);
        }
        this.startNewHeartbeat();
    }

    public synchronized ServerEventsClient addListener(String eventName, Action<ServerEventMessage> handler) {
        List<Action<ServerEventMessage>> handlers = this.listeners.get(eventName);
        if (handlers == null) {
            handlers = new ArrayList<Action<ServerEventMessage>>();
            this.listeners.put(eventName, handlers);
        }
        handlers.add(handler);
        return this;
    }

    public synchronized ServerEventsClient removeListener(String eventName, Action<ServerEventMessage> handler) {
        List<Action<ServerEventMessage>> handlers = this.listeners.get(eventName);
        if (handlers != null) {
            handlers.remove(handler);
        }
        return this;
    }

    public synchronized void raiseEvent(String eventName, ServerEventMessage message) {
        List<Action<ServerEventMessage>> handlers = this.listeners.get(eventName);
        if (handlers != null) {
            for (Action<ServerEventMessage> handler : handlers) {
                try {
                    handler.apply(message);
                }
                catch (Exception e) {
                    Log.e("Error whilst executing '" + eventName + "' handler", e);
                }
            }
        }
    }

    private void startNewHeartbeat() {
        if (this.connectionInfo == null || this.connectionInfo.getHeartbeatUrl() == null) {
            return;
        }
        if (this.stopped.get()) {
            return;
        }
        if (this.heartbeatTimer == null) {
            this.heartbeatTimer = new ScheduledThreadPoolExecutor(1);
        }
        this.heartbeatTimer.schedule(new Runnable(){

            @Override
            public void run() {
                ServerEventsClient.this.Heartbeat();
            }
        }, this.connectionInfo.getHeartbeatIntervalMs(), TimeUnit.MILLISECONDS);
    }

    public void Heartbeat() {
        if (Log.isDebugEnabled()) {
            Log.d("[SSE-CLIENT] Prep for Heartbeat...");
        }
        if (this.connectionInfo == null) {
            return;
        }
        if (this.stopped.get()) {
            return;
        }
        long elapsedMs = new Date().getTime() - this.lastPulseAt.getTime();
        if (elapsedMs > this.connectionInfo.getIdleTimeoutMs()) {
            this.onExceptionReceived(new TimeoutException("Last Heartbeat Pulse was " + elapsedMs + "ms ago"));
            return;
        }
        try {
            URL heartbeatUrl = new URL(this.connectionInfo.getHeartbeatUrl());
            HttpURLConnection conn = (HttpURLConnection)heartbeatUrl.openConnection();
            if (this.heartbeatRequestFilter != null) {
                this.heartbeatRequestFilter.execute(conn);
            }
            if (Log.isDebugEnabled()) {
                Log.d("[SSE-CLIENT] Sending Heartbeat...");
            }
            try {
                String string = Utils.readToEnd(conn.getInputStream(), "UTF-8");
            }
            catch (FileNotFoundException notFound) {
                if (this.stopped.get()) {
                    return;
                }
                Log.e(conn.getResponseMessage(), notFound);
                throw notFound;
            }
            if (Log.isDebugEnabled()) {
                Log.d("[SSE-CLIENT] Heartbeat sent to: " + heartbeatUrl);
            }
            this.startNewHeartbeat();
        }
        catch (Exception e) {
            if (Log.isDebugEnabled()) {
                Log.d("[SSE-CLIENT] Error from Heartbeat: " + e);
            }
            this.onExceptionReceived(e);
        }
    }

    protected void processOnConnectMessage(ServerEventMessage e) {
        JsonObject msg = JsonUtils.toJsonObject(e.getJson());
        this.connectionInfo = new ServerEventConnect();
        this.connectionInfo.setId(JsonUtils.asString(msg, "id"));
        this.connectionInfo.setHeartbeatUrl(JsonUtils.asString(msg, "heartbeatUrl"));
        this.connectionInfo.setHeartbeatIntervalMs(JsonUtils.asLong(msg, "heartbeatIntervalMs", DefaultHeartbeatMs));
        this.connectionInfo.setIdleTimeoutMs(JsonUtils.asLong(msg, "idleTimeoutMs", DefaultIdleTimeoutMs));
        this.connectionInfo.setUnRegisterUrl(JsonUtils.asString(msg, "unRegisterUrl"));
        this.connectionInfo.setUserId(JsonUtils.asString(msg, "userId"));
        this.connectionInfo.setDisplayName(JsonUtils.asString(msg, "displayName"));
        this.connectionInfo.setAuthenticated("true".equals(JsonUtils.asString(msg, "isAuthenticated")));
        this.connectionInfo.setProfileUrl(JsonUtils.asString(msg, "profileUrl"));
        this.onConnectReceived();
    }

    protected void processOnJoinMessage(ServerEventMessage e) {
        ServerEventJoin m = new ServerEventJoin();
        m.populate(e, JsonUtils.toJsonObject(e.getJson()));
        this.onJoinReceived(m);
        this.onCommandReceived(m);
    }

    protected void processOnLeaveMessage(ServerEventMessage e) {
        ServerEventLeave m = new ServerEventLeave();
        m.populate(e, JsonUtils.toJsonObject(e.getJson()));
        this.onLeaveReceived(m);
        this.onCommandReceived(m);
    }

    protected void processOnUpdateMessage(ServerEventMessage e) {
        ServerEventUpdate m = new ServerEventUpdate();
        m.populate(e, JsonUtils.toJsonObject(e.getJson()));
        this.onUpdateReceived(m);
        this.onCommandReceived(m);
    }

    protected void processOnHeartbeatMessage(ServerEventMessage e) {
        this.lastPulseAt = new Date();
        if (Log.isDebugEnabled()) {
            Log.d("[SSE-CLIENT] LastPulseAt: " + new SimpleDateFormat("HH:mm:ss.SSS", Locale.US).format(this.lastPulseAt));
        }
        this.onHeartbeatReceived(new ServerEventHeartbeat().populate(e, JsonUtils.toJsonObject(e.getJson())));
    }

    @Override
    public void close() {
        this.stop();
    }

    public List<ServerEventUser> getChannelSubscribers() {
        ArrayList<HashMap<String, String>> response = this.serviceClient.get(new GetEventSubscribers().setChannels(Func.toList(this.getChannels())));
        return this.toServerEventUser(response);
    }

    protected ArrayList<ServerEventUser> toServerEventUser(ArrayList<HashMap<String, String>> response) {
        return Func.map(response, new Function<HashMap<String, String>, ServerEventUser>(){

            @Override
            public ServerEventUser apply(HashMap<String, String> map) {
                String channels = map.get("channels");
                ServerEventUser to = new ServerEventUser().setUserId(map.get("userId")).setDisplayName(map.get("displayName")).setProfileUrl(map.get("profileUrl")).setChannels(Utils.isNullOrEmpty(channels) ? channels.split(",") : null);
                ArrayList<String> reservedNames = Func.toList("userId", "displayName", "profileUrl", "channels");
                for (Map.Entry<String, String> entry : map.entrySet()) {
                    if (reservedNames.contains(entry.getKey())) continue;
                    if (to.getMeta() == null) {
                        to.setMeta(new HashMap<String, String>());
                    }
                    to.getMeta().put(entry.getKey(), entry.getValue());
                }
                return to;
            }
        });
    }

    public void updateSubscriber(UpdateEventSubscriber request) {
        if (request.getId() == null) {
            request.setId(this.connectionInfo.getId());
        }
        this.serviceClient.post(request);
        this.update(Func.toArray(request.getSubscribeChannels(), String.class), Func.toArray(request.getUnsubscribeChannels(), String.class));
    }

    public void subscribeToChannels(String ... channels) {
        this.serviceClient.post(new UpdateEventSubscriber().setId(this.connectionInfo.getId()).setSubscribeChannels(Func.toList(channels)));
        this.update(channels, null);
    }

    public void unSubscribeFromChannels(String ... channels) {
        this.serviceClient.post(new UpdateEventSubscriber().setId(this.connectionInfo.getId()).setUnsubscribeChannels(Func.toList(channels)));
        this.update(null, channels);
    }

    public void update(String[] subscribe, String[] unsubscribe) {
        ArrayList<String> snapshot = Func.toList(this.getChannels());
        if (subscribe != null) {
            for (String channel : subscribe) {
                if (snapshot.contains(channel)) continue;
                snapshot.add(channel);
            }
        }
        if (unsubscribe != null) {
            snapshot.removeAll(Func.toList(unsubscribe));
        }
        this.setChannels(Func.toArray(snapshot, String.class));
    }
}

