/*
 * Decompiled with CFR 0.152.
 */
package net.servicestack.client.sse;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import net.servicestack.client.Log;
import net.servicestack.client.Utils;
import net.servicestack.client.sse.ServerEventCallback;
import net.servicestack.client.sse.ServerEventMessage;
import net.servicestack.client.sse.ServerEventsClient;

public class EventStream
implements Runnable {
    static int BufferSize = 65536;
    ServerEventsClient client;
    ServerEventMessage currentMsg;

    public EventStream(ServerEventsClient client) {
        this.client = client;
    }

    protected InputStream getInputStream(URL streamUri) throws IOException {
        HttpURLConnection req = (HttpURLConnection)streamUri.openConnection();
        return new BufferedInputStream(req.getInputStream());
    }

    public void cancel() {
    }

    @Override
    public void run() {
        InputStream is = null;
        try {
            if (this.client.running.get()) {
                return;
            }
            this.client.running.set(true);
            URL streamUri = new URL(this.client.getEventStreamUri());
            is = this.getInputStream(streamUri);
            this.client.errorsCount.set(0);
            this.readStream(is);
            Utils.closeQuietly(is);
            this.client.running.set(false);
        }
        catch (InterruptedException ie) {
            Log.i("EventStream.run(): Caught InterruptedException");
            return;
        }
        catch (Exception e) {
            Log.e("Error reading from event-stream, continuous errors: " + this.client.errorsCount.incrementAndGet(), e);
            Log.e(Utils.getStackTrace(e));
        }
        finally {
            Utils.closeQuietly(is);
            this.client.running.set(false);
        }
        if (!this.client.running.get()) {
            this.client.restart();
        }
    }

    protected int readFromStream(InputStream inputStream, byte[] buffer) throws IOException, InterruptedException {
        int available;
        while ((available = inputStream.available()) <= 0) {
            Thread.sleep(1L);
        }
        int len = inputStream.read(buffer);
        return len;
    }

    protected void readStream(InputStream inputStream) throws IOException, InterruptedException {
        byte[] buffer = new byte[BufferSize];
        String overflowText = "";
        int len = 0;
        while ((len = this.readFromStream(inputStream, buffer)) > 0) {
            int pos;
            String text = overflowText + new String(buffer, 0, len, "UTF-8");
            while ((pos = text.indexOf(10)) >= 0) {
                if (pos == 0) {
                    if (this.currentMsg != null) {
                        this.processEventMessage(this.currentMsg);
                    }
                    this.currentMsg = null;
                    if (Utils.isEmpty(text = text.substring(pos + 1))) break;
                    continue;
                }
                String line = text.substring(0, pos);
                if (!Utils.isNullOrWhiteSpace(line)) {
                    this.processLine(line);
                }
                if (text.length() <= pos + 1) continue;
                text = text.substring(pos + 1);
            }
            overflowText = text;
        }
        if (Log.isDebugEnabled()) {
            Log.d("Connection ended on " + this.client.getConnectionDisplayName());
        }
    }

    protected void processLine(String line) {
        if (line == null || line.length() == 0) {
            return;
        }
        if (this.currentMsg == null) {
            this.currentMsg = new ServerEventMessage();
        }
        String[] parts = Utils.splitOnFirst(line, ':');
        String label = parts[0];
        String data = parts[1];
        if (data.length() > 0 && data.charAt(0) == ' ') {
            data = data.substring(1);
        }
        if ("id".equals(label)) {
            this.currentMsg.setEventId(Long.parseLong(data));
        } else if ("data".equals(label)) {
            this.currentMsg.setData(data);
        }
    }

    protected void processEventMessage(ServerEventMessage e) {
        String[] parts = Utils.splitOnFirst(e.getData(), ' ');
        e.setSelector(parts[0]);
        String[] selParts = Utils.splitOnFirst(e.getSelector(), '@');
        if (selParts.length > 1) {
            e.setChannel(selParts[0]);
            e.setSelector(selParts[1]);
        }
        e.setJson(parts[1]);
        if (!Utils.isNullOrEmpty(e.getSelector())) {
            parts = Utils.splitOnFirst(e.getSelector(), '.');
            if (parts.length < 2) {
                throw new IllegalArgumentException("Invalid Selector '" + e.getSelector() + "'");
            }
            e.setOp(parts[0]);
            String target = parts[1].replace("%20", " ");
            String[] tokens = Utils.splitOnFirst(target, '$');
            e.setTarget(tokens[0]);
            if (tokens.length > 1) {
                e.setCssSelector(tokens[1]);
            }
            if ("cmd".equals(e.getOp())) {
                target = e.getTarget();
                if ("onConnect".equals(target)) {
                    this.client.processOnConnectMessage(e);
                    return;
                }
                if ("onJoin".equals(target)) {
                    this.client.processOnJoinMessage(e);
                    return;
                }
                if ("onLeave".equals(target)) {
                    this.client.processOnLeaveMessage(e);
                    return;
                }
                if ("onUpdate".equals(target)) {
                    this.client.processOnUpdateMessage(e);
                    return;
                }
                if ("onHeartbeat".equals(target)) {
                    this.client.processOnHeartbeatMessage(e);
                    return;
                }
                ServerEventCallback cb = this.client.getHandlers().get(e.getTarget());
                if (cb != null) {
                    cb.execute(this.client, e);
                }
            } else if ("trigger".equals(e.getOp())) {
                this.client.onTriggerReceived(e);
            }
            ServerEventCallback receiver = this.client.getNamedReceivers().get(e.getOp());
            if (receiver != null) {
                receiver.execute(this.client, e);
            }
        }
        this.client.onMessageReceived(e);
    }
}

