/*
 * Decompiled with CFR 0.152.
 */
package net.servicestack.client;

import net.servicestack.client.Utils;

public class TimeSpan {
    public static final double TicksPerSecond = 1.0E7;
    double durationSecs = 0.0;

    public TimeSpan() {
    }

    public TimeSpan(double durationSecs) {
        this.durationSecs = durationSecs;
    }

    public TimeSpan(int hours, int mins, int secs) {
        this.addHours(hours);
        this.addMinutes(mins);
        this.addSeconds(secs);
    }

    public TimeSpan(int days, int hours, int mins, int secs) {
        this.addDays(days);
        this.addHours(hours);
        this.addMinutes(mins);
        this.addSeconds(secs);
    }

    public TimeSpan(int days, int hours, int mins, int secs, int ms) {
        this.addDays(days);
        this.addHours(hours);
        this.addMinutes(mins);
        this.addSeconds(secs);
        this.addMillis(ms);
    }

    public TimeSpan addDays(int days) {
        this.durationSecs += (double)(days * 24 * 60 * 60);
        return this;
    }

    double getTotalSeconds() {
        return this.durationSecs;
    }

    int getTotalHours() {
        return (int)this.durationSecs / 60 / 60;
    }

    int getTotalMinutes() {
        return (int)this.durationSecs / 60;
    }

    public int getDays() {
        return (int)this.durationSecs / 24 / 60 / 60;
    }

    public TimeSpan addHours(int hours) {
        this.durationSecs += (double)(hours * 60 * 60);
        return this;
    }

    public int getHours() {
        return this.getTotalHours() - this.getDays() * 24;
    }

    public TimeSpan addMinutes(int mins) {
        this.durationSecs += (double)(mins * 60);
        return this;
    }

    public int getMinutes() {
        return this.getTotalMinutes() - (this.getDays() * 24 * 60 + this.getHours() * 60);
    }

    public TimeSpan addSeconds(int secs) {
        this.durationSecs += (double)secs;
        return this;
    }

    public int getSeconds() {
        return (int)this.durationSecs - (this.getDays() * 24 * 60 * 60 + this.getHours() * 60 * 60 + this.getMinutes() * 60);
    }

    public TimeSpan addMillis(int ms) {
        this.durationSecs += (double)ms / 1000.0;
        return this;
    }

    public int getMillis() {
        return (int)((this.durationSecs - (double)((int)this.durationSecs)) * 1000.0);
    }

    public String toXsdDuration() {
        StringBuilder sb = new StringBuilder("P");
        double totalSeconds = this.getTotalSeconds();
        int wholeSeconds = (int)totalSeconds;
        int seconds = wholeSeconds;
        int sec = seconds >= 60 ? seconds % 60 : seconds;
        int min = (seconds /= 60) >= 60 ? seconds % 60 : seconds;
        int hours = (seconds /= 60) >= 24 ? seconds % 24 : seconds;
        int days = seconds / 24;
        double remainingSecs = (double)sec + (totalSeconds - (double)wholeSeconds);
        if (days > 0) {
            sb.append(days + "D");
        }
        if (days == 0 || (double)(hours + min + sec) + remainingSecs > 0.0) {
            sb.append("T");
            if (hours > 0) {
                sb.append(hours + "H");
            }
            if (min > 0) {
                sb.append(min + "M");
            }
            if (remainingSecs > 0.0) {
                String secFmt = String.format("%.7f", remainingSecs);
                secFmt = Utils.trimEnd(secFmt, '0');
                secFmt = Utils.trimEnd(secFmt, '.');
                sb.append(secFmt).append("S");
            } else if (sb.length() == 2) {
                sb.append("0S");
            }
        }
        String xsdDuration = sb.toString();
        return xsdDuration;
    }

    public static TimeSpan fromXsdDuration(String xsdDuration) {
        return TimeSpan.parse(xsdDuration);
    }

    public static TimeSpan parse(String xsdDuration) {
        Integer day;
        int days = 0;
        int hours = 0;
        int minutes = 0;
        int seconds = 0;
        double ms = 0.0;
        String[] t = Utils.splitOnFirst(xsdDuration.substring(1), 'T');
        boolean hasTime = t.length == 2;
        String[] d = Utils.splitOnFirst(t[0], 'D');
        if (d.length == 2 && (day = Utils.tryParseInt(d[0])) != null) {
            days = day;
        }
        if (hasTime) {
            Double millis;
            String[] s;
            Integer min;
            String[] m;
            Integer hour;
            String[] h = Utils.splitOnFirst(t[1], 'H');
            if (h.length == 2 && (hour = Utils.tryParseInt(h[0])) != null) {
                hours = hour;
            }
            if ((m = Utils.splitOnFirst(h[h.length - 1], 'M')).length == 2 && (min = Utils.tryParseInt(m[0])) != null) {
                minutes = min;
            }
            if ((s = Utils.splitOnFirst(m[m.length - 1], 'S')).length == 2 && (millis = Utils.tryParseDouble(s[0])) != null) {
                ms = millis;
            }
            seconds = (int)ms;
            ms -= (double)seconds;
        }
        double totalSecs = 0 + days * 24 * 60 * 60 + hours * 60 * 60 + minutes * 60 + seconds;
        double interval = totalSecs + ms;
        return new TimeSpan(interval);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TimeSpan)) {
            return false;
        }
        TimeSpan timeSpan = (TimeSpan)o;
        return Double.compare(timeSpan.durationSecs, this.durationSecs) == 0;
    }

    public int hashCode() {
        long temp = Double.doubleToLongBits(this.durationSecs);
        return (int)(temp ^ temp >>> 32);
    }
}

