/*
 * Decompiled with CFR 0.152.
 */
package net.servicestack.client;

import net.servicestack.client.LogType;

public class LogProvider {
    protected String prefix = null;
    protected boolean debugEnabled = false;

    public void println(LogType type, Object message) {
        System.out.println(this.getPrefix() + this.logTypeString(type) + ": " + message);
    }

    public LogProvider() {
    }

    public LogProvider(String prefix) {
        this.prefix = prefix;
    }

    public LogProvider(String prefix, boolean debugEnabled) {
        this.prefix = prefix;
        this.debugEnabled = debugEnabled;
    }

    protected String getPrefix() {
        return this.prefix == null ? "" : "[" + this.prefix + "] ";
    }

    public boolean isDebugEnabled() {
        return this.debugEnabled;
    }

    public String logTypeString(LogType logType) {
        switch (logType) {
            case DEBUG: {
                return "DEBUG";
            }
            case WARN: {
                return "WARN";
            }
            case INFO: {
                return "INFO";
            }
            case ERROR: {
                return "ERROR";
            }
        }
        return "UNKNOWN";
    }

    public void d(Object msg) {
        this.debug(msg);
    }

    public void debug(String msg) {
        this.debug((Object)msg);
    }

    public void debug(Object msg) {
        this.println(LogType.DEBUG, msg);
    }

    public void i(Object msg) {
        this.info(msg);
    }

    public void info(String msg) {
        this.info((Object)msg);
    }

    public void info(Object msg) {
        this.println(LogType.INFO, msg);
    }

    public void w(Object msg) {
        this.warn(msg);
    }

    public void warn(String msg) {
        this.warn((Object)msg);
    }

    public void warn(Object msg) {
        this.println(LogType.WARN, msg);
    }

    public void e(Object msg) {
        this.error(msg);
    }

    public void e(Object msg, Exception ex) {
        this.error(msg, ex);
    }

    public void error(String msg) {
        this.error((Object)msg);
    }

    public void error(Object msg) {
        this.println(LogType.ERROR, msg);
    }

    public void error(Object msg, Exception ex) {
        this.println(LogType.ERROR, msg + "\nEXCEPTION" + ex);
    }
}

