/*
 * Decompiled with CFR 0.152.
 */
package net.servicestack.client.sse;

import com.google.gson.JsonObject;
import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import net.servicestack.client.IReceiver;
import net.servicestack.client.IResolver;
import net.servicestack.client.JsonServiceClient;
import net.servicestack.client.JsonUtils;
import net.servicestack.client.Log;
import net.servicestack.client.Utils;
import net.servicestack.client.sse.ExceptionCallback;
import net.servicestack.client.sse.GetEventSubscribers;
import net.servicestack.client.sse.HttpRequestFilter;
import net.servicestack.client.sse.NewInstanceResolver;
import net.servicestack.client.sse.ServerEventCallback;
import net.servicestack.client.sse.ServerEventConnect;
import net.servicestack.client.sse.ServerEventConnectCallback;
import net.servicestack.client.sse.ServerEventHeartbeat;
import net.servicestack.client.sse.ServerEventJoin;
import net.servicestack.client.sse.ServerEventLeave;
import net.servicestack.client.sse.ServerEventMessage;
import net.servicestack.client.sse.ServerEventMessageCallback;
import net.servicestack.client.sse.ServerEventReceiver;
import net.servicestack.client.sse.ServerEventUpdate;
import net.servicestack.client.sse.ServerEventUser;
import net.servicestack.client.sse.UpdateEventSubscriber;
import net.servicestack.func.Func;
import net.servicestack.func.Function;

public class ServerEventsClient
implements Closeable {
    protected String baseUri;
    protected String[] channels;
    protected String eventStreamPath;
    protected String eventStreamUri;
    protected JsonServiceClient serviceClient;
    protected IResolver resolver;
    protected Map<String, ServerEventCallback> handlers;
    protected Map<String, ServerEventCallback> namedReceivers;
    protected ServerEventConnectCallback onConnect;
    protected ServerEventMessageCallback onMessage;
    protected ServerEventMessageCallback onCommand;
    protected ServerEventMessageCallback onHeartbeat;
    protected ExceptionCallback onException;
    protected HttpRequestFilter heartbeatRequestFilter;
    protected ServerEventConnect connectionInfo;
    protected Date lastPulseAt;
    protected Thread bgThread;
    protected final AtomicBoolean stopped = new AtomicBoolean(false);
    protected final AtomicBoolean running = new AtomicBoolean(false);
    static int BufferSize = 65536;
    static int DefaultHeartbeatMs = 10000;
    static int DefaultIdleTimeoutMs = 30000;
    public static String UnknownChannel = "*";
    private AtomicInteger errorsCount = new AtomicInteger();
    Timer heratbeatTimer;

    public ServerEventsClient(String baseUri, String ... channels) {
        this.setBaseUri(baseUri);
        this.setChannels(channels);
        this.serviceClient = new JsonServiceClient(baseUri);
        this.resolver = new NewInstanceResolver();
        this.handlers = new HashMap<String, ServerEventCallback>();
        this.namedReceivers = new HashMap<String, ServerEventCallback>();
    }

    public ServerEventsClient(String baseUrl, String channel) {
        this(baseUrl, new String[]{channel});
    }

    public ServerEventsClient(String baseUrl) {
        this(baseUrl, new String[0]);
    }

    public String getBaseUri() {
        return this.baseUri;
    }

    public void setBaseUri(String baseUri) {
        this.baseUri = baseUri;
        this.eventStreamPath = Utils.combinePath(baseUri, "event-stream");
        this.buildEventStreamUri();
        if (this.serviceClient != null) {
            this.serviceClient.setBaseUrl(baseUri);
        }
    }

    public String[] getChannels() {
        return this.channels;
    }

    public void setChannels(String[] channels) {
        if (channels == null) {
            channels = new String[]{};
        }
        this.channels = channels;
        this.buildEventStreamUri();
    }

    private void buildEventStreamUri() {
        ArrayList<String> encodedChannels = Func.map(this.channels != null ? this.channels : new String[]{}, new Function<String, String>(){

            @Override
            public String apply(String x) {
                try {
                    return URLEncoder.encode(x, "UTF-8");
                }
                catch (UnsupportedEncodingException e) {
                    return x;
                }
            }
        });
        this.eventStreamUri = Utils.addQueryParam(this.eventStreamPath, "channels", Utils.join(encodedChannels, ","), false);
    }

    public String getEventStreamUri() {
        return this.eventStreamUri;
    }

    public JsonServiceClient getServiceClient() {
        return this.serviceClient;
    }

    public IResolver getResolver() {
        return this.resolver;
    }

    public ServerEventsClient setResolver(IResolver resolver) {
        this.resolver = resolver;
        return this;
    }

    public ServerEventsClient setOnConnect(ServerEventConnectCallback onConnect) {
        this.onConnect = onConnect;
        return this;
    }

    public ServerEventsClient setOnMessage(ServerEventMessageCallback onMessage) {
        this.onMessage = onMessage;
        return this;
    }

    public ServerEventsClient setOnCommand(ServerEventMessageCallback onCommand) {
        this.onCommand = onCommand;
        return this;
    }

    public ServerEventsClient setOnException(ExceptionCallback onException) {
        this.onException = onException;
        return this;
    }

    public ServerEventsClient setHeartbeatRequestFilter(HttpRequestFilter heartbeatRequestFilter) {
        this.heartbeatRequestFilter = heartbeatRequestFilter;
        return this;
    }

    public ServerEventsClient setOnHeartbeat(ServerEventMessageCallback onHeartbeat) {
        this.onHeartbeat = onHeartbeat;
        return this;
    }

    public Map<String, ServerEventCallback> getHandlers() {
        return this.handlers;
    }

    public void setHandlers(Map<String, ServerEventCallback> handlers) {
        this.handlers = handlers;
    }

    public ServerEventsClient registerHandler(String name, ServerEventCallback handler) {
        this.handlers.put(name, handler);
        return this;
    }

    public Map<String, ServerEventCallback> getNamedReceivers() {
        return this.namedReceivers;
    }

    public ServerEventsClient registerReceiver(Class<?> receiverClass) {
        return this.registerNamedReceiver("cmd", receiverClass);
    }

    public ServerEventsClient registerNamedReceiver(String name, final Class<?> namedReceiverClass) {
        if (!IReceiver.class.isAssignableFrom(namedReceiverClass)) {
            throw new IllegalArgumentException(namedReceiverClass.getSimpleName() + " must implement IReceiver");
        }
        this.namedReceivers.put(name, new ServerEventCallback(){

            @Override
            public void execute(ServerEventsClient client, ServerEventMessage msg) {
                try {
                    IReceiver receiver = (IReceiver)ServerEventsClient.this.resolver.TryResolve(namedReceiverClass);
                    if (receiver instanceof ServerEventReceiver) {
                        ServerEventReceiver injectReceiver = (ServerEventReceiver)receiver;
                        injectReceiver.setClient(client);
                        injectReceiver.setRequest(msg);
                    }
                    String target = msg.getTarget().replace("-", "");
                    for (Method mi : namedReceiverClass.getDeclaredMethods()) {
                        Class<?>[] args;
                        if (!Modifier.isPublic(mi.getModifiers()) || Modifier.isStatic(mi.getModifiers()) || (args = mi.getParameterTypes()).length != 1 || "equals".equals(mi.getName())) continue;
                        Class<?> requestType = args[0];
                        if (target.equals(requestType.getSimpleName())) {
                            Object request = !Utils.isNullOrEmpty(msg.getJson()) ? JsonUtils.fromJson(msg.getJson(), requestType) : requestType.newInstance();
                            mi.invoke((Object)receiver, request);
                            return;
                        }
                        String actionName = mi.getName();
                        if (!target.equalsIgnoreCase(actionName) && actionName.startsWith("set")) {
                            actionName = actionName.substring(3);
                        }
                        if (!target.equalsIgnoreCase(actionName)) continue;
                        Object request = !Utils.isNullOrEmpty(msg.getJson()) ? JsonUtils.fromJson(msg.getJson(), requestType) : requestType.newInstance();
                        mi.invoke((Object)receiver, request);
                        return;
                    }
                    receiver.noSuchMethod(msg.getTarget(), msg);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        });
        return this;
    }

    public ServerEventConnect getConnectionInfo() {
        return this.connectionInfo;
    }

    public String getSubscriptionId() {
        return this.connectionInfo != null ? this.connectionInfo.getId() : null;
    }

    public String getConnectionDisplayName() {
        return this.connectionInfo != null ? this.connectionInfo.getDisplayName() : "(not connected)";
    }

    private synchronized void interruptBackgroundThread() {
        if (this.bgThread != null) {
            this.bgThread.interrupt();
            try {
                this.bgThread.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.bgThread = null;
        }
    }

    public ServerEventsClient start() {
        this.interruptBackgroundThread();
        this.stopped.set(false);
        this.bgThread = new Thread(new EventStream(this));
        this.bgThread.start();
        this.lastPulseAt = new Date();
        return this;
    }

    public synchronized void restart() {
        try {
            this.internalStop();
            if (this.stopped.get()) {
                return;
            }
            try {
                this.sleepBackOffMultiplier(this.errorsCount.intValue());
                this.start();
            }
            catch (Exception e) {
                this.onExceptionReceived(e);
            }
        }
        catch (Exception ex) {
            Log.e("[SSE-CLIENT] Error whilst restarting: " + ex.getMessage(), ex);
            ex.printStackTrace();
        }
    }

    private void sleepBackOffMultiplier(int continuousErrorsCount) throws InterruptedException {
        if (continuousErrorsCount <= 1) {
            return;
        }
        int MaxSleepMs = 60000;
        Random rand = new Random();
        int min = (int)Math.pow(continuousErrorsCount, 3.0);
        int max = (int)Math.pow(continuousErrorsCount + 1, 3.0);
        int nextTry = Math.min(rand.nextInt(max - min + 1) + min, 60000);
        Log.info("Sleeping for " + nextTry + "ms after " + continuousErrorsCount + " continuous errors");
        Thread.sleep(nextTry);
    }

    public synchronized void stop() {
        this.stopped.set(true);
        this.internalStop();
    }

    public ServerEventsClient waitTillConnected() throws Exception {
        return this.waitTillConnected(Integer.MAX_VALUE);
    }

    public ServerEventsClient waitTillConnected(int timeoutMs) throws Exception {
        Date startedAt = new Date();
        while (this.connectionInfo == null) {
            Thread.sleep(50L);
            if (new Date().getTime() - startedAt.getTime() <= (long)timeoutMs) continue;
            throw new TimeoutException("Not connected after " + timeoutMs + "ms");
        }
        return this;
    }

    private synchronized void internalStop() {
        if (Log.isDebugEnabled()) {
            Log.d("Stop() " + this.getConnectionDisplayName());
        }
        if (this.connectionInfo != null && this.connectionInfo.getUnRegisterUrl() != null) {
            try {
                Utils.readToEnd(this.connectionInfo.getUnRegisterUrl());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.connectionInfo = null;
        this.interruptBackgroundThread();
    }

    private void onCommandReceived(ServerEventMessage e) {
        if (Log.isDebugEnabled()) {
            Log.d("[SSE-CLIENT] OnCommandReceived: (" + e.getClass().getSimpleName() + ") #" + e.getEventId() + " on #" + this.getConnectionDisplayName() + " (" + Utils.join(this.channels, ",") + ")");
        }
        if (this.onCommand != null) {
            this.onCommand.execute(e);
        }
    }

    private void onHeartbeatReceived(ServerEventMessage e) {
        if (Log.isDebugEnabled()) {
            Log.d("[SSE-CLIENT] OnHeartbeatReceived: (" + e.getClass().getSimpleName() + ") #" + e.getEventId() + " on #" + this.getConnectionDisplayName() + " (" + Utils.join(this.channels, ",") + ")");
        }
        if (this.onHeartbeat != null) {
            this.onHeartbeat.execute(e);
        }
    }

    private void onMessageReceived(ServerEventMessage e) {
        if (Log.isDebugEnabled()) {
            Log.d("[SSE-CLIENT] OnMessageReceived: " + e.getEventId() + " on #" + this.getConnectionDisplayName() + " " + Utils.join(this.channels, ","));
        }
        if (this.onMessage != null) {
            this.onMessage.execute(e);
        }
    }

    protected void onExceptionReceived(Exception ex) {
        this.errorsCount.incrementAndGet();
        Log.e("[SSE-CLIENT] OnExceptionReceived: " + ex.getMessage() + " on #" + this.getConnectionDisplayName(), ex);
        if (Log.isDebugEnabled()) {
            Log.d(Utils.getStackTrace(ex));
        }
        if (this.onException != null) {
            this.onException.execute(ex);
        }
        this.restart();
    }

    private void onConnectReceived() {
        if (Log.isDebugEnabled()) {
            Log.d(String.format("[SSE-CLIENT] OnConnectReceived: %s on #%s / %s on (%s)", this.connectionInfo.getEventId(), this.getConnectionDisplayName(), this.connectionInfo.getId(), Utils.join(this.channels, ",")));
        }
        if (this.onConnect != null) {
            this.onConnect.execute(this.connectionInfo);
        }
        this.startNewHeartbeat();
    }

    private void startNewHeartbeat() {
        if (this.connectionInfo == null || this.connectionInfo.getHeartbeatUrl() == null) {
            return;
        }
        if (this.stopped.get()) {
            return;
        }
        if (this.heratbeatTimer == null) {
            this.heratbeatTimer = new Timer("ServerEventsClient Heartbeat");
        }
        this.heratbeatTimer.schedule(new TimerTask(){

            @Override
            public void run() {
                ServerEventsClient.this.Heartbeat();
            }
        }, this.connectionInfo.getHeartbeatIntervalMs(), Integer.MAX_VALUE);
    }

    public void Heartbeat() {
        if (Log.isDebugEnabled()) {
            Log.d("[SSE-CLIENT] Prep for Heartbeat...");
        }
        if (this.connectionInfo == null) {
            return;
        }
        if (this.stopped.get()) {
            return;
        }
        long elapsedMs = new Date().getTime() - this.lastPulseAt.getTime();
        if (elapsedMs > this.connectionInfo.getIdleTimeoutMs()) {
            this.onExceptionReceived(new TimeoutException("Last Heartbeat Pulse was " + elapsedMs + "ms ago"));
            return;
        }
        try {
            URL heartbeatUrl = new URL(this.connectionInfo.getHeartbeatUrl());
            HttpURLConnection conn = (HttpURLConnection)heartbeatUrl.openConnection();
            if (this.heartbeatRequestFilter != null) {
                this.heartbeatRequestFilter.execute(conn);
            }
            if (Log.isDebugEnabled()) {
                Log.d("[SSE-CLIENT] Sending Heartbeat...");
            }
            try {
                String string = Utils.readToEnd(conn.getInputStream(), "UTF-8");
            }
            catch (FileNotFoundException notFound) {
                if (this.stopped.get()) {
                    return;
                }
                Log.e(conn.getResponseMessage(), notFound);
                throw notFound;
            }
            if (Log.isDebugEnabled()) {
                Log.d("[SSE-CLIENT] Heartbeat sent to: " + heartbeatUrl);
            }
            this.startNewHeartbeat();
        }
        catch (Exception e) {
            if (Log.isDebugEnabled()) {
                Log.d("[SSE-CLIENT] Error from Heartbeat: " + e);
            }
            this.onExceptionReceived(e);
        }
    }

    private void processOnConnectMessage(ServerEventMessage e) {
        JsonObject msg = JsonUtils.toJsonObject(e.getJson());
        this.connectionInfo = new ServerEventConnect();
        this.connectionInfo.setId(JsonUtils.asString(msg, "id"));
        this.connectionInfo.setHeartbeatUrl(JsonUtils.asString(msg, "heartbeatUrl"));
        this.connectionInfo.setHeartbeatIntervalMs(JsonUtils.asLong(msg, "heartbeatIntervalMs", DefaultHeartbeatMs));
        this.connectionInfo.setIdleTimeoutMs(JsonUtils.asLong(msg, "idleTimeoutMs", DefaultIdleTimeoutMs));
        this.connectionInfo.setUnRegisterUrl(JsonUtils.asString(msg, "unRegisterUrl"));
        this.connectionInfo.setUserId(JsonUtils.asString(msg, "userId"));
        this.connectionInfo.setDisplayName(JsonUtils.asString(msg, "displayName"));
        this.connectionInfo.setAuthenticated("true".equals(JsonUtils.asString(msg, "isAuthenticated")));
        this.connectionInfo.setProfileUrl(JsonUtils.asString(msg, "profileUrl"));
        this.onConnectReceived();
    }

    private void processOnJoinMessage(ServerEventMessage e) {
        this.onCommandReceived(new ServerEventJoin().populate(e, JsonUtils.toJsonObject(e.getJson())));
    }

    private void processOnLeaveMessage(ServerEventMessage e) {
        this.onCommandReceived(new ServerEventLeave().populate(e, JsonUtils.toJsonObject(e.getJson())));
    }

    private void processOnUpdateMessage(ServerEventMessage e) {
        this.onCommandReceived(new ServerEventUpdate().populate(e, JsonUtils.toJsonObject(e.getJson())));
    }

    private void processOnHeartbeatMessage(ServerEventMessage e) {
        this.lastPulseAt = new Date();
        if (Log.isDebugEnabled()) {
            Log.d("[SSE-CLIENT] LastPulseAt: " + new SimpleDateFormat("HH:mm:ss.SSS", Locale.US).format(this.lastPulseAt));
        }
        this.onHeartbeatReceived(new ServerEventHeartbeat().populate(e, JsonUtils.toJsonObject(e.getJson())));
    }

    @Override
    public void close() {
        this.stop();
    }

    public List<ServerEventUser> getChannelSubscribers() {
        ArrayList<HashMap<String, String>> response = this.serviceClient.get(new GetEventSubscribers().setChannels(Func.toList(this.getChannels())));
        return this.toServerEventUser(response);
    }

    protected ArrayList<ServerEventUser> toServerEventUser(ArrayList<HashMap<String, String>> response) {
        return Func.map(response, new Function<HashMap<String, String>, ServerEventUser>(){

            @Override
            public ServerEventUser apply(HashMap<String, String> map) {
                String channels = map.get("channels");
                ServerEventUser to = new ServerEventUser().setUserId(map.get("userId")).setDisplayName(map.get("displayName")).setProfileUrl(map.get("profileUrl")).setChannels(Utils.isNullOrEmpty(channels) ? channels.split(",") : null);
                ArrayList<String> reservedNames = Func.toList("userId", "displayName", "profileUrl", "channels");
                for (Map.Entry<String, String> entry : map.entrySet()) {
                    if (reservedNames.contains(entry.getKey())) continue;
                    if (to.getMeta() == null) {
                        to.setMeta(new HashMap<String, String>());
                    }
                    to.getMeta().put(entry.getKey(), entry.getValue());
                }
                return to;
            }
        });
    }

    public void updateSubscriber(UpdateEventSubscriber request) {
        if (request.getId() == null) {
            request.setId(this.connectionInfo.getId());
        }
        this.serviceClient.post(request);
        this.update(Func.toArray(request.getSubscribeChannels(), String.class), Func.toArray(request.getUnsubscribeChannels(), String.class));
    }

    public void subscribeToChannels(String ... channels) {
        this.serviceClient.post(new UpdateEventSubscriber().setId(this.connectionInfo.getId()).setSubscribeChannels(Func.toList(channels)));
        this.update(channels, null);
    }

    public void unSubscribeFromChannels(String ... channels) {
        this.serviceClient.post(new UpdateEventSubscriber().setId(this.connectionInfo.getId()).setUnsubscribeChannels(Func.toList(channels)));
        this.update(null, channels);
    }

    public void update(String[] subscribe, String[] unsubscribe) {
        ArrayList<String> snapshot = Func.toList(this.getChannels());
        if (subscribe != null) {
            for (String channel : subscribe) {
                if (snapshot.contains(channel)) continue;
                snapshot.add(channel);
            }
        }
        if (unsubscribe != null) {
            snapshot.removeAll(Func.toList(unsubscribe));
        }
        this.setChannels(Func.toArray(snapshot, String.class));
    }

    class EventStream
    implements Runnable {
        ServerEventsClient client;
        ServerEventMessage currentMsg;

        public EventStream(ServerEventsClient client) {
            this.client = client;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                if (ServerEventsClient.this.running.get()) {
                    return;
                }
                ServerEventsClient.this.running.set(true);
                URL streamUri = new URL(this.client.getEventStreamUri());
                HttpURLConnection req = (HttpURLConnection)streamUri.openConnection();
                BufferedInputStream is = new BufferedInputStream(req.getInputStream());
                ServerEventsClient.this.errorsCount.set(0);
                this.readStream(is);
            }
            catch (InterruptedException ie) {
                Log.i("EventStream.run(): Caught InterruptedException");
                return;
            }
            catch (Exception e) {
                Log.e("Error reading from event-stream, continuous errors: " + ServerEventsClient.this.errorsCount.incrementAndGet(), e);
                Log.e(Utils.getStackTrace(e));
            }
            finally {
                ServerEventsClient.this.running.set(false);
            }
            if (!ServerEventsClient.this.running.get()) {
                this.client.restart();
            }
        }

        private void readStream(InputStream inputStream) throws IOException, InterruptedException {
            byte[] buffer = new byte[BufferSize];
            String overflowText = "";
            int len = 0;
            while (true) {
                int pos;
                int available;
                if ((available = inputStream.available()) <= 0) {
                    Thread.sleep(5L);
                    continue;
                }
                len = inputStream.read(buffer);
                if (len <= 0) break;
                String text = overflowText + new String(buffer, 0, len, "UTF-8");
                while ((pos = text.indexOf(10)) >= 0) {
                    if (pos == 0) {
                        if (this.currentMsg != null) {
                            this.processEventMessage(this.currentMsg);
                        }
                        this.currentMsg = null;
                        if (Utils.isEmpty(text = text.substring(pos + 1))) break;
                        continue;
                    }
                    String line = text.substring(0, pos);
                    if (!Utils.isNullOrWhiteSpace(line)) {
                        this.processLine(line);
                    }
                    if (text.length() <= pos + 1) continue;
                    text = text.substring(pos + 1);
                }
                overflowText = text;
            }
            if (Log.isDebugEnabled()) {
                Log.d("Connection ended on " + this.client.getConnectionDisplayName());
            }
        }

        private void processLine(String line) {
            if (line == null || line.length() == 0) {
                return;
            }
            if (this.currentMsg == null) {
                this.currentMsg = new ServerEventMessage();
            }
            String[] parts = Utils.splitOnFirst(line, ':');
            String label = parts[0];
            String data = parts[1];
            if (data.length() > 0 && data.charAt(0) == ' ') {
                data = data.substring(1);
            }
            if ("id".equals(label)) {
                this.currentMsg.setEventId(Long.parseLong(data));
            } else if ("data".equals(label)) {
                this.currentMsg.setData(data);
            }
        }

        private void processEventMessage(ServerEventMessage e) {
            String[] parts = Utils.splitOnFirst(e.getData(), ' ');
            e.setSelector(parts[0]);
            String[] selParts = Utils.splitOnFirst(e.getSelector(), '@');
            if (selParts.length > 1) {
                e.setChannel(selParts[0]);
                e.setSelector(selParts[1]);
            }
            e.setJson(parts[1]);
            if (!Utils.isNullOrEmpty(e.getSelector())) {
                ServerEventCallback receiver;
                parts = Utils.splitOnFirst(e.getSelector(), '.');
                if (parts.length < 2) {
                    throw new IllegalArgumentException("Invalid Selector '" + e.getSelector() + "'");
                }
                e.setOp(parts[0]);
                String target = parts[1].replace("%20", " ");
                String[] tokens = Utils.splitOnFirst(target, '$');
                e.setTarget(tokens[0]);
                if (tokens.length > 1) {
                    e.setCssSelector(tokens[1]);
                }
                if ("cmd".equals(e.getOp())) {
                    target = e.getTarget();
                    if ("onConnect".equals(target)) {
                        this.client.processOnConnectMessage(e);
                        return;
                    }
                    if ("onJoin".equals(target)) {
                        this.client.processOnJoinMessage(e);
                        return;
                    }
                    if ("onLeave".equals(target)) {
                        this.client.processOnLeaveMessage(e);
                        return;
                    }
                    if ("onUpdate".equals(target)) {
                        this.client.processOnUpdateMessage(e);
                        return;
                    }
                    if ("onHeartbeat".equals(target)) {
                        this.client.processOnHeartbeatMessage(e);
                        return;
                    }
                    ServerEventCallback cb = this.client.getHandlers().get(e.getTarget());
                    if (cb != null) {
                        cb.execute(this.client, e);
                    }
                }
                if ((receiver = this.client.getNamedReceivers().get(e.getOp())) != null) {
                    receiver.execute(this.client, e);
                }
            }
            this.client.onMessageReceived(e);
        }
    }
}

