/*
 * Decompiled with CFR 0.152.
 */
package net.servicestack.func;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import net.servicestack.func.Each;
import net.servicestack.func.Function;
import net.servicestack.func.FunctionIndex;
import net.servicestack.func.Group;
import net.servicestack.func.Predicate;
import net.servicestack.func.Predicate2;
import net.servicestack.func.PredicateIndex;
import net.servicestack.func.Reducer;
import net.servicestack.func.Tuple;

public class Func {
    public static ArrayList<Integer> toList(int ... xs) {
        ArrayList<Integer> to = new ArrayList<Integer>();
        for (int x : xs) {
            to.add(x);
        }
        return to;
    }

    public static ArrayList<Double> toList(double ... xs) {
        ArrayList<Double> to = new ArrayList<Double>();
        for (double x : xs) {
            to.add(x);
        }
        return to;
    }

    @SafeVarargs
    public static <T> ArrayList<T> toList(T ... xs) {
        ArrayList<T> to = new ArrayList<T>();
        for (T x : xs) {
            to.add(x);
        }
        return to;
    }

    public static <T> ArrayList<T> toList(Iterable<T> xs) {
        ArrayList<T> to = new ArrayList<T>();
        if (xs == null) {
            return to;
        }
        for (T x : xs) {
            to.add(x);
        }
        return to;
    }

    public static <T> T[] toArray(Iterable<T> xs, Class<T> cls) {
        return Func.toArray(Func.toList(xs), cls);
    }

    public static <T> T[] toArray(List<T> list, Class<T> cls) {
        Object[] array = (Object[])Array.newInstance(cls, list.size());
        return list.toArray(array);
    }

    public static <K, V> HashMap<K, V> toDictionary(K k1, V v1) {
        HashMap<K, V> to = new HashMap<K, V>();
        to.put(k1, v1);
        return to;
    }

    public static <K, V> HashMap<K, V> toDictionary(K k1, V v1, K k2, V v2) {
        HashMap<K, V> to = new HashMap<K, V>();
        to.put(k1, v1);
        to.put(k2, v2);
        return to;
    }

    public static <K, V> HashMap<K, V> toDictionary(K k1, V v1, K k2, V v2, K k3, V v3) {
        HashMap<K, V> to = new HashMap<K, V>();
        to.put(k1, v1);
        to.put(k2, v2);
        to.put(k3, v3);
        return to;
    }

    public static <K, V> HashMap<K, V> toDictionary(Tuple<K, V> ... xs) {
        HashMap to = new HashMap();
        for (Tuple<K, V> x : xs) {
            to.put(x.A, x.B);
        }
        return to;
    }

    public static <K, T> HashMap<K, T> toDictionary(Iterable<T> xs, Function<T, K> f) {
        HashMap<K, T> to = new HashMap<K, T>();
        for (T x : xs) {
            K key = f.apply(x);
            to.put(key, x);
        }
        return to;
    }

    public static <T> ArrayList<T> ofType(Iterable xs, Class<T> cls) {
        ArrayList to = new ArrayList();
        for (Object x : xs) {
            if (!cls.isInstance(x)) continue;
            to.add(x);
        }
        return to;
    }

    public static <T, R> ArrayList<R> map(T[] xs, Function<T, R> f) {
        return Func.map(Func.toList(xs), f);
    }

    public static <T, R> ArrayList<R> map(Iterable<T> xs, Function<T, R> f) {
        ArrayList<R> to = new ArrayList<R>();
        if (xs == null) {
            return to;
        }
        for (T x : xs) {
            R ret = f.apply(x);
            to.add(ret);
        }
        return to;
    }

    public static <T, R> ArrayList<R> mapi(T[] xs, FunctionIndex<T, R> f) {
        return Func.mapi(Func.toList(xs), f);
    }

    public static <T, R> ArrayList<R> mapi(Iterable<T> xs, FunctionIndex<T, R> f) {
        ArrayList<R> to = new ArrayList<R>();
        if (xs == null) {
            return to;
        }
        int i = 0;
        for (T x : xs) {
            R ret = f.apply(x, i++);
            to.add(ret);
        }
        return to;
    }

    public static <T> void each(T[] xs, Each<T> f) {
        Func.each(Func.toList(xs), f);
    }

    public static <T> void each(Iterable<T> xs, Each<T> f) {
        if (xs == null) {
            return;
        }
        for (T x : xs) {
            f.apply(x);
        }
    }

    public static <T> ArrayList<T> filter(T[] xs, Predicate<T> predicate) {
        return Func.filter(Func.toList(xs), predicate);
    }

    public static <T> ArrayList<T> filter(Iterable<T> xs, Predicate<T> predicate) {
        ArrayList<T> to = new ArrayList<T>();
        if (xs == null) {
            return to;
        }
        for (T x : xs) {
            if (!predicate.apply(x)) continue;
            to.add(x);
        }
        return to;
    }

    public static <T> ArrayList<T> filteri(T[] xs, PredicateIndex<T> predicate) {
        return Func.filteri(Func.toList(xs), predicate);
    }

    public static <T> ArrayList<T> filteri(Iterable<T> xs, PredicateIndex<T> predicate) {
        ArrayList<T> to = new ArrayList<T>();
        if (xs == null) {
            return to;
        }
        int i = 0;
        for (T x : xs) {
            if (!predicate.apply(x, i++)) continue;
            to.add(x);
        }
        return to;
    }

    public static <T> T first(Iterable<T> xs, Predicate<T> predicate) {
        if (xs == null) {
            return null;
        }
        for (T x : xs) {
            if (!predicate.apply(x)) continue;
            return x;
        }
        return null;
    }

    public static <T> T first(T[] xs) {
        return xs == null || xs.length == 0 ? null : (T)xs[0];
    }

    public static <T> T first(Iterable<T> xs) {
        return (T)Func.first(xs, (Object)null);
    }

    public static <T> T first(Iterable<T> xs, T defaultValue) {
        if (xs == null) {
            return defaultValue;
        }
        Iterator<T> i$ = xs.iterator();
        if (i$.hasNext()) {
            T x = i$.next();
            return x;
        }
        return defaultValue;
    }

    public static <T> T last(T[] xs, Predicate<T> predicate) {
        return Func.last(Func.toList(xs), predicate);
    }

    public static <T> T last(Iterable<T> xs, Predicate<T> predicate) {
        if (xs == null) {
            return null;
        }
        for (T x : Func.reverse(xs)) {
            if (!predicate.apply(x)) continue;
            return x;
        }
        return null;
    }

    public static <T> T last(T[] xs) {
        return xs == null ? null : (T)xs[xs.length - 1];
    }

    public static <T> T last(Iterable<T> xs) {
        if (xs == null) {
            return null;
        }
        T last = null;
        for (T x : xs) {
            last = x;
        }
        return last;
    }

    public static <T> boolean contains(T[] xs, Predicate<T> predicate) {
        return Func.contains(Func.toList(xs), predicate);
    }

    public static <T> boolean contains(Iterable<T> xs, Predicate<T> predicate) {
        return Func.first(xs, predicate) != null;
    }

    public static <T> ArrayList<T> skip(T[] xs, int skip) {
        return Func.skip(Func.toList(xs), skip);
    }

    public static <T> ArrayList<T> skip(Iterable<T> xs, int skip) {
        int i = 0;
        ArrayList<T> to = new ArrayList<T>();
        if (xs == null) {
            return to;
        }
        for (T x : xs) {
            if (i++ < skip) continue;
            to.add(x);
        }
        return to;
    }

    public static <T> ArrayList<T> skipWhile(T[] xs, Predicate<T> predicate) {
        return Func.skipWhile(Func.toList(xs), predicate);
    }

    public static <T> ArrayList<T> skipWhile(Iterable<T> xs, Predicate<T> predicate) {
        ArrayList<T> to = new ArrayList<T>();
        if (xs == null) {
            return to;
        }
        boolean started = false;
        for (T x : xs) {
            if (!started && predicate.apply(x)) continue;
            started = true;
            to.add(x);
        }
        return to;
    }

    public static <T> ArrayList<T> skipWhilei(Iterable<T> xs, PredicateIndex<T> predicate) {
        ArrayList<T> to = new ArrayList<T>();
        if (xs == null) {
            return to;
        }
        int i = 0;
        boolean started = false;
        for (T x : xs) {
            if (!started && predicate.apply(x, i++)) continue;
            started = true;
            to.add(x);
        }
        return to;
    }

    public static <T> ArrayList<T> takeWhile(T[] xs, Predicate<T> predicate) {
        return Func.takeWhile(Func.toList(xs), predicate);
    }

    public static <T> ArrayList<T> takeWhile(Iterable<T> xs, Predicate<T> predicate) {
        ArrayList<T> to = new ArrayList<T>();
        if (xs == null) {
            return to;
        }
        for (T x : xs) {
            if (!predicate.apply(x)) {
                return to;
            }
            to.add(x);
        }
        return to;
    }

    public static <T> ArrayList<T> takeWhilei(Iterable<T> xs, PredicateIndex<T> predicate) {
        ArrayList<T> to = new ArrayList<T>();
        if (xs == null) {
            return to;
        }
        int i = 0;
        for (T x : xs) {
            if (!predicate.apply(x, i++)) {
                return to;
            }
            to.add(x);
        }
        return to;
    }

    public static <T> ArrayList<T> take(T[] xs, int take) {
        return Func.take(Func.toList(xs), take);
    }

    public static <T> ArrayList<T> take(Iterable<T> xs, int take) {
        int i = 0;
        ArrayList<T> to = new ArrayList<T>();
        if (xs == null) {
            return to;
        }
        for (T x : xs) {
            if (i++ >= take) {
                return to;
            }
            to.add(x);
        }
        return to;
    }

    public static <T> boolean any(T[] xs, Predicate<T> predicate) {
        return Func.any(Func.toList(xs), predicate);
    }

    public static <T> boolean any(Iterable<T> xs, Predicate<T> predicate) {
        if (xs == null) {
            return false;
        }
        for (T x : xs) {
            if (!predicate.apply(x)) continue;
            return true;
        }
        return false;
    }

    public static <T> boolean all(T[] xs, Predicate<T> predicate) {
        return Func.all(Func.toList(xs), predicate);
    }

    public static <T> boolean all(Iterable<T> xs, Predicate<T> predicate) {
        if (xs == null) {
            return false;
        }
        for (T x : xs) {
            if (predicate.apply(x)) continue;
            return false;
        }
        return true;
    }

    public static <T> ArrayList<T> expand(Iterable<T> ... xss) {
        ArrayList<T> to = new ArrayList<T>();
        if (xss == null) {
            return to;
        }
        for (Iterable<T> xs : xss) {
            for (T x : xs) {
                to.add(x);
            }
        }
        return to;
    }

    public static <T> ArrayList<T> expand(Iterable<List<T>> xss) {
        ArrayList to = new ArrayList();
        if (xss == null) {
            return to;
        }
        for (Iterable iterable : xss) {
            for (Object x : iterable) {
                to.add(x);
            }
        }
        return to;
    }

    public static <T> T elementAt(T[] xs, int index) {
        return Func.elementAt(Func.toList(xs), index);
    }

    public static <T> T elementAt(Iterable<T> xs, int index) {
        if (xs == null) {
            return null;
        }
        int i = 0;
        for (T x : xs) {
            if (i++ != index) continue;
            return x;
        }
        return null;
    }

    public static <T> ArrayList<T> reverse(T[] xs) {
        return Func.reverse(Func.toList(xs));
    }

    public static <T> ArrayList<T> reverse(Iterable<T> xs) {
        if (xs == null) {
            return new ArrayList();
        }
        ArrayList<T> clone = Func.toList(xs);
        Collections.reverse(clone);
        return clone;
    }

    private static <T> ArrayList<T> asReversed(ArrayList<T> xs) {
        if (xs == null) {
            return new ArrayList();
        }
        Collections.reverse(xs);
        return xs;
    }

    public static <T, E> E reduce(T[] xs, E initialValue, Reducer<T, E> reducer) {
        return Func.reduce(Func.toList(xs), initialValue, reducer);
    }

    public static <T, E> E reduce(Iterable<T> xs, E initialValue, Reducer<T, E> reducer) {
        if (xs == null) {
            return initialValue;
        }
        E currentValue = initialValue;
        for (T x : xs) {
            currentValue = reducer.reduce(currentValue, x);
        }
        return currentValue;
    }

    public static <T, E> E reduceRight(T[] xs, E initialValue, Reducer<T, E> reducer) {
        return Func.reduceRight(Func.toList(xs), initialValue, reducer);
    }

    public static <T, E> E reduceRight(Iterable<T> xs, E initialValue, Reducer<T, E> reducer) {
        return Func.reduce(Func.reverse(xs), initialValue, reducer);
    }

    public static <T> String join(T[] xs, String separator) {
        return Func.join(Func.toList(xs), separator);
    }

    public static <T> String join(Iterable<T> xs, String separator) {
        StringBuilder sb = new StringBuilder();
        if (xs == null) {
            return sb.toString();
        }
        for (T x : xs) {
            if (sb.length() > 0) {
                sb.append(separator);
            }
            sb.append(x);
        }
        return sb.toString();
    }

    public static <T extends Comparable<? super T>> ArrayList<T> orderBy(T[] xs) {
        return Func.orderBy(Func.toList(xs));
    }

    public static <T extends Comparable<? super T>> ArrayList<T> orderBy(Iterable<T> xs) {
        return Func.orderBy(Func.toList(xs));
    }

    private static <T extends Comparable<? super T>> ArrayList<T> orderBy(ArrayList<T> cloned) {
        Collections.sort(cloned);
        return cloned;
    }

    public static <T, R extends Comparable<? super R>> ArrayList<T> orderBy(T[] xs, Function<T, R> f) {
        return Func.orderBy(Func.toList(xs), f);
    }

    public static <T, R extends Comparable<? super R>> ArrayList<T> orderBy(Iterable<T> xs, Function<T, R> f) {
        return Func.orderBy(Func.toList(xs), f);
    }

    private static <T, R extends Comparable<? super R>> ArrayList<T> orderBy(ArrayList<T> cloned, final Function<T, R> f) {
        Collections.sort(cloned, new Comparator<T>(){

            @Override
            public int compare(T a, T b) {
                Comparable aVal = (Comparable)f.apply(a);
                Comparable bVal = (Comparable)f.apply(b);
                if (aVal == null && bVal == null) {
                    return 0;
                }
                if (aVal == null) {
                    return -1;
                }
                if (bVal == null) {
                    return 1;
                }
                return aVal.compareTo(bVal);
            }
        });
        return cloned;
    }

    public static <T> ArrayList<T> orderBy(T[] xs, Comparator<T> comparer) {
        return Func.orderBy(Func.toList(xs), comparer);
    }

    public static <T> ArrayList<T> orderBy(Iterable<T> xs, Comparator<T> comparer) {
        return Func.orderBy(Func.toList(xs), comparer);
    }

    private static <T> ArrayList<T> orderBy(ArrayList<T> cloned, Comparator<T> comparer) {
        Collections.sort(cloned, comparer);
        return cloned;
    }

    public static <T, R extends Comparable<? super R>> ArrayList<T> orderByDesc(T[] xs, Function<T, R> f) {
        return Func.asReversed(Func.orderBy(Func.toList(xs), f));
    }

    public static <T, R extends Comparable<? super R>> ArrayList<T> orderByDesc(Iterable<T> xs, Function<T, R> f) {
        return Func.asReversed(Func.orderBy(Func.toList(xs), f));
    }

    public static <T extends Comparable<? super T>> List<T> orderByDesc(T[] xs) {
        return Func.asReversed(Func.orderBy(Func.toList(xs)));
    }

    public static <T extends Comparable<? super T>> List<T> orderByDesc(Iterable<T> xs) {
        return Func.asReversed(Func.orderBy(Func.toList(xs)));
    }

    public static <T> List<T> orderByDesc(T[] xs, Comparator<T> comparer) {
        return Func.asReversed(Func.orderBy(Func.toList(xs), comparer));
    }

    public static <T> List<T> orderByDesc(Iterable<T> xs, Comparator<T> comparer) {
        return Func.asReversed(Func.orderBy(Func.toList(xs), comparer));
    }

    @SafeVarargs
    public static <T> ArrayList<T> orderByAll(T[] xs, Comparator<T> ... comparers) {
        return Func.orderByAll(Func.toList(xs), comparers);
    }

    @SafeVarargs
    public static <T> ArrayList<T> orderByAll(Iterable<T> xs, Comparator<T> ... comparers) {
        return Func.orderByAll(Func.toList(xs), comparers);
    }

    @SafeVarargs
    private static <T> ArrayList<T> orderByAll(ArrayList<T> cloned, final Comparator<T> ... comparers) {
        Collections.sort(cloned, new Comparator<T>(){

            @Override
            public int compare(T a, T b) {
                for (Comparator c : comparers) {
                    int cmp = c.compare(a, b);
                    if (cmp == 0) continue;
                    return cmp;
                }
                return 0;
            }
        });
        return cloned;
    }

    public static <Key, Item> ArrayList<Group<Key, Item>> groupBy(Iterable<Item> xs, Function<Item, Key> f) {
        return Func.groupBy(xs, f, null, null);
    }

    public static <Key, Item> ArrayList<Group<Key, Item>> groupBy(Iterable<Item> xs, Function<Item, Key> f, Predicate2<Key, Key> matchWith) {
        return Func.groupBy(xs, f, matchWith, null);
    }

    public static <Key, Item> ArrayList<Group<Key, Item>> groupBy(Iterable<Item> xs, Function<Item, Key> f, Predicate2<Key, Key> matchWith, Function<Item, Item> valueAs) {
        ArrayList to = new ArrayList();
        HashMap<Key, Group<Key, Item>> map = new HashMap<Key, Group<Key, Item>>();
        Iterator<Item> i$ = xs.iterator();
        while (i$.hasNext()) {
            Group<Key, Item> group;
            Key val;
            Item x;
            Item e = x = i$.next();
            Object key = val = f.apply(e);
            if (matchWith != null) {
                for (Object k : map.keySet()) {
                    if (!matchWith.apply(val, k)) continue;
                    key = k;
                    break;
                }
            }
            if (valueAs != null) {
                e = valueAs.apply(e);
            }
            if (!map.containsKey(key)) {
                group = new Group<Key, Item>(key);
                map.put(key, group);
            } else {
                group = (Group<Key, Item>)map.get(key);
            }
            group.add(e);
        }
        return Func.toList(map.values());
    }

    public static <T> ArrayList<T> distinct(T[] xs) {
        return Func.distinct(Func.toList(xs));
    }

    public static <T> ArrayList<T> distinct(Iterable<T> xs) {
        HashSet<T> to = new HashSet<T>();
        for (T x : xs) {
            to.add(x);
        }
        return Func.toList(to);
    }

    @SafeVarargs
    public static <T> ArrayList<T> union(T[] ... xss) {
        ArrayList<T> to = new ArrayList<T>();
        T[][] arr$ = xss;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            T[] xs;
            for (T x : xs = arr$[i$]) {
                if (to.contains(x)) continue;
                to.add(x);
            }
        }
        return to;
    }

    @SafeVarargs
    public static <T> ArrayList<T> union(Iterable<T> ... xss) {
        ArrayList<T> to = new ArrayList<T>();
        for (Iterable<T> xs : xss) {
            for (T x : xs) {
                if (to.contains(x)) continue;
                to.add(x);
            }
        }
        return to;
    }

    @SafeVarargs
    public static <T> ArrayList<T> concat(T[] ... xss) {
        ArrayList<T> to = new ArrayList<T>();
        T[][] arr$ = xss;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            T[] xs;
            for (T x : xs = arr$[i$]) {
                to.add(x);
            }
        }
        return to;
    }

    @SafeVarargs
    public static <T> ArrayList<T> concat(Iterable<T> ... xss) {
        ArrayList<T> to = new ArrayList<T>();
        for (Iterable<T> xs : xss) {
            for (T x : xs) {
                to.add(x);
            }
        }
        return to;
    }

    @SafeVarargs
    public static <T> ArrayList<T> intersect(T[] ... xss) {
        return Func.intersect(Func.expand(xss));
    }

    @SafeVarargs
    public static <T> ArrayList<T> intersect(Iterable<T> ... xss) {
        ArrayList<T> first = null;
        for (Iterable<T> xs : xss) {
            if (first == null) {
                first = Func.union(xs);
                continue;
            }
            Func.retainOnly(first, Func.toList(xs));
        }
        return first;
    }

    public static <T> void retainOnly(List<T> source, List<T> occurrances) {
        for (int i = source.size() - 1; i >= 0; --i) {
            if (occurrances.contains(source.get(i))) continue;
            source.remove(i);
        }
    }

    @SafeVarargs
    public static <T> ArrayList<T> difference(T[] original, T[] ... xss) {
        return Func.difference(Func.toList(original), new List[]{Func.expand(xss)});
    }

    @SafeVarargs
    public static <T> ArrayList<T> difference(Iterable<T> source, Iterable<T> ... xss) {
        return Func.difference(Func.toList(source), new List[]{Func.expand(xss)});
    }

    @SafeVarargs
    public static <T> ArrayList<T> difference(List<T> source, List<T> ... xss) {
        ArrayList<T> to = new ArrayList<T>();
        for (List<T> xs : xss) {
            for (T x : source) {
                if (xs.contains(x) || to.contains(x)) continue;
                to.add(x);
            }
        }
        return to;
    }

    public static int[] range(int begin, int end) {
        if (end >= begin) {
            int[] to = new int[++end - begin];
            int i = 0;
            while (begin < end) {
                to[i++] = begin++;
            }
            return to;
        }
        int[] to = new int[++begin - end];
        int i = 0;
        while (end < begin) {
            to[i++] = end++;
        }
        return to;
    }

    public static int[] repeat(int repeatedValue, int count) {
        int[] to = new int[count];
        for (int i = 0; i < count; ++i) {
            to[i] = repeatedValue;
        }
        return to;
    }

    public static <T> int count(T[] xs, Predicate<T> predicate) {
        return Func.count(Func.toList(xs), predicate);
    }

    public static <T> int count(Iterable<T> xs, Predicate<T> predicate) {
        if (xs == null) {
            return 0;
        }
        int count = 0;
        for (T x : xs) {
            if (!predicate.apply(x)) continue;
            ++count;
        }
        return count;
    }

    public static int sum(int[] xs) {
        return Func.sum(Func.toList(xs), (Predicate<Integer>)null);
    }

    public static int sum(int[] xs, Predicate<Integer> predicate) {
        return Func.sum(Func.toList(xs), predicate);
    }

    public static Integer sum(Iterable<Integer> xs) {
        return Func.sum(xs, (Predicate<Integer>)null);
    }

    public static Integer sum(Iterable<Integer> xs, Predicate<Integer> predicate) {
        if (xs == null) {
            return 0;
        }
        int sum = 0;
        for (Integer x : xs) {
            if (predicate != null && !predicate.apply(x)) continue;
            sum += x.intValue();
        }
        return sum;
    }

    public static <T> Integer sum(T[] xs, Function<T, Integer> f) {
        return Func.sum(Func.toList(xs), f);
    }

    public static <T> Integer sum(Iterable<T> xs, Function<T, Integer> f) {
        if (xs == null) {
            return 0;
        }
        int sum = 0;
        for (T x : xs) {
            sum += f.apply(x).intValue();
        }
        return sum;
    }

    public static double sumDouble(double[] xs) {
        return Func.sumDouble(Func.toList(xs), (Predicate<Double>)null);
    }

    public static double sumDouble(double[] xs, Predicate<Double> predicate) {
        return Func.sumDouble(Func.toList(xs), predicate);
    }

    public static Double sumDouble(Iterable<Double> xs) {
        return Func.sumDouble(xs, (Predicate<Double>)null);
    }

    public static Double sumDouble(Iterable<Double> xs, Predicate<Double> predicate) {
        if (xs == null) {
            return 0.0;
        }
        double sum = 0.0;
        for (Double x : xs) {
            if (predicate != null && !predicate.apply(x)) continue;
            sum += x.doubleValue();
        }
        return sum;
    }

    public static <T> Double sumDouble(T[] xs, Function<T, Double> f) {
        return Func.sumDouble(Func.toList(xs), f);
    }

    public static <T> Double sumDouble(Iterable<T> xs, Function<T, Double> f) {
        if (xs == null) {
            return 0.0;
        }
        double sum = 0.0;
        for (T x : xs) {
            sum += f.apply(x).doubleValue();
        }
        return sum;
    }

    public static <T> ArrayList<T> expand(T[] ... xss) {
        ArrayList<T> to = new ArrayList<T>();
        if (xss == null) {
            return to;
        }
        T[][] arr$ = xss;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            T[] xs;
            for (T x : xs = arr$[i$]) {
                to.add(x);
            }
        }
        return to;
    }

    public static int min(int[] xs) {
        return Func.min(Func.toList(xs), (Predicate<Integer>)null);
    }

    public static int min(int[] xs, Predicate<Integer> predicate) {
        return Func.min(Func.toList(xs), predicate);
    }

    public static Integer min(Iterable<Integer> xs) {
        return Func.min(xs, (Predicate<Integer>)null);
    }

    public static Integer min(Iterable<Integer> xs, Predicate<Integer> predicate) {
        if (xs == null) {
            return null;
        }
        Integer min = null;
        for (Integer x : xs) {
            if (predicate != null && !predicate.apply(x) || min != null && x >= min) continue;
            min = x;
        }
        return min;
    }

    public static <T> Integer min(T[] xs, Function<T, Integer> f) {
        return Func.min(Func.toList(xs), f);
    }

    public static <T> Integer min(Iterable<T> xs, Function<T, Integer> f) {
        if (xs == null) {
            return null;
        }
        Integer min = null;
        for (T t : xs) {
            Integer x = f.apply(t);
            if (min != null && x >= min) continue;
            min = x;
        }
        return min;
    }

    public static double minDouble(double[] xs) {
        return Func.minDouble(Func.toList(xs), (Predicate<Double>)null);
    }

    public static double minDouble(double[] xs, Predicate<Double> predicate) {
        return Func.minDouble(Func.toList(xs), predicate);
    }

    public static Double minDouble(Iterable<Double> xs) {
        return Func.minDouble(xs, (Predicate<Double>)null);
    }

    public static Double minDouble(Iterable<Double> xs, Predicate<Double> predicate) {
        if (xs == null) {
            return null;
        }
        Double min = null;
        for (Double x : xs) {
            if (predicate != null && !predicate.apply(x) || min != null && !(x < min)) continue;
            min = x;
        }
        return min;
    }

    public static <T> Double minDouble(T[] xs, Function<T, Double> f) {
        return Func.minDouble(Func.toList(xs), f);
    }

    public static <T> Double minDouble(Iterable<T> xs, Function<T, Double> f) {
        if (xs == null) {
            return null;
        }
        Double min = null;
        for (T t : xs) {
            Double x = f.apply(t);
            if (min != null && !(x < min)) continue;
            min = x;
        }
        return min;
    }

    public static int max(int[] xs) {
        return Func.max(Func.toList(xs), (Predicate<Integer>)null);
    }

    public static int max(int[] xs, Predicate<Integer> predicate) {
        return Func.max(Func.toList(xs), predicate);
    }

    public static Integer max(Iterable<Integer> xs) {
        return Func.max(xs, (Predicate<Integer>)null);
    }

    public static Integer max(Iterable<Integer> xs, Predicate<Integer> predicate) {
        if (xs == null) {
            return null;
        }
        Integer max = null;
        for (Integer x : xs) {
            if (predicate != null && !predicate.apply(x) || max != null && x <= max) continue;
            max = x;
        }
        return max;
    }

    public static <T> Integer max(T[] xs, Function<T, Integer> f) {
        return Func.max(Func.toList(xs), f);
    }

    public static <T> Integer max(Iterable<T> xs, Function<T, Integer> f) {
        if (xs == null) {
            return null;
        }
        Integer max = null;
        for (T t : xs) {
            Integer x = f.apply(t);
            if (max != null && x <= max) continue;
            max = x;
        }
        return max;
    }

    public static double maxDouble(double[] xs) {
        return Func.maxDouble(Func.toList(xs), (Predicate<Double>)null);
    }

    public static double maxDouble(double[] xs, Predicate<Double> predicate) {
        return Func.maxDouble(Func.toList(xs), predicate);
    }

    public static Double maxDouble(Iterable<Double> xs) {
        return Func.maxDouble(xs, (Predicate<Double>)null);
    }

    public static Double maxDouble(Iterable<Double> xs, Predicate<Double> predicate) {
        if (xs == null) {
            return null;
        }
        Double max = null;
        for (Double x : xs) {
            if (predicate != null && !predicate.apply(x) || max != null && !(x > max)) continue;
            max = x;
        }
        return max;
    }

    public static <T> Double maxDouble(T[] xs, Function<T, Double> f) {
        return Func.maxDouble(Func.toList(xs), f);
    }

    public static <T> Double maxDouble(Iterable<T> xs, Function<T, Double> f) {
        if (xs == null) {
            return null;
        }
        Double max = null;
        for (T t : xs) {
            Double x = f.apply(t);
            if (max != null && !(x > max)) continue;
            max = x;
        }
        return max;
    }

    public static double avg(int[] xs) {
        return Func.avg(Func.toList(xs), (Predicate<Integer>)null);
    }

    public static double avg(int[] xs, Predicate<Integer> predicate) {
        return Func.avg(Func.toList(xs), predicate);
    }

    public static Double avg(Iterable<Integer> xs) {
        return Func.avg(xs, (Predicate<Integer>)null);
    }

    public static Double avg(Iterable<Integer> xs, Predicate<Integer> predicate) {
        return Func.avg(Func.toList(xs), predicate);
    }

    public static Double avg(List<Integer> xs, Predicate<Integer> predicate) {
        return (double)Func.sum(xs, predicate).intValue() / (double)xs.size();
    }

    public static <T> Double avg(T[] xs, Function<T, Integer> f) {
        return Func.avg(Func.toList(xs), f);
    }

    public static <T> Double avg(Iterable<T> xs, Function<T, Integer> f) {
        return Func.avg(Func.toList(xs), f);
    }

    public static <T> Double avg(List<T> xs, Function<T, Integer> f) {
        return (double)Func.sum(xs, f).intValue() / (double)xs.size();
    }

    public static double avgDouble(double[] xs) {
        return Func.avgDouble(Func.toList(xs), (Predicate<Double>)null);
    }

    public static double avgDouble(double[] xs, Predicate<Double> predicate) {
        return Func.avgDouble(Func.toList(xs), predicate);
    }

    public static Double avgDouble(Iterable<Double> xs) {
        return Func.avgDouble(xs, (Predicate<Double>)null);
    }

    public static Double avgDouble(Iterable<Double> xs, Predicate<Double> predicate) {
        return Func.avgDouble(Func.toList(xs), predicate);
    }

    public static Double avgDouble(List<Double> xs, Predicate<Double> predicate) {
        return Func.sumDouble(xs, predicate) / (double)xs.size();
    }

    public static <T> Double avgDouble(T[] xs, Function<T, Double> f) {
        return Func.avgDouble(Func.toList(xs), f);
    }

    public static <T> Double avgDouble(Iterable<T> xs, Function<T, Double> f) {
        return Func.avgDouble(Func.toList(xs), f);
    }

    public static <T> Double avgDouble(List<T> xs, Function<T, Double> f) {
        return Func.sumDouble(xs, f) / (double)xs.size();
    }

    public static <T, U> List<Tuple<T, U>> join(Iterable<T> xs, final Iterable<U> with, final Predicate2<T, U> match) {
        return Func.expand(Func.map(xs, new Function<T, List<Tuple<T, U>>>(){

            @Override
            public List<Tuple<T, U>> apply(final T t) {
                return Func.map(Func.filter(with, new Predicate<U>(){

                    @Override
                    public boolean apply(U u) {
                        return match.apply(t, u);
                    }
                }), new Function<U, Tuple<T, U>>(){

                    @Override
                    public Tuple<T, U> apply(U u) {
                        return new Tuple(t, u);
                    }
                });
            }
        }));
    }

    public static <T, U> List<Group<T, Tuple<T, U>>> joinGroup(Iterable<T> xs, Iterable<U> with, Predicate2<T, U> match) {
        return Func.groupBy(Func.join(xs, with, match), new Function<Tuple<T, U>, T>(){

            @Override
            public T apply(Tuple<T, U> x) {
                return x.A;
            }
        });
    }
}

