/*
 * Decompiled with CFR 0.152.
 */
package net.servicestack.client;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import java.util.Date;
import java.util.UUID;
import net.servicestack.client.TimeSpan;
import net.servicestack.client.Utils;

public class JsonSerializers {
    public static JsonSerializer<Date> getDateSerializer() {
        return new JsonSerializer<Date>(){

            public JsonElement serialize(Date src, Type typeOfSrc, JsonSerializationContext context) {
                return src == null ? null : new JsonPrimitive(Utils.toJsonDate(src));
            }
        };
    }

    public static JsonDeserializer<Date> getDateDeserializer() {
        return new JsonDeserializer<Date>(){

            public Date deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
                return json == null ? null : Utils.parseDate(json.getAsString());
            }
        };
    }

    public static JsonSerializer<TimeSpan> getTimeSpanSerializer() {
        return new JsonSerializer<TimeSpan>(){

            public JsonElement serialize(TimeSpan src, Type typeOfSrc, JsonSerializationContext context) {
                return src == null ? null : new JsonPrimitive(src.toXsdDuration());
            }
        };
    }

    public static JsonDeserializer<TimeSpan> getTimeSpanDeserializer() {
        return new JsonDeserializer<TimeSpan>(){

            public TimeSpan deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
                return json == null ? null : TimeSpan.parse(json.getAsString());
            }
        };
    }

    public static JsonSerializer<UUID> getGuidSerializer() {
        return new JsonSerializer<UUID>(){

            public JsonElement serialize(UUID src, Type typeOfSrc, JsonSerializationContext context) {
                return src == null ? null : new JsonPrimitive(Utils.toGuidString(src));
            }
        };
    }

    public static JsonDeserializer<UUID> getGuidDeserializer() {
        return new JsonDeserializer<UUID>(){

            public UUID deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
                return json == null ? null : Utils.fromGuidString(json.getAsString());
            }
        };
    }
}

