/*
 * Decompiled with CFR 0.152.
 */
package net.servicestack.client;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.net.HttpURLConnection;
import java.nio.ByteBuffer;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.servicestack.client.Log;
import net.servicestack.client.ResponseError;
import net.servicestack.client.ResponseStatus;
import net.servicestack.func.Func;
import net.servicestack.func.Function;
import org.apache.http.util.ByteArrayBuffer;

public class Utils {
    protected static final char[] hexArray = "0123456789ABCDEF".toCharArray();
    static final String wcfJsonPrefix = "/Date(";
    private static final ThreadLocal<SimpleDateFormat> iso8601Formatter = new ThreadLocal<SimpleDateFormat>(){

        @Override
        protected SimpleDateFormat initialValue() {
            return new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ");
        }
    };
    private static final ThreadLocal<SimpleDateFormat> iso8601FormatterWithMs = new ThreadLocal<SimpleDateFormat>(){

        @Override
        protected SimpleDateFormat initialValue() {
            return new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
        }
    };
    public static final int isoDateLength = "YYYY-MM-DDT00:00:00+00:00".length();
    public static final int isoDateWithMsLength = "YYYY-MM-DDT00:00:00.000+00:00".length();
    public static final int isoDateWithSubMsMin = "YYYY-MM-DDT00:00:00.0000+00:00".length();
    public static final int isoDateWithSubMsMax = "YYYY-MM-DDT00:00:00.0000000+00:00".length();

    public static Integer tryParseInt(String str) {
        try {
            return Integer.parseInt(str);
        }
        catch (Exception ex) {
            return null;
        }
    }

    public static Double tryParseDouble(String str) {
        try {
            return Double.parseDouble(str);
        }
        catch (Exception ex) {
            return null;
        }
    }

    public static Field[] getSerializableFields(Class type) {
        ArrayList<Field> fields = new ArrayList<Field>();
        for (Class c = type; c != null && c != Object.class; c = c.getSuperclass()) {
            for (Field f : c.getDeclaredFields()) {
                if (Modifier.isStatic(f.getModifiers()) || !Modifier.isPublic(f.getModifiers())) continue;
                fields.add(f);
            }
        }
        return fields.toArray(new Field[fields.size()]);
    }

    public static String stripQuotes(String str) {
        String result = str;
        if (str.indexOf("\"") == 0 && str.lastIndexOf("\"") == str.length() - 1) {
            result = str.substring(1, str.length() - 1);
        }
        return result;
    }

    public static void reverse(byte[] bytes) {
        if (bytes == null) {
            return;
        }
        int i = 0;
        for (int j = bytes.length - 1; j > i; --j, ++i) {
            byte hold = bytes[j];
            bytes[j] = bytes[i];
            bytes[i] = hold;
        }
    }

    public static String toHex(byte[] bytes) {
        char[] hexChars = new char[bytes.length * 2];
        for (int j = 0; j < bytes.length; ++j) {
            int v = bytes[j] & 0xFF;
            hexChars[j * 2] = hexArray[v >>> 4];
            hexChars[j * 2 + 1] = hexArray[v & 0xF];
        }
        return new String(hexChars);
    }

    public static byte[] fromHex(String hex) {
        int len = hex.length();
        byte[] data = new byte[len / 2];
        for (int i = 0; i < len; i += 2) {
            data[i / 2] = (byte)((Character.digit(hex.charAt(i), 16) << 4) + Character.digit(hex.charAt(i + 1), 16));
        }
        return data;
    }

    public static String toGuidString(UUID uuid) {
        byte[] guidBytes = Utils.toGuidBytes(uuid);
        String to = Utils.toHex(guidBytes);
        return to;
    }

    public static UUID fromGuidString(String guid) {
        guid = guid.replaceAll("-", "");
        byte[] guidBytes = Utils.fromHex(guid);
        UUID to = Utils.fromGuidBytes(guidBytes);
        return to;
    }

    public static UUID fromGuidBytes(byte[] guidBytes) {
        ByteBuffer buf = ByteBuffer.wrap(guidBytes);
        byte[] first4 = new byte[4];
        buf.get(first4);
        Utils.reverse(first4);
        byte[] second2 = new byte[2];
        buf.get(second2);
        Utils.reverse(second2);
        byte[] third2 = new byte[2];
        buf.get(third2);
        Utils.reverse(third2);
        long lsb = buf.getLong();
        buf = ByteBuffer.wrap(new byte[8]).put(first4).put(second2).put(third2);
        buf.rewind();
        long msb = buf.getLong();
        return new UUID(msb, lsb);
    }

    public static byte[] toGuidBytes(UUID theUuid) {
        ByteBuffer first8 = ByteBuffer.allocate(8);
        first8.putLong(theUuid.getMostSignificantBits());
        first8.rewind();
        byte[] first4 = new byte[4];
        first8.get(first4);
        Utils.reverse(first4);
        byte[] second2 = new byte[2];
        first8.get(second2);
        Utils.reverse(second2);
        byte[] third2 = new byte[2];
        first8.get(third2);
        Utils.reverse(third2);
        ByteBuffer converted16 = ByteBuffer.allocate(16).put(first4).put(second2).put(third2);
        ByteBuffer last8 = ByteBuffer.allocate(8);
        last8.putLong(theUuid.getLeastSignificantBits());
        last8.rewind();
        converted16.put(last8);
        return converted16.array();
    }

    public static String toJsonDate(Date date) {
        return wcfJsonPrefix + date.getTime() + "-0000)/";
    }

    public static Date parseDate(String string) {
        String str;
        String string2 = str = string.startsWith("\\") ? string.substring(1) : string;
        if (str.startsWith(wcfJsonPrefix)) {
            String body = Utils.splitOnLast(Utils.splitOnFirst(str, '(')[1], ')')[0];
            String unixTimeStr = Utils.splitOnFirst(body, '-', 1)[0];
            unixTimeStr = Utils.splitOnFirst(unixTimeStr, '+', 1)[0];
            long unixTime = Long.parseLong(unixTimeStr);
            return new Date(unixTime);
        }
        return Utils.fromIsoDateString(string);
    }

    public static String stripSubMillis(String iso8601string) {
        if (iso8601string.length() < isoDateWithSubMsMin || iso8601string.length() > isoDateWithSubMsMax) {
            return iso8601string;
        }
        String[] parts = Utils.splitOnFirst(iso8601string, '.');
        String suffix = parts[1].substring(parts[1].length() - 6);
        String ms = parts[1].substring(0, 3);
        return parts[0] + "." + ms + suffix;
    }

    public static Date fromIsoDateString(String iso8601string) {
        if (iso8601string == null) {
            return null;
        }
        String s = iso8601string.replace("Z", "+00:00");
        try {
            s = s.substring(0, 22) + s.substring(23);
            s = Utils.stripSubMillis(s);
            if (s.length() == isoDateWithMsLength) {
                return iso8601FormatterWithMs.get().parse(s);
            }
            return iso8601Formatter.get().parse(s);
        }
        catch (Exception e) {
            return Utils.ParseManual(iso8601string);
        }
    }

    public static Date ParseManual(String dateTimeStr) {
        String[] parts;
        if (dateTimeStr == null || dateTimeStr.length() < "yyyy-MM-dd".length()) {
            return null;
        }
        if (dateTimeStr.endsWith("Z")) {
            dateTimeStr = dateTimeStr.substring(0, dateTimeStr.length() - 1);
        }
        if ((parts = dateTimeStr.split("T")).length == 1) {
            parts = Utils.splitOnFirst(dateTimeStr, ' ');
        }
        String[] dateParts = parts[0].split("-");
        int hh = 0;
        int min = 0;
        int ss = 0;
        int ms = 0;
        double subMs = 0.0;
        int offsetMultiplier = 0;
        if (parts.length == 1) {
            return new Date(Utils.tryParseInt(dateParts[0]) - 1900, Utils.tryParseInt(dateParts[1]) - 1, Utils.tryParseInt(dateParts[2]), 0, 0, 0);
        }
        if (parts.length == 2) {
            String[] timeStringParts = parts[1].split("\\+");
            if (timeStringParts.length == 2) {
                offsetMultiplier = -1;
            } else {
                timeStringParts = parts[1].split("-");
                if (timeStringParts.length == 2) {
                    offsetMultiplier = 1;
                }
            }
            String timeOffset = timeStringParts.length == 2 ? timeStringParts[1] : null;
            String[] timeParts = timeStringParts[0].split(":");
            if (timeParts.length == 3) {
                String[] secParts;
                Integer val = null;
                val = Utils.tryParseInt(timeParts[0]);
                if (val != null) {
                    hh = val;
                }
                if ((val = Utils.tryParseInt(timeParts[1])) != null) {
                    min = val;
                }
                if ((val = Utils.tryParseInt((secParts = timeParts[2].split("\\."))[0])) != null) {
                    ss = val;
                }
                if (secParts.length == 2) {
                    String msStr = String.format("%03d", Utils.tryParseInt(secParts[1]));
                    ms = Utils.tryParseInt(msStr.substring(0, 3));
                    if (msStr.length() > 3) {
                        String subMsStr = msStr.substring(3);
                    }
                }
            }
            Date dateTime = new Date(Utils.tryParseInt(dateParts[0]) - 1900, Utils.tryParseInt(dateParts[1]) - 1, Utils.tryParseInt(dateParts[2]), hh, min, ss);
            Calendar cal = Calendar.getInstance();
            cal.setTime(dateTime);
            if (ms > 0) {
                cal.add(14, ms);
            }
            if (offsetMultiplier != 0 && timeOffset != null) {
                timeParts = timeOffset.split(":");
                if (timeParts.length == 2) {
                    hh = Utils.tryParseInt(timeParts[0]);
                    min = Utils.tryParseInt(timeParts[1]);
                } else {
                    hh = Utils.tryParseInt(timeOffset.substring(0, 2));
                    min = Utils.tryParseInt(timeOffset.substring(2));
                }
                cal.add(10, offsetMultiplier * hh);
                cal.add(12, offsetMultiplier * min);
            }
            dateTime = cal.getTime();
            return dateTime;
        }
        return null;
    }

    public static String[] splitOnFirst(String strVal, char needle) {
        return Utils.splitOnFirst(strVal, needle, 0);
    }

    public static String[] splitOnFirst(String strVal, char needle, int start) {
        String[] stringArray;
        if (strVal == null) {
            return new String[0];
        }
        int pos = strVal.indexOf(needle, start);
        if (pos == -1) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = strVal;
        } else {
            String[] stringArray3 = new String[2];
            stringArray3[0] = strVal.substring(0, pos);
            stringArray = stringArray3;
            stringArray3[1] = strVal.substring(pos + 1);
        }
        return stringArray;
    }

    public static String[] splitOnFirst(String strVal, String needle) {
        return Utils.splitOnFirst(strVal, needle, 0);
    }

    public static String[] splitOnFirst(String strVal, String needle, int start) {
        String[] stringArray;
        if (strVal == null) {
            return new String[0];
        }
        int pos = strVal.indexOf(needle, start);
        if (pos == -1) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = strVal;
        } else {
            String[] stringArray3 = new String[2];
            stringArray3[0] = strVal.substring(0, pos);
            stringArray = stringArray3;
            stringArray3[1] = strVal.substring(pos + needle.length());
        }
        return stringArray;
    }

    public static String[] splitOnLast(String strVal, char needle) {
        return Utils.splitOnLast(strVal, needle, strVal.length());
    }

    public static String[] splitOnLast(String strVal, char needle, int start) {
        String[] stringArray;
        if (strVal == null) {
            return new String[0];
        }
        int pos = strVal.lastIndexOf(needle, start);
        if (pos == -1) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = strVal;
        } else {
            String[] stringArray3 = new String[2];
            stringArray3[0] = strVal.substring(0, pos);
            stringArray = stringArray3;
            stringArray3[1] = strVal.substring(pos + 1);
        }
        return stringArray;
    }

    public static String[] splitOnLast(String strVal, String needle) {
        return Utils.splitOnLast(strVal, needle, strVal.length());
    }

    public static String[] splitOnLast(String strVal, String needle, int start) {
        String[] stringArray;
        if (strVal == null) {
            return new String[0];
        }
        int pos = strVal.lastIndexOf(needle, start);
        if (pos == -1) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = strVal;
        } else {
            String[] stringArray3 = new String[2];
            stringArray3[0] = strVal.substring(0, pos);
            stringArray = stringArray3;
            stringArray3[1] = strVal.substring(pos + needle.length());
        }
        return stringArray;
    }

    public static String combinePath(String basePath, String withPath) {
        if (basePath == null) {
            basePath = "";
        }
        if (withPath == null) {
            withPath = "";
        }
        String prefix = basePath.endsWith("/") ? basePath : basePath + "/";
        String suffix = withPath.startsWith("/") ? withPath.substring(1) : withPath;
        return prefix + suffix;
    }

    public static String fromUtf8Bytes(byte[] bytes) {
        try {
            return new String(bytes, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public static byte[] toUtf8Bytes(String string) {
        try {
            return string.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public static String readToEnd(HttpURLConnection response) {
        try {
            return Utils.readToEnd(response.getInputStream(), "UTF-8");
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static String readToEnd(InputStream stream, String charsetName) throws IOException {
        String line;
        BufferedReader reader = new BufferedReader(new InputStreamReader(stream, charsetName));
        StringBuilder sb = new StringBuilder();
        while ((line = reader.readLine()) != null) {
            sb.append(line);
        }
        String text = sb.toString();
        reader.close();
        return text;
    }

    public static byte[] readBytesToEnd(HttpURLConnection response) {
        try {
            return Utils.readBytesToEnd(response.getInputStream());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] readBytesToEnd(InputStream stream) throws IOException {
        ByteArrayBuffer bytes = new ByteArrayBuffer(1024);
        try (BufferedInputStream bufferedStream = new BufferedInputStream(stream, 8192);){
            byte[] buffer = new byte[1024];
            int bytesRead = 0;
            while ((bytesRead = bufferedStream.read(buffer)) > 0) {
                bytes.append(buffer, 0, bytesRead);
            }
            byte[] byArray = bytes.toByteArray();
            return byArray;
        }
    }

    public static String getUnderlyingContentType(String contentType) {
        return Utils.splitOnFirst(contentType, ';')[0].trim().toLowerCase();
    }

    public static boolean matchesContentType(String contentType, String matchesContentType) {
        return Utils.getUnderlyingContentType(contentType).equals(Utils.getUnderlyingContentType(matchesContentType));
    }

    public static String sanitizeVarName(String name) {
        return name.replaceAll("_", "").toLowerCase();
    }

    public static ResponseStatus createResponseStatus(Object obj) {
        if (obj instanceof JsonObject) {
            return Utils.createResponseStatus((JsonObject)obj);
        }
        return null;
    }

    public static ResponseStatus createResponseStatus(JsonObject obj) {
        ResponseStatus status = new ResponseStatus();
        for (Map.Entry jsonElementEntry : obj.entrySet()) {
            String key = (String)jsonElementEntry.getKey();
            String varName = Utils.sanitizeVarName(key);
            try {
                JsonElement field = obj.get(key);
                if (varName.toLowerCase().equals("errorcode")) {
                    status.setErrorCode(((JsonElement)jsonElementEntry.getValue()).getAsString());
                    continue;
                }
                if (varName.toLowerCase().equals("message")) {
                    status.setMessage(((JsonElement)jsonElementEntry.getValue()).getAsString());
                    continue;
                }
                if (varName.toLowerCase().equals("stacktrace")) {
                    status.setStackTrace(((JsonElement)jsonElementEntry.getValue()).getAsString());
                    continue;
                }
                if (!varName.toLowerCase().equals("errors")) continue;
                if (field instanceof JsonArray) {
                    JsonArray jFields = (JsonArray)field;
                    ArrayList<ResponseError> errors = new ArrayList<ResponseError>();
                    for (JsonElement fieldElement : jFields) {
                        JsonObject fieldObj = fieldElement.getAsJsonObject();
                        ResponseError fieldError = new ResponseError();
                        for (Map.Entry entry : fieldObj.entrySet()) {
                            String fieldKey = (String)entry.getKey();
                            String fieldName = Utils.sanitizeVarName(fieldKey);
                            if (fieldName.toLowerCase().equals("errorcode")) {
                                fieldError.setErrorCode(((JsonElement)entry.getValue()).getAsString());
                                continue;
                            }
                            if (fieldName.toLowerCase().equals("message")) {
                                fieldError.setMessage(((JsonElement)entry.getValue()).getAsString());
                                continue;
                            }
                            if (!fieldName.toLowerCase().equals("fieldname")) continue;
                            fieldError.setFieldName(((JsonElement)entry.getValue()).getAsString());
                        }
                        errors.add(fieldError);
                    }
                    status.setErrors(errors);
                }
                status.setStackTrace(obj.get(key).toString());
            }
            catch (JsonParseException e) {
                Log.e((Object)e);
            }
        }
        return status;
    }

    public static <T> ArrayList<T> createList(T ... params) {
        ArrayList<T> to = new ArrayList<T>();
        to.addAll(Arrays.asList(params));
        return to;
    }

    public static <K, V> HashMap<K, V> createMap(K k1, V v1) {
        HashMap<K, V> to = new HashMap<K, V>();
        to.put(k1, v1);
        return to;
    }

    public static <K, V> HashMap<K, V> createMap(K k1, V v1, K k2, V v2) {
        HashMap<K, V> to = new HashMap<K, V>();
        to.put(k1, v1);
        to.put(k2, v2);
        return to;
    }

    public static <K, V> HashMap<K, V> createMap(K k1, V v1, K k2, V v2, K k3, V v3) {
        HashMap<K, V> to = new HashMap<K, V>();
        to.put(k1, v1);
        to.put(k2, v2);
        to.put(k3, v3);
        return to;
    }

    public static boolean equals(String s1, String s2) {
        if (s1 == null) {
            return s2 == null;
        }
        if (s2 == null) {
            return s1 == null;
        }
        return s1.equals(s2);
    }

    public static String trimStart(String text, char character) {
        if (text == null || text.length() == 0) {
            return "";
        }
        int i = 0;
        while (text.charAt(i) == character) {
            ++i;
        }
        return text.substring(i).trim();
    }

    public static String trimEnd(String text, char character) {
        if (text == null || text.length() == 0) {
            return "";
        }
        int i = text.length() - 1;
        while (text.charAt(i) == character) {
            if (--i >= 0) continue;
            return "";
        }
        return text.substring(0, i + 1).trim();
    }

    public static String toHumanFriendlyUrl(String url) {
        if (url == null) {
            return null;
        }
        url = Utils.trimEnd(Func.last(Utils.splitOnFirst(url, "://")), '/');
        return url;
    }

    public static <K, V> HashMap<K, ArrayList<V>> createMap(ArrayList<V> xs, Function<V, K> f) {
        HashMap<K, ArrayList<V>> to = new HashMap<K, ArrayList<V>>();
        if (xs == null) {
            return to;
        }
        for (V val : xs) {
            K key = f.apply(val);
            ArrayList<V> list = (ArrayList<V>)to.get(key);
            if (list == null) {
                list = new ArrayList<V>();
                to.put(key, list);
            }
            list.add(val);
        }
        return to;
    }
}

