/*
 * Decompiled with CFR 0.152.
 */
package net.servicestack.client;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.util.Date;
import java.util.Map;
import java.util.UUID;
import net.servicestack.client.ConnectionFilter;
import net.servicestack.client.ExceptionFilter;
import net.servicestack.client.IReturn;
import net.servicestack.client.JsonSerializers;
import net.servicestack.client.Log;
import net.servicestack.client.ServiceClient;
import net.servicestack.client.TimeSpan;
import net.servicestack.client.Utils;
import net.servicestack.client.WebServiceException;

public class JsonServiceClient
implements ServiceClient {
    static Charset UTF8 = Charset.forName("UTF-8");
    String baseUrl;
    String replyUrl;
    Integer timeoutMs;
    public ConnectionFilter RequestFilter;
    public ConnectionFilter ResponseFilter;
    public ExceptionFilter ExceptionFilter;
    public static ConnectionFilter GlobalRequestFilter;
    public static ConnectionFilter GlobalResponseFilter;
    public static ExceptionFilter GlobalExceptionFilter;
    Gson gson;

    public JsonServiceClient(String baseUrl) {
        this.baseUrl = baseUrl.endsWith("/") ? baseUrl : baseUrl + "/";
        this.replyUrl = this.baseUrl + "json/reply/";
    }

    public void setTimeout(int timeoutMs) {
        this.timeoutMs = timeoutMs;
    }

    public GsonBuilder getGsonBuilder() {
        return new GsonBuilder().registerTypeAdapter(Date.class, JsonSerializers.getDateSerializer()).registerTypeAdapter(Date.class, JsonSerializers.getDateDeserializer()).registerTypeAdapter(TimeSpan.class, JsonSerializers.getTimeSpanSerializer()).registerTypeAdapter(TimeSpan.class, JsonSerializers.getTimeSpanDeserializer()).registerTypeAdapter(UUID.class, JsonSerializers.getGuidSerializer()).registerTypeAdapter(UUID.class, JsonSerializers.getGuidDeserializer());
    }

    public Gson getGson() {
        if (this.gson == null) {
            this.gson = this.getGsonBuilder().create();
        }
        return this.gson;
    }

    public String toJson(Object o) {
        String json = this.getGson().toJson(o);
        return json;
    }

    public Object fromJson(String json, Class c) {
        Object o = this.getGson().fromJson(json, c);
        return o;
    }

    public void setGson(Gson gson) {
        this.gson = gson;
    }

    public String createUrl(Object requestDto) {
        return this.createUrl(requestDto, null);
    }

    public String createUrl(Object requestDto, Map<String, String> query) {
        String requestUrl = this.replyUrl + requestDto.getClass().getSimpleName();
        StringBuilder sb = new StringBuilder();
        Object lastField = null;
        try {
            for (Field f : Utils.getSerializableFields(requestDto.getClass())) {
                Object val = f.get(requestDto);
                if (val == null) continue;
                sb.append(sb.length() == 0 ? "?" : "&");
                sb.append(URLEncoder.encode(f.getName(), "UTF-8"));
                sb.append("=");
                sb.append(URLEncoder.encode(val.toString(), "UTF-8"));
            }
            if (query != null) {
                for (Map.Entry<String, String> entry : query.entrySet()) {
                    String key = entry.getKey();
                    String val = entry.getValue();
                    sb.append(sb.length() == 0 ? "?" : "&");
                    sb.append(URLEncoder.encode(key, "UTF-8"));
                    sb.append("=");
                    if (val == null) continue;
                    sb.append(URLEncoder.encode(val, "UTF-8"));
                }
            }
        }
        catch (UnsupportedEncodingException | IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        return requestUrl + sb.toString();
    }

    public HttpURLConnection createRequest(String url, String httpMethod) {
        return this.createRequest(url, httpMethod, null, null);
    }

    public HttpURLConnection createRequest(String url, String httpMethod, Object request) {
        String contentType = null;
        byte[] requestBody = null;
        if (request != null) {
            contentType = "application/json";
            String json = this.getGson().toJson(request);
            if (Log.isDebugEnabled()) {
                Log.d(json);
            }
            requestBody = json.getBytes(UTF8);
        }
        return this.createRequest(url, httpMethod, requestBody, contentType);
    }

    public HttpURLConnection createRequest(String requestUrl, String httpMethod, byte[] requestBody, String requestType) {
        try {
            URL url = new URL(requestUrl);
            HttpURLConnection req = (HttpURLConnection)url.openConnection();
            if (this.timeoutMs != null) {
                req.setConnectTimeout(this.timeoutMs);
                req.setReadTimeout(this.timeoutMs);
            }
            req.setRequestMethod(httpMethod);
            req.setRequestProperty("Accept", "application/json");
            if (requestType != null) {
                req.setRequestProperty("Content-Type", requestType);
            }
            if (this.RequestFilter != null) {
                this.RequestFilter.exec(req);
            }
            if (GlobalRequestFilter != null) {
                GlobalRequestFilter.exec(req);
            }
            if (requestBody != null) {
                req.setRequestProperty("Content-Length", Integer.toString(requestBody.length));
                DataOutputStream wr = new DataOutputStream(req.getOutputStream());
                wr.write(requestBody);
                wr.flush();
                wr.close();
            }
            return req;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static RuntimeException createException(HttpURLConnection res, int responseCode) {
        WebServiceException webEx = null;
        try {
            String responseBody = Utils.readToEnd(res.getErrorStream(), UTF8.name());
            webEx = new WebServiceException(responseCode, res.getResponseMessage(), responseBody);
            if (res.getHeaderFields().containsKey("Content-Type") && Utils.matchesContentType(res.getHeaderField("Content-Type"), "application/json")) {
                Gson gson = new Gson();
                JsonElement element = (JsonElement)gson.fromJson(responseBody, JsonElement.class);
                JsonObject jsonObj = element.getAsJsonObject();
                for (Map.Entry jsonElementEntry : jsonObj.entrySet()) {
                    if (!((String)jsonElementEntry.getKey()).toLowerCase().equals("responsestatus")) continue;
                    webEx.setResponseStatus(Utils.createResponseStatus(jsonObj.get((String)jsonElementEntry.getKey())));
                    break;
                }
            }
            return webEx;
        }
        catch (IOException e) {
            if (webEx != null) {
                return webEx;
            }
            return new RuntimeException(e);
        }
    }

    public <TResponse> TResponse send(HttpURLConnection req, Object responseClass) {
        try {
            Type resType;
            Class resClass = responseClass instanceof Class ? (Class)responseClass : null;
            Type type = resType = responseClass instanceof Type ? (Type)responseClass : null;
            if (resClass == null && resType == null) {
                throw new RuntimeException("responseClass '" + responseClass.getClass().getSimpleName() + "' must be a Class or Type");
            }
            int responseCode = req.getResponseCode();
            if (responseCode >= 400) {
                RuntimeException ex = JsonServiceClient.createException(req, responseCode);
                if (this.ExceptionFilter != null) {
                    this.ExceptionFilter.exec(req, ex);
                }
                if (GlobalExceptionFilter != null) {
                    GlobalExceptionFilter.exec(req, ex);
                }
                throw ex;
            }
            InputStream is = req.getInputStream();
            if (this.ResponseFilter != null) {
                this.ResponseFilter.exec(req);
            }
            if (GlobalResponseFilter != null) {
                GlobalResponseFilter.exec(req);
            }
            if (Log.isDebugEnabled()) {
                Object response;
                String json = Utils.readToEnd(is, UTF8.name());
                Log.d(json);
                Object object = response = resClass != null ? this.getGson().fromJson(json, resClass) : this.getGson().fromJson(json, resType);
                return (TResponse)object;
            }
            BufferedReader reader = new BufferedReader(new InputStreamReader(is));
            Object response = resClass != null ? this.getGson().fromJson((Reader)reader, resClass) : this.getGson().fromJson((Reader)reader, resType);
            reader.close();
            Object object = response;
            return (TResponse)object;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            req.disconnect();
        }
    }

    static String typeName(Object o) {
        return o.getClass().getSimpleName();
    }

    private String resolveUrl(String relativeOrAbsoluteUrl) {
        return relativeOrAbsoluteUrl.startsWith("http:") || relativeOrAbsoluteUrl.startsWith("https:") ? relativeOrAbsoluteUrl : Utils.combinePath(this.baseUrl, relativeOrAbsoluteUrl);
    }

    @Override
    public <TResponse> TResponse get(IReturn<TResponse> request) {
        return this.send(this.createRequest(this.createUrl(request), "GET"), request.getResponseType());
    }

    @Override
    public <TResponse> TResponse get(IReturn<TResponse> request, Map<String, String> queryParams) {
        return this.send(this.createRequest(this.createUrl(request, queryParams), "GET"), request.getResponseType());
    }

    @Override
    public <TResponse> TResponse get(String path, Class responseType) {
        return this.send(this.createRequest(this.resolveUrl(path), "GET"), responseType);
    }

    @Override
    public <TResponse> TResponse get(String path, Type responseType) {
        return this.send(this.createRequest(this.resolveUrl(path), "GET"), responseType);
    }

    @Override
    public HttpURLConnection get(String path) {
        return this.createRequest(this.resolveUrl(path), "GET");
    }

    @Override
    public <TResponse> TResponse post(IReturn<TResponse> request) {
        return this.send(this.createRequest(Utils.combinePath(this.replyUrl, JsonServiceClient.typeName(request)), "POST", request), request.getResponseType());
    }

    @Override
    public <TResponse> TResponse post(String path, Object request, Class responseType) {
        return this.send(this.createRequest(this.resolveUrl(path), "POST", request), responseType);
    }

    @Override
    public <TResponse> TResponse post(String path, Object request, Type responseType) {
        return this.send(this.createRequest(this.resolveUrl(path), "POST", request), responseType);
    }

    @Override
    public <TResponse> TResponse post(String path, byte[] requestBody, String contentType, Class responseType) {
        return this.send(this.createRequest(this.resolveUrl(path), "POST", requestBody, contentType), responseType);
    }

    @Override
    public <TResponse> TResponse post(String path, byte[] requestBody, String contentType, Type responseType) {
        return this.send(this.createRequest(this.resolveUrl(path), "POST", requestBody, contentType), responseType);
    }

    @Override
    public HttpURLConnection post(String path, byte[] requestBody, String contentType) {
        return this.createRequest(this.resolveUrl(path), "POST", requestBody, contentType);
    }

    @Override
    public <TResponse> TResponse put(IReturn<TResponse> request) {
        return this.send(this.createRequest(Utils.combinePath(this.replyUrl, JsonServiceClient.typeName(request)), "PUT", request), request.getResponseType());
    }

    @Override
    public <TResponse> TResponse put(String path, Object request, Class responseType) {
        return this.send(this.createRequest(this.resolveUrl(path), "PUT", request), responseType);
    }

    @Override
    public <TResponse> TResponse put(String path, Object request, Type responseType) {
        return this.send(this.createRequest(this.resolveUrl(path), "PUT", request), responseType);
    }

    @Override
    public <TResponse> TResponse put(String path, byte[] requestBody, String contentType, Class responseType) {
        return this.send(this.createRequest(this.resolveUrl(path), "PUT", requestBody, contentType), responseType);
    }

    @Override
    public <TResponse> TResponse put(String path, byte[] requestBody, String contentType, Type responseType) {
        return this.send(this.createRequest(this.resolveUrl(path), "PUT", requestBody, contentType), responseType);
    }

    @Override
    public HttpURLConnection put(String path, byte[] requestBody, String contentType) {
        return this.createRequest(this.resolveUrl(path), "PUT", requestBody, contentType);
    }

    @Override
    public <TResponse> TResponse delete(IReturn<TResponse> request) {
        return this.send(this.createRequest(this.createUrl(request), "DELETE"), request.getResponseType());
    }

    @Override
    public <TResponse> TResponse delete(IReturn<TResponse> request, Map<String, String> queryParams) {
        return this.send(this.createRequest(this.createUrl(request, queryParams), "DELETE"), request.getResponseType());
    }

    @Override
    public <TResponse> TResponse delete(String path, Class responseType) {
        return this.send(this.createRequest(this.resolveUrl(path), "DELETE"), responseType);
    }

    @Override
    public <TResponse> TResponse delete(String path, Type responseType) {
        return this.send(this.createRequest(this.resolveUrl(path), "DELETE"), responseType);
    }

    @Override
    public HttpURLConnection delete(String path) {
        return this.createRequest(this.resolveUrl(path), "DELETE");
    }
}

