/*
 * Decompiled with CFR 0.152.
 */
package jp.go.nict.langrid.client.soap.io.parameter;

import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import jp.go.nict.langrid.commons.rpc.intf.Parameter;
import jp.go.nict.langrid.commons.rpc.intf.Schema;

public class EncoderUtil {
    private static Set<Class<?>> simples = new HashSet();
    private static Map<Class<?>, String> xsdTypes;

    public static String getParameterName(Annotation[] annots) {
        for (Annotation a : annots) {
            if (!(a instanceof Parameter)) continue;
            return ((Parameter)a).name();
        }
        return null;
    }

    public static String typeToXsdType(Class<?> type) {
        return xsdTypes.get(type);
    }

    public static String valueToString(Object value) {
        return value.toString();
    }

    public static String getNamespace(Class<?> clazz) {
        int i;
        String cn;
        Schema s = clazz.getAnnotation(Schema.class);
        String ns = null;
        if (s != null && (ns = s.namespace()).trim().length() == 0) {
            ns = null;
        }
        if (ns == null && (cn = clazz.getName()).startsWith("jp.go.nict.langrid.service_1_2.") && (i = (cn = cn.substring("jp.go.nict.langrid.service_1_2.".length())).lastIndexOf(".")) != -1) {
            ns = "http://langrid.nict.go.jp/ws_1_2/" + cn.substring(0, i + 1).replace('.', '/');
        }
        if (ns == null) {
            ns = "java:" + clazz.getPackage().getName();
        }
        return ns;
    }

    public static boolean isSimpleType(Class<?> type) {
        return simples.contains(type);
    }

    static {
        simples.add(String.class);
        simples.add(Boolean.class);
        simples.add(Character.class);
        simples.add(Short.class);
        simples.add(Integer.class);
        simples.add(Long.class);
        simples.add(Float.class);
        simples.add(Double.class);
        simples.add(Boolean.TYPE);
        simples.add(Character.TYPE);
        simples.add(Short.TYPE);
        simples.add(Integer.TYPE);
        simples.add(Long.TYPE);
        simples.add(Float.TYPE);
        simples.add(Double.TYPE);
        xsdTypes = new HashMap();
        xsdTypes.put(String.class, "string");
        xsdTypes.put(Boolean.class, "boolean");
        xsdTypes.put(Character.class, "unsignedShort");
        xsdTypes.put(Short.class, "short");
        xsdTypes.put(Integer.class, "int");
        xsdTypes.put(Long.class, "long");
        xsdTypes.put(Float.class, "float");
        xsdTypes.put(Double.class, "double");
        xsdTypes.put(Boolean.TYPE, "boolean");
        xsdTypes.put(Character.TYPE, "unsignedShort");
        xsdTypes.put(Short.TYPE, "short");
        xsdTypes.put(Integer.TYPE, "int");
        xsdTypes.put(Long.TYPE, "long");
        xsdTypes.put(Float.TYPE, "float");
        xsdTypes.put(Double.TYPE, "double");
    }
}

