/*
 * Decompiled with CFR 0.152.
 */
package jp.go.nict.langrid.client.soap.io.parameter;

import java.io.IOException;
import java.io.PrintWriter;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import jp.go.nict.langrid.client.soap.io.parameter.Encoder;

public class CalendarEncoder
extends Encoder {
    private Calendar value;
    private ThreadLocal<DateFormat> format = new ThreadLocal<DateFormat>(){

        @Override
        protected DateFormat initialValue() {
            return new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
        }
    };

    public CalendarEncoder(int indent, String name, Object value) {
        super(indent, name);
        this.value = (Calendar)value;
    }

    @Override
    public void write(PrintWriter writer) throws IOException {
        this.writeIndent(writer);
        String s = this.format.get().format(this.value.getTime());
        writer.println(String.format("<%s xsi:type=\"xsd:dateTime\">%s</%1$s>", this.getName(), s.substring(0, s.length() - 2) + ":" + s.substring(s.length() - 2)));
    }
}

