/*
 * Decompiled with CFR 0.152.
 */
package jp.go.nict.langrid.client.soap.io.parameter;

import java.io.IOException;
import java.io.PrintWriter;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import jp.go.nict.langrid.client.soap.io.parameter.Encoder;
import jp.go.nict.langrid.client.soap.io.parameter.EncoderUtil;
import jp.go.nict.langrid.client.soap.io.parameter.Encoders;
import jp.go.nict.langrid.commons.io.CascadingIOException;

public class ArrayEncoder
extends Encoder {
    private Class<?> type;
    private Object value;

    public ArrayEncoder(int indent, String name, Class<?> type, Object value) {
        super(indent, name);
        this.type = type;
        this.value = value;
    }

    @Override
    public void write(PrintWriter writer) throws IOException {
        Class<?> ct = this.type.getComponentType();
        int n = Array.getLength(this.value);
        this.writeIndent(writer);
        String xsiType = EncoderUtil.typeToXsdType(ct);
        if (xsiType != null) {
            writer.println(String.format("<%s soapenc:arrayType=\"xsd:%s[%s]\" xsi:type=\"soapenc:Array\" %s>", this.getName(), xsiType, n == 0 ? "" : Integer.toString(n), "xmlns:soapenc=\"http://schemas.xmlsoap.org/soap/encoding/\""));
        } else {
            writer.println(String.format("<%s soapenc:arrayType=\"ns:%s[%s]\" xsi:type=\"soapenc:Array\" xmlns:ns=\"%s\" %s>", this.getName(), ct.getSimpleName(), n == 0 ? "" : Integer.toString(n), EncoderUtil.getNamespace(ct), "xmlns:soapenc=\"http://schemas.xmlsoap.org/soap/encoding/\""));
        }
        try {
            for (int i = 0; i < n; ++i) {
                Object element = Array.get(this.value, i);
                Encoders.create(this.getIndent() + 1, this.getName(), ct, element).write(writer);
            }
        }
        catch (IllegalAccessException e) {
            throw new CascadingIOException((Throwable)e);
        }
        catch (IllegalArgumentException e) {
            throw new CascadingIOException((Throwable)e);
        }
        catch (InvocationTargetException e) {
            throw new CascadingIOException((Throwable)e);
        }
        this.writeClosingTag(writer);
    }
}

