/*
 * Decompiled with CFR 0.152.
 */
package jp.go.nict.langrid.client.soap;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Collection;
import jp.go.nict.langrid.client.ClientFactory;
import jp.go.nict.langrid.client.ResponseAttributes;
import jp.go.nict.langrid.client.RpcRequestAttributes;
import jp.go.nict.langrid.client.RpcResponseAttributes;
import jp.go.nict.langrid.client.soap.InputStreamFilter;
import jp.go.nict.langrid.client.soap.OutputStreamFilter;
import jp.go.nict.langrid.client.soap.SoapRequestAttributes;
import jp.go.nict.langrid.client.soap.io.SoapRequestWriter;
import jp.go.nict.langrid.client.soap.io.SoapResponseParser;
import jp.go.nict.langrid.commons.beanutils.Converter;
import jp.go.nict.langrid.commons.io.StreamUtil;
import jp.go.nict.langrid.commons.rpc.RpcFault;
import jp.go.nict.langrid.commons.rpc.RpcFaultUtil;
import jp.go.nict.langrid.commons.rpc.RpcHeader;
import jp.go.nict.langrid.commons.util.Trio;
import org.apache.commons.lang.StringEscapeUtils;

public class SoapClientFactory
implements ClientFactory {
    private Converter converter = new Converter();
    private static InputStreamFilter inputStreamFilter = new InputStreamFilter(){

        @Override
        public InputStream filter(InputStream is) {
            return is;
        }
    };
    private static OutputStreamFilter outputStreamFilter = new OutputStreamFilter(){

        @Override
        public OutputStream filter(OutputStream os) {
            return os;
        }
    };

    public <T> T create(Class<T> interfaceClass, URL url) {
        AxisStublessInvocationHandler h = new AxisStublessInvocationHandler(url, this.converter);
        return this.create(interfaceClass, h);
    }

    public <T> T create(Class<T> interfaceClass, URL url, String userId, String password) {
        AxisStublessInvocationHandler h = new AxisStublessInvocationHandler(url, this.converter);
        h.reqAttrs.setUserId(userId);
        h.reqAttrs.setPassword(password);
        return this.create(interfaceClass, h);
    }

    private <T> T create(Class<T> interfaceClass, AxisStublessInvocationHandler h) {
        return interfaceClass.cast(Proxy.newProxyInstance(Thread.currentThread().getContextClassLoader(), new Class[]{interfaceClass, SoapRequestAttributes.class, ResponseAttributes.class}, (InvocationHandler)h));
    }

    public Converter getConverter() {
        return this.converter;
    }

    public static InputStreamFilter setInputStreamFilter(InputStreamFilter inputStreamFilter) {
        InputStreamFilter cur = SoapClientFactory.inputStreamFilter;
        SoapClientFactory.inputStreamFilter = inputStreamFilter;
        return cur;
    }

    public static OutputStreamFilter setOutputStreamFilter(OutputStreamFilter outputStreamFilter) {
        OutputStreamFilter cur = SoapClientFactory.outputStreamFilter;
        SoapClientFactory.outputStreamFilter = outputStreamFilter;
        return cur;
    }

    static class AxisStublessInvocationHandler
    implements InvocationHandler {
        private URL url;
        private Converter converter;
        private String targetNamespace;
        private RpcRequestAttributes reqAttrs;
        private RpcResponseAttributes resAttrs;

        public AxisStublessInvocationHandler(URL url, Converter converter) {
            this.url = url;
            this.converter = converter;
            this.reqAttrs = new RpcRequestAttributes();
            this.resAttrs = new RpcResponseAttributes();
        }

        protected void preInvocation() {
        }

        protected void postInvocation() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            Class<?> clz = method.getDeclaringClass();
            if (clz.equals(SoapRequestAttributes.class)) {
                if (method.getName().equals("setTargetNamespace")) {
                    this.targetNamespace = args[0].toString();
                    return null;
                }
                return method.invoke((Object)this.reqAttrs, args);
            }
            if (clz.equals(ResponseAttributes.class)) {
                return method.invoke((Object)this.resAttrs, args);
            }
            HttpURLConnection con = (HttpURLConnection)this.url.openConnection();
            try {
                Object object;
                con.setDoOutput(true);
                con.setConnectTimeout(10000);
                con.setReadTimeout(600000);
                con.setRequestProperty("X-Langrid-Protocol", "SOAP_RPC_ENCODED");
                con.setRequestProperty("Accept", "application/soap+xml");
                con.setRequestProperty("Content-Type", "text/xml; charset=utf-8");
                con.setRequestProperty("SOAPAction", "\"\"");
                this.reqAttrs.setUpConnection(con);
                OutputStream os = outputStreamFilter.filter(con.getOutputStream());
                SoapRequestWriter.writeSoapRequest(os, this.targetNamespace, this.reqAttrs.getAllRpcHeaders(), method, args);
                os.flush();
                int code = con.getResponseCode();
                if (code != 200) {
                    String response = "";
                    try {
                        response = ": " + StringEscapeUtils.unescapeXml((String)StreamUtil.readAsString((InputStream)con.getErrorStream(), (String)"UTF-8"));
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                    con.disconnect();
                    if (code == 403) {
                        throw new RuntimeException("HTTP " + code + response + "  with " + this.reqAttrs.getUserId() + ":*****");
                    }
                    throw new RuntimeException("HTTP " + code + response);
                }
                InputStream is = null;
                try {
                    is = con.getInputStream();
                }
                catch (IOException e) {
                    is = con.getErrorStream();
                }
                is = inputStreamFilter.filter(is);
                try {
                    Class<?> rt = method.getReturnType();
                    Trio<Collection<RpcHeader>, RpcFault, ?> ret = SoapResponseParser.parseSoapResponse(rt, method.getName(), is, this.converter);
                    if (ret == null) {
                        throw new RuntimeException("null response");
                    }
                    this.resAttrs.loadAttributes(con, (Collection)ret.getFirst());
                    if (ret.getSecond() != null) {
                        RpcFault f = (RpcFault)ret.getSecond();
                        throw RpcFaultUtil.rpcFaultToThrowable((RpcFault)f);
                    }
                    object = ret.getThird();
                }
                catch (Throwable throwable) {
                    is.close();
                    throw throwable;
                }
                is.close();
                return object;
            }
            finally {
                con.disconnect();
            }
        }
    }
}

