/*
 * Decompiled with CFR 0.152.
 */
package jp.go.nict.langrid.client.axis;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.Socket;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.util.Hashtable;
import java.util.List;
import java.util.logging.Logger;
import jp.go.nict.langrid.commons.net.proxy.ProxyUtil;
import org.apache.axis.AxisProperties;
import org.apache.axis.components.net.BooleanHolder;
import org.apache.axis.components.net.DefaultSocketFactory;
import org.apache.axis.components.net.SocketFactory;
import org.apache.axis.components.net.TransportClientProperties;
import org.apache.axis.components.net.TransportClientPropertiesFactory;
import org.apache.axis.encoding.Base64;
import org.apache.axis.utils.Messages;

public class ProxySelectingAxisSocketFactory
extends DefaultSocketFactory {
    private static boolean plain;
    private static Class<InetSocketAddress> inetClass;
    private static Constructor<InetSocketAddress> inetConstructor;
    private static Constructor<InetSocketAddress> inetConstructorWithInetAddress;
    private static Constructor<Socket> socketConstructor;
    private static Constructor<Socket> socketConstructorWithProxy;
    private static Method connect;
    private static Logger logger;

    public static void install() {
        AxisProperties.setProperty((String)SocketFactory.class.getName(), (String)ProxySelectingAxisSocketFactory.class.getName());
    }

    public ProxySelectingAxisSocketFactory(Hashtable<?, ?> attributes) {
        super(attributes);
    }

    public Socket create(String host, int port, StringBuffer otherHeaders, BooleanHolder useFullURL) throws Exception {
        int timeout = 0;
        if (this.attributes != null) {
            String value = (String)this.attributes.get(CONNECT_TIMEOUT);
            timeout = value != null ? Integer.parseInt(value) : 0;
        }
        TransportClientProperties tcp = TransportClientPropertiesFactory.create((String)"http");
        Socket sock = null;
        boolean hostInNonProxyList = this.isHostInNonProxyList(host, tcp.getNonProxyHosts());
        if (tcp.getProxyUser().length() != 0) {
            StringBuffer tmpBuf = new StringBuffer();
            tmpBuf.append(tcp.getProxyUser()).append(":").append(tcp.getProxyPassword());
            otherHeaders.append("Proxy-Authorization").append(": Basic ").append(Base64.encode((byte[])tmpBuf.toString().getBytes())).append("\r\n");
        }
        if (port == -1) {
            port = 80;
        }
        if (hostInNonProxyList) {
            sock = ProxySelectingAxisSocketFactory.create(host, port, timeout);
            logger.finest(Messages.getMessage((String)"createdHTTP00"));
        } else if (tcp.getProxyHost().length() == 0 || tcp.getProxyPort().length() == 0) {
            sock = this.createSocketAccordingProxySelector(host, port, timeout, useFullURL);
        } else {
            sock = ProxySelectingAxisSocketFactory.create(tcp.getProxyHost(), new Integer(tcp.getProxyPort()), timeout);
            logger.finest(Messages.getMessage((String)"createdHTTP01", (String)tcp.getProxyHost(), (String)tcp.getProxyPort()));
            useFullURL.value = true;
        }
        return sock;
    }

    private Socket createSocketAccordingProxySelector(String host, int port, int timeout, BooleanHolder useFullURL) throws IllegalAccessException, InstantiationException, InvocationTargetException, IOException, UnknownHostException, URISyntaxException {
        Socket sock = null;
        List<Proxy> proxies = ProxySelector.getDefault().select(new URI(String.format("http://%s:%d/", host, port)));
        if (proxies.equals(ProxyUtil.DIRECT) || proxies.size() == 0) {
            sock = ProxySelectingAxisSocketFactory.create(host, port, timeout);
            logger.finest(Messages.getMessage((String)"createdHTTP00"));
        } else {
            for (Proxy p : proxies) {
                if (p.type().equals((Object)Proxy.Type.HTTP)) {
                    if (!(p.address() instanceof InetSocketAddress)) continue;
                    InetSocketAddress addr = (InetSocketAddress)p.address();
                    sock = addr.getAddress() != null ? ProxySelectingAxisSocketFactory.create(Proxy.NO_PROXY, addr.getAddress(), addr.getPort(), timeout) : ProxySelectingAxisSocketFactory.create(Proxy.NO_PROXY, addr.getHostName(), addr.getPort(), timeout);
                    useFullURL.value = true;
                    logger.finest(Messages.getMessage((String)"createdHTTP01", (String)addr.getHostName(), (String)Integer.toString(addr.getPort())));
                    break;
                }
                if (!p.type().equals((Object)Proxy.Type.SOCKS)) continue;
                sock = ProxySelectingAxisSocketFactory.create(p, host, port, timeout);
                logger.finest(Messages.getMessage((String)"createdHTTP00"));
                break;
            }
            if (sock == null) {
                sock = ProxySelectingAxisSocketFactory.create(host, port, timeout);
                logger.finest(Messages.getMessage((String)"createdHTTP00"));
            }
        }
        return sock;
    }

    private static Socket create(String host, int port, int timeout) throws IllegalAccessException, InstantiationException, InvocationTargetException, IOException, UnknownHostException {
        Socket sock = null;
        if (plain || timeout == 0) {
            sock = new Socket(host, port);
        } else {
            InetSocketAddress address = inetConstructor.newInstance(host, port);
            sock = socketConstructor.newInstance(new Object[0]);
            connect.invoke((Object)sock, address, timeout);
        }
        return sock;
    }

    private static Socket create(Proxy proxy, String host, int port, int timeout) throws IllegalAccessException, InstantiationException, InvocationTargetException, IOException, UnknownHostException {
        Socket sock = null;
        if (plain || timeout == 0) {
            sock = new Socket(proxy);
            sock.connect(inetConstructor.newInstance(host, port));
        } else {
            InetSocketAddress address = inetConstructor.newInstance(host, port);
            sock = socketConstructorWithProxy.newInstance(proxy);
            connect.invoke((Object)sock, address, timeout);
        }
        return sock;
    }

    private static Socket create(Proxy proxy, InetAddress inetAddress, int port, int timeout) throws IllegalAccessException, InstantiationException, InvocationTargetException, IOException, UnknownHostException {
        Socket sock = null;
        if (plain || timeout == 0) {
            sock = new Socket(proxy);
            sock.connect(inetConstructorWithInetAddress.newInstance(inetAddress, port));
        } else {
            InetSocketAddress address = inetConstructorWithInetAddress.newInstance(inetAddress, port);
            sock = socketConstructorWithProxy.newInstance(proxy);
            connect.invoke((Object)sock, address, timeout);
        }
        return sock;
    }

    static {
        try {
            inetClass = Class.forName("java.net.InetSocketAddress");
            plain = false;
            inetConstructor = inetClass.getConstructor(String.class, Integer.TYPE);
            inetConstructorWithInetAddress = inetClass.getConstructor(InetAddress.class, Integer.TYPE);
            socketConstructor = Socket.class.getConstructor(new Class[0]);
            socketConstructorWithProxy = Socket.class.getConstructor(Proxy.class);
            connect = Socket.class.getMethod("connect", inetClass.getSuperclass(), Integer.TYPE);
        }
        catch (Exception e) {
            plain = true;
        }
        logger = Logger.getLogger(ProxySelectingAxisSocketFactory.class.getName());
    }
}

