/*
 * Decompiled with CFR 0.152.
 */
package jp.go.nict.langrid.client.axis;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.soap.Detail;
import javax.xml.soap.MimeHeader;
import javax.xml.soap.MimeHeaders;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFault;
import javax.xml.soap.SOAPHeader;
import jp.go.nict.langrid.client.ResponseAttributes;
import jp.go.nict.langrid.commons.cs.calltree.CallNode;
import jp.go.nict.langrid.commons.cs.calltree.CallTreeUtil;
import jp.go.nict.langrid.commons.rpc.RpcFault;
import jp.go.nict.langrid.commons.rpc.RpcHeader;
import jp.go.nict.langrid.commons.ws.soap.SoapHeaderRpcHeadersAdapter;
import jp.go.nict.langrid.commons.ws.util.MimeHeadersUtil;
import org.apache.axis.Message;
import org.apache.axis.client.Stub;

public class AxisStubResponseAttributes
implements ResponseAttributes {
    private Stub stub;
    private String serviceName;
    private String copyright;
    private String licenseInfo;
    private List<CallNode> callTree = new ArrayList<CallNode>();
    private MimeHeaders mimeHeaders;
    private SOAPHeader soapHeader;
    private SOAPFault soapFault;

    public AxisStubResponseAttributes(Stub stub) {
        this.stub = stub;
    }

    void reload() {
        this.serviceName = null;
        this.copyright = null;
        this.licenseInfo = null;
        this.callTree.clear();
        if (this.stub._getCall() == null) {
            return;
        }
        Message message = this.stub._getCall().getMessageContext().getResponseMessage();
        if (message == null) {
            return;
        }
        this.mimeHeaders = message.getMimeHeaders();
        this.serviceName = MimeHeadersUtil.getJoinedAndDecodedValue((MimeHeaders)this.mimeHeaders, (String)"X-LanguageGrid-ServiceName", (String)", ");
        this.copyright = MimeHeadersUtil.getJoinedAndDecodedValue((MimeHeaders)this.mimeHeaders, (String)"X-LanguageGrid-ServiceCopyright", (String)", ");
        this.licenseInfo = MimeHeadersUtil.getJoinedAndDecodedValue((MimeHeaders)this.mimeHeaders, (String)"X-LanguageGrid-ServiceLicense", (String)", ");
        try {
            this.soapHeader = message.getSOAPHeader();
            this.soapFault = message.getSOAPBody().getFault();
            this.callTree = CallTreeUtil.extractNodes((Iterable)new SoapHeaderRpcHeadersAdapter(this.soapHeader));
        }
        catch (SOAPException e) {
        }
        catch (ParseException parseException) {
            // empty catch block
        }
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public String getCopyright() {
        return this.copyright;
    }

    public String getLicenseInfo() {
        return this.licenseInfo;
    }

    public Collection<CallNode> getCallTree() {
        return this.callTree;
    }

    public Map<String, Object> getResponseMimeHeaders() {
        Iterator it = this.mimeHeaders.getAllHeaders();
        HashMap<String, Object> ret = new HashMap<String, Object>();
        while (it.hasNext()) {
            MimeHeader h = (MimeHeader)it.next();
            ret.put(h.getName(), Arrays.asList(this.mimeHeaders.getHeader(h.getName())));
        }
        return ret;
    }

    public Iterable<RpcHeader> getResponseRpcHeaders() {
        return new SoapHeaderRpcHeadersAdapter(this.soapHeader);
    }

    public RpcFault getResponseRpcFault() {
        if (this.soapFault == null) {
            return null;
        }
        Detail d = this.soapFault.getDetail();
        return new RpcFault(this.soapFault.getFaultCode(), this.soapFault.getFaultString(), d != null ? d.getNodeValue() : null);
    }
}

