/*
 * Decompiled with CFR 0.152.
 */
package jp.go.nict.langrid.client.axis;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import jp.go.nict.langrid.client.AuthMethod;
import jp.go.nict.langrid.client.RequestAttributes;
import jp.go.nict.langrid.client.axis.AxisStubUtil;
import jp.go.nict.langrid.commons.cs.binding.BindingNode;
import jp.go.nict.langrid.commons.cs.binding.DynamicBindingUtil;
import org.apache.axis.client.Stub;

public class AxisStubRequestAttributes
implements RequestAttributes {
    private boolean mightBeModified = false;
    private Stub stub;
    private Map<String, Object> headers = new HashMap<String, Object>();
    private Map<QName, Object> soapHeaders = new HashMap<QName, Object>();
    private List<BindingNode> bindings = new ArrayList<BindingNode>();

    public AxisStubRequestAttributes(Stub stub) {
        this.stub = stub;
        this.mightBeModified = true;
    }

    public void setUserId(String userId) {
        AxisStubUtil.setUserName(this.stub, userId);
    }

    public void setPassword(String password) {
        AxisStubUtil.setPassword(this.stub, password);
    }

    public void setConnectTimeout(int timeoutMillis) {
        AxisStubUtil.setTimeout(this.stub, timeoutMillis);
    }

    public void setTimeout(int timeoutMillis) {
        AxisStubUtil.setTimeout(this.stub, timeoutMillis);
    }

    public void setAuthMethod(AuthMethod method) {
        throw new UnsupportedOperationException();
    }

    public void addRequestMimeHeader(String name, String value) {
        this.mightBeModified = true;
        this.headers.put(name, value);
    }

    public void addRequestMimeHeaders(Map<String, Object> headers) {
        this.mightBeModified = true;
        this.headers.putAll(headers);
    }

    public Map<String, Object> getRequestMimeHeaders() {
        this.mightBeModified = true;
        return this.headers;
    }

    public void addRequestRpcHeader(String namespace, String name, String value) {
        this.mightBeModified = true;
        this.soapHeaders.put(new QName(namespace, name), value);
    }

    public void addRequestRpcHeaders(Map<QName, Object> headers) {
        this.mightBeModified = true;
        this.soapHeaders.putAll(headers);
    }

    public Map<QName, Object> getRequestRpcHeaders() {
        this.mightBeModified = true;
        return this.soapHeaders;
    }

    public Collection<BindingNode> getTreeBindings() {
        this.mightBeModified = true;
        return this.bindings;
    }

    void setUpStub() {
        if (this.mightBeModified) {
            AxisStubUtil.setMimeHeaders(this.stub, this.headers.entrySet());
            HashMap<QName, Object> mergedSoapHeaders = new HashMap<QName, Object>(this.soapHeaders);
            if (this.bindings.size() > 0) {
                String tvalue = DynamicBindingUtil.encodeTree(this.bindings);
                mergedSoapHeaders.put(new QName("http://langrid.nict.go.jp/process/binding/tree", "binding"), tvalue);
            }
            AxisStubUtil.setSoapHeaders(this.stub, mergedSoapHeaders.entrySet());
            this.mightBeModified = false;
        }
    }
}

