/*
 * Decompiled with CFR 0.152.
 */
package jp.go.nict.langrid.client.axis;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import jp.go.nict.langrid.client.ClientFactory;
import jp.go.nict.langrid.client.RequestAttributes;
import jp.go.nict.langrid.client.ResponseAttributes;
import jp.go.nict.langrid.client.axis.AxisStubRequestAttributes;
import jp.go.nict.langrid.client.axis.AxisStubResponseAttributes;
import jp.go.nict.langrid.client.axis.AxisStubUtil;
import jp.go.nict.langrid.commons.beanutils.Converter;
import jp.go.nict.langrid.commons.beanutils.DynamicInvocationHandler;
import jp.go.nict.langrid.commons.util.Pair;
import org.apache.axis.EngineConfiguration;
import org.apache.axis.client.Service;
import org.apache.axis.client.Stub;
import org.apache.axis.transport.http.HTTPConstants;

public class AxisClientFactory
implements ClientFactory {
    private EngineConfiguration config;
    private Map<Class<?>, Pair<Object, Method>> stubs = new HashMap();
    private Converter converter = new Converter();

    public AxisClientFactory() {
    }

    public AxisClientFactory(EngineConfiguration config) {
        this.config = config;
    }

    public <T> T create(Class<T> interfaceClass, URL url) {
        Stub stub = this.createStub(interfaceClass);
        if (stub == null) {
            return null;
        }
        AxisStubUtil.setUrl(stub, url);
        return this.create(interfaceClass, stub);
    }

    public <T> T create(Class<T> interfaceClass, URL url, String userId, String password) {
        Stub stub = this.createStub(interfaceClass);
        if (stub == null) {
            return null;
        }
        AxisStubUtil.setUrl(stub, url);
        AxisStubUtil.setUserName(stub, userId);
        AxisStubUtil.setPassword(stub, password);
        return this.create(interfaceClass, stub);
    }

    private <T> T create(Class<T> interfaceClass, Stub stub) {
        stub._setProperty("axis.transport.version", (Object)HTTPConstants.HEADER_PROTOCOL_V11);
        return interfaceClass.cast(Proxy.newProxyInstance(Thread.currentThread().getContextClassLoader(), new Class[]{interfaceClass, RequestAttributes.class, ResponseAttributes.class}, (InvocationHandler)((Object)new AxisDynamicInvocationHandler(stub, this.converter))));
    }

    public boolean hasStub(Class<?> intf) {
        return this.stubs.containsKey(intf);
    }

    public void registerStub(Class<?> intf, Class<? extends Service> locatorClass, String createMethodName) {
        try {
            Method m = locatorClass.getMethod(createMethodName, new Class[0]);
            Service loc = this.config != null ? locatorClass.getConstructor(EngineConfiguration.class).newInstance(this.config) : locatorClass.newInstance();
            this.stubs.put(intf, (Pair<Object, Method>)Pair.create((Object)loc, (Object)m));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void unregisterStub(Class<?> intf) {
        this.stubs.remove(intf);
    }

    public Converter getConverter() {
        return this.converter;
    }

    private Stub createStub(Class<?> interfaceClass) {
        Pair<Object, Method> s = this.stubs.get(interfaceClass);
        if (s == null) {
            return null;
        }
        try {
            return (Stub)((Method)s.getSecond()).invoke(s.getFirst(), new Object[0]);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    static class AxisDynamicInvocationHandler
    extends DynamicInvocationHandler<Stub> {
        private AxisStubRequestAttributes reqAttr;
        private AxisStubResponseAttributes resAttr;

        public AxisDynamicInvocationHandler(Stub stub, Converter converter) {
            super((Object)stub, converter);
            this.reqAttr = new AxisStubRequestAttributes(stub);
            this.resAttr = new AxisStubResponseAttributes(stub);
        }

        protected void preInvocation() {
            this.reqAttr.setUpStub();
        }

        protected void postInvocation() {
            this.resAttr.reload();
        }

        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            Class<?> clz = method.getDeclaringClass();
            if (clz.equals(RequestAttributes.class)) {
                return method.invoke((Object)this.reqAttr, args);
            }
            if (clz.equals(ResponseAttributes.class)) {
                return method.invoke((Object)this.resAttr, args);
            }
            return super.invoke(proxy, method, args);
        }
    }
}

