/*
 * Decompiled with CFR 0.152.
 */
package net.segoia.util.swing.components;

import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.AWTEventListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseEvent;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.awt.event.WindowListener;
import java.security.AccessController;
import java.security.PrivilegedAction;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.LineBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.metal.MetalBorders;
import net.segoia.java.forms.swing.SwingUiElementsHelper;
import net.segoia.util.swing.components.ComboPanePopup;

public class JComboPane
extends JPanel {
    private static final long serialVersionUID = 6552471190971978570L;
    private JComponent content = new JPanel();
    private String title = "JComboPane";
    private ComboPanePopup popup;
    private JLabel titleLabel;
    private JButton controlButton;
    private boolean opened;
    private MouseGrabber mouseGrabber;

    public JComboPane() {
        this.init();
    }

    private void init() {
        this.initTitleLable();
        this.initControlButton();
        this.setUpLayout();
        this.mouseGrabber = new MouseGrabber();
        this.setPreferredSize(this.getFullSize());
    }

    private void initTitleLable() {
        this.titleLabel = new JLabel(this.title);
        LineBorder border = new LineBorder(Color.BLACK);
        this.titleLabel.setBorder(new MetalBorders.TextFieldBorder());
    }

    private void initControlButton() {
        this.controlButton = new JButton("...");
        Insets insets = this.controlButton.getMargin();
        this.controlButton.setMargin(new Insets(insets.top, insets.top, insets.bottom, insets.top));
        this.controlButton.addActionListener(new ControlButtonListener());
    }

    private void setUpLayout() {
        GridBagLayout layout = new GridBagLayout();
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.fill = 1;
        constraints.gridwidth = -1;
        constraints.weightx = 1.0;
        this.setLayout(layout);
        this.add((Component)this.titleLabel, constraints);
        constraints.weightx = 0.0;
        this.add((Component)this.controlButton, constraints);
    }

    protected void update() {
        this.titleLabel.setText(this.title);
    }

    private Dimension getFullSize() {
        Dimension labelDim = this.titleLabel.getPreferredSize();
        Dimension cbDim = this.controlButton.getPreferredSize();
        double w = labelDim.width + cbDim.width;
        double h = Math.max(labelDim.height, cbDim.height);
        return new Dimension((int)w, (int)h);
    }

    protected Window getParentWindow(Component comp) {
        if (comp == null) {
            return null;
        }
        if (comp.getParent() instanceof Window) {
            return (Window)comp.getParent();
        }
        return this.getParentWindow(comp.getParent());
    }

    public void open() {
        this.createNewPopup();
        this.showNewPopup();
    }

    private void createNewPopup() {
        this.opened = true;
        this.popup = new ComboPanePopup(this.getParentWindow(this));
        Point refPos = this.titleLabel.getLocationOnScreen();
        this.popup.setAnchorPoint(new Point(refPos.x + this.getFullSize().width / 2, refPos.y));
    }

    private void showNewPopup() {
        this.popup.setContent(this.content);
        this.popup.setVisible(true);
        this.mouseGrabber.grabWindow();
    }

    public void validatePopup() {
        if (this.popup != null) {
            this.popup.refresh();
        }
    }

    public void close() {
        if (this.popup != null) {
            this.opened = false;
            this.popup.dispose();
        }
    }

    public ComboPanePopup deliverPopup() {
        this.mouseGrabber.ungrabWindow();
        ComboPanePopup popupref = this.popup;
        this.popup = null;
        this.opened = false;
        return popupref;
    }

    public void receivePopup(ComboPanePopup p) {
        if (p == null) {
            return;
        }
        this.close();
        this.popup = p;
        this.showNewPopup();
    }

    public boolean isOpened() {
        return this.opened;
    }

    public JComponent getContent() {
        return this.content;
    }

    public String getTitle() {
        return this.title;
    }

    public void setContent(JComponent content) {
        this.content = content;
        content.setDoubleBuffered(true);
        this.update();
    }

    public void setTitle(String title) {
        this.title = title;
        this.update();
    }

    public static void main(String[] args) {
        JFrame f = new JFrame();
        f.setLayout(new FlowLayout());
        f.setSize(800, 600);
        JPanel content = new JPanel(new GridBagLayout());
        content.add(SwingUiElementsHelper.createStandardCombo(new Object[]{"JComboPane"}));
        content.add(SwingUiElementsHelper.createStandartButton("bang"));
        content.add(SwingUiElementsHelper.createStandartButton("bang"));
        content.add(SwingUiElementsHelper.createStandartButton("bang"));
        JComboPane nestedCp = new JComboPane();
        JPanel content2 = new JPanel(new GridBagLayout());
        content2.add(SwingUiElementsHelper.createStandardCombo(new Object[]{"JComboPane2"}));
        nestedCp.setContent(content2);
        content.add(nestedCp);
        JComboPane cp = new JComboPane();
        cp.setContent(content);
        f.add(cp);
        f.add(new JButton("test"));
        f.setVisible(true);
    }

    class MouseGrabber
    implements ChangeListener,
    AWTEventListener,
    ComponentListener,
    WindowListener {
        private boolean underMouse;

        void grabWindow() {
            final Toolkit tk = Toolkit.getDefaultToolkit();
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    tk.addAWTEventListener(MouseGrabber.this, 80L);
                    return null;
                }
            });
        }

        void ungrabWindow() {
            final Toolkit tk = Toolkit.getDefaultToolkit();
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    tk.removeAWTEventListener(MouseGrabber.this);
                    return null;
                }
            });
        }

        public void eventDispatched(AWTEvent ev) {
            WindowEvent wev;
            if (ev instanceof MouseEvent) {
                MouseEvent me = (MouseEvent)ev;
                Component src = me.getComponent();
                switch (me.getID()) {
                    case 501: {
                        if (this.underMouse) break;
                        this.cancelPopupMenu();
                        break;
                    }
                    case 504: {
                        this.underMouse = JComboPane.this.popup.equals(ev.getSource()) || JComboPane.this.popup.isAncestorOf((Component)ev.getSource());
                    }
                }
            } else if (ev instanceof WindowEvent && (wev = (WindowEvent)ev).getWindow().equals(JComboPane.this.popup)) {
                switch (wev.getID()) {
                    case 208: {
                        if (JComboPane.this.popup.isAncestorOf(wev.getOppositeWindow()) || JComboPane.this.popup.equals(wev.getWindow())) break;
                        this.cancelPopupMenu();
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void cancelPopupMenu() {
            try {
                JComboPane.this.close();
            }
            finally {
                this.ungrabWindow();
            }
        }

        public void componentResized(ComponentEvent e) {
            this.cancelPopupMenu();
        }

        public void componentMoved(ComponentEvent e) {
            this.cancelPopupMenu();
        }

        public void componentShown(ComponentEvent e) {
            this.cancelPopupMenu();
        }

        public void componentHidden(ComponentEvent e) {
            this.cancelPopupMenu();
        }

        public void windowClosing(WindowEvent e) {
            this.cancelPopupMenu();
        }

        public void windowClosed(WindowEvent e) {
            this.cancelPopupMenu();
        }

        public void windowIconified(WindowEvent e) {
            this.cancelPopupMenu();
        }

        public void windowDeactivated(WindowEvent e) {
            this.cancelPopupMenu();
        }

        public void windowOpened(WindowEvent e) {
        }

        public void windowDeiconified(WindowEvent e) {
        }

        public void windowActivated(WindowEvent e) {
        }

        public void stateChanged(ChangeEvent e) {
        }
    }

    class PopupFocusListener
    implements WindowFocusListener {
        PopupFocusListener() {
        }

        public void windowGainedFocus(WindowEvent e) {
            JComboPane.this.opened = true;
        }

        public void windowLostFocus(WindowEvent e) {
            if (!JComboPane.this.popup.isAncestorOf(e.getOppositeWindow())) {
                JComboPane.this.opened = false;
                JComboPane.this.close();
            } else {
                e.getOppositeWindow().addWindowFocusListener(new WindowFocusListener(){

                    public void windowGainedFocus(WindowEvent e) {
                    }

                    public void windowLostFocus(WindowEvent e) {
                        Window focusedWindow = e.getOppositeWindow();
                        if (!JComboPane.this.popup.equals(focusedWindow) && !JComboPane.this.popup.isAncestorOf(focusedWindow)) {
                            JComboPane.this.close();
                            JComboPane.this.opened = false;
                        }
                    }
                });
            }
        }
    }

    class ControlButtonListener
    implements ActionListener {
        ControlButtonListener() {
        }

        public void actionPerformed(ActionEvent e) {
            if (!JComboPane.this.isOpened()) {
                JComboPane.this.open();
            }
        }
    }
}

