/*
 * Decompiled with CFR 0.152.
 */
package net.segoia.util.swing.components;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.border.LineBorder;
import javax.swing.plaf.metal.MetalBorders;
import net.segoia.java.forms.swing.SwingUiElementsHelper;
import net.segoia.util.swing.components.JComboPane;

public class JComboOptionPane
extends JPanel {
    private static final long serialVersionUID = -2372630646532041587L;
    private JComponent content;
    private String title = "OptionPane";
    private JLabel titleLabel;
    private JButton controlButton;
    private JOptionPane optionPane;
    private JDialog dialog;

    public JComboOptionPane() {
        this.init();
    }

    private void init() {
        this.initTitleLable();
        this.initControlButton();
        this.setUpLayout();
        this.setPreferredSize(this.getFullSize());
    }

    private void initTitleLable() {
        this.titleLabel = new JLabel(this.title);
        this.titleLabel.setPreferredSize(new Dimension(150, 20));
        LineBorder border = new LineBorder(Color.BLACK);
        this.titleLabel.setBorder(new MetalBorders.TextFieldBorder());
    }

    private void initControlButton() {
        this.controlButton = new JButton("...");
        Insets insets = this.controlButton.getMargin();
        this.controlButton.setMargin(new Insets(insets.top, insets.top, insets.bottom, insets.top));
        this.controlButton.addActionListener(new ControlButtonListener());
    }

    private void setUpLayout() {
        GridBagLayout layout = new GridBagLayout();
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.fill = 1;
        constraints.gridwidth = -1;
        constraints.weightx = 1.0;
        this.setLayout(layout);
        this.add((Component)this.titleLabel, constraints);
        constraints.weightx = 0.0;
        this.add((Component)this.controlButton, constraints);
    }

    protected void update() {
        this.titleLabel.setText(this.title);
    }

    private Dimension getFullSize() {
        Dimension labelDim = this.titleLabel.getPreferredSize();
        Dimension cbDim = this.controlButton.getPreferredSize();
        double w = labelDim.width + cbDim.width;
        double h = Math.max(labelDim.height, cbDim.height);
        return new Dimension((int)w, (int)h);
    }

    public void open() {
        this.optionPane = new JOptionPane(this.content);
        this.dialog = this.optionPane.createDialog("Configure " + this.title);
        this.dialog.setVisible(true);
    }

    public void validateOptionPane() {
        this.optionPane.validate();
        this.dialog.pack();
    }

    public JComponent getContent() {
        return this.content;
    }

    public String getTitle() {
        return this.title;
    }

    public JLabel getTitleLabel() {
        return this.titleLabel;
    }

    public JButton getControlButton() {
        return this.controlButton;
    }

    public void setContent(JComponent content) {
        this.content = content;
    }

    public void setTitle(String title) {
        this.title = title;
        this.update();
    }

    public void setTitleLabel(JLabel titleLabel) {
        this.titleLabel = titleLabel;
    }

    public void setControlButton(JButton controlButton) {
        this.controlButton = controlButton;
    }

    public static void main(String[] args) {
        JFrame f = new JFrame();
        f.setLayout(new FlowLayout());
        f.setSize(800, 600);
        JPanel content = new JPanel(new GridBagLayout());
        content.add(SwingUiElementsHelper.createStandardCombo(new Object[]{"JComboPane"}));
        content.add(SwingUiElementsHelper.createStandartButton("bang"));
        content.add(SwingUiElementsHelper.createStandartButton("bang"));
        content.add(SwingUiElementsHelper.createStandartButton("bang"));
        JComboPane nestedCp = new JComboPane();
        JPanel content2 = new JPanel(new GridBagLayout());
        content2.add(SwingUiElementsHelper.createStandardCombo(new Object[]{"JComboPane2"}));
        nestedCp.setContent(content2);
        content.add(nestedCp);
        JComboOptionPane cp = new JComboOptionPane();
        cp.setTitle("ComboOptionPane");
        cp.setContent(content);
        f.add(cp);
        f.add(new JButton("test"));
        f.setVisible(true);
    }

    class ControlButtonListener
    implements ActionListener {
        ControlButtonListener() {
        }

        public void actionPerformed(ActionEvent e) {
            JComboOptionPane.this.open();
        }
    }
}

