/*
 * Decompiled with CFR 0.152.
 */
package net.segoia.util.swing.components;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Window;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JWindow;
import javax.swing.border.LineBorder;

public class ComboPanePopup
extends JWindow {
    private Point anchorPoint;
    private JPanel container;
    private static final long serialVersionUID = 1407582121825831789L;

    public ComboPanePopup() {
    }

    public ComboPanePopup(Window parent) {
        super(parent);
    }

    public ComboPanePopup(Frame parent) {
        super(parent);
    }

    private void initContainer() {
        this.container = new JPanel();
        this.container.setBorder(new LineBorder(Color.black));
        this.setContentPane(this.container);
    }

    private void prepareContainer() {
        if (this.container == null) {
            this.initContainer();
        } else {
            this.container.removeAll();
        }
    }

    public Point getAnchorPoint() {
        return this.anchorPoint;
    }

    public void setAnchorPoint(Point anchorPoint) {
        this.anchorPoint = anchorPoint;
    }

    public void setContent(JComponent c) {
        this.prepareContainer();
        this.container.add(c);
        this.pack();
        this.relocate();
    }

    public void relocate() {
        if (this.anchorPoint != null) {
            Dimension size = this.container.getPreferredSize();
            this.setLocation(this.anchorPoint.x - size.width / 2, this.anchorPoint.y);
        }
    }

    public void refresh() {
        this.relocate();
        this.pack();
        this.validate();
    }
}

