/*
 * Decompiled with CFR 0.152.
 */
package net.segoia.java.forms.swing;

import java.awt.Dimension;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import net.segoia.java.forms.ComponentConfig;
import net.segoia.java.forms.ComponentCreator;
import net.segoia.java.forms.event.FormUiEventListener;
import net.segoia.java.forms.event.ValueChangedEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SwingTextAreaCreator
implements ComponentCreator<JComponent> {
    public JComponent create(ComponentConfig c) {
        FormUiEventListener listener;
        JTextArea ta = new JTextArea();
        ta.setLineWrap(true);
        ta.setAutoscrolls(true);
        if (c.getValue() != null) {
            ta.setText(c.getValue().toString());
        }
        if ((listener = c.getUiEventListener()) != null) {
            ta.getDocument().addDocumentListener(new DocumentListener(){

                private void onChange(DocumentEvent e) {
                    Document d = e.getDocument();
                    try {
                        String value = d.getText(0, d.getLength());
                        listener.onEvent((Object)new ValueChangedEvent((Object)value));
                    }
                    catch (BadLocationException e1) {
                        e1.printStackTrace();
                    }
                }

                public void changedUpdate(DocumentEvent e) {
                    this.onChange(e);
                }

                public void insertUpdate(DocumentEvent e) {
                    this.onChange(e);
                }

                public void removeUpdate(DocumentEvent e) {
                    this.onChange(e);
                }
            });
        }
        JScrollPane sp = new JScrollPane(ta);
        sp.setPreferredSize(new Dimension(100, 150));
        sp.setMinimumSize(new Dimension(100, 100));
        return sp;
    }
}

