/*
 * Decompiled with CFR 0.152.
 */
package net.segoia.java.forms.swing;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.LayoutManager;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.border.TitledBorder;
import net.segoia.java.forms.AbstractFormUi;
import net.segoia.java.forms.ComponentConfig;
import net.segoia.java.forms.ComponentCreator;
import net.segoia.java.forms.ComponentCreatorsRepository;
import net.segoia.java.forms.FormLayoutConstraints;
import net.segoia.java.forms.FormUi;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SwingFormUi
extends AbstractFormUi<JComponent> {
    private JPanel holder;
    private GridBagConstraints constraints;

    public SwingFormUi(ComponentCreatorsRepository<JComponent> cc) {
        super(cc);
        this.init();
    }

    private void init() {
        this.holder = new JPanel(new GridBagLayout());
        this.constraints = new GridBagConstraints();
    }

    public void addComponent(ComponentConfig config, FormLayoutConstraints fconst) {
        this.translateConstraints(fconst);
        ComponentCreator cc = this.componentCreatorsRepository.get(config.getType());
        if (cc != null) {
            this.holder.add((Component)cc.create(config), this.constraints);
        }
    }

    public void addSubform(FormUi ui, FormLayoutConstraints fconst) {
        this.translateConstraints(fconst);
        this.holder.add((Component)((JComponent)ui.getHolder()), this.constraints);
    }

    private void translateConstraints(FormLayoutConstraints fconst) {
        this.constraints = fconst;
    }

    public Object getHolder() {
        return this.holder;
    }

    public void validate() {
        this.holder.revalidate();
    }

    private void refreshParent(Container c) {
        if (c == null) {
            return;
        }
        if (c.getParent() != null) {
            this.refreshParent(c.getParent());
        }
        c.validate();
    }

    public void clear() {
        this.holder.removeAll();
        Container parent = this.holder.getParent();
        if (parent != null) {
            parent.invalidate();
            parent.validate();
        }
    }

    public void addSeparator(FormLayoutConstraints constraints) {
        this.translateConstraints(constraints);
        JSeparator s = new JSeparator();
        this.holder.add((Component)s, this.constraints);
    }

    public void addVerticalSeparator(FormLayoutConstraints constraints) {
        this.translateConstraints(constraints);
        JSeparator s = new JSeparator(1);
        this.holder.add((Component)s, this.constraints);
    }

    public void removeComponent(Object component) {
        if (component instanceof JComponent) {
            this.holder.remove((JComponent)component);
        }
    }

    public void setBorderName(String name) {
        TitledBorder b = new TitledBorder(name);
        this.holder.setBorder(b);
    }

    public void addEmptySpace(FormLayoutConstraints constraints) {
        this.translateConstraints(constraints);
        Dimension d = new Dimension(0, 0);
        this.holder.add((Component)new Box.Filler(d, d, d), this.constraints);
    }

    public Object getLayout() {
        return this.holder.getLayout();
    }

    public void setLayout(Object l) {
        this.holder.setLayout((LayoutManager)l);
    }
}

