/*
 * Decompiled with CFR 0.152.
 */
package net.segoia.java.forms.model;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.segoia.java.forms.ComponentConfig;
import net.segoia.java.forms.Form;
import net.segoia.java.forms.FormComponent;
import net.segoia.java.forms.FormConfig;
import net.segoia.java.forms.FormControlComponent;
import net.segoia.java.forms.FormElement;
import net.segoia.java.forms.FormLayoutConstraints;
import net.segoia.java.forms.FormUi;
import net.segoia.java.forms.ParamInitConfig;
import net.segoia.java.forms.event.FormUiEventListener;
import net.segoia.java.forms.event.ValueChangedEvent;
import net.segoia.java.forms.impl.DefaultFormDataContext;
import net.segoia.java.forms.impl.ObjectFormDataFactory;
import net.segoia.java.forms.model.FormData;
import net.segoia.java.forms.model.FormDataContext;
import net.segoia.java.forms.model.FormDataFactory;
import net.segoia.java.forms.model.FormDataSource;
import net.segoia.util.data.reflection.ReflectionUtility;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ObjectFormModel
implements Cloneable {
    protected FormDataContext dataContext = new DefaultFormDataContext();
    protected FormData formData;
    protected FormUi ui;
    protected Form owner;
    protected Map<String, Form> subforms = new HashMap<String, Form>();
    protected FormConfig formConfig;
    protected FormLayoutConstraints constraints = new FormLayoutConstraints();
    protected PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);
    protected PropertyChangeSupport formConfigChangeSupport;
    protected ActionListener actionListener;
    private FormDataFactory formDataFactory = new ObjectFormDataFactory();

    public ObjectFormModel() {
        this.formConfigChangeSupport = new PropertyChangeSupport(this);
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
            return null;
        }
    }

    public void init() {
        this.initFormData();
        Map<String, ParamInitConfig> fieldConfigs = this.formConfig.getFieldInitConfigs();
        if (fieldConfigs == null) {
            return;
        }
        for (ParamInitConfig fic : fieldConfigs.values()) {
            if (!this.checkShouldInitParam(fic)) continue;
            Object value = null;
            if (fic.getValue() != null) {
                value = fic.getValue();
            } else if (fic.getSource() != null) {
                value = this.dataContext.getValue(this.replaceFieldValueInSource(fic.getSource()));
            } else if (fic.getSourceField() != null) {
                value = this.getValueForProperty(fic.getSourceField());
            }
            if ("this".equals(fic.getName())) {
                if (value != null) {
                    this.setDataObject(value);
                    continue;
                }
                this.setDataObject(this.createObjectForDataType(this.formConfig.getDataType()));
                continue;
            }
            if (fic.isPropertyFlagOn()) {
                this.setValueForProperty(fic.getName(), value);
                continue;
            }
            this.dataContext.setValue(fic.getName(), value);
        }
    }

    protected void initFormData() {
        if (this.formData == null) {
            this.formData = this.getNewFormData();
        }
    }

    protected FormData getNewFormData() {
        FormDataFactory formDataFactory = this.formConfig.getFormDataFactory();
        if (formDataFactory == null) {
            formDataFactory = this.formDataFactory;
        }
        if (this.formConfig.getDataType() != null) {
            return formDataFactory.createFormDataForType(this.formConfig.getDataType());
        }
        return null;
    }

    protected FormData getFormDataForObject(Object o) {
        FormDataFactory formDataFactory = this.formConfig.getFormDataFactory();
        if (formDataFactory == null) {
            formDataFactory = this.formDataFactory;
        }
        return formDataFactory.createFormDataFromObject(o);
    }

    private boolean checkShouldInitParam(ParamInitConfig pic) {
        String initFlag = pic.getInitFlag();
        if ("always".equals(initFlag)) {
            return true;
        }
        if ("wrong-type".equals(initFlag)) {
            return !this.formData.getType().equals(this.getNewFormData().getType());
        }
        return !"null".equals(initFlag) || !pic.isPropertyFlagOn() || pic.getName() == null || this.getValueForProperty(pic.getName()) == null;
    }

    public abstract void construct() throws Exception;

    protected void setUpBorder() {
        String desc;
        if (this.formConfig.isShowLabels() && (desc = this.getFormDescription()) != null) {
            this.ui.setBorderName(desc);
        }
    }

    protected String getFormDescription() {
        String desc = this.formConfig.getLabel();
        if (desc == null) {
            desc = this.formConfig.getFieldName();
        }
        return desc;
    }

    protected void onValueChanged(String propertyName, Object value) {
        this.setValueForProperty(propertyName, value);
    }

    protected String replaceFieldValueInSource(String target) {
        Pattern p = Pattern.compile("\\(.*\\)");
        Matcher m = p.matcher(target);
        String resp = target;
        while (m.find()) {
            String group = m.group();
            String prop = group.replace("(", "");
            Object value = this.getAnyValueForProperty(prop = prop.replace(")", ""));
            if (value == null) continue;
            resp = resp.replace(group, value.toString());
        }
        return resp;
    }

    public PropertyChangeEvent onNestedValueChanged(PropertyChangeEvent event) {
        return event;
    }

    public void addPropertyChangeListener(PropertyChangeListener pcl) {
        this.propertyChangeSupport.addPropertyChangeListener(pcl);
    }

    public void removePropertyChangeListener(PropertyChangeListener pcl) {
        this.propertyChangeSupport.removePropertyChangeListener(pcl);
    }

    public void addFormConfigChangeListener(PropertyChangeListener pcl) {
        this.formConfigChangeSupport.addPropertyChangeListener(pcl);
    }

    public void removeFormConfigChangeListener(PropertyChangeListener pcl) {
        this.formConfigChangeSupport.removePropertyChangeListener(pcl);
    }

    public void refresh() {
        this.ui.clear();
        try {
            this.construct();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.ui.validate();
    }

    protected void addElement(FormElement element, Object value) throws Exception {
        if (element.getClass().equals(FormComponent.class)) {
            this.addComponent((FormComponent)element, value);
        } else if (element instanceof FormControlComponent) {
            this.addControlComponent((FormControlComponent)element, value);
        }
    }

    protected Object getSourceData(FormElement fe) {
        if (fe.getSourceField() != null) {
            return this.getValueForProperty(fe.getSourceField());
        }
        if (fe.getSource() != null) {
            return this.dataContext.getValue(this.replaceFieldValueInSource(fe.getSource()));
        }
        return null;
    }

    protected ComponentConfig getComponentConfig(FormComponent fc) throws Exception {
        ComponentConfig cc = new ComponentConfig();
        cc.setType(fc.getUiType());
        cc.setName(fc.getFieldName());
        cc.setSource(this.getSourceData(fc));
        return cc;
    }

    protected ComponentConfig getComponentConfig(String name, String type, Object value, Object source) {
        ComponentConfig cc = new ComponentConfig();
        cc.setType(type);
        cc.setName(name);
        cc.setSource(source);
        cc.setValue(value);
        return cc;
    }

    protected void addComponent(ComponentConfig cc) throws Exception {
        cc.setUiEventListener(new ValueChangedListener(cc.getName()));
        this.ui.addComponent(cc, this.constraints);
    }

    protected void addComponent(FormComponent component, Object value) throws Exception {
        ComponentConfig cc = this.getComponentConfig(component);
        cc.setValue(value);
        cc.setUiEventListener(new ValueChangedListener(component.getFieldName()));
        this.ui.addComponent(cc, this.constraints);
    }

    protected void addActionComponent(FormComponent c) throws Exception {
        ComponentConfig cc = new ComponentConfig();
        cc.setType(c.getUiType());
        cc.setName(c.getActionName());
        cc.setValue(this.getLabel(c));
        cc.setUiEventListener(new FormActionEventListener(c.getActionName()));
        this.ui.addComponent(cc, this.constraints);
    }

    protected String getLabel(FormElement fe) {
        return fe.getLabel();
    }

    protected void addSubform(FormConfig formConfig, Object dataObject, FormUi ui) throws Exception {
        FormConfig newFormConfig = this.syncWithControlComponents((FormConfig)formConfig.clone(), dataObject);
        String fieldName = newFormConfig.getFieldName();
        boolean formChanged = !newFormConfig.equals(formConfig);
        boolean isNewForm = !this.subforms.containsKey(newFormConfig.getId());
        Form form = this.owner.getFormFactory().createForm(newFormConfig);
        if (ui != null) {
            form.setUi(ui);
        }
        form.setDataObject(dataObject);
        form.setDataContext(this.dataContext);
        form.addPropertyChangeListener(new NestedFormPropertyChangeListener(fieldName));
        form.getModel().addFormConfigChangeListener(new NestedFormConfigChangeListener(fieldName));
        if (this.ui != form.getUi()) {
            this.ui.addSubform(form.getUi(), this.constraints);
        }
        if (formChanged || isNewForm) {
            form.initialize();
        } else {
            form.construct();
        }
        this.subforms.put(fieldName, form);
    }

    protected void setUpNestedForm(Form nestedForm, Object dataObject, String fieldName) {
        nestedForm.setDataObject(dataObject);
        nestedForm.setDataContext(this.dataContext);
        nestedForm.addPropertyChangeListener(new NestedFormPropertyChangeListener(fieldName));
        nestedForm.getModel().addFormConfigChangeListener(new NestedFormConfigChangeListener(fieldName));
    }

    protected FormConfig syncWithControlComponents(FormConfig formConfig, Object dataObject) {
        if (formConfig.getElements() == null || dataObject == null) {
            return formConfig;
        }
        for (FormElement el : formConfig.getElements().values()) {
            if (!(el instanceof FormControlComponent)) continue;
            FormControlComponent cc = (FormControlComponent)el;
            if (cc.getFormMappings() == null) break;
            Object value = this.getValueForProperty(cc.getFieldName(), dataObject);
            FormConfig newFormConfig = cc.getFormMappings().get(value);
            if (newFormConfig == null) break;
            this.changeFormConfig(newFormConfig, formConfig);
            break;
        }
        return formConfig;
    }

    protected void addControlComponent(FormControlComponent controlComponent, Object value) throws Exception {
        ComponentConfig cc = this.getComponentConfig(controlComponent);
        cc.setValue(value);
        cc.setUiEventListener(new FormControlEventListener(controlComponent));
        if (!controlComponent.isHidden()) {
            this.ui.addComponent(cc, this.constraints);
        }
    }

    protected Object getValueForProperty(String propertyName) {
        FormElement fe = this.formConfig.getElements().get(propertyName);
        if (fe == null || fe.isBoundToField()) {
            return this.formData.getValue(propertyName);
        }
        return this.dataContext.getValue(propertyName);
    }

    protected Object getAnyValueForProperty(String propertyName) {
        Object value = null;
        if (!propertyName.startsWith("_")) {
            value = this.formData.getValue(propertyName);
        }
        if (value == null) {
            value = this.dataContext.getValue(propertyName);
        }
        return value;
    }

    protected Object getValueForProperty(String propertyName, Object target) {
        if (target != null) {
            try {
                return ReflectionUtility.getValueForField((Object)target, (String)propertyName);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    protected void setValueForProperty(String propertyName, Object value) {
        String stringValue;
        FormElement el = this.formConfig.getElements().get(propertyName);
        Object oldValue = null;
        if (value != null && (stringValue = value.toString()) != null && "".equals(stringValue.trim())) {
            value = null;
        }
        if (el == null || el.isBoundToField()) {
            if (this.formData != null) {
                try {
                    oldValue = this.getValueForProperty(propertyName);
                    this.formData.setValue(propertyName, value);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        } else {
            try {
                oldValue = this.getValueForProperty(propertyName);
                this.dataContext.setValue(propertyName, value);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.propertyChangeSupport.firePropertyChange(propertyName, oldValue, value);
    }

    protected Object createObjectForDataType(String dataType) {
        try {
            return Class.forName(dataType).newInstance();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    protected void update() {
        this.refresh();
        this.formConfigChangeSupport.firePropertyChange(this.formConfig.getFieldName(), null, this.formConfig);
    }

    public Object getObjectForProperty(String propName) {
        if (propName.contains(".")) {
            ArrayList<String> pl = new ArrayList<String>(Arrays.asList(propName.split("\\.")));
            return this.getObjecForPropertyPath(pl);
        }
        return this.formData.asObject();
    }

    public Object getObjecForPropertyPath(List<String> pp) {
        Form f;
        if (pp.size() == 1) {
            return this.formData.asObject();
        }
        if (pp.size() > 1 && (f = this.subforms.get(pp.remove(0))) != null) {
            return f.getModel().getObjecForPropertyPath(pp);
        }
        return null;
    }

    private void changeFormConfig(FormConfig source, FormConfig target) {
        target.setElements(source.getElements());
        target.setFieldInitConfigs(source.getFieldInitConfigs());
        target.setConfigParams(source.getConfigParams());
        target.setDataType(source.getDataType());
        target.setModelFactory(source.getModelFactory());
    }

    public FormConfig getFormConfig() {
        return this.formConfig;
    }

    public void setFormConfig(FormConfig formConfig) {
        this.formConfig = formConfig;
    }

    public Object getDataObject() {
        return this.formData.asObject();
    }

    public FormUi getUi() {
        return this.ui;
    }

    public Form getOwner() {
        return this.owner;
    }

    public FormLayoutConstraints getConstraints() {
        return this.constraints;
    }

    public void setDataObject(Object dataObject) {
        FormData oldFormData = this.formData;
        this.formData = null;
        if (dataObject != null) {
            this.formData = this.getFormDataForObject(dataObject);
            if (this.propertyChangeSupport == null) {
                this.propertyChangeSupport = new PropertyChangeSupport(this.formData);
            }
        }
        if (this.propertyChangeSupport != null) {
            this.propertyChangeSupport.firePropertyChange("<dataObject>", oldFormData, this.formData);
        }
    }

    public void setUi(FormUi ui) {
        this.ui = ui;
    }

    public void setOwner(Form owner) {
        this.owner = owner;
    }

    public void setConstraints(FormLayoutConstraints constraints) {
        this.constraints = constraints;
    }

    protected void onNestedFormConfigChanged(PropertyChangeEvent evt) {
        this.formConfigChangeSupport.firePropertyChange(this.formConfig.getFieldName() + "." + evt.getPropertyName(), evt.getOldValue(), evt.getNewValue());
        this.refresh();
    }

    public ActionListener getActionListener() {
        return this.actionListener;
    }

    public void setActionListener(ActionListener actionListener) {
        this.actionListener = actionListener;
    }

    public FormData getFormData() {
        return this.formData;
    }

    public void setFormData(FormData formData) {
        this.formData = formData;
    }

    public FormDataContext getDataContext() {
        return this.dataContext;
    }

    public void setDataContext(FormDataContext dataContext) {
        this.dataContext = dataContext;
    }

    public void setDatasource(FormDataSource ds) {
        this.dataContext.setDatasource(ds);
    }

    public FormDataFactory getFormDataFactory() {
        return this.formDataFactory;
    }

    public void setFormDataFactory(FormDataFactory formDataFactory) {
        this.formDataFactory = formDataFactory;
    }

    class NestedFormConfigChangeListener
    implements PropertyChangeListener {
        private String fieldName;

        public NestedFormConfigChangeListener(String fn) {
            this.fieldName = fn;
        }

        public void propertyChange(PropertyChangeEvent evt) {
            ObjectFormModel.this.onNestedFormConfigChanged(evt);
        }
    }

    class FormControlEventListener
    implements FormUiEventListener {
        private FormControlComponent cc;

        public FormControlEventListener(FormControlComponent cc) {
            this.cc = cc;
        }

        public void onEvent(Object event) {
            ValueChangedEvent vce = (ValueChangedEvent)event;
            String value = (String)vce.getValue();
            ObjectFormModel.this.onValueChanged(this.cc.getFieldName(), value);
            if (this.cc.getFormMappings() != null && value != null) {
                FormConfig newFormConfig = this.cc.getFormMappings().get(value);
                if (newFormConfig != null) {
                    ObjectFormModel.this.changeFormConfig(newFormConfig, ObjectFormModel.this.formConfig);
                }
                ObjectFormModel.this.init();
                ObjectFormModel.this.update();
            }
        }
    }

    class NestedFormPropertyChangeListener
    implements PropertyChangeListener {
        private String fieldName;

        public NestedFormPropertyChangeListener(String f) {
            this.fieldName = f;
        }

        public void propertyChange(PropertyChangeEvent evt) {
            String fullPropName = null;
            fullPropName = this.fieldName != null ? this.fieldName + "." + evt.getPropertyName() : evt.getPropertyName();
            PropertyChangeEvent newEvent = new PropertyChangeEvent(evt.getSource(), fullPropName, evt.getOldValue(), evt.getNewValue());
            if ((newEvent = ObjectFormModel.this.onNestedValueChanged(newEvent)) != null) {
                ObjectFormModel.this.propertyChangeSupport.firePropertyChange(newEvent.getPropertyName(), newEvent.getOldValue(), newEvent.getNewValue());
            }
        }
    }

    class FormActionEventListener
    implements FormUiEventListener {
        private String actionName;

        public FormActionEventListener(String actionName) {
            this.actionName = actionName;
        }

        public void onEvent(Object event) {
            if (ObjectFormModel.this.actionListener != null) {
                ActionEvent ae = (ActionEvent)event;
                ActionEvent newEvent = new ActionEvent(ae.getSource(), ae.getID(), this.actionName, ae.getWhen(), ae.getModifiers());
                ObjectFormModel.this.actionListener.actionPerformed(newEvent);
            }
        }
    }

    class ValueChangedListener
    implements FormUiEventListener {
        private String propertyName;

        public ValueChangedListener(String name) {
            this.propertyName = name;
        }

        public void onEvent(Object event) {
            ValueChangedEvent vce = (ValueChangedEvent)event;
            Object oldValue = null;
            ObjectFormModel.this.onValueChanged(this.propertyName, vce.getValue());
        }
    }
}

