/*
 * Decompiled with CFR 0.152.
 */
package net.segoia.java.forms.model;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.segoia.java.forms.ComponentConfig;
import net.segoia.java.forms.FormComponent;
import net.segoia.java.forms.FormConfig;
import net.segoia.java.forms.FormElement;
import net.segoia.java.forms.FormLayoutConstraints;
import net.segoia.java.forms.event.FormUiEventListener;
import net.segoia.java.forms.model.FormDataContext;
import net.segoia.java.forms.model.FormDataSource;
import net.segoia.java.forms.model.ObjectFormModel;
import net.segoia.util.data.ProxyMap;

public class MapFormModel
extends ObjectFormModel {
    private int currentIndex;
    private Map<String, Object> referencesMap = new HashMap<String, Object>();
    private List availableKeysFromSource;
    private List keysSource;
    private List valuesSource;
    private Map dataMap;
    private FormElement keyFieldInfo;
    private FormElement valueFieldInfo;
    private FormComponent keyComponent;
    private FormComponent valueComponent;
    private FormConfig keyFormConfig;
    private FormConfig valueFormConfig;
    private Map<Object, Object> originalSourceData;

    private void initConstraints() {
        this.constraints = new FormLayoutConstraints();
        this.constraints.anchor = 18;
        this.constraints.weightx = 1.0;
        this.constraints.fill = 1;
    }

    public void setDataObject(Object obj) {
        super.setDataObject(obj);
        if (this.formData != null) {
            this.dataMap = new ProxyMap(this.formData.asMap());
        }
    }

    public void setFormConfig(FormConfig fc) {
        super.setFormConfig(fc);
        if (this.formConfig.getElements() != null) {
            this.keyFieldInfo = this.formConfig.getElements().get("key");
            this.valueFieldInfo = this.formConfig.getElements().get("value");
            if (this.keyFieldInfo != null) {
                if (this.keyFieldInfo instanceof FormComponent) {
                    this.keyComponent = (FormComponent)this.keyFieldInfo;
                } else if (this.keyFieldInfo instanceof FormConfig) {
                    this.keyFormConfig = (FormConfig)this.keyFieldInfo;
                }
            }
            if (this.valueFieldInfo != null) {
                if (this.valueFieldInfo instanceof FormComponent) {
                    this.valueComponent = (FormComponent)this.valueFieldInfo;
                } else if (this.valueFieldInfo instanceof FormConfig) {
                    this.valueFormConfig = (FormConfig)this.valueFieldInfo;
                    this.valueFormConfig.setShowLabels(false);
                }
            }
        }
    }

    public void setDataContext(FormDataContext dataContext) {
        super.setDataContext(dataContext);
        this.updateKeysSource();
    }

    public void setDatasource(FormDataSource ds) {
        super.setDatasource(ds);
        this.updateKeysSource();
    }

    private void updateKeysSource() {
        if (this.keyFieldInfo instanceof FormComponent) {
            FormComponent keyComponent = (FormComponent)this.keyFieldInfo;
            if (this.keyFieldInfo != null && keyComponent.getSource() != null) {
                this.keysSource = (List)this.getSourceData(keyComponent);
                if (this.keysSource != null) {
                    this.deriveAvailableKeysFromSource();
                    if (this.dataMap != null && !this.availableKeysFromSource.containsAll(this.dataMap.keySet())) {
                        this.dataMap.clear();
                    }
                }
            }
        }
    }

    private void deriveAvailableKeysFromSource() {
        if (this.keyFieldInfo.getAuxiliarySourceProperty() == null) {
            this.availableKeysFromSource = new ArrayList(this.keysSource);
        } else {
            String nestedProp = this.keyFieldInfo.getAuxiliarySourceProperty();
            this.availableKeysFromSource = new ArrayList();
            this.originalSourceData = new HashMap<Object, Object>();
            for (Object sourceObject : this.keysSource) {
                Object key = this.getValueForProperty(nestedProp, sourceObject);
                this.availableKeysFromSource.add(key);
                this.originalSourceData.put(key, sourceObject);
            }
        }
    }

    public void construct() throws Exception {
        this.initConstraints();
        this.setUpBorder();
        String keyLabel = "key";
        String valueLabel = "value";
        if (this.keyFieldInfo != null && this.keyFieldInfo.getLabel() != null) {
            keyLabel = this.keyFieldInfo.getLabel();
        }
        if (this.valueFieldInfo != null && this.valueFieldInfo.getLabel() != null) {
            valueLabel = this.valueFieldInfo.getLabel();
        }
        ComponentConfig cc = new ComponentConfig("LABEL", keyLabel, null);
        this.ui.addComponent(cc, this.constraints);
        cc = new ComponentConfig("LABEL", valueLabel, null);
        this.constraints.gridwidth = 0;
        this.ui.addComponent(cc, this.constraints);
        this.currentIndex = 0;
        this.getAvailableKeysFromSource();
        if (!this.formConfig.isEditable()) {
            int availableKeysCount = this.availableKeysFromSource.size();
            for (int i = 0; i < availableKeysCount; ++i) {
                Object newKey = this.getAvailableKey(i);
                Object newValue = this.getAvailableValue(i);
                if (newKey == null || newValue == null) continue;
                this.dataMap.put(newKey, newValue);
            }
        }
        for (Object key : this.dataMap.keySet()) {
            this.initConstraints();
            Object value = this.dataMap.get(key);
            String keyName = "key" + this.currentIndex;
            String valueName = "value" + this.currentIndex;
            this.dataContext.setValue("_currentKeyIndex", this.currentIndex);
            if (this.keyComponent != null) {
                ArrayList currentAvailableKeys = null;
                if (this.availableKeysFromSource != null) {
                    currentAvailableKeys = new ArrayList(this.availableKeysFromSource);
                    currentAvailableKeys.add(0, key);
                }
                ComponentConfig newc = this.getComponentConfig(keyName, this.keyComponent.getUiType(), key, currentAvailableKeys.toArray());
                this.addComponent(newc);
                this.referencesMap.put(keyName, key);
                if (this.originalSourceData != null) {
                    this.dataContext.setValue("originalSourceKey", this.originalSourceData.get(key));
                }
            } else {
                this.keyFieldInfo.setFieldName(keyName);
                this.keyFormConfig.setId(keyName);
                this.addSubform(this.keyFormConfig, key, null);
            }
            if (!this.formConfig.isEditable()) {
                this.constraints.gridwidth = 0;
            }
            if (this.valueComponent != null) {
                List sourceValues = (List)this.getSourceData(this.valueFieldInfo);
                ComponentConfig valueCompConfig = this.getComponentConfig(valueName, this.valueComponent.getUiType(), value, sourceValues);
                this.addComponent(valueCompConfig);
                this.referencesMap.put(valueName, value);
            } else {
                this.valueFieldInfo.setFieldName(valueName);
                this.valueFormConfig.setId(valueName);
                this.addSubform(this.valueFormConfig, value, this.ui);
            }
            if (this.formConfig.isEditable()) {
                this.constraints.gridwidth = 0;
                this.constraints.fill = 0;
                this.addRemoveButton();
                this.constraints.fill = 1;
            } else {
                this.constraints.gridwidth = 0;
                this.constraints.weightx = 0.0;
                this.ui.addVerticalSeparator(this.constraints);
                this.constraints.weightx = 1.0;
            }
            ++this.currentIndex;
        }
        if (this.checkCanAdd()) {
            this.constraints.gridwidth = 0;
            this.constraints.fill = 0;
            this.addAddButton();
        }
    }

    private boolean checkCanAdd() {
        if (!this.formConfig.isEditable()) {
            return false;
        }
        if (this.keyFieldInfo != null && this.valueFieldInfo != null) {
            if (this.keyFieldInfo.getSource() != null && this.availableKeysFromSource != null) {
                return this.availableKeysFromSource.size() > 0;
            }
            return this.keyFieldInfo.getDataType() != null && this.valueFieldInfo.getDataType() != null;
        }
        return false;
    }

    private List getAvailableKeysFromSource() {
        if (this.keysSource != null) {
            this.deriveAvailableKeysFromSource();
            this.availableKeysFromSource.removeAll(this.dataMap.keySet());
        } else {
            this.availableKeysFromSource = new ArrayList();
        }
        return this.availableKeysFromSource;
    }

    public void onValueChanged(String propertyName, Object value) {
        String keyName;
        Object key;
        if (propertyName.startsWith("key")) {
            Object key2 = this.referencesMap.get(propertyName);
            if (key2 != null) {
                List valueSource;
                Object associatedValue = this.dataMap.get(key2);
                if (this.originalSourceData != null) {
                    this.dataContext.setValue("originalSourceKey", this.originalSourceData.get(value));
                }
                if ((valueSource = (List)this.getSourceData(this.valueFieldInfo)) != null && valueSource.size() > 0 && !valueSource.contains(associatedValue)) {
                    associatedValue = valueSource.get(0);
                }
                LinkedHashMap newDataMap = new LinkedHashMap();
                for (Object ck : this.dataMap.keySet()) {
                    if (ck.equals(key2)) {
                        newDataMap.put(value, associatedValue);
                        continue;
                    }
                    newDataMap.put(ck, this.dataMap.get(ck));
                }
                this.dataMap.clear();
                this.dataMap.putAll(newDataMap);
            }
            this.update();
        } else if (propertyName.startsWith("value") && (key = this.referencesMap.get(keyName = "key" + propertyName.replace("value", ""))) != null && value != null) {
            this.dataMap.put(key, value);
        }
    }

    private Object getAvailableKey(int index) {
        if (this.keysSource != null) {
            if (this.availableKeysFromSource.size() > index) {
                return this.availableKeysFromSource.get(index);
            }
        } else {
            String keyNestedType = this.keyFieldInfo.getDataType();
            if (keyNestedType != null) {
                return this.createObjectForDataType(keyNestedType);
            }
        }
        return null;
    }

    private Object getAvailableValue(int index) {
        if (this.valuesSource != null && this.valuesSource.size() > index) {
            return this.valuesSource.get(index);
        }
        String valueNestedType = this.valueFieldInfo.getDataType();
        if (valueNestedType != null) {
            return this.createObjectForDataType(valueNestedType);
        }
        return null;
    }

    private void addAddButton() {
        ComponentConfig cc = new ComponentConfig("BUTTON", "Add", null);
        cc.setUiEventListener(new FormUiEventListener(){

            public void onEvent(Object event) {
                Object key = null;
                Object value = null;
                if (MapFormModel.this.keysSource != null) {
                    MapFormModel.this.deriveAvailableKeysFromSource();
                    MapFormModel.this.availableKeysFromSource.removeAll(MapFormModel.this.dataMap.keySet());
                    if (MapFormModel.this.availableKeysFromSource.size() > 0) {
                        key = MapFormModel.this.availableKeysFromSource.get(0);
                    }
                } else {
                    String keyNestedType = MapFormModel.this.keyFieldInfo.getDataType();
                    if (keyNestedType != null) {
                        try {
                            key = Class.forName(keyNestedType).newInstance();
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                }
                if (key != null) {
                    List valueSource;
                    if (MapFormModel.this.originalSourceData != null) {
                        MapFormModel.this.dataContext.setValue("originalSourceKey", MapFormModel.this.originalSourceData.get(key));
                    }
                    if ((valueSource = (List)MapFormModel.this.getSourceData(MapFormModel.this.valueFieldInfo)) != null && valueSource.size() > 0) {
                        value = valueSource.get(0);
                    } else {
                        String valueNestedType = MapFormModel.this.valueFieldInfo.getDataType();
                        if (valueNestedType != null) {
                            try {
                                value = Class.forName(valueNestedType).newInstance();
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                    }
                }
                if (key != null && value != null) {
                    MapFormModel.this.dataMap.put(key, value);
                    MapFormModel.this.update();
                } else {
                    ActionEvent ae = (ActionEvent)event;
                    MapFormModel.this.ui.removeComponent(ae.getSource());
                }
            }
        });
        this.ui.addComponent(cc, this.constraints);
    }

    private void addRemoveButton() {
        ComponentConfig cc = new ComponentConfig("BUTTON", "Remove", null);
        cc.setUiEventListener(new RemoveListener(this.currentIndex));
        this.ui.addComponent(cc, this.constraints);
    }

    class RemoveListener
    implements FormUiEventListener {
        private int index;

        public RemoveListener(int index) {
            this.index = index;
        }

        public void onEvent(Object event) {
            Object key = MapFormModel.this.referencesMap.get("key" + this.index);
            if (key != null) {
                MapFormModel.this.dataMap.remove(key);
            }
            MapFormModel.this.update();
        }
    }
}

