/*
 * Decompiled with CFR 0.152.
 */
package net.segoia.java.forms.model;

import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.List;
import net.segoia.java.forms.ComponentConfig;
import net.segoia.java.forms.FormComponent;
import net.segoia.java.forms.FormConfig;
import net.segoia.java.forms.FormElement;
import net.segoia.java.forms.FormLayoutConstraints;
import net.segoia.java.forms.event.FormUiEventListener;
import net.segoia.java.forms.model.ObjectFormModel;

public class ListFormModel
extends ObjectFormModel {
    private int currentIndex;
    private FormElement nestedElement;
    private List<Object> sourceData;
    private List<Object> dataList;

    private void initConstraints() {
        this.constraints = new FormLayoutConstraints();
        this.constraints.anchor = 18;
        this.constraints.weightx = 1.0;
        this.constraints.fill = 1;
    }

    public void setDataObject(Object obj) {
        super.setDataObject(obj);
        if (this.formData != null) {
            this.dataList = this.formData.asList();
        }
    }

    public void construct() throws Exception {
        this.initConstraints();
        this.setUpBorder();
        if (this.formConfig.getElements() != null) {
            this.nestedElement = this.formConfig.getElements().get("nestedElement");
        }
        if (this.nestedElement == null) {
            return;
        }
        if (this.formConfig.getSource() != null || this.formConfig.getSourceField() != null) {
            this.sourceData = (List)this.getSourceData(this.formConfig);
        }
        if (this.formData == null) {
            if (this.sourceData != null && !this.formConfig.isEditable()) {
                this.setDataObject(new ArrayList<Object>(this.sourceData));
            } else {
                this.setDataObject(new ArrayList());
            }
        }
        if (this.nestedElement instanceof FormConfig) {
            this.handleNestedForm((FormConfig)this.nestedElement);
        } else {
            this.handleNestedComponent((FormComponent)this.nestedElement);
        }
    }

    protected void handleNestedForm(FormConfig fc) throws Exception {
        int i;
        ArrayList<FormElement> elements = new ArrayList<FormElement>(fc.getElements().values());
        if (!fc.isShowLabels()) {
            for (i = 0; i < elements.size(); ++i) {
                FormElement fi = (FormElement)elements.get(i);
                String label = fi.getLabel();
                if (label == null) {
                    label = fi.getFieldName();
                }
                ComponentConfig cc = new ComponentConfig("LABEL", label, null);
                if (i == elements.size() - 1) {
                    this.constraints.gridwidth = 0;
                }
                this.ui.addComponent(cc, this.constraints);
            }
            this.ui.addSeparator(this.constraints);
        } else {
            this.constraints.gridwidth = 0;
        }
        for (i = 0; i < this.dataList.size(); ++i) {
            this.currentIndex = i;
            Object e = this.dataList.get(i);
            fc.setFieldName("" + this.currentIndex);
            this.addSubform(fc, e, this.ui);
            if (this.formConfig.isEditable()) {
                this.constraints.gridwidth = -1;
            }
            if (this.formConfig.isEditable()) {
                this.constraints.gridwidth = 0;
                this.constraints.fill = 0;
                this.addRemoveButton();
                this.constraints.fill = 1;
                continue;
            }
            this.constraints.gridwidth = 0;
            this.constraints.weightx = 0.0;
            this.ui.addVerticalSeparator(this.constraints);
            this.constraints.weightx = 1.0;
        }
        if (this.formConfig.isEditable()) {
            this.constraints.fill = 0;
            this.addAddButton();
        }
    }

    protected void handleNestedComponent(FormComponent fc) {
    }

    public void onValueChanged(String propertyName, Object value) {
    }

    protected void onNestedFormConfigChanged(PropertyChangeEvent evt) {
        super.onNestedFormConfigChanged(evt);
    }

    private void addAddButton() {
        ComponentConfig cc = new ComponentConfig("BUTTON", "Add", null);
        cc.setUiEventListener(new FormUiEventListener(){

            public void onEvent(Object event) {
                Object newElement = null;
                if (ListFormModel.this.sourceData != null && ListFormModel.this.sourceData.size() > 0) {
                    int nextIndex = ListFormModel.this.dataList.size();
                    newElement = ListFormModel.this.sourceData.size() > nextIndex ? ListFormModel.this.sourceData.get(nextIndex) : ListFormModel.this.sourceData.get(nextIndex % ListFormModel.this.sourceData.size());
                } else {
                    newElement = ListFormModel.this.createObjectForDataType(ListFormModel.this.nestedElement.getDataType());
                }
                ListFormModel.this.dataList.add(newElement);
                ListFormModel.this.update();
                ListFormModel.this.propertyChangeSupport.firePropertyChange("" + (ListFormModel.this.dataList.size() - 1), null, newElement);
            }
        });
        this.ui.addComponent(cc, this.constraints);
    }

    private void addRemoveButton() {
        ComponentConfig cc = new ComponentConfig("BUTTON", "Remove", null);
        cc.setUiEventListener(new RemoveListener(this.currentIndex));
        this.ui.addComponent(cc, this.constraints);
    }

    class RemoveListener
    implements FormUiEventListener {
        private int index;

        public RemoveListener(int index) {
            this.index = index;
        }

        public void onEvent(Object event) {
            Object removedObject = ListFormModel.this.dataList.remove(this.index);
            ListFormModel.this.propertyChangeSupport.firePropertyChange("" + this.index, removedObject, null);
            ListFormModel.this.update();
        }
    }
}

