/*
 * Decompiled with CFR 0.152.
 */
package net.segoia.java.forms.model;

import java.beans.PropertyChangeEvent;
import java.util.Collection;
import java.util.Map;
import net.segoia.java.forms.ComponentConfig;
import net.segoia.java.forms.FormComponent;
import net.segoia.java.forms.FormConfig;
import net.segoia.java.forms.FormElement;
import net.segoia.java.forms.FormLayoutConstraints;
import net.segoia.java.forms.event.FormUiEventListener;
import net.segoia.java.forms.event.ValueChangedEvent;
import net.segoia.java.forms.model.FormData;
import net.segoia.java.forms.model.ObjectFormModel;

public class DefaultFormModel
extends ObjectFormModel {
    public void construct() throws Exception {
        this.initFormData();
        Collection<FormElement> elements = this.formConfig.getElements().values();
        if (this.formConfig.getElements() == null) {
            return;
        }
        this.initConstraints();
        this.setUpBorder();
        int count = 0;
        for (Map.Entry<String, FormElement> entry : this.formConfig.getElements().entrySet()) {
            FormElement e = entry.getValue();
            e.setId(entry.getKey());
            e.setFieldName(entry.getKey());
            this.addComponentForField(e);
            ++count;
        }
    }

    private void initConstraints() {
        this.constraints = new FormLayoutConstraints();
        this.constraints.anchor = 18;
        this.constraints.weightx = 1.0;
        this.constraints.fill = 1;
    }

    private void addComponentForField(FormElement fi) throws Exception {
        String fieldName = fi.getFieldName();
        Object value = null;
        boolean isSimpleField = fi instanceof FormComponent;
        FormComponent sfi = null;
        if (isSimpleField) {
            sfi = (FormComponent)fi;
            isSimpleField = sfi.getUiType() != null;
        }
        ComponentConfig config = null;
        if (this.formConfig.isShowLabels() && isSimpleField && !sfi.getUiType().equals("BUTTON")) {
            String label = fi.getLabel();
            if (label == null) {
                label = fi.getFieldName();
            }
            config = new ComponentConfig("LABEL", label, null);
            if (isSimpleField) {
                this.initConstraints();
            } else {
                this.constraints.gridwidth = 0;
            }
            this.ui.addComponent(config, this.constraints);
        }
        if (isSimpleField) {
            if (fi.getActionName() != null) {
                this.addActionComponent(sfi);
            } else if (fieldName != null) {
                value = sfi.isBoundToField() ? this.getValueForProperty(fieldName) : this.dataContext.getValue(fieldName);
                this.addElement(sfi, value);
            }
        } else {
            if (fi.isBoundToField() && (value = this.getValueForProperty(fieldName)) == null && fi.getDataType() != null) {
                value = this.createObjectForDataType(fi.getDataType());
                this.setValueForProperty(fieldName, value);
            }
            this.addSubform((FormConfig)fi, value, null);
        }
        if (this.formConfig.isShowLabels()) {
            this.addEndLine();
        }
    }

    private void addEndLine() {
        this.constraints.gridwidth = 0;
        this.constraints.weightx = 0.0;
        this.ui.addEmptySpace(this.constraints);
        this.constraints.weightx = 1.0;
    }

    public PropertyChangeEvent onNestedValueChanged(PropertyChangeEvent event) {
        int index;
        String propName = event.getPropertyName();
        if (propName.contains("<dataObject>") && (index = propName.lastIndexOf(".")) >= 0 && (propName = propName.substring(0, index)).indexOf(".") < 0) {
            FormData formData = (FormData)event.getNewValue();
            if (formData != null) {
                this.setValueForProperty(propName, formData.asObject());
            } else {
                this.setValueForProperty(propName, null);
            }
        }
        return event;
    }

    class ValueChangedListener
    implements FormUiEventListener {
        private String propertyName;

        public ValueChangedListener(String name) {
            this.propertyName = name;
        }

        public void onEvent(Object event) {
            ValueChangedEvent vce = (ValueChangedEvent)event;
            DefaultFormModel.this.formData.setValue(this.propertyName, vce.getValue());
        }
    }
}

