/*
 * Decompiled with CFR 0.152.
 */
package net.scattersphere.data.message;

import java.io.Serializable;
import net.scattersphere.data.DataSerializer;

public class JobResponseMessage
implements Serializable {
    private static final long serialVersionUID = 8965863129042005132L;
    private final String jobId;
    private final String jobDescription;
    private final String jobStatus;
    private final String jobMessage;
    private final Exception jobException;

    public JobResponseMessage(String jobId, String jobStatus, String jobMessage, Exception jobException) {
        this.jobId = jobId;
        this.jobStatus = jobStatus;
        this.jobMessage = jobMessage;
        this.jobException = jobException;
        this.jobDescription = null;
    }

    public JobResponseMessage(String jobId, String jobStatus) {
        this(jobId, jobStatus, null, null);
    }

    public JobResponseMessage(String jobId, String jobStatus, String jobDescription) {
        this.jobId = jobId;
        this.jobStatus = jobStatus;
        this.jobMessage = null;
        this.jobException = null;
        this.jobDescription = jobDescription;
    }

    public String getJobId() {
        return this.jobId;
    }

    public String getJobDescription() {
        return this.jobDescription;
    }

    public String getJobStatus() {
        return this.jobStatus;
    }

    public String getJobMessage() {
        return this.jobMessage;
    }

    public Exception getJobException() {
        return this.jobException;
    }

    public byte[] toByteArray() {
        return DataSerializer.serialize(this);
    }

    public static JobResponseMessage fromByteArray(byte[] array) {
        return (JobResponseMessage)DataSerializer.deserialize(array);
    }

    public String toString() {
        return "JobResponseMessage{jobId='" + this.jobId + '\'' + ", jobDescription='" + this.jobDescription + '\'' + ", jobStatus='" + this.jobStatus + '\'' + ", jobMessage='" + this.jobMessage + '\'' + ", jobException=" + this.jobException + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JobResponseMessage that = (JobResponseMessage)o;
        if (this.jobDescription != null ? !this.jobDescription.equals(that.jobDescription) : that.jobDescription != null) {
            return false;
        }
        if (this.jobException != null ? !this.jobException.equals(that.jobException) : that.jobException != null) {
            return false;
        }
        if (this.jobId != null ? !this.jobId.equals(that.jobId) : that.jobId != null) {
            return false;
        }
        if (this.jobMessage != null ? !this.jobMessage.equals(that.jobMessage) : that.jobMessage != null) {
            return false;
        }
        return !(this.jobStatus != null ? !this.jobStatus.equals(that.jobStatus) : that.jobStatus != null);
    }

    public int hashCode() {
        int result = this.jobId != null ? this.jobId.hashCode() : 0;
        result = 31 * result + (this.jobDescription != null ? this.jobDescription.hashCode() : 0);
        result = 31 * result + (this.jobStatus != null ? this.jobStatus.hashCode() : 0);
        result = 31 * result + (this.jobMessage != null ? this.jobMessage.hashCode() : 0);
        result = 31 * result + (this.jobException != null ? this.jobException.hashCode() : 0);
        return result;
    }
}

