/*
 * Decompiled with CFR 0.152.
 */
package net.scattersphere.data.message;

import java.io.Serializable;
import java.util.Arrays;
import net.scattersphere.data.DataSerializer;

public class JobParametersMessage
implements Serializable {
    private static final long serialVersionUID = 8347544063219425591L;
    private final String jobName;
    private final String jobMessage;
    private final String[] jobParameters;

    public JobParametersMessage(String jobName, String jobMessage, String[] jobParameters) {
        this.jobName = jobName;
        this.jobMessage = jobMessage;
        this.jobParameters = jobParameters;
    }

    public JobParametersMessage(String jobName, String[] jobParameters) {
        this(jobName, null, jobParameters);
    }

    public String getJobName() {
        return this.jobName;
    }

    public String getJobMessage() {
        return this.jobMessage;
    }

    public String[] getJobParameters() {
        return this.jobParameters;
    }

    public byte[] toByteArray() {
        return DataSerializer.serialize(this);
    }

    public static JobParametersMessage fromByteArray(byte[] array) {
        return (JobParametersMessage)DataSerializer.deserialize(array);
    }

    public String toString() {
        return "JobParametersMessage{jobName='" + this.jobName + '\'' + ", jobMessage='" + this.jobMessage + '\'' + ", jobParameters=" + Arrays.toString(this.jobParameters) + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JobParametersMessage that = (JobParametersMessage)o;
        if (this.jobMessage != null ? !this.jobMessage.equals(that.jobMessage) : that.jobMessage != null) {
            return false;
        }
        if (this.jobName != null ? !this.jobName.equals(that.jobName) : that.jobName != null) {
            return false;
        }
        return Arrays.equals(this.jobParameters, that.jobParameters);
    }

    public int hashCode() {
        int result = this.jobName != null ? this.jobName.hashCode() : 0;
        result = 31 * result + (this.jobMessage != null ? this.jobMessage.hashCode() : 0);
        result = 31 * result + (this.jobParameters != null ? Arrays.hashCode(this.jobParameters) : 0);
        return result;
    }
}

