/*
 * Decompiled with CFR 0.152.
 */
package net.scattersphere.data.message;

import java.io.Serializable;
import net.scattersphere.data.DataSerializer;

public class JobParametersMessage
implements Serializable {
    private final String jobName;
    private final String jobMessage;
    private final String[] jobParameters;

    public JobParametersMessage(String jobName, String jobMessage, String[] jobParameters) {
        this.jobName = jobName;
        this.jobMessage = jobMessage;
        this.jobParameters = jobParameters;
    }

    public JobParametersMessage(String jobName, String[] jobParameters) {
        this(jobName, null, jobParameters);
    }

    public String getJobName() {
        return this.jobName;
    }

    public String getJobMessage() {
        return this.jobMessage;
    }

    public String[] getJobParameters() {
        return this.jobParameters;
    }

    public byte[] toByteArray() {
        return DataSerializer.serialize(this);
    }

    public static JobParametersMessage fromByteArray(byte[] array) {
        return (JobParametersMessage)DataSerializer.deserialize(array);
    }

    public String toString() {
        StringBuilder out = new StringBuilder("JobParametersMessage: jobName=");
        out.append(this.jobName).append(";jobMessage=").append(this.jobMessage).append(";jobParameters=").append(this.jobParameters);
        return out.toString();
    }
}

