/*
 * Decompiled with CFR 0.152.
 */
package net.scattersphere.data.message;

import java.io.Serializable;
import net.scattersphere.data.DataSerializer;

public class JobMessage
implements Serializable {
    private final String message;
    private final String action;
    private final byte[] payload;

    public JobMessage(String message, String action, byte[] payload) {
        this.message = message;
        this.action = action;
        this.payload = payload;
    }

    public JobMessage(String message) {
        this(message, null, null);
    }

    public JobMessage(String message, String action) {
        this(message, action, null);
    }

    public JobMessage(String message, byte[] payload) {
        this(message, null, payload);
    }

    public String getMessage() {
        return this.message;
    }

    public String getAction() {
        return this.action;
    }

    public byte[] getPayload() {
        return this.payload;
    }

    public byte[] toByteArray() {
        return DataSerializer.serialize(this);
    }

    public static JobMessage fromByteArray(byte[] array) {
        return (JobMessage)DataSerializer.deserialize(array);
    }

    public String toString() {
        StringBuilder response = new StringBuilder("JobMessage: message=");
        response.append(this.message).append(";action=").append(this.action).append(";payload=").append(this.payload == null ? 0 : this.payload.length).append(" bytes");
        return response.toString();
    }
}

