/*
 * Decompiled with CFR 0.152.
 */
package net.scattersphere.api;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import net.scattersphere.api.ClientConnection;
import net.scattersphere.api.ClientConnectionState;
import net.scattersphere.data.DataSerializer;
import net.scattersphere.data.message.JobMessage;
import net.scattersphere.data.message.JobParametersMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StreamClient {
    private Consumer<String> onConnect = null;
    private Consumer<String> onDisconnect;
    private BiConsumer<String, byte[]> onStream;
    private final Logger LOG = LoggerFactory.getLogger(StreamClient.class);
    private Map<String, StreamClientConnectionPair> connections = new HashMap<String, StreamClientConnectionPair>();

    public void addClient(String clientName, String clientAddress) {
        Objects.requireNonNull(clientName);
        Objects.requireNonNull(clientAddress);
        StreamClientConnectionPair clientConnectionPair = new StreamClientConnectionPair(clientName, clientAddress);
        clientConnectionPair.connect();
        this.connections.put(clientName, clientConnectionPair);
    }

    public ClientConnection getClientConnection(String clientName) {
        Objects.requireNonNull(clientName);
        if (this.connections.get(clientName) == null) {
            throw new NullPointerException("Connection for client by name does not exist: " + clientName);
        }
        return this.connections.get(clientName).getClientConnection();
    }

    public void openStream(String clientName, String streamId) {
        JobParametersMessage parameters = new JobParametersMessage(streamId, "open", new String[0]);
        JobMessage message = new JobMessage("STREAM", parameters.toByteArray());
        this.getClientConnection(clientName).sendMessage(DataSerializer.packetize((byte[])message.toByteArray()));
    }

    public void closeStream(String clientName, String streamId) {
        JobParametersMessage parameters = new JobParametersMessage(streamId, "close", new String[0]);
        JobMessage message = new JobMessage("STREAM", parameters.toByteArray());
        this.getClientConnection(clientName).sendMessage(DataSerializer.packetize((byte[])message.toByteArray()));
    }

    public StreamClient onConnect(Consumer<String> function) {
        this.onConnect = function;
        return this;
    }

    public StreamClient onDisconnect(Consumer<String> function) {
        this.onDisconnect = function;
        return this;
    }

    public StreamClient onStream(BiConsumer<String, byte[]> function) {
        this.onStream = function;
        return this;
    }

    private class StreamClientConnectionPair {
        private String host;
        private String pairName;
        private ClientConnection client;

        public StreamClientConnectionPair(String pairName, String host) {
            this.pairName = pairName;
            this.host = host;
            this.client = new ClientConnection(true);
        }

        public String getHost() {
            return this.host;
        }

        public void connect() {
            this.client.onConnect(x -> {
                if (x == ClientConnectionState.CONNECTED) {
                    StreamClient.this.onConnect.accept(this.pairName);
                    StreamClient.this.LOG.info("New connection state: {}", (Object)x);
                }
                if (x == ClientConnectionState.CLOSED) {
                    StreamClient.this.onDisconnect.accept(this.pairName);
                    StreamClient.this.LOG.info("Connection closed: {}", (Object)x);
                }
                if (x == ClientConnectionState.FAILED) {
                    StreamClient.this.onDisconnect.accept(this.pairName);
                    StreamClient.this.LOG.info("Connection failed: {}", (Object)this.host);
                }
            }).streamReceived(msg -> StreamClient.this.onStream.accept(this.pairName, msg)).messageReceived(msg -> StreamClient.this.LOG.info("Unexpected message received: {}", msg)).authReceived(msg -> StreamClient.this.LOG.info("Authentication received: {}", msg)).connect(this.host);
        }

        public ClientConnection getClientConnection() {
            return this.client;
        }
    }
}

