/*
 * Decompiled with CFR 0.152.
 */
package net.scattersphere.api;

import java.util.Objects;
import java.util.function.Consumer;
import net.scattersphere.api.ClientConnectionState;
import net.scattersphere.data.message.JobMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.vertx.java.core.AsyncResult;
import org.vertx.java.core.AsyncResultHandler;
import org.vertx.java.core.Handler;
import org.vertx.java.core.VertxFactory;
import org.vertx.java.core.VoidHandler;
import org.vertx.java.core.buffer.Buffer;
import org.vertx.java.core.net.NetClient;
import org.vertx.java.core.net.NetSocket;

public class ClientConnection {
    private NetClient client = null;
    private NetSocket clientSocket = null;
    private String clientAddress;
    private String connectStatus = "Not connected";
    private boolean connected = false;
    private boolean streamMode = false;
    private Buffer readBuffer;
    private long expectedBufferSize = 0L;
    private Consumer<ClientConnectionState> onConnect;
    private Consumer<JobMessage> onMessage;
    private Consumer<byte[]> onStream;
    private final Logger LOG = LoggerFactory.getLogger(ClientConnection.class);

    public ClientConnection() {
        this.readBuffer = new Buffer();
    }

    public ClientConnection(boolean streamMode) {
        this();
        this.streamMode = streamMode;
    }

    public ClientConnection onConnect(Consumer<ClientConnectionState> onConnect) {
        this.onConnect = onConnect;
        return this;
    }

    public ClientConnection messageReceived(Consumer<JobMessage> onMessage) {
        this.onMessage = onMessage;
        return this;
    }

    public ClientConnection streamReceived(Consumer<byte[]> onStream) {
        this.onStream = onStream;
        return this;
    }

    public void connect(final String endpointSent) {
        Objects.requireNonNull(endpointSent);
        String endpoint = endpointSent.trim();
        if (endpoint == null || endpoint.length() == 0) {
            throw new NullPointerException("Endpoint address must not be null.");
        }
        if (this.client != null) {
            throw new IllegalStateException("Connection already established to endpoint at " + this.clientSocket.remoteAddress());
        }
        String[] endpoints = endpoint.split(":");
        int endpointPort = this.streamMode ? 10002 : 10001;
        String endpointIp = null;
        try {
            if (endpoints.length == 1) {
                endpointIp = endpoints[0];
            } else {
                endpointIp = endpoints[0];
                endpointPort = Integer.parseInt(endpoints[1]);
            }
        }
        catch (Exception ex) {
            throw new IllegalArgumentException("Unable to connect to address: " + endpointSent, ex);
        }
        this.client = VertxFactory.newVertx().createNetClient();
        this.connectStatus = "Connecting to " + endpointSent + ":" + endpointPort;
        this.clientAddress = endpointIp;
        this.onConnect.accept(ClientConnectionState.WAITING);
        this.client.connect(endpointPort, endpointIp, (Handler)new AsyncResultHandler<NetSocket>(){

            public void handle(AsyncResult<NetSocket> netSocketAsyncResult) {
                if (netSocketAsyncResult.succeeded()) {
                    ClientConnection.this.connectStatus = "Connected to " + endpointSent;
                    ClientConnection.this.connected = true;
                    ClientConnection.this.clientSocket = (NetSocket)netSocketAsyncResult.result();
                    ClientConnection.this.onConnect.accept(ClientConnectionState.CONNECTED);
                    ClientConnection.this.clientSocket.closeHandler((Handler)new VoidHandler(){

                        public void handle() {
                            ClientConnection.this.client = null;
                            ClientConnection.this.connectStatus = "Not connected";
                            ClientConnection.this.connected = false;
                            ClientConnection.this.clientSocket = null;
                            ClientConnection.this.onConnect.accept(ClientConnectionState.CLOSED);
                        }
                    });
                    ClientConnection.this.clientSocket.dataHandler(buffer -> {
                        byte[] data = null;
                        if (ClientConnection.this.expectedBufferSize == 0L) {
                            int payloadSize = 0;
                            if (buffer.length() > 4) {
                                data = buffer.getBytes();
                                payloadSize = (data[0] & 0xFF) << 24 | (data[1] & 0xFF) << 16 | (data[2] & 0xFF) << 8 | data[3] & 0xFF;
                            }
                            ClientConnection.this.LOG.debug("READ: payloadSize={} appendedBufferSize={}", (Object)payloadSize, (Object)buffer.length());
                            byte[] newData = new byte[data.length - 4];
                            System.arraycopy(data, 4, newData, 0, data.length - 4);
                            ClientConnection.this.expectedBufferSize = payloadSize;
                            ClientConnection.this.readBuffer = new Buffer(newData);
                        } else {
                            ClientConnection.this.readBuffer.appendBuffer(buffer);
                        }
                        data = ClientConnection.this.readBuffer.getBytes();
                        if ((long)data.length >= ClientConnection.this.expectedBufferSize) {
                            int newBufferLength = (int)((long)data.length - ClientConnection.this.expectedBufferSize);
                            byte[] newBuffer = null;
                            ClientConnection.this.readBuffer = new Buffer();
                            if (newBufferLength > 0) {
                                newBuffer = new byte[newBufferLength];
                                System.arraycopy(data, (int)ClientConnection.this.expectedBufferSize, newBuffer, 0, newBufferLength);
                                ClientConnection.this.readBuffer.setBytes(0, newBuffer);
                            }
                            ClientConnection.this.expectedBufferSize = 0L;
                            ClientConnection.this.LOG.debug("READ: received full packet: length={}", (Object)ClientConnection.this.expectedBufferSize);
                            if (ClientConnection.this.streamMode) {
                                ClientConnection.this.onStream.accept(data);
                            } else {
                                JobMessage jMessage = JobMessage.fromByteArray((byte[])data);
                                ClientConnection.this.onMessage.accept(jMessage);
                            }
                        }
                    });
                } else if (netSocketAsyncResult.failed()) {
                    ClientConnection.this.onConnect.accept(ClientConnectionState.FAILED);
                    ClientConnection.this.client = null;
                    ClientConnection.this.connectStatus = "Not connected";
                    ClientConnection.this.connected = false;
                    ClientConnection.this.clientSocket = null;
                }
            }
        });
    }

    public void disconnect() {
        if (this.client == null) {
            return;
        }
        this.client.close();
        this.client = null;
        this.connectStatus = "Not connected";
        this.connected = false;
        this.clientSocket = null;
    }

    public void sendMessage(byte[] data) {
        Objects.requireNonNull(data);
        this.LOG.debug("sendMessage: Writing: size={}", (Object)data.length);
        this.clientSocket.write(new Buffer(data));
    }

    public String getConnectStatus() {
        return this.connectStatus;
    }

    public boolean isConnected() {
        return this.connected;
    }
}

