package net.scattersphere.api;

/**
 * These are the client connection states that occur during a connection.  These states are sent in the {@link ClientConnection}
 * class, and are used to indicate whether a client is waiting to connect, has connected, has dropped, or has failed.
 *
 * Created by kenji on 1/4/15.
 */
public enum ClientConnectionState {

    /** Waiting for connection, or attempting to connect. */
    WAITING,

    /** Endpoint connected. */
    CONNECTED,

    /** Endpoint has closed the connection, or the connection has dropped. */
    CLOSED,

    /** The connection failed due to a network issue. */
    FAILED

}
